/*
 * Decompiled with CFR 0.152.
 */
import Sirius.navigator.connection.Connection;
import Sirius.navigator.connection.ConnectionFactory;
import Sirius.navigator.connection.ConnectionInfo;
import Sirius.navigator.connection.ConnectionSession;
import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.connection.proxy.ConnectionProxy;
import Sirius.navigator.exception.ConnectionException;
import Sirius.navigator.types.treenode.RootTreeNode;
import Sirius.navigator.ui.DescriptionPaneFS;
import Sirius.navigator.ui.LayoutedContainer;
import Sirius.navigator.ui.MutableMenuBar;
import Sirius.navigator.ui.MutablePopupMenu;
import Sirius.navigator.ui.MutableToolBar;
import Sirius.navigator.ui.attributes.AttributeViewer;
import Sirius.navigator.ui.tree.SearchResultsTree;
import Sirius.server.middleware.types.Node;
import de.cismet.belis.broker.CidsBroker;
import de.cismet.belis.client.BelisClient;
import de.cismet.belis.gui.widget.ExtendedNavigatorAttributeEditorGui;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.tools.gui.DefaultPopupMenuListener;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.log4jquickconfig.Log4JQuickConfig;
import java.awt.Component;
import java.awt.Frame;
import java.util.ArrayList;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.auth.LoginService;

public class BrokerTester {
    private static final transient Logger LOG = Logger.getLogger(BrokerTester.class);
    public static final String CONNECTION_CLASS = "Sirius.navigator.connection.RESTfulConnection";
    public static final String CONNECTION_PROXY_CLASS = "Sirius.navigator.connection.proxy.DefaultConnectionProxyHandler";
    public static final String CALLSERVER_URL = "http://localhost:9917/callserver/binary";
    public static final String CALLSERVER_DOMAIN = "BELIS2";
    public static final String CALLSERVER_USER = "";
    public static final String CALLSERVER_PASSWORD = "";
    public static final String CALLSERVER_GROUP = "Bearbeiter";

    private static void initComponentRegistry() throws Exception {
        SearchResultsTree searchResultsTree = new SearchResultsTree();
        MutableToolBar toolBar = new MutableToolBar();
        MutableMenuBar menuBar = new MutableMenuBar();
        LayoutedContainer container = new LayoutedContainer(toolBar, menuBar, true);
        AttributeViewer attributeViewer = new AttributeViewer();
        ExtendedNavigatorAttributeEditorGui attributeEditor = new ExtendedNavigatorAttributeEditorGui();
        DescriptionPaneFS descriptionPane = new DescriptionPaneFS();
        MutablePopupMenu popupMenu = new MutablePopupMenu();
        ArrayList<Component> toRemoveComponents = new ArrayList<Component>();
        for (Component component : popupMenu.getComponents()) {
            if (!(component instanceof JSeparator) && (!(component instanceof JMenuItem) || ((JMenuItem)component).getActionCommand() == null || !((JMenuItem)component).getActionCommand().equals("cmdSearch") && !((JMenuItem)component).getActionCommand().equals("treecommand"))) continue;
            toRemoveComponents.add(component);
        }
        for (Component toRemoveComponent : toRemoveComponents) {
            popupMenu.remove(toRemoveComponent);
        }
        DefaultPopupMenuListener cataloguePopupMenuListener = new DefaultPopupMenuListener((JPopupMenu)popupMenu);
        Node[] roots = SessionManager.getProxy().getRoots(CALLSERVER_DOMAIN);
        while (true) {
            RootTreeNode rootTreeNode = new RootTreeNode(roots);
            LOG.fatal((Object)("test: " + rootTreeNode.getChildCount() + " / " + roots.length), (Throwable)new Exception());
            Thread.sleep(1000L);
        }
    }

    private static void runTest(JFrame frame) throws Exception {
        try {
            SessionManager.init((ConnectionProxy)BrokerTester.initProxy());
            ClassCacheMultiple.setInstance((String)CALLSERVER_DOMAIN);
            BrokerTester.initComponentRegistry();
            final TreeNodesDialog dialog = new TreeNodesDialog((Frame)frame, true);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException ex) {
                        LOG.fatal((Object)"error while sleeping", (Throwable)ex);
                    }
                    dialog.dispose();
                }
            }).start();
            StaticSwingTools.showDialog((JDialog)dialog);
            SessionManager.destroy();
            Thread.sleep(500L);
        }
        catch (ConnectionException ex) {
            LOG.fatal((Object)"getRoots()", (Throwable)ex);
        }
    }

    public static void main(String[] args) {
        Log4JQuickConfig.configure4LumbermillOnLocalhost();
        final JFrame frame = new JFrame();
        frame.setVisible(true);
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            BrokerTester.runTest(frame);
                        }
                    }
                    catch (Exception ex) {
                        LOG.fatal((Object)"error while test", (Throwable)ex);
                        System.exit(0);
                        continue;
                    }
                    break;
                }
            }
        }).start();
    }

    private static ConnectionProxy initProxy() throws Exception {
        Connection connection = ConnectionFactory.getFactory().createConnection(CONNECTION_CLASS, CALLSERVER_URL);
        ConnectionInfo connectionInfo = new ConnectionInfo();
        connectionInfo.setCallserverURL(CALLSERVER_URL);
        connectionInfo.setPassword("");
        connectionInfo.setUserDomain(CALLSERVER_DOMAIN);
        connectionInfo.setUsergroup(CALLSERVER_GROUP);
        connectionInfo.setUsergroupDomain(CALLSERVER_DOMAIN);
        connectionInfo.setUsername("");
        ConnectionSession session = ConnectionFactory.getFactory().createSession(connection, connectionInfo, true);
        return ConnectionFactory.getFactory().createProxy(CONNECTION_PROXY_CLASS, session);
    }

    public static class WundaAuthentification
    extends LoginService {
        private final Logger log = Logger.getLogger(BelisClient.WundaAuthentification.class);

        public boolean authenticate(String name, char[] password, String server) throws Exception {
            try {
                String user = "";
                String group = BrokerTester.CALLSERVER_GROUP;
                Connection connection = ConnectionFactory.getFactory().createConnection(BrokerTester.CONNECTION_CLASS, BrokerTester.CALLSERVER_URL);
                ConnectionInfo connectionInfo = new ConnectionInfo();
                connectionInfo.setCallserverURL(BrokerTester.CALLSERVER_URL);
                connectionInfo.setPassword("");
                connectionInfo.setUserDomain(BrokerTester.CALLSERVER_DOMAIN);
                connectionInfo.setUsergroup(BrokerTester.CALLSERVER_GROUP);
                connectionInfo.setUsergroupDomain(BrokerTester.CALLSERVER_DOMAIN);
                connectionInfo.setUsername("");
                ConnectionSession session = ConnectionFactory.getFactory().createSession(connection, connectionInfo, true);
                ConnectionProxy proxy = ConnectionFactory.getFactory().createProxy(BrokerTester.CONNECTION_PROXY_CLASS, session);
                SessionManager.init((ConnectionProxy)proxy);
                ClassCacheMultiple.setInstance((String)BrokerTester.CALLSERVER_DOMAIN);
                CidsBroker.getInstance().setProxy(proxy);
                return true;
            }
            catch (Throwable t) {
                this.log.error((Object)"Fehler beim Anmelden", t);
                return false;
            }
        }
    }
}

