/*
 * Decompiled with CFR 0.152.
 */
import Sirius.navigator.connection.Connection;
import Sirius.navigator.connection.ConnectionFactory;
import Sirius.navigator.connection.ConnectionInfo;
import Sirius.navigator.connection.ConnectionSession;
import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.connection.proxy.ConnectionProxy;
import Sirius.server.middleware.types.MetaObject;
import Sirius.server.middleware.types.MetaObjectNode;
import de.cismet.belis.arbeitsprotokollwizard.ArbeitsprotokollDialog;
import de.cismet.belis.arbeitsprotokollwizard.LeuchteLeuchtmittelwechselElekpruefungWizard;
import de.cismet.belis.broker.CidsBroker;
import de.cismet.belis2.server.search.ArbeitsauftragSearchStatement;
import de.cismet.cids.custom.beans.belis2.ArbeitsauftragCustomBean;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.log4jquickconfig.Log4JQuickConfig;
import java.io.File;
import java.util.Collection;
import javax.swing.JDialog;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class DeserializeTester {
    private static final transient Logger LOG = Logger.getLogger(BrokerTester.class);
    public static final String CONNECTION_CLASS = "Sirius.navigator.connection.RESTfulConnection";
    public static final String CONNECTION_PROXY_CLASS = "Sirius.navigator.connection.proxy.DefaultConnectionProxyHandler";
    public static final String CALLSERVER_URL = "http://localhost:9917/callserver/binary";
    public static final String CALLSERVER_DOMAIN = "BELIS2";
    public static final String CALLSERVER_USER = "*";
    public static final String CALLSERVER_PASSWORD = "*";
    public static final String CALLSERVER_GROUP = "Bearbeiter";

    public static void main(String[] args) {
        try {
            Log4JQuickConfig.configure4LumbermillOnLocalhost();
            LOG.setLevel(Level.WARN);
            CidsBroker.getInstance().setProxy(DeserializeTester.initProxy());
            SessionManager.init((ConnectionProxy)CidsBroker.getInstance().getProxy());
            DeserializeTester test = new DeserializeTester();
            test.doTest();
            System.exit(0);
        }
        catch (Exception ex) {
            LOG.fatal((Object)ex, (Throwable)ex);
            System.exit(1);
        }
    }

    private void doTest() throws Exception {
        ArbeitsauftragSearchStatement arbeitsauftragSearchStatement = new ArbeitsauftragSearchStatement();
        arbeitsauftragSearchStatement.setAuftragsNummer("%5015");
        LOG.fatal((Object)"execute search");
        Collection col = CidsBroker.getInstance().executeServerSearch((CidsServerSearch)arbeitsauftragSearchStatement);
        Object object = col.iterator().next();
        MetaObjectNode mon = (MetaObjectNode)object;
        int classid = mon.getClassId();
        int objectid = mon.getObjectId();
        LOG.fatal((Object)"construct metaobject");
        MetaObject mo = CidsBroker.getInstance().getMetaObject(classid, objectid, CALLSERVER_DOMAIN);
        LOG.fatal((Object)"construct bean");
        ArbeitsauftragCustomBean aa = (ArbeitsauftragCustomBean)mo.getBean();
        LOG.fatal((Object)"protokollaktion");
        LeuchteLeuchtmittelwechselElekpruefungWizard wizard = new LeuchteLeuchtmittelwechselElekpruefungWizard();
        ArbeitsprotokollDialog dialog = new ArbeitsprotokollDialog(wizard, null, true);
        wizard.setProtokolle(aa.getAr_protokolle());
        StaticSwingTools.showDialog((JDialog)dialog);
        LOG.fatal((Object)"save debugstring to to \"/home/jruiz/test.html\"");
        FileUtils.writeStringToFile((File)new File("/home/jruiz/test.html"), (String)mo.getDebugString());
        LOG.fatal((Object)"start to persist");
        aa.persist();
        LOG.fatal((Object)"persisted");
    }

    private static ConnectionProxy initProxy() throws Exception {
        Connection connection = ConnectionFactory.getFactory().createConnection(CONNECTION_CLASS, CALLSERVER_URL);
        ConnectionInfo connectionInfo = new ConnectionInfo();
        connectionInfo.setCallserverURL(CALLSERVER_URL);
        connectionInfo.setPassword("*");
        connectionInfo.setUserDomain(CALLSERVER_DOMAIN);
        connectionInfo.setUsergroup(CALLSERVER_GROUP);
        connectionInfo.setUsergroupDomain(CALLSERVER_DOMAIN);
        connectionInfo.setUsername("*");
        ConnectionSession session = ConnectionFactory.getFactory().createSession(connection, connectionInfo, true);
        return ConnectionFactory.getFactory().createProxy(CONNECTION_PROXY_CLASS, session);
    }
}

