/*
 * Decompiled with CFR 0.152.
 */
import Sirius.navigator.connection.Connection;
import Sirius.navigator.connection.ConnectionFactory;
import Sirius.navigator.connection.ConnectionInfo;
import Sirius.navigator.connection.ConnectionSession;
import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.connection.proxy.ConnectionProxy;
import Sirius.server.middleware.types.MetaObjectNode;
import de.cismet.belis.broker.BelisBroker;
import de.cismet.belis.broker.CidsBroker;
import de.cismet.belis.gui.widget.DetailWidget;
import de.cismet.belis2.server.search.ArbeitsauftragSearchStatement;
import de.cismet.cids.custom.beans.belis2.ArbeitsauftragCustomBean;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.log4jquickconfig.Log4JQuickConfig;
import java.awt.Frame;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.JDialog;
import javax.swing.SwingWorker;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXLoginPane;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.auth.LoginService;

public class TestMultiBinding {
    private static final transient Logger LOG = Logger.getLogger(TestReport.class);

    public void doLogin(String callServerURL, String domain) {
        CidsAuthentification cidsAuth = new CidsAuthentification(callServerURL, domain);
        JXLoginPane login = new JXLoginPane((LoginService)cidsAuth);
        JXLoginPane.JXLoginDialog loginDialog = new JXLoginPane.JXLoginDialog((Frame)null, login);
        login.setPassword("".toCharArray());
        try {
            ((JXPanel)((JXPanel)login.getComponent(1)).getComponent(1)).getComponent(3).requestFocus();
        }
        catch (Exception ex) {
            LOG.info((Object)"could nor request focus", (Throwable)ex);
        }
        StaticSwingTools.showDialog((JDialog)loginDialog);
        if (loginDialog.getStatus() != JXLoginPane.Status.SUCCEEDED) {
            System.exit(0);
        }
    }

    public static void main(String[] args) {
        Log4JQuickConfig.configure4LumbermillOnLocalhost();
        String callServerURL = "rmi://localhost/callServer";
        String domain = "BELIS2";
        String idString = "00006024";
        TestMultiBinding test = new TestMultiBinding();
        test.doLogin("rmi://localhost/callServer", "BELIS2");
        test.doMultiBinding("00006024");
    }

    public void doMultiBinding(final String id) {
        CidsBroker.getInstance().setProxy(SessionManager.getProxy());
        final DetailWidget detail = new DetailWidget();
        detail.setEnabled(true);
        BelisBroker.getInstance().setDetailWidget(detail);
        final JDialog dialog = new JDialog();
        dialog.setContentPane(detail.getArbeitsauftragPanel());
        StaticSwingTools.showDialog((JDialog)dialog);
        new SwingWorker<ArbeitsauftragCustomBean, Void>(){

            @Override
            protected ArbeitsauftragCustomBean doInBackground() throws Exception {
                ArbeitsauftragSearchStatement searchStatement = new ArbeitsauftragSearchStatement();
                searchStatement.setAuftragsNummer(id);
                try {
                    Collection mons = SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)searchStatement);
                    Iterator iterator = mons.iterator();
                    if (iterator.hasNext()) {
                        MetaObjectNode mon = (MetaObjectNode)iterator.next();
                        ArbeitsauftragCustomBean bean = (ArbeitsauftragCustomBean)CidsBroker.getInstance().getMetaObject(mon.getClassId(), mon.getObjectId(), "BELIS2").getBean();
                        return bean;
                    }
                }
                catch (Exception ex) {
                    LOG.error((Object)ex, (Throwable)ex);
                }
                return null;
            }

            @Override
            protected void done() {
                try {
                    ArbeitsauftragCustomBean arbeitsauftragBean = (ArbeitsauftragCustomBean)this.get();
                    detail.getArbeitsauftragPanel().setCurrentEntity(arbeitsauftragBean);
                    detail.getArbeitsauftragPanel().setEnabled(true);
                    dialog.pack();
                }
                catch (Exception ex) {
                    LOG.error((Object)ex, (Throwable)ex);
                }
            }
        }.execute();
    }

    class CidsAuthentification
    extends LoginService {
        public static final String CONNECTION_PROXY_CLASS = "Sirius.navigator.connection.proxy.DefaultConnectionProxyHandler";
        public static final String CONNECTION_CLASS = "Sirius.navigator.connection.RMIConnection";
        private final String callServerURL;
        private final String domain;

        public CidsAuthentification(String callServerURL, String domain) {
            this.callServerURL = callServerURL;
            this.domain = domain;
        }

        public boolean authenticate(String name, char[] password, String server) throws Exception {
            System.setProperty("sun.rmi.transport.connectionTimeout", "15");
            String[] split = name.split("@");
            String user = split.length > 1 ? split[0] : name;
            String group = split.length > 1 ? split[1] : null;
            String connectionclass = CONNECTION_CLASS;
            try {
                Connection connection = ConnectionFactory.getFactory().createConnection(CONNECTION_CLASS, this.callServerURL);
                ConnectionInfo connectionInfo = new ConnectionInfo();
                connectionInfo.setCallserverURL(this.callServerURL);
                connectionInfo.setPassword(new String(password));
                connectionInfo.setUserDomain(this.domain);
                connectionInfo.setUsergroup(group);
                connectionInfo.setUsergroupDomain(this.domain);
                connectionInfo.setUsername(user);
                ConnectionSession session = ConnectionFactory.getFactory().createSession(connection, connectionInfo, true);
                ConnectionProxy proxy = ConnectionFactory.getFactory().createProxy(CONNECTION_PROXY_CLASS, session);
                SessionManager.init((ConnectionProxy)proxy);
                ClassCacheMultiple.setInstance((String)this.domain);
                return true;
            }
            catch (Throwable t) {
                LOG.error((Object)"Fehler beim Anmelden", t);
                return false;
            }
        }
    }
}

