/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.belis.broker;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.connection.proxy.ConnectionProxy;
import Sirius.navigator.exception.ConnectionException;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import Sirius.server.middleware.types.MetaObjectNode;
import de.cismet.belis.broker.CsvExportBackend;
import de.cismet.belis.gui.widget.KeyTableListener;
import de.cismet.belis2.server.action.LockEntitiesServerAction;
import de.cismet.belis2.server.search.LockedEntitySearch;
import de.cismet.belis2.server.utils.ActionNotSuccessfulException;
import de.cismet.belis2.server.utils.LockAlreadyExistsException;
import de.cismet.belisEE.util.EntityComparator;
import de.cismet.belisEE.util.StandortKey;
import de.cismet.cids.custom.beans.belis2.ArbeitsauftragCustomBean;
import de.cismet.cids.custom.beans.belis2.ArbeitsprotokollCustomBean;
import de.cismet.cids.custom.beans.belis2.MauerlascheCustomBean;
import de.cismet.cids.custom.beans.belis2.SchaltstelleCustomBean;
import de.cismet.cids.custom.beans.belis2.SperreCustomBean;
import de.cismet.cids.custom.beans.belis2.TdtaStandortMastCustomBean;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.cismap.commons.BoundingBox;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.commons.server.entity.BaseEntity;
import de.cismet.commons.server.entity.WorkbenchEntity;
import de.cismet.commons.server.entity.WorkbenchFeatureEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.TreeSet;
import org.apache.commons.collections.comparators.ReverseComparator;
import org.apache.log4j.Logger;

public class CidsBroker {
    private static final Logger LOG = Logger.getLogger(CidsBroker.class);
    public static final String BELIS_DOMAIN = "BELIS2";
    private static CidsBroker brokerInstance = null;
    HashMap<String, Collection<KeyTableListener>> keyTableListeners = new HashMap();
    private ConnectionProxy proxy = null;

    public static synchronized CidsBroker getInstance() {
        if (brokerInstance == null) {
            brokerInstance = new CidsBroker();
        }
        return brokerInstance;
    }

    public ConnectionProxy getProxy() {
        return this.proxy;
    }

    public void setProxy(ConnectionProxy proxy) {
        this.proxy = proxy;
        CsvExportBackend.getInstance().init();
    }

    public Object executeServerAction(String taskname, Object body, ServerActionParameter ... params) throws ConnectionException {
        Object result = this.getProxy().executeTask(taskname, BELIS_DOMAIN, body, params);
        return result;
    }

    public MetaClass getMetaClass(String tablename, String domain) {
        try {
            return CidsBean.getMetaClassFromTableName((String)domain, (String)tablename);
        }
        catch (Exception ex) {
            LOG.error((Object)("couldn't load metaclass for " + tablename), (Throwable)ex);
            return null;
        }
    }

    public MetaClass getMetaClass(Integer id, String domain) {
        try {
            return this.proxy.getMetaClass(id.intValue(), domain);
        }
        catch (ConnectionException ex) {
            LOG.error((Object)("couldn't load metaclass with the id =" + id), (Throwable)ex);
            return null;
        }
    }

    public MetaClass getBelisMetaClass(String tablename) {
        return this.getMetaClass(tablename, BELIS_DOMAIN);
    }

    public MetaObject[] getBelisMetaObject(String query) {
        return this.getMetaObject(query, BELIS_DOMAIN);
    }

    public MetaObject[] getMetaObject(String query, String domain) {
        MetaObject[] mos = null;
        try {
            mos = this.getProxy().getMetaObjectByQuery(SessionManager.getSession().getUser(), query, domain);
        }
        catch (ConnectionException ex) {
            LOG.error((Object)"error retrieving metaobject by query", (Throwable)ex);
        }
        return mos;
    }

    public boolean checkForDelete() {
        try {
            return this.getProxy().hasConfigAttr(SessionManager.getSession().getUser(), "belis.delete");
        }
        catch (Exception ex) {
            return false;
        }
    }

    public boolean checkForCreateBasic() {
        try {
            return this.getProxy().hasConfigAttr(SessionManager.getSession().getUser(), "belis.create.Basic");
        }
        catch (Exception ex) {
            return false;
        }
    }

    public boolean checkForEditBasic() {
        try {
            return this.getProxy().hasConfigAttr(SessionManager.getSession().getUser(), "belis.edit.Basic");
        }
        catch (Exception ex) {
            return false;
        }
    }

    public boolean checkForCreateVeranlassung() {
        try {
            return this.getProxy().hasConfigAttr(SessionManager.getSession().getUser(), "belis.create.Veranlassung");
        }
        catch (Exception ex) {
            return false;
        }
    }

    public boolean checkForEditVeranlassung() {
        try {
            return this.getProxy().hasConfigAttr(SessionManager.getSession().getUser(), "belis.edit.Veranlassung");
        }
        catch (Exception ex) {
            return false;
        }
    }

    public boolean checkForCreateArbeitsauftrag() {
        try {
            return this.getProxy().hasConfigAttr(SessionManager.getSession().getUser(), "belis.create.Arbeitsauftrag");
        }
        catch (Exception ex) {
            return false;
        }
    }

    public boolean checkForEditArbeitsauftrag() {
        try {
            return this.getProxy().hasConfigAttr(SessionManager.getSession().getUser(), "belis.edit.Arbeitsauftrag");
        }
        catch (Exception ex) {
            return false;
        }
    }

    public boolean checkForEditKeytables() {
        try {
            return this.getProxy().hasConfigAttr(SessionManager.getSession().getUser(), "belis.edit.Keytables");
        }
        catch (Exception ex) {
            return false;
        }
    }

    public MetaObject getMetaObject(int classid, int objectid, String domain) {
        MetaObject mos = null;
        try {
            mos = this.getProxy().getMetaObject(SessionManager.getSession().getUser(), objectid, classid, domain);
        }
        catch (ConnectionException ex) {
            LOG.error((Object)"error retrieving metaobject by id", (Throwable)ex);
        }
        return mos;
    }

    public void addListenerForKeyTableChange(String className, KeyTableListener listener) {
        Collection<KeyTableListener> listeners = this.keyTableListeners.get(className.toLowerCase());
        if (listeners == null) {
            listeners = new ArrayList<KeyTableListener>();
            this.keyTableListeners.put(className.toLowerCase(), listeners);
        }
        listeners.add(listener);
    }

    public void removeListenerForKeyTableChange(String className, KeyTableListener listener) {
        Collection<KeyTableListener> listeners = this.keyTableListeners.get(className.toLowerCase());
        if (listeners != null) {
            listeners.remove(listener);
            if (listeners.isEmpty()) {
                this.keyTableListeners.remove(className.toLowerCase());
            }
        }
    }

    public void fireListenerForKeyTableChange(String className) {
        Collection<KeyTableListener> listeners = this.keyTableListeners.get(className.toLowerCase());
        if (listeners != null) {
            for (KeyTableListener listener : listeners) {
                listener.keyTableChanged();
            }
        }
    }

    public Collection refreshAll(String className) {
        className = className.toLowerCase();
        MetaClass metaclass = CidsBroker.getInstance().getBelisMetaClass(className);
        if (metaclass == null) {
            return null;
        }
        MetaObject[] mos = CidsBroker.getInstance().getBelisMetaObject("SELECT " + metaclass.getID() + ", " + metaclass.getTableName() + "." + metaclass.getPrimaryKey() + " FROM " + metaclass.getTableName());
        HashSet<CidsBean> beans = new HashSet<CidsBean>();
        for (MetaObject metaObject : mos) {
            beans.add(metaObject.getBean());
        }
        this.fireListenerForKeyTableChange(className);
        return beans;
    }

    public TreeSet<BaseEntity> getObjectsByKey(String strassenschluessel, Integer kennziffer, Integer laufendeNummer) throws ActionNotSuccessfulException {
        Collection<TdtaStandortMastCustomBean> standorte = this.retrieveStandort(new StandortKey(strassenschluessel, kennziffer, laufendeNummer));
        Collection<SchaltstelleCustomBean> schaltstellen = this.retrieveSchaltstelle(strassenschluessel, laufendeNummer);
        Collection<MauerlascheCustomBean> mauerlaschen = this.retrieveMauerlasche(strassenschluessel, laufendeNummer);
        TreeSet<BaseEntity> results = new TreeSet<BaseEntity>((Comparator<BaseEntity>)new ReverseComparator((Comparator)new EntityComparator()));
        if (standorte != null) {
            results.addAll(standorte);
        }
        if (schaltstellen != null) {
            results.addAll(schaltstellen);
        }
        if (mauerlaschen != null) {
            results.addAll(mauerlaschen);
        }
        return results;
    }

    public Collection<TdtaStandortMastCustomBean> retrieveStandort(StandortKey key) throws ActionNotSuccessfulException {
        try {
            Collection result;
            Integer lfdNummer;
            MetaClass metaclass = this.getMetaClass("tdta_standort_mast", BELIS_DOMAIN);
            if (key == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"The search key is null");
                }
                throw new ActionNotSuccessfulException("The search key is null");
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Finde Standort: ");
                LOG.debug((Object)("Strassenschl\u00fcssel       : " + key.getStrassenschluessel().getPk()));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Kennziffer: " + key.getKennziffer()));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("laufende Nummer : " + key.getLaufendeNummer()));
            }
            String strasse = null;
            if (key.getStrassenschluessel() == null || (strasse = key.getStrassenschluessel().getPk()) == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"At least the strassenschluessel must be != null");
                }
                return null;
            }
            Integer kennziffer = null;
            if ((key.getKennziffer() == null || (kennziffer = key.getKennziffer().getKennziffer()) == null) && LOG.isDebugEnabled()) {
                LOG.debug((Object)"kennziffer is null --> wildcard");
            }
            if ((lfdNummer = key.getLaufendeNummer()) == null && LOG.isDebugEnabled()) {
                LOG.debug((Object)"lfdNummer is null --> wildcard");
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Strasse: " + strasse));
            }
            if ((result = strasse != null && lfdNummer != null && kennziffer != null ? this.getBeanCollectionForQuery("SELECT " + metaclass.getID() + ", " + metaclass.getTableName() + "." + metaclass.getPrimaryKey() + "  FROM " + metaclass.getTableName() + " s WHERE s.strassenschluessel.pk = " + strasse + " AND s.kennziffer.kennziffer = " + kennziffer + " AND s.laufendeNummer = " + lfdNummer + "", BELIS_DOMAIN) : (strasse != null && lfdNummer != null ? this.getBeanCollectionForQuery("SELECT " + metaclass.getID() + ", " + metaclass.getTableName() + "." + metaclass.getPrimaryKey() + "  FROM " + metaclass.getTableName() + " s WHERE s.strassenschluessel.pk = " + strasse + " AND s.laufendeNummer = " + lfdNummer + "", BELIS_DOMAIN) : (strasse != null && kennziffer != null ? this.getBeanCollectionForQuery("SELECT " + metaclass.getID() + ", " + metaclass.getTableName() + "." + metaclass.getPrimaryKey() + "  FROM " + metaclass.getTableName() + " s WHERE s.strassenschluessel.pk = " + strasse + " AND s.kennziffer.kennziffer = " + kennziffer + "", BELIS_DOMAIN) : this.getBeanCollectionForQuery("SELECT " + metaclass.getID() + ", " + metaclass.getTableName() + "." + metaclass.getPrimaryKey() + "  FROM " + metaclass.getTableName() + " s WHERE s.strassenschluessel.pk = " + strasse + "", BELIS_DOMAIN)))) != null && !result.isEmpty()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Found Standort");
                }
                return new HashSet<TdtaStandortMastCustomBean>(result);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"No Standort found");
            }
            return null;
        }
        catch (Exception ex) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Failure during Standort querying: " + key), (Throwable)ex);
            }
            throw new ActionNotSuccessfulException("Failure during Standort querying");
        }
    }

    public Collection getBeanCollectionForQuery(String query, String domain) {
        MetaObject[] mos = CidsBroker.getInstance().getMetaObject(query, domain);
        HashSet<CidsBean> beans = new HashSet<CidsBean>();
        for (MetaObject metaObject : mos) {
            beans.add(metaObject.getBean());
        }
        return beans;
    }

    public Collection<SchaltstelleCustomBean> retrieveSchaltstelle(String key, Integer laufendeNummer) throws ActionNotSuccessfulException {
        try {
            Collection result;
            MetaClass metaclass = this.getMetaClass("schaltstelle", BELIS_DOMAIN);
            if (key == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"The search key is null");
                }
                throw new ActionNotSuccessfulException("The search key is null");
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Finde Schaltstelle: ");
                LOG.debug((Object)("Strassenschl\u00fcssel       : " + key));
            }
            if (key == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"The strassenschluessel must be != null");
                }
                return null;
            }
            Object lfdNummer = null;
            if (laufendeNummer == null && LOG.isDebugEnabled()) {
                LOG.debug((Object)"lfdNummer is null --> wildcard");
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Strasse: " + key));
            }
            if ((result = key != null && lfdNummer != null ? this.getBeanCollectionForQuery("SELECT " + metaclass.getID() + ", " + metaclass.getTableName() + "." + metaclass.getPrimaryKey() + "  FROM " + metaclass.getTableName() + " s WHERE s.strassenschluessel.pk = " + key + " AND s.laufendeNummer = " + lfdNummer + "", BELIS_DOMAIN) : this.getBeanCollectionForQuery("SELECT " + metaclass.getID() + ", " + metaclass.getTableName() + "." + metaclass.getPrimaryKey() + "  FROM " + metaclass.getTableName() + " s WHERE s.strassenschluessel.pk = " + key + "", BELIS_DOMAIN)) != null && !result.isEmpty()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Found Schaltstelle");
                }
                return new HashSet<SchaltstelleCustomBean>(result);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"No Schaltstelle found");
            }
            return null;
        }
        catch (Exception ex) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Failure during Schaltstelle querying: " + key), (Throwable)ex);
            }
            throw new ActionNotSuccessfulException("Failure during Schaltstelle querying");
        }
    }

    public Collection<MauerlascheCustomBean> retrieveMauerlasche(String key, Integer laufendeNummer) throws ActionNotSuccessfulException {
        try {
            Collection result;
            MetaClass metaclass = this.getMetaClass("mauerlasche", BELIS_DOMAIN);
            if (key == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"The search key is null");
                }
                throw new ActionNotSuccessfulException("The search key is null");
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Finde Mauerlasche: ");
                LOG.debug((Object)("Strassenschl\u00fcssel       : " + key));
            }
            String strasse = null;
            if (key == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"The strassenschluessel must be != null");
                }
                return null;
            }
            Object lfdNummer = null;
            if (laufendeNummer == null && LOG.isDebugEnabled()) {
                LOG.debug((Object)"lfdNummer is null --> wildcard");
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Strasse: " + strasse));
            }
            if ((result = strasse != null && lfdNummer != null ? this.getBeanCollectionForQuery("SELECT " + metaclass.getID() + ", " + metaclass.getTableName() + "." + metaclass.getPrimaryKey() + "  FROM " + metaclass.getTableName() + " m WHERE m.strassenschluessel.pk = " + strasse + " AND m.laufendeNummer = " + lfdNummer + "", BELIS_DOMAIN) : this.getBeanCollectionForQuery("SELECT " + metaclass.getID() + ", " + metaclass.getTableName() + "." + metaclass.getPrimaryKey() + "  FROM " + metaclass.getTableName() + " m WHERE m.strassenschluessel.pk = " + strasse + "", BELIS_DOMAIN)) != null && !result.isEmpty()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Found Mauerlasche");
                }
                return new HashSet<MauerlascheCustomBean>(result);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"No Mauerlasche found");
            }
            return null;
        }
        catch (Exception ex) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Failure during Mauerlasche querying: " + key), (Throwable)ex);
            }
            throw new ActionNotSuccessfulException("Failure during Mauerlasche querying");
        }
    }

    public Collection<WorkbenchEntity> saveObjects(Collection<WorkbenchEntity> objectsToSave) throws ActionNotSuccessfulException {
        ArrayList<WorkbenchEntity> errornousEntities;
        TreeSet<WorkbenchEntity> savedEntities;
        block13: {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"save objects");
            }
            savedEntities = new TreeSet<WorkbenchEntity>((Comparator<WorkbenchEntity>)new ReverseComparator((Comparator)new EntityComparator()));
            errornousEntities = new ArrayList<WorkbenchEntity>();
            try {
                if (objectsToSave != null) {
                    for (WorkbenchEntity curEntity : objectsToSave) {
                        try {
                            if (curEntity == null) continue;
                            if (curEntity.getId() == null) {
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug((Object)"Entity Id is not set --> persisting entity (create).");
                                }
                                savedEntities.add((WorkbenchEntity)curEntity.persist());
                                continue;
                            }
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)"Entity Id is set --> merge entity (update).");
                            }
                            savedEntities.add((WorkbenchEntity)curEntity.persist());
                        }
                        catch (Exception ex) {
                            LOG.error((Object)("Error while saving Entity: " + curEntity), (Throwable)ex);
                            errornousEntities.add(curEntity);
                        }
                    }
                    break block13;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"There are no Objects to save.");
                }
                throw new ActionNotSuccessfulException("There are no Objects to save.");
            }
            catch (Exception ex) {
                LOG.error((Object)"Error while saving entities", (Throwable)ex);
                throw new ActionNotSuccessfulException("Error while saving entities", (Throwable)ex);
            }
        }
        if (!errornousEntities.isEmpty()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("There were problems during saving the entities errorCount: " + errornousEntities.size()));
            }
            throw new ActionNotSuccessfulException("There were problems during saving the entities", errornousEntities);
        }
        return savedEntities;
    }

    public Collection executeServerSearch(CidsServerSearch search) throws Exception {
        return this.proxy.customServerSearch(this.proxy.getSession().getUser(), search);
    }

    public Collection<BaseEntity> refreshObjects(Collection<BaseEntity> objectsToRefresh) throws ActionNotSuccessfulException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"refresh objects");
        }
        ArrayList<BaseEntity> errornousEntities = new ArrayList<BaseEntity>();
        TreeSet refreshedObjects = new TreeSet(new ReverseComparator((Comparator)new EntityComparator()));
        HashMap entityIDs = new HashMap();
        try {
            if (objectsToRefresh != null && objectsToRefresh.size() > 0) {
                for (BaseEntity curEntity : objectsToRefresh) {
                    try {
                        String className = curEntity.getMetaObject().getMetaClass().getName();
                        if (entityIDs.containsKey(className)) {
                            ArrayList classIdList = (ArrayList)entityIDs.get(className);
                            classIdList.add(curEntity.getId());
                        } else {
                            ArrayList<Integer> newClassIdList = new ArrayList<Integer>();
                            newClassIdList.add(curEntity.getId());
                            entityIDs.put(className, newClassIdList);
                        }
                        for (String curClassName : entityIDs.keySet()) {
                            String idIn;
                            Integer[] ids = ((ArrayList)entityIDs.get(curClassName)).toArray(new Integer[0]);
                            if (ids.length == 0) {
                                idIn = "";
                            } else {
                                StringBuilder sb = new StringBuilder();
                                sb.append(ids[0]);
                                for (int index = 1; index < ids.length; ++index) {
                                    sb.append(", ");
                                    sb.append(ids[index]);
                                }
                                idIn = sb.toString();
                            }
                            MetaClass curMetaClass = this.getMetaClass(curClassName, BELIS_DOMAIN);
                            MetaObject[] mos = CidsBroker.getInstance().getMetaObject("SELECT " + curMetaClass.getID() + ", " + curMetaClass.getPrimaryKey() + " FROM " + curMetaClass.getTableName() + " WHERE id IN (" + idIn + ");", BELIS_DOMAIN);
                            ArrayList<CidsBean> curClassResults = new ArrayList<CidsBean>(mos.length);
                            for (MetaObject mo : mos) {
                                curClassResults.add(mo.getBean());
                            }
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("found: " + curClassResults));
                            }
                            refreshedObjects.addAll(curClassResults);
                        }
                    }
                    catch (Exception ex) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Error while refreshing Entity: " + (Object)((Object)curEntity)), (Throwable)ex);
                        }
                        errornousEntities.add(curEntity);
                    }
                }
                if (errornousEntities.isEmpty()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"refreshing of entities successful");
                    }
                } else {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("There were problems during refreshing the entities errorCount: " + errornousEntities.size()));
                    }
                    throw new ActionNotSuccessfulException("There were problems during refreshing the entities", errornousEntities);
                }
                return new HashSet<BaseEntity>(refreshedObjects);
            }
            return new HashSet<BaseEntity>();
        }
        catch (Exception ex) {
            LOG.error((Object)"Error while refreshing entities", (Throwable)ex);
            throw new ActionNotSuccessfulException("Error while refreshing entities", (Throwable)ex);
        }
    }

    public void deleteEntities(Collection<WorkbenchEntity> objectsToDelete) throws ActionNotSuccessfulException {
        try {
            if (objectsToDelete != null) {
                for (WorkbenchEntity objectToDelete : objectsToDelete) {
                    if (objectToDelete == null) continue;
                    objectToDelete.setIs_deleted(Boolean.TRUE);
                    objectToDelete.persist();
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)"deleting of entity successful");
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"deleting of all entities successful");
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"Error while deleting entities", (Throwable)ex);
            throw new ActionNotSuccessfulException("Error while deleting entities", (Throwable)ex);
        }
    }

    public TreeSet getObjectsByBoundingBox(BoundingBox bb) throws ActionNotSuccessfulException {
        TreeSet result = new TreeSet(new ReverseComparator((Comparator)new EntityComparator()));
        Collection curClassResults = this.getBeanCollectionForQuery("SELECT classid, objectid  FROM ( SELECT 5 as classid, id as objectid, fk_geom FROM abzweigdose  UNION SELECT 14, id, fk_geom FROM mauerlasche UNION SELECT 11, id, fk_geom FROM leitung UNION SELECT 15, id, fk_geom FROM schaltstelle UNION SELECT 29, id, fk_geom FROM tdta_standort_mast) AS geom_objects, geom WHERE geom.id = geom_objects.fk_geom AND envelope(ST_geometryfromtext('" + bb.getGeometryFromTextLineString() + "', " + CrsTransformer.getCurrentSrid() + ")) && geom.geo_field", BELIS_DOMAIN);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("found: " + curClassResults));
        }
        result.addAll(curClassResults);
        return result;
    }

    public SperreCustomBean lockEntities(Collection<WorkbenchEntity> objectsToLock, String userString) throws ActionNotSuccessfulException, LockAlreadyExistsException {
        Object ret;
        ArrayList<ServerActionParameter> entityKeySAP = new ArrayList<ServerActionParameter>();
        ArrayList<WorkbenchEntity> lockAlso = new ArrayList<WorkbenchEntity>();
        for (WorkbenchEntity objectToLock : objectsToLock) {
            if (!(objectToLock instanceof ArbeitsauftragCustomBean)) continue;
            ArbeitsauftragCustomBean arbeitsauftrag = (ArbeitsauftragCustomBean)objectToLock;
            for (ArbeitsprotokollCustomBean protokoll : arbeitsauftrag.getAr_protokolle()) {
                lockAlso.add(protokoll);
                WorkbenchFeatureEntity childEntity = protokoll.getChildEntity();
                if (childEntity == null) continue;
                lockAlso.add(childEntity);
            }
        }
        objectsToLock.addAll(lockAlso);
        for (WorkbenchEntity objectToLock : objectsToLock) {
            if (objectToLock.getId() == null || objectToLock.getMetaObject().getClassID() < 0) continue;
            entityKeySAP.add(new ServerActionParameter(LockEntitiesServerAction.ParameterType.ENTITY_KEY.name(), (Object)(objectToLock.getId() + "@" + objectToLock.getMetaObject().getClassID())));
        }
        try {
            ret = this.executeServerAction(new LockEntitiesServerAction().getTaskName(), null, entityKeySAP.toArray(new ServerActionParameter[0]));
        }
        catch (ConnectionException ex) {
            throw new ActionNotSuccessfulException(ex.getMessage(), (Throwable)ex);
        }
        if (ret instanceof ActionNotSuccessfulException) {
            throw (ActionNotSuccessfulException)((Object)ret);
        }
        if (ret instanceof LockAlreadyExistsException) {
            throw (LockAlreadyExistsException)((Object)ret);
        }
        return (SperreCustomBean)CidsBroker.getInstance().getMetaObject(((MetaObjectNode)ret).getClassId(), ((MetaObjectNode)ret).getObjectId(), BELIS_DOMAIN).getBean();
    }

    public static String implode(String[] stringArray, String delimiter) {
        if (stringArray.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(stringArray[0]);
        for (int index = 1; index < stringArray.length; ++index) {
            sb.append(delimiter);
            String string = stringArray[index];
            if (string == null) continue;
            sb.append(string);
        }
        return sb.toString();
    }

    public Collection<SperreCustomBean> checkIfLocked(Collection<WorkbenchEntity> objectsToCheck) throws Exception {
        ArrayList<String> entityKeys = new ArrayList<String>();
        for (WorkbenchEntity objectToCheck : objectsToCheck) {
            entityKeys.add(objectToCheck.getId() + "@" + objectToCheck.getMetaObject().getClassID());
        }
        Collection mons = this.executeServerSearch((CidsServerSearch)new LockedEntitySearch(entityKeys));
        ArrayList<SperreCustomBean> beanColl = new ArrayList<SperreCustomBean>();
        for (MetaObjectNode mon : mons) {
            MetaObject mo = CidsBroker.getInstance().getMetaObject(mon.getClassId(), mon.getObjectId(), BELIS_DOMAIN);
            if (mo == null) continue;
            beanColl.add((SperreCustomBean)mo.getBean());
        }
        return beanColl;
    }

    public void unlock(SperreCustomBean holdedLock) throws ActionNotSuccessfulException {
        try {
            if (holdedLock != null) {
                holdedLock.delete();
                holdedLock.persist();
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"Failure while releasing lock", (Throwable)ex);
            throw new ActionNotSuccessfulException("Failure while releasing lock", (Throwable)ex);
        }
    }
}

