/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.belis.broker;

import de.cismet.belis.broker.BelisBroker;
import de.cismet.belis.broker.CidsBroker;
import de.cismet.belis.broker.EntityClipboardListener;
import de.cismet.belis.todo.CustomMutableTreeTableNode;
import de.cismet.cids.custom.beans.belis2.AbzweigdoseCustomBean;
import de.cismet.cids.custom.beans.belis2.ArbeitsauftragCustomBean;
import de.cismet.cids.custom.beans.belis2.ArbeitsprotokollCustomBean;
import de.cismet.cids.custom.beans.belis2.GeometrieCustomBean;
import de.cismet.cids.custom.beans.belis2.LeitungCustomBean;
import de.cismet.cids.custom.beans.belis2.MauerlascheCustomBean;
import de.cismet.cids.custom.beans.belis2.SchaltstelleCustomBean;
import de.cismet.cids.custom.beans.belis2.TdtaLeuchtenCustomBean;
import de.cismet.cids.custom.beans.belis2.TdtaStandortMastCustomBean;
import de.cismet.cids.custom.beans.belis2.VeranlassungCustomBean;
import de.cismet.commons.server.entity.WorkbenchEntity;
import de.cismet.commons.server.entity.WorkbenchFeatureEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class EntityClipboard {
    private static final Logger LOG = Logger.getLogger(EntityClipboard.class);
    private final Collection<WorkbenchEntity> clipboardBeans = new ArrayList<WorkbenchEntity>();
    private final List<EntityClipboardListener> listeners = new ArrayList<EntityClipboardListener>();
    private final BelisBroker broker;

    public EntityClipboard(BelisBroker broker) {
        this.broker = broker;
    }

    public boolean addListener(EntityClipboardListener listener) {
        return this.listeners.add(listener);
    }

    public boolean removeListener(EntityClipboardListener listener) {
        return this.listeners.remove(listener);
    }

    protected void fireClipboardChanged() {
        for (EntityClipboardListener listener : this.listeners) {
            listener.clipboardChanged();
        }
    }

    public Collection<WorkbenchEntity> getClipboardBeans() {
        return this.clipboardBeans;
    }

    public void paste() {
        if (this.isPastable()) {
            try {
                CustomMutableTreeTableNode selectedNode = this.getSelectedNodeForPaste();
                Object selectedObject = selectedNode.getUserObject();
                if (selectedObject instanceof ArbeitsauftragCustomBean && CidsBroker.getInstance().checkForEditArbeitsauftrag()) {
                    ArbeitsauftragCustomBean arbeitsauftragCustomBean = (ArbeitsauftragCustomBean)selectedObject;
                    for (WorkbenchEntity clipboardBean : this.clipboardBeans) {
                        if (clipboardBean instanceof VeranlassungCustomBean) {
                            HashSet<WorkbenchFeatureEntity> allBasics = new HashSet<WorkbenchFeatureEntity>();
                            VeranlassungCustomBean veranlassungCustomBean = (VeranlassungCustomBean)clipboardBean;
                            allBasics.addAll(veranlassungCustomBean.getAr_abzweigdosen());
                            allBasics.addAll(veranlassungCustomBean.getAr_leitungen());
                            allBasics.addAll(veranlassungCustomBean.getAr_leuchten());
                            allBasics.addAll(veranlassungCustomBean.getAr_mauerlaschen());
                            allBasics.addAll(veranlassungCustomBean.getAr_schaltstellen());
                            allBasics.addAll(veranlassungCustomBean.getAr_geometrien());
                            allBasics.addAll(veranlassungCustomBean.getAr_standorte());
                            for (WorkbenchEntity workbenchEntity : allBasics) {
                                ArbeitsprotokollCustomBean protokoll = this.broker.createProtokollFromBasic(workbenchEntity);
                                protokoll.setVeranlassungsnummer(veranlassungCustomBean.getNummer());
                                protokoll.setProtokollnummer(arbeitsauftragCustomBean.getAr_protokolle().size() + 1);
                                this.broker.addNewProtokollToAuftragNode(selectedNode, protokoll, workbenchEntity);
                                arbeitsauftragCustomBean.getAr_protokolle().add(protokoll);
                            }
                            continue;
                        }
                        ArbeitsprotokollCustomBean protokoll = this.broker.createProtokollFromBasic(clipboardBean);
                        protokoll.setProtokollnummer(arbeitsauftragCustomBean.getAr_protokolle().size() + 1);
                        this.broker.addNewProtokollToAuftragNode(selectedNode, protokoll, clipboardBean);
                        arbeitsauftragCustomBean.getAr_protokolle().add(protokoll);
                    }
                } else if (selectedObject instanceof VeranlassungCustomBean && CidsBroker.getInstance().checkForEditVeranlassung()) {
                    VeranlassungCustomBean veranlassungCustomBean = (VeranlassungCustomBean)selectedObject;
                    for (WorkbenchEntity clipboardBean : this.clipboardBeans) {
                        Collection<GeometrieCustomBean> geometrien;
                        if (clipboardBean instanceof TdtaStandortMastCustomBean) {
                            Collection<TdtaStandortMastCustomBean> standorte = veranlassungCustomBean.getAr_standorte();
                            if (standorte.contains((TdtaStandortMastCustomBean)clipboardBean)) continue;
                            standorte.add((TdtaStandortMastCustomBean)clipboardBean);
                            this.broker.addNewBasicToVeranlassungNode(selectedNode, clipboardBean);
                            continue;
                        }
                        if (clipboardBean instanceof TdtaLeuchtenCustomBean) {
                            Collection<TdtaLeuchtenCustomBean> leuchten = veranlassungCustomBean.getAr_leuchten();
                            if (leuchten.contains((TdtaLeuchtenCustomBean)clipboardBean)) continue;
                            leuchten.add((TdtaLeuchtenCustomBean)clipboardBean);
                            this.broker.addNewBasicToVeranlassungNode(selectedNode, clipboardBean);
                            continue;
                        }
                        if (clipboardBean instanceof LeitungCustomBean) {
                            Collection<LeitungCustomBean> leitungen = veranlassungCustomBean.getAr_leitungen();
                            if (leitungen.contains((LeitungCustomBean)clipboardBean)) continue;
                            leitungen.add((LeitungCustomBean)clipboardBean);
                            this.broker.addNewBasicToVeranlassungNode(selectedNode, clipboardBean);
                            continue;
                        }
                        if (clipboardBean instanceof MauerlascheCustomBean) {
                            Collection<MauerlascheCustomBean> mauerlaschen = veranlassungCustomBean.getAr_mauerlaschen();
                            if (mauerlaschen.contains((MauerlascheCustomBean)clipboardBean)) continue;
                            mauerlaschen.add((MauerlascheCustomBean)clipboardBean);
                            this.broker.addNewBasicToVeranlassungNode(selectedNode, clipboardBean);
                            continue;
                        }
                        if (clipboardBean instanceof AbzweigdoseCustomBean) {
                            Collection<AbzweigdoseCustomBean> abzweigdosen = veranlassungCustomBean.getAr_abzweigdosen();
                            if (abzweigdosen.contains((AbzweigdoseCustomBean)clipboardBean)) continue;
                            abzweigdosen.add((AbzweigdoseCustomBean)clipboardBean);
                            this.broker.addNewBasicToVeranlassungNode(selectedNode, clipboardBean);
                            continue;
                        }
                        if (clipboardBean instanceof SchaltstelleCustomBean) {
                            Collection<SchaltstelleCustomBean> schaltstellen = veranlassungCustomBean.getAr_schaltstellen();
                            if (schaltstellen.contains((SchaltstelleCustomBean)clipboardBean)) continue;
                            schaltstellen.add((SchaltstelleCustomBean)clipboardBean);
                            this.broker.addNewBasicToVeranlassungNode(selectedNode, clipboardBean);
                            continue;
                        }
                        if (!(clipboardBean instanceof GeometrieCustomBean) || (geometrien = veranlassungCustomBean.getAr_geometrien()).contains((GeometrieCustomBean)clipboardBean)) continue;
                        geometrien.add((GeometrieCustomBean)clipboardBean);
                        this.broker.addNewBasicToVeranlassungNode(selectedNode, clipboardBean);
                    }
                }
                this.clear();
            }
            catch (Exception ex) {
                LOG.error((Object)"error while pasting bean", (Throwable)ex);
            }
        }
    }

    private void clear() {
        this.clipboardBeans.clear();
        this.fireClipboardChanged();
    }

    public WorkbenchEntity createPastedBean(WorkbenchEntity clipboardBean) throws Exception {
        return null;
    }

    public boolean isPastable() {
        return (this.broker.isInCreateMode() || this.broker.isInEditMode()) && !this.clipboardBeans.isEmpty() && this.getSelectedNodeForPaste() != null;
    }

    public boolean isCopyable() {
        return !this.getSelectedBeansForCopy().isEmpty();
    }

    private Collection<WorkbenchEntity> getSelectedBeansForCopy() {
        ArrayList<WorkbenchEntity> beans = new ArrayList<WorkbenchEntity>();
        Collection<TreePath> paths = this.broker.getWorkbenchWidget().getSelectedTreeNodes();
        if (paths != null) {
            for (TreePath path : paths) {
                CustomMutableTreeTableNode node = (CustomMutableTreeTableNode)((Object)path.getLastPathComponent());
                if (node == null) continue;
                Object object = node.getUserObject();
                if ((!this.broker.isFilterVeranlassung() || !(object instanceof VeranlassungCustomBean)) && (!this.broker.isFilterNormal() || !(object instanceof WorkbenchEntity) && !(object instanceof GeometrieCustomBean))) continue;
                beans.add((WorkbenchEntity)object);
            }
        }
        return beans;
    }

    private CustomMutableTreeTableNode getSelectedNodeForPaste() {
        CustomMutableTreeTableNode node;
        Collection<TreePath> paths = this.broker.getWorkbenchWidget().getSelectedTreeNodes();
        if (paths != null && paths.size() == 1 && (node = (CustomMutableTreeTableNode)((Object)paths.iterator().next().getLastPathComponent())) != null) {
            Object object = node.getUserObject();
            if (object instanceof ArbeitsauftragCustomBean && CidsBroker.getInstance().checkForEditArbeitsauftrag()) {
                return node;
            }
            if (object instanceof VeranlassungCustomBean && CidsBroker.getInstance().checkForEditVeranlassung()) {
                return node;
            }
        }
        return null;
    }

    public boolean copy() {
        if (this.isCopyable()) {
            Collection<WorkbenchEntity> selectedBeans = this.getSelectedBeansForCopy();
            if (selectedBeans != null && !selectedBeans.isEmpty()) {
                try {
                    this.clipboardBeans.clear();
                    for (WorkbenchEntity cidsBean : selectedBeans) {
                        this.clipboardBeans.add(cidsBean);
                    }
                    this.fireClipboardChanged();
                    return true;
                }
                catch (Exception ex) {
                    LOG.error((Object)"error while copying or cutting cidsbean", (Throwable)ex);
                    this.clear();
                    return false;
                }
            }
            return false;
        }
        return false;
    }
}

