/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.belis.client;

import Sirius.navigator.DefaultNavigatorExceptionHandler;
import Sirius.navigator.connection.Connection;
import Sirius.navigator.connection.ConnectionFactory;
import Sirius.navigator.connection.ConnectionInfo;
import Sirius.navigator.connection.ConnectionSession;
import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.connection.proxy.ConnectionProxy;
import Sirius.navigator.exception.ConnectionException;
import Sirius.navigator.plugin.interfaces.FloatingPluginUI;
import Sirius.navigator.tools.StaticNavigatorTools;
import com.jgoodies.looks.plastic.Plastic3DLookAndFeel;
import de.cismet.belis.broker.BelisBroker;
import de.cismet.belis.broker.CidsBroker;
import de.cismet.belis.util.BelisIcons;
import de.cismet.belis.util.JnlpSystemPropertyHelper;
import de.cismet.cids.client.tools.CallServerTunnel;
import de.cismet.cids.client.tools.ContinueOrExitHandler;
import de.cismet.cids.custom.navigatorstartuphooks.MotdStartUpHook;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cids.navigatorstartuphooks.CidsServerMessageStartUpHook;
import de.cismet.cids.servermessage.CidsServerMessageNotifier;
import de.cismet.cids.servermessage.CidsServerMessageNotifierListener;
import de.cismet.cids.servermessage.CidsServerMessageNotifierListenerEvent;
import de.cismet.cismap.commons.BoundingBox;
import de.cismet.cismap.commons.features.FeatureCollectionListener;
import de.cismet.cismap.commons.gui.ClipboardWaitDialog;
import de.cismet.cismap.commons.gui.statusbar.StatusBar;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.interaction.StatusListener;
import de.cismet.commons.security.Tunnel;
import de.cismet.commons2.architecture.layout.LayoutManager;
import de.cismet.commons2.architecture.layout.LayoutManagerListener;
import de.cismet.lookupoptions.gui.OptionsClient;
import de.cismet.lookupoptions.gui.OptionsDialog;
import de.cismet.netutil.Proxy;
import de.cismet.netutil.ProxyHandler;
import de.cismet.netutil.ProxyProperties;
import de.cismet.security.WebAccessManager;
import de.cismet.tools.StaticDebuggingTools;
import de.cismet.tools.StaticDecimalTools;
import de.cismet.tools.configuration.Configurable;
import de.cismet.tools.configuration.ConfigurationManager;
import de.cismet.tools.configuration.NoWriteError;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.log4jquickconfig.Log4JQuickConfig;
import de.cismet.tools.gui.startup.StaticStartupTools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.PropertyResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import net.infonode.docking.View;
import net.infonode.docking.util.StringViewMap;
import org.jdesktop.swingx.JXLoginPane;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.auth.DefaultUserNameStore;
import org.jdesktop.swingx.auth.LoginService;
import org.jdesktop.swingx.auth.UserNameStore;
import org.jdom.Content;
import org.jdom.Element;

public class BelisClient
extends JFrame
implements FloatingPluginUI,
Configurable {
    private static final org.apache.log4j.Logger LOG = org.apache.log4j.Logger.getLogger(BelisClient.class);
    private static final String PLUGIN_CONFIGURATION_CLASSPATH = "/de/cismet/commons/architecture/configuration/";
    protected static BelisBroker broker = null;
    private static ConfigurationManager configManager;
    private static Image banner;
    private static final String FIRST_START_IMAGE = "/de/cismet/belis/resource/icon/image/belis.jpg";
    private static Image applicationIcon;
    private static WundaAuthentification wa;
    private static String DIRECTORYPATH_BELIS;
    private static String FILEPATH_SCREEN;
    private static JFrame SPLASH;
    private ClipboardWaitDialog clipboarder;
    private Dimension windowSize = null;
    private Point windowLocation = null;
    private boolean readyToShow = false;
    private ArrayList<JMenuItem> menues = new ArrayList();
    private JPanel jPanel1;
    private JSeparator jSeparator12;
    private JSeparator jSeparator13;
    private JSeparator jSeparator14;
    private JSeparator jSeparator8;
    private JSeparator jSeparator9;
    private JMenu menEdit;
    private JMenu menExtras;
    private JMenu menFile;
    private JMenu menHelp;
    private JMenu menHistory;
    private JMenu menSearch;
    private JMenu menWindow;
    private JMenuItem mniAbout;
    private JMenuItem mniBack;
    private JMenuItem mniClippboard;
    private JMenuItem mniClose;
    private JMenuItem mniForward;
    private JMenuItem mniGotoPoint;
    private JMenuItem mniHistorySidebar;
    private JMenuItem mniHome;
    private JMenuItem mniLisences;
    private JMenuItem mniLoadLayout;
    private JMenuItem mniLockLayout;
    private JMenuItem mniNews;
    private JMenuItem mniOnlineHelp;
    private JMenuItem mniOptions;
    private JMenuItem mniPrint;
    private JMenuItem mniRefresh;
    private JMenuItem mniResetWindowLayout;
    private JMenuItem mniSaveLayout;
    private JMenuItem mniScale;
    private JMenuItem mniVersions;
    private JMenuBar mnuBar;
    private JPanel panMain;
    private JSeparator sepAfterPos;
    private JSeparator sepBeforePos;
    private JPanel toolbarPanel;
    private JPanel toolbarWrapperPanel;

    public BelisClient() {
        try {
            ContinueOrExitHandler.getInstance().showFromConfAttr((Frame)this);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"windowClosing(): beende Application");
                        LOG.debug((Object)"windowClosing(): Check if there unsaved changes.");
                    }
                    BelisClient.this.close();
                }
            });
            this.clipboarder = new ClipboardWaitDialog((Frame)this, true);
            broker = BelisBroker.getInstance();
            LayoutManager lm = new LayoutManager(DIRECTORYPATH_BELIS, broker);
            lm.addLayoutManagerListener(new LayoutManagerListener(){

                @Override
                public void infoNodeDockingConfigured() {
                    BelisClient.this.setWindowMenus();
                }
            });
            broker.setLayoutManager(lm);
            broker.setFilterNormal(true);
            broker.setFilterVeranlassung(false);
            broker.setFilterArbeitsauftrag(false);
            broker.initComponentRegistry(this);
            broker.initMappingComponent();
            broker.lookupWidgets();
            broker.lookupProtokollWizards();
            this.initComponents();
            this.configurePlugin();
            this.menues.add(this.menFile);
            this.menues.add(this.menEdit);
            this.menues.add(this.menHistory);
            this.menues.add(this.menExtras);
            this.menues.add(this.menWindow);
            this.menues.add(this.menHelp);
            KeyStroke configLoggerKeyStroke = KeyStroke.getKeyStroke(76, 2);
            AbstractAction configAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Log4JQuickConfig.getSingletonInstance().setVisible(true);
                        }
                    });
                }
            };
            this.getRootPane().getInputMap(2).put(configLoggerKeyStroke, "CONFIGLOGGING");
            this.getRootPane().getActionMap().put("CONFIGLOGGING", configAction);
            this.constructionDone();
            this.toolbarPanel.add(broker.getToolbar());
            this.setWindowSize();
            if (SPLASH != null) {
                SPLASH.dispose();
            }
            SPLASH = null;
            Runnable startupComplete = new Runnable(){

                @Override
                public void run() {
                    try {
                        broker.getLayoutManager().loadUserLayout();
                    }
                    catch (Exception ex) {
                        LOG.error((Object)"Error while loading layout", (Throwable)ex);
                    }
                    BelisClient.this.setReadyToShow(true);
                    broker.getMappingComponent().unlock();
                }
            };
            if (EventQueue.isDispatchThread()) {
                startupComplete.run();
            } else {
                EventQueue.invokeLater(startupComplete);
            }
            this.initTotd();
            this.initStartupHooks();
        }
        catch (Exception ex) {
            LOG.fatal((Object)"Fatal Error in Abstract Plugin Constructor.", (Throwable)ex);
        }
        this.setIconImage(BelisIcons.applicationIcon.getImage());
        StaticSwingTools.tweakUI();
    }

    private void initTotd() {
        try {
            if (SessionManager.getConnection().hasConfigAttr(SessionManager.getSession().getUser(), "csm://totd")) {
                CidsServerMessageNotifier.getInstance().subscribe(new CidsServerMessageNotifierListener(){

                    public void messageRetrieved(CidsServerMessageNotifierListenerEvent event) {
                        try {
                            String totd = (String)event.getMessage().getContent();
                            broker.setTotd(totd);
                            BelisClient.this.refreshTitle();
                        }
                        catch (Exception ex) {
                            LOG.warn((Object)ex, (Throwable)ex);
                        }
                    }
                }, "totd");
            }
        }
        catch (ConnectionException ex) {
            LOG.warn((Object)"Konnte Rechte an csm://totd nicht abfragen. Keine Titleleiste des Tages !", (Throwable)ex);
        }
    }

    private void initStartupHooks() {
        try {
            new MotdStartUpHook().applicationStarted();
            new CidsServerMessageStartUpHook().applicationStarted();
        }
        catch (Exception ex) {
            LOG.error((Object)"Fehler beim Ausf\u00fchren der StartupHooks: ", (Throwable)ex);
        }
    }

    private void setWindowMenus() {
        LayoutManager lman = BelisBroker.getInstance().getLayoutManager();
        StringViewMap viewMap = lman.getViewMap();
        for (int i = 0; i < viewMap.getViewCount(); ++i) {
            View view = viewMap.getViewAtIndex(i);
            JMenuItem tmpMen = new JMenuItem(new DefaultWindowAction(view));
            this.menWindow.insert(tmpMen, i);
        }
    }

    public boolean isReadyToShow() {
        return this.readyToShow;
    }

    public void setReadyToShow(boolean readyToShow) {
        this.readyToShow = readyToShow;
    }

    private void configurePlugin() {
        configManager.addConfigurable((Configurable)this);
        configManager.configure((Configurable)this);
    }

    private void constructionDone() {
        broker.pluginConstructionDone();
    }

    public JComponent getComponent() {
        return this.panMain;
    }

    public void hidden() {
    }

    public void moved() {
    }

    public void resized() {
    }

    public void shown() {
    }

    public Collection getMenus() {
        return this.menues;
    }

    public void floatingStarted() {
    }

    public void floatingStopped() {
    }

    public String getId() {
        return broker.getApplicationName();
    }

    public void configure(Element parent) {
        Element prefs = parent.getChild("cismapPluginUIPreferences");
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"writing windowSize into Configuration");
            }
            Element window = prefs.getChild("window");
            int windowHeight = window.getAttribute("height").getIntValue();
            int windowWidth = window.getAttribute("width").getIntValue();
            int windowX = window.getAttribute("x").getIntValue();
            int windowY = window.getAttribute("y").getIntValue();
            boolean windowMaximised = window.getAttribute("max").getBooleanValue();
            this.windowSize = new Dimension(windowWidth, windowHeight);
            this.windowLocation = new Point(windowX, windowY);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Fenstergr\u00f6\u00dfe: Breite " + windowWidth + " H\u00f6he " + windowHeight));
            }
            if (windowMaximised) {
                this.setExtendedState(6);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Fenstergr\u00f6\u00dfe erfolgreich eingelesen");
            }
        }
        catch (Throwable t) {
            LOG.error((Object)"Fehler beim Laden der Fenstergr\u00f6\u00dfe", t);
        }
    }

    public Element getConfiguration() throws NoWriteError {
        boolean windowMaximised;
        Element ret = new Element("cismapPluginUIPreferences");
        Element window = new Element("window");
        int windowHeight = this.getHeight();
        int windowWidth = this.getWidth();
        int windowX = (int)this.getLocation().getX();
        int windowY = (int)this.getLocation().getY();
        boolean bl = windowMaximised = this.getExtendedState() == 6;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Fenstergr\u00f6\u00dfe: Breite " + windowWidth + " H\u00f6he " + windowHeight));
        }
        window.setAttribute("height", "" + windowHeight);
        window.setAttribute("width", "" + windowWidth);
        window.setAttribute("x", "" + windowX);
        window.setAttribute("y", "" + windowY);
        window.setAttribute("max", "" + windowMaximised);
        ret.addContent((Content)window);
        return ret;
    }

    public void masterConfigure(Element parent) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Master Configure: " + this.getClass().getName()));
        }
        try {
            try {
                try {
                    String applicationName = JnlpSystemPropertyHelper.getProperty("ApplicationName");
                    this.setTitle(applicationName);
                    broker.setApplicatioName(applicationName);
                    this.refreshTitle();
                }
                catch (Exception ex) {
                    broker.setApplicatioName("Kein Name");
                    LOG.warn((Object)"Error while setting application title", (Throwable)ex);
                }
                broker.setParentComponent(this.panMain);
                broker.setConfigManager(configManager);
                configManager.addConfigurable((Configurable)broker);
                configManager.addConfigurable((Configurable)OptionsClient.getInstance());
                configManager.configure((Configurable)broker);
            }
            catch (Exception ex) {
                LOG.warn((Object)"Error while retrieving broker instance", (Throwable)ex);
            }
            try {
                StatusBar statusBar = new StatusBar(broker.getMappingComponent());
                DefaultNavigatorExceptionHandler.getInstance().addListener(statusBar.getExceptionHandlerListener());
                broker.setStatusBar(statusBar);
                broker.getMappingComponent().getFeatureCollection().addFeatureCollectionListener((FeatureCollectionListener)statusBar);
                CismapBroker.getInstance().addStatusListener((StatusListener)statusBar);
                if (broker.isStatusBarEnabled()) {
                    this.add((Component)statusBar, "South");
                }
            }
            catch (Exception ex) {
                LOG.error((Object)"Error whil configuring the statusbar: ", (Throwable)ex);
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"Fehler beim konfigurieren der Belis Applikation: ", (Throwable)ex);
        }
    }

    private void refreshTitle() {
        if (SwingUtilities.isEventDispatchThread()) {
            String totd = broker.getTotd();
            if (totd == null || totd.trim().isEmpty()) {
                this.setTitle(broker.getApplicationName());
            } else {
                this.setTitle(broker.getApplicationName() + " - " + totd);
            }
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BelisClient.this.refreshTitle();
                }
            });
        }
    }

    private void initComponents() {
        this.panMain = new JPanel();
        this.toolbarWrapperPanel = new JPanel();
        this.toolbarPanel = new JPanel();
        this.jPanel1 = new JPanel();
        this.mnuBar = new JMenuBar();
        this.menFile = new JMenu();
        this.mniSaveLayout = new JMenuItem();
        this.mniLoadLayout = new JMenuItem();
        this.mniLockLayout = new JMenuItem();
        this.jSeparator8 = new JSeparator();
        this.mniClippboard = new JMenuItem();
        this.mniPrint = new JMenuItem();
        this.jSeparator9 = new JSeparator();
        this.mniClose = new JMenuItem();
        this.menEdit = new JMenu();
        this.mniRefresh = new JMenuItem();
        this.menSearch = broker.getMetaSearchComponentFactory().getMenSearch();
        this.menHistory = new JMenu();
        this.mniBack = new JMenuItem();
        this.mniForward = new JMenuItem();
        this.mniHome = new JMenuItem();
        this.sepBeforePos = new JSeparator();
        this.sepAfterPos = new JSeparator();
        this.mniHistorySidebar = new JMenuItem();
        this.menExtras = new JMenu();
        this.mniOptions = new JMenuItem();
        this.jSeparator12 = new JSeparator();
        this.mniGotoPoint = new JMenuItem();
        this.jSeparator13 = new JSeparator();
        this.mniScale = new JMenuItem();
        this.menWindow = new JMenu();
        this.jSeparator14 = new JSeparator();
        this.mniResetWindowLayout = new JMenuItem();
        this.menHelp = new JMenu();
        this.mniOnlineHelp = new JMenuItem();
        this.mniNews = new JMenuItem();
        this.mniVersions = new JMenuItem();
        this.mniLisences = new JMenuItem();
        this.mniAbout = new JMenuItem();
        this.setDefaultCloseOperation(0);
        this.setMinimumSize(new Dimension(800, 600));
        this.panMain.setBorder(null);
        this.panMain.setLayout(new BorderLayout());
        this.toolbarWrapperPanel.setBorder(null);
        this.toolbarWrapperPanel.setLayout(new BorderLayout());
        this.toolbarPanel.setBorder(null);
        this.toolbarPanel.setOpaque(false);
        this.toolbarPanel.setLayout(new FlowLayout(1, 0, 0));
        this.toolbarWrapperPanel.add((Component)this.toolbarPanel, "West");
        this.jPanel1.setBorder(null);
        this.jPanel1.setOpaque(false);
        this.toolbarWrapperPanel.add((Component)this.jPanel1, "Center");
        this.panMain.add((Component)this.toolbarWrapperPanel, "North");
        this.getContentPane().add((Component)this.panMain, "Center");
        this.menFile.setMnemonic('D');
        this.menFile.setText("Datei");
        this.mniSaveLayout.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.mniSaveLayout.setText("Aktuelles Layout speichern");
        this.mniSaveLayout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BelisClient.this.mniSaveLayoutActionPerformed(evt);
            }
        });
        this.menFile.add(this.mniSaveLayout);
        this.mniLoadLayout.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.mniLoadLayout.setText("Layout laden");
        this.mniLoadLayout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BelisClient.this.mniLoadLayoutActionPerformed(evt);
            }
        });
        this.menFile.add(this.mniLoadLayout);
        this.mniLockLayout.setText("Layout sperren");
        this.mniLockLayout.setEnabled(false);
        this.mniLockLayout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BelisClient.this.mniLockLayoutActionPerformed(evt);
            }
        });
        this.menFile.add(this.mniLockLayout);
        this.jSeparator8.setEnabled(false);
        this.menFile.add(this.jSeparator8);
        this.mniClippboard.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.mniClippboard.setText("Bild der Karte in die Zwischenablage kopieren");
        this.mniClippboard.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BelisClient.this.mniClippboardActionPerformed(evt);
            }
        });
        this.menFile.add(this.mniClippboard);
        this.mniPrint.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        this.mniPrint.setText("Drucken");
        this.mniPrint.setEnabled(false);
        this.menFile.add(this.mniPrint);
        this.jSeparator9.setEnabled(false);
        this.menFile.add(this.jSeparator9);
        this.mniClose.setAccelerator(KeyStroke.getKeyStroke(115, 8));
        this.mniClose.setText("Beenden");
        this.mniClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BelisClient.this.mniCloseActionPerformed(evt);
            }
        });
        this.menFile.add(this.mniClose);
        this.mnuBar.add(this.menFile);
        this.menEdit.setMnemonic('B');
        this.menEdit.setText("Bearbeiten");
        this.mniRefresh.setAccelerator(KeyStroke.getKeyStroke(116, 0));
        this.mniRefresh.setText("Neu laden");
        this.mniRefresh.setEnabled(false);
        this.mniRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BelisClient.this.mniRefreshActionPerformed(evt);
            }
        });
        this.menEdit.add(this.mniRefresh);
        this.mnuBar.add(this.menEdit);
        this.menSearch.setText("Suche");
        this.mnuBar.add(this.menSearch);
        this.menHistory.setMnemonic('C');
        this.menHistory.setText("Chronik");
        this.mniBack.setAccelerator(KeyStroke.getKeyStroke(37, 2));
        this.mniBack.setText("Zur\u00fcck");
        this.mniBack.setEnabled(false);
        this.mniBack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BelisClient.this.mniBackActionPerformed(evt);
            }
        });
        this.menHistory.add(this.mniBack);
        this.mniForward.setAccelerator(KeyStroke.getKeyStroke(39, 2));
        this.mniForward.setText("Vor");
        this.mniForward.setEnabled(false);
        this.mniForward.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BelisClient.this.mniForwardActionPerformed(evt);
            }
        });
        this.menHistory.add(this.mniForward);
        this.mniHome.setAccelerator(KeyStroke.getKeyStroke(36, 0));
        this.mniHome.setText("Home");
        this.mniHome.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BelisClient.this.mniHomeActionPerformed(evt);
            }
        });
        this.menHistory.add(this.mniHome);
        this.sepBeforePos.setEnabled(false);
        this.menHistory.add(this.sepBeforePos);
        this.sepAfterPos.setEnabled(false);
        this.menHistory.add(this.sepAfterPos);
        this.mniHistorySidebar.setText("In eigenem Fenster anzeigen");
        this.mniHistorySidebar.setEnabled(false);
        this.menHistory.add(this.mniHistorySidebar);
        this.mnuBar.add(this.menHistory);
        this.menExtras.setMnemonic('E');
        this.menExtras.setText("Extras");
        this.mniOptions.setText("Optionen");
        this.mniOptions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BelisClient.this.mniOptionsActionPerformed(evt);
            }
        });
        this.menExtras.add(this.mniOptions);
        this.jSeparator12.setEnabled(false);
        this.menExtras.add(this.jSeparator12);
        this.mniGotoPoint.setAccelerator(KeyStroke.getKeyStroke(71, 2));
        this.mniGotoPoint.setText("Gehe zu ...");
        this.mniGotoPoint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BelisClient.this.mniGotoPointActionPerformed(evt);
            }
        });
        this.menExtras.add(this.mniGotoPoint);
        this.jSeparator13.setEnabled(false);
        this.menExtras.add(this.jSeparator13);
        this.mniScale.setText("Ma\u00dfstab ver\u00e4ndern");
        this.mniScale.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BelisClient.this.mniScaleActionPerformed(evt);
            }
        });
        this.menExtras.add(this.mniScale);
        this.mnuBar.add(this.menExtras);
        this.menWindow.setMnemonic('F');
        this.menWindow.setText("Fenster");
        this.jSeparator14.setEnabled(false);
        this.menWindow.add(this.jSeparator14);
        this.mniResetWindowLayout.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        this.mniResetWindowLayout.setText("Fensteranordnung zur\u00fccksetzen");
        this.mniResetWindowLayout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BelisClient.this.mniResetWindowLayoutActionPerformed(evt);
            }
        });
        this.menWindow.add(this.mniResetWindowLayout);
        this.mnuBar.add(this.menWindow);
        this.menHelp.setMnemonic('H');
        this.menHelp.setText("Hilfe");
        this.mniOnlineHelp.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        this.mniOnlineHelp.setText("Online Hilfe");
        this.mniOnlineHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BelisClient.this.mniOnlineHelpActionPerformed(evt);
            }
        });
        this.menHelp.add(this.mniOnlineHelp);
        this.mniNews.setText("News");
        this.mniNews.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BelisClient.this.mniNewsActionPerformed(evt);
            }
        });
        this.menHelp.add(this.mniNews);
        this.mniVersions.setAccelerator(KeyStroke.getKeyStroke(86, 10));
        this.mniVersions.setText("Versionsinformationen");
        this.mniVersions.setEnabled(false);
        this.menHelp.add(this.mniVersions);
        this.mniLisences.setAccelerator(KeyStroke.getKeyStroke(76, 10));
        this.mniLisences.setText("Lizenzinformationen");
        this.mniLisences.setEnabled(false);
        this.menHelp.add(this.mniLisences);
        this.mniAbout.setAccelerator(KeyStroke.getKeyStroke(65, 10));
        this.mniAbout.setText("\u00dcber BelIS");
        this.mniAbout.setEnabled(false);
        this.menHelp.add(this.mniAbout);
        this.mnuBar.add(this.menHelp);
        this.setJMenuBar(this.mnuBar);
        this.pack();
    }

    private void mniSaveLayoutActionPerformed(ActionEvent evt) {
        broker.getLayoutManager().saveLayout();
    }

    private void mniLoadLayoutActionPerformed(ActionEvent evt) {
        broker.getLayoutManager().loadLayout();
    }

    private void mniLockLayoutActionPerformed(ActionEvent evt) {
    }

    private void mniClippboardActionPerformed(ActionEvent evt) {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        BelisClient.this.clipboarder.setLocationRelativeTo((Component)BelisClient.this);
                        BelisClient.this.clipboarder.setVisible(true);
                    }
                });
                ImageSelection imgSel = new ImageSelection(broker.getMappingComponent().getImage());
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(imgSel, null);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        BelisClient.this.clipboarder.dispose();
                    }
                });
            }
        });
        t.start();
    }

    private void mniCloseActionPerformed(ActionEvent evt) {
        this.close();
    }

    private void close() {
        this.cleanUp();
        this.dispose();
        System.exit(0);
    }

    private void mniRefreshActionPerformed(ActionEvent evt) {
    }

    private void mniBackActionPerformed(ActionEvent evt) {
        if (broker.getMappingComponent() != null && broker.getMappingComponent().isBackPossible()) {
            broker.getMappingComponent().back(true);
        }
    }

    private void mniForwardActionPerformed(ActionEvent evt) {
        if (broker.getMappingComponent() != null && broker.getMappingComponent().isForwardPossible()) {
            broker.getMappingComponent().forward(true);
        }
    }

    private void mniHomeActionPerformed(ActionEvent evt) {
        if (broker.getMappingComponent() != null) {
            broker.getMappingComponent().gotoInitialBoundingBox();
        }
    }

    private void mniOptionsActionPerformed(ActionEvent evt) {
        OptionsDialog od = new OptionsDialog((Frame)this, true);
        od.pack();
        StaticSwingTools.showDialog((JDialog)od, (boolean)false);
    }

    private void mniGotoPointActionPerformed(ActionEvent evt) {
        BoundingBox c = broker.getMappingComponent().getCurrentBoundingBox();
        double x = (c.getX1() + c.getX2()) / 2.0;
        double y = (c.getY1() + c.getY2()) / 2.0;
        String s = JOptionPane.showInputDialog(this, "Zentriere auf folgendem Punkt: x,y", StaticDecimalTools.round((double)x) + "," + StaticDecimalTools.round((double)y));
        try {
            String[] sa = s.split(",");
            Double gotoX = new Double(sa[0]);
            Double gotoY = new Double(sa[1]);
            BoundingBox bb = new BoundingBox(gotoX.doubleValue(), gotoY.doubleValue(), gotoX.doubleValue(), gotoY.doubleValue());
            broker.getMappingComponent().gotoBoundingBox(bb, true, false, broker.getMappingComponent().getAnimationDuration());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void mniScaleActionPerformed(ActionEvent evt) {
        String s = JOptionPane.showInputDialog(this, "Ma\u00dfstab manuell ausw\u00e4hlen", (int)broker.getMappingComponent().getScaleDenominator() + "");
        try {
            Integer i = new Integer(s);
            broker.getMappingComponent().gotoBoundingBoxWithHistory(broker.getMappingComponent().getBoundingBoxFromScale((double)i.intValue()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void mniResetWindowLayoutActionPerformed(ActionEvent evt) {
        broker.getLayoutManager().doLayoutInfoNodeDefaultFile();
    }

    private void mniOnlineHelpActionPerformed(ActionEvent evt) {
    }

    private void mniNewsActionPerformed(ActionEvent evt) {
    }

    public BelisBroker getBroker() {
        return broker;
    }

    public void setBroker(BelisBroker broker) {
        BelisClient.broker = broker;
    }

    @Override
    public void dispose() {
        try {
            StaticStartupTools.saveScreenshotOfFrame((JFrame)this, (String)FILEPATH_SCREEN);
        }
        catch (Exception ex) {
            LOG.fatal((Object)"Fehler beim Capturen des App-Inhaltes", (Throwable)ex);
        }
        this.setVisible(false);
        LOG.info((Object)"Dispose(): Application gets shutted down");
        broker.getLayoutManager().saveUserLayout();
        super.dispose();
        System.exit(0);
    }

    protected void cleanUp() {
        if (broker.isInEditMode()) {
            try {
                int answer;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Application is in Editmode --> ask user if he wants to save");
                }
                if ((answer = JOptionPane.showConfirmDialog(this, "Wollen Sie die gemachten \u00c4nderungen speichern", "Belis \u00c4nderungen", 0)) == 0) {
                    boolean isValid = broker.validateWidgets();
                    if (isValid) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("All changes are valid" + isValid));
                        }
                        broker.saveWorkbench();
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"\u00c4nderungen wurden gespeichert");
                        }
                    } else {
                        LOG.warn((Object)"not all changes are valid --> can't save");
                    }
                }
            }
            catch (Exception ex) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Es ist ein Fehler w\u00e4hrend dem abspeichern der Objekte aufgetreten", (Throwable)ex);
                }
                JOptionPane.showMessageDialog(this, "Es traten Fehler beim abspeichern der Objekte auf", "Fehler", 0);
            }
            while (broker.isInEditMode()) {
                try {
                    broker.releaseLock();
                    if (!LOG.isDebugEnabled()) break;
                    LOG.debug((Object)"Sperre konnte erfolgreich gel\u00f6st werden");
                }
                catch (Exception ex) {
                    Logger.getLogger(BelisClient.class.getName()).log(Level.SEVERE, null, ex);
                    int answer = JOptionPane.showConfirmDialog(this, "Sperre konnte nicht entfernt werden. M\u00f6chten Sie es erneut probieren?", "Belis \u00c4nderungen", 0);
                    if (answer != 1) continue;
                }
                break;
            }
        }
        configManager.writeConfiguration();
    }

    private void setWindowSize() {
        if (this.windowSize != null && this.windowLocation != null) {
            this.setSize(this.windowSize);
            this.setLocation(this.windowLocation);
        } else {
            this.pack();
        }
    }

    @Override
    public void setVisible(boolean visible) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("No Plugin super.setVisible: " + visible));
        }
        super.setVisible(visible);
    }

    public static String getPluginConfigurationFile() {
        return "defaultBelisConfiguration.xml";
    }

    public Collection getButtons() {
        return Arrays.asList(broker.getToolbar().getComponents());
    }

    public static void main(String[] args) {
        if (StaticDebuggingTools.checkHomeForFile((String)"cismetBeansbindingDebuggingOn")) {
            System.setProperty("cismet.beansdebugging", "true");
        }
        Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)DefaultNavigatorExceptionHandler.getInstance());
        try {
            Plastic3DLookAndFeel lf = new Plastic3DLookAndFeel();
            UIManager.setLookAndFeel((LookAndFeel)lf);
        }
        catch (Exception ex) {
            LOG.error((Object)"Fehler beim setzen des Look & Feels", (Throwable)ex);
        }
        String fileSeparator = JnlpSystemPropertyHelper.getProperty("file.separator");
        String directoryPath = JnlpSystemPropertyHelper.getProperty("user.home");
        String directoryExtension = JnlpSystemPropertyHelper.getProperty("directory.extension");
        String belisHomeName = ".belis" + (directoryExtension != null ? directoryExtension : "");
        DIRECTORYPATH_BELIS = directoryPath + fileSeparator + belisHomeName;
        FILEPATH_SCREEN = DIRECTORYPATH_BELIS + fileSeparator + "belis.screen";
        configManager = new ConfigurationManager();
        configManager.setDefaultFileName(BelisClient.getPluginConfigurationFile());
        configManager.setFileName(BelisClient.getPluginConfigurationFile());
        configManager.setHome(directoryPath);
        configManager.setFolder(belisHomeName);
        configManager.setClassPathFolder(PLUGIN_CONFIGURATION_CLASSPATH);
        configManager.addConfigurable((Configurable)wa);
        configManager.configure((Configurable)wa);
        try {
            File ghostFrameFile = new File(FILEPATH_SCREEN + ".png");
            SPLASH = !ghostFrameFile.exists() ? StaticStartupTools.showCustomGhostFrame((URL)BelisClient.class.getResource(FIRST_START_IMAGE), (String)"belis [Startup]") : StaticStartupTools.showGhostFrame((String)FILEPATH_SCREEN, (String)"belis [Startup]");
            SPLASH.setLocationRelativeTo(null);
        }
        catch (Exception e) {
            LOG.warn((Object)"Problem beim Darstellen des Pre-Loading-Frame", (Throwable)e);
        }
        try {
            BelisClient.handleLogin();
        }
        catch (Exception ex) {
            LOG.error((Object)"Fehler beim Loginframe", (Throwable)ex);
            System.exit(2);
        }
    }

    public static void handleLogin() {
        JXLoginPane.JXLoginDialog d;
        JXLoginPane login;
        DefaultUserNameStore usernames;
        block9: {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Intialisiere Loginframe");
            }
            usernames = new DefaultUserNameStore();
            Preferences appPrefs = Preferences.userNodeForPackage(BelisClient.class);
            usernames.setPreferences(appPrefs.node("login"));
            login = new JXLoginPane(wa, null, (UserNameStore)usernames){

                protected Image createLoginBanner() {
                    return BelisClient.getBannerImage();
                }
            };
            String u = null;
            try {
                u = usernames.getUserNames()[usernames.getUserNames().length - 1];
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (u != null) {
                login.setUserName(u);
            }
            d = new JXLoginPane.JXLoginDialog((Frame)SPLASH, login);
            try {
                String loginTitle = JnlpSystemPropertyHelper.getProperty("login.title");
                if (loginTitle != null) {
                    d.setTitle(loginTitle);
                }
            }
            catch (Exception ex) {
                if (!LOG.isDebugEnabled()) break block9;
                LOG.debug((Object)"no login title set", (Throwable)ex);
            }
        }
        d.setIconImage(applicationIcon);
        login.setPassword("".toCharArray());
        try {
            ((JXPanel)((JXPanel)login.getComponent(1)).getComponent(1)).getComponent(3).requestFocus();
        }
        catch (Exception exception) {
            // empty catch block
        }
        d.setIconImage(applicationIcon);
        d.setAlwaysOnTop(true);
        StaticSwingTools.showDialog((JDialog)d, (boolean)false);
        BelisClient.handleLoginStatus(d.getStatus(), usernames, login);
    }

    public static Image getBannerImage() {
        return banner;
    }

    private static void handleLoginStatus(JXLoginPane.Status status, DefaultUserNameStore usernames, JXLoginPane login) {
        if (status == JXLoginPane.Status.SUCCEEDED) {
            usernames.removeUserName(login.getUserName());
            usernames.saveUserNames();
            usernames.addUserName(login.getUserName());
            usernames.saveUserNames();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Login erfolgreich");
            }
            BelisClient client = new BelisClient();
            client.setVisible(true);
        } else {
            LOG.warn((Object)"Login fehlgeschlagen");
            System.exit(0);
        }
    }

    static {
        banner = new ImageIcon(BelisClient.class.getResource("/de/cismet/belis/resource/icon/image/login.png")).getImage();
        applicationIcon = null;
        wa = new WundaAuthentification();
    }

    private static class AppProperties
    extends PropertyResourceBundle {
        public AppProperties(InputStream is) throws Exception {
            super(is);
        }

        public String getCallserverUrl() {
            return this.getString("callserverUrl");
        }

        public boolean isCompressionEnabled() {
            return Boolean.parseBoolean(this.getString("compressionEnabled"));
        }

        public String getProxyConfig() {
            return this.getString("proxy.config");
        }

        public boolean isIntranetUseEnabled() {
            return Boolean.parseBoolean(this.getString("intranetUse"));
        }

        public String getDomain() {
            return this.getString("domain");
        }
    }

    public static class WundaAuthentification
    extends LoginService
    implements Configurable {
        public static final String CONNECTION_CLASS = "Sirius.navigator.connection.RESTfulConnection";
        public static final String CONNECTION_PROXY_CLASS = "de.cismet.belis.broker.ConnectionProxyHandler";
        private static String standaloneDomain;
        private final org.apache.log4j.Logger log = org.apache.log4j.Logger.getLogger(WundaAuthentification.class);
        private String callserverhost;
        private String userString;
        private boolean compressionEnabled = false;
        private final ProxyProperties proxyProperties = new ProxyProperties();
        private BelisBroker broker;

        public boolean authenticate(String name, char[] password, String server) throws Exception {
            try {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Authentication for :" + name));
                }
                System.setProperty("sun.rmi.transport.connectionTimeout", "15");
                String user = name.split("@")[0];
                String group = name.split("@")[1];
                this.broker.setAccountName(name);
                String callServerURL = this.callserverhost;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("callServerUrl:" + callServerURL));
                }
                String domain = standaloneDomain;
                this.userString = name;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("full qualified username: " + this.userString + "@" + standaloneDomain));
                }
                Proxy proxy = ProxyHandler.getInstance().init(this.proxyProperties);
                Connection connection = ConnectionFactory.getFactory().createConnection(CONNECTION_CLASS, callServerURL, proxy, this.compressionEnabled);
                ConnectionInfo connectionInfo = new ConnectionInfo();
                connectionInfo.setCallserverURL(callServerURL);
                connectionInfo.setPassword(new String(password));
                connectionInfo.setUserDomain(domain);
                connectionInfo.setUsergroup(group);
                connectionInfo.setUsergroupDomain(domain);
                connectionInfo.setUsername(user);
                ConnectionSession connectionSession = ConnectionFactory.getFactory().createSession(connection, connectionInfo, true);
                ConnectionProxy connectionProxy = ConnectionFactory.getFactory().createProxy(CONNECTION_PROXY_CLASS, connectionSession);
                SessionManager.init((ConnectionProxy)connectionProxy);
                ClassCacheMultiple.setInstance((String)"BELIS2");
                CidsBroker.getInstance().setProxy(connectionProxy);
                String tester = (group + "@" + domain).toLowerCase();
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("authentication: tester = " + tester));
                    this.log.debug((Object)("authentication: name = " + name));
                    this.log.debug((Object)("authentication: RM Plugin key = " + name + "@" + domain));
                }
                return true;
            }
            catch (Throwable t) {
                this.log.error((Object)"Fehler beim Anmelden", t);
                return false;
            }
        }

        public void configure(Element parent) {
        }

        public Element getConfiguration() throws NoWriteError {
            return null;
        }

        public void masterConfigure(Element parent) {
            Boolean intranetUse = null;
            String cfgFile = JnlpSystemPropertyHelper.getProperty("configFile");
            if (cfgFile != null) {
                String proxyConfig = null;
                try {
                    AppProperties appProperties = new AppProperties(StaticNavigatorTools.getInputStreamFromFileOrUrl((String)cfgFile));
                    if (appProperties.getCallserverUrl() != null) {
                        this.callserverhost = appProperties.getCallserverUrl();
                    } else {
                        this.log.fatal((Object)"Error while reading callserverhost can't authenticate");
                        System.exit(2);
                    }
                    try {
                        this.compressionEnabled = appProperties.isCompressionEnabled();
                    }
                    catch (Exception ex) {
                        this.log.warn((Object)"Error while parsing compressionEnabled", (Throwable)ex);
                    }
                    if (appProperties.getDomain() != null) {
                        standaloneDomain = appProperties.getDomain();
                    } else {
                        this.log.fatal((Object)"Error while reading userdomain can't authenticate");
                        System.exit(2);
                    }
                    try {
                        intranetUse = appProperties.isIntranetUseEnabled();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    proxyConfig = appProperties.getProxyConfig();
                }
                catch (Exception ex) {
                    this.log.fatal((Object)"Error while reading config file", (Throwable)ex);
                    System.exit(2);
                }
                try {
                    String cfgProxy;
                    String cfgFileName = Paths.get(new URI(cfgFile).getPath(), new String[0]).getFileName().toString();
                    String cfgDirname = cfgFile.substring(0, cfgFile.lastIndexOf(cfgFileName));
                    String string = cfgProxy = proxyConfig != null && !proxyConfig.isEmpty() ? cfgDirname + proxyConfig : null;
                    if (proxyConfig != null) {
                        this.proxyProperties.load(StaticNavigatorTools.getInputStreamFromFileOrUrl(cfgProxy));
                    }
                }
                catch (Exception ex) {
                    LOG.error((Object)"error while loading proxy.config", (Throwable)ex);
                }
            } else {
                try {
                    intranetUse = Boolean.parseBoolean(JnlpSystemPropertyHelper.getProperty("intranetUse", "false"));
                }
                catch (Exception proxyConfig) {
                    // empty catch block
                }
                try {
                    standaloneDomain = JnlpSystemPropertyHelper.getProperty("domain");
                }
                catch (Exception ex) {
                    this.log.fatal((Object)"Error while reading userdomain can't authenticate", (Throwable)ex);
                    System.exit(2);
                }
                try {
                    this.callserverhost = JnlpSystemPropertyHelper.getProperty("callserverhost");
                }
                catch (Exception ex) {
                    this.log.fatal((Object)"Error while reading callserverhost can't authenticate", (Throwable)ex);
                    System.exit(2);
                }
                try {
                    this.compressionEnabled = Boolean.parseBoolean(JnlpSystemPropertyHelper.getProperty("compressionEnabled"));
                }
                catch (Exception ex) {
                    this.log.warn((Object)"Error while parsing compressionEnabled", (Throwable)ex);
                }
            }
            try {
                this.broker = BelisBroker.getInstance();
            }
            catch (Exception ex) {
                this.log.fatal((Object)"Error while configuring Login", (Throwable)ex);
                System.exit(2);
            }
            if (!Boolean.TRUE.equals(intranetUse)) {
                try {
                    WebAccessManager.getInstance().setTunnel((Tunnel)new CallServerTunnel("BELIS2"));
                }
                catch (Throwable e) {
                    LOG.error((Object)"problem initializing WebaccessManager", e);
                }
            }
        }
    }

    class ImageSelection
    implements Transferable {
        private Image image;

        public ImageSelection(Image image) {
            this.image = image;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{DataFlavor.imageFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return DataFlavor.imageFlavor.equals(flavor);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (!DataFlavor.imageFlavor.equals(flavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.image;
        }
    }

    private class DefaultWindowAction
    extends AbstractAction {
        private View view;

        public DefaultWindowAction(View view) {
            super(view.getTitle(), view.getIcon());
            this.view = view;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.view.isClosable()) {
                this.view.close();
            } else {
                this.view.restore();
            }
        }
    }
}

