/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.belis.gui.utils;

import de.cismet.cids.client.tools.WebDavTunnelHelper;
import de.cismet.cids.custom.beans.belis2.DmsUrlCustomBean;
import de.cismet.cismap.commons.gui.printing.BackgroundTaskDownload;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.tools.CismetThreadPool;
import de.cismet.tools.Static2DTools;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.WaitDialog;
import de.cismet.tools.gui.downloadmanager.Download;
import de.cismet.tools.gui.downloadmanager.DownloadManager;
import de.cismet.tools.gui.downloadmanager.DownloadManagerDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import javax.swing.TransferHandler;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.swingbinding.JListBinding;
import org.jdesktop.swingbinding.SwingBindings;
import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.error.ErrorInfo;
import org.jdesktop.swingx.graphics.ShadowRenderer;

public final class DocumentPanel
extends JPanel {
    private static final Logger LOG = Logger.getLogger(DocumentPanel.class);
    private static final String ICON_RES_PATH = "/de/cismet/belis/resource/icon/16/";
    private static final ImageIcon NO_PREVIEW = new ImageIcon(DocumentPanel.class.getResource("/de/cismet/belis/resource/icon/16/nopreview.png"));
    private static final ExecutorService THREAD_EXECUTOR = Executors.newCachedThreadPool();
    public static final int SHADOW_SIZE = 4;
    public static final int INSET = 55;
    public static final int ANIMATION_RATE = 30;
    private static final Icon IDLE_ICON;
    private static final Icon[] BUSY_ICONS;
    private static final String THUMBNAIL_SUFFIX_WITHOUT_EXTENSION = ".thumbnail";
    private static final ImageIcon UNKNOWN_FORMAT;
    public static final String EXTENTION_PDF = "pdf";
    public static final String EXTENTION_JPG = "jpg";
    public static final String EXTENTION_JPEG = "jpeg";
    public static final String EXTENTION_GIF = "gif";
    public static final String EXTENTION_PNG = "png";
    public static final String EXTENTION_BMP = "bmp";
    public static final String EXTENTION_HTML = "html";
    public static final String EXTENTION_DOC = "doc";
    public static final String EXTENTION_XLS = "xls";
    private static final Map<String, ImageIcon> FILE_TYPE_ICONS;
    private final Timer busyIconTimer;
    private int busyIconIndex = 0;
    private SwingWorker<ImageIcon, Void> previewWorker;
    private Collection<DmsUrlCustomBean> dokumente = null;
    private boolean inEditMode = false;
    private JLabel lblAbsolutePath;
    private JLabel lblPreview;
    private JLabel lblStatus;
    private JList lstDocList;
    private JMenuItem miDelete;
    private JPanel panList;
    private JPanel panPreviewIntern;
    private JPanel panPreviewScp;
    private JPanel panStatus;
    private JPopupMenu popMenu;
    private JScrollPane scpDocList;
    private JScrollPane scpPreview;
    private BindingGroup bindingGroup;

    public DocumentPanel() {
        this.initComponents();
        AbstractAction deleteAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DocumentPanel.this.inEditMode) {
                    DocumentPanel.this.deleteSelectedListItems();
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Can not remove document because it not in edit mode.");
                }
            }
        };
        InputMap im = this.getInputMap(1);
        KeyStroke delete = KeyStroke.getKeyStroke("DELETE");
        im.put(delete, "delete");
        this.getActionMap().put("delete", deleteAction);
        this.lstDocList.setTransferHandler(new DocListTransferHandler());
        this.lstDocList.setDragEnabled(true);
        DocumentPanel.decorateComponentWithMouseOverCursorChange(this.lblPreview, 12, 0);
        this.lstDocList.setCellRenderer(new DocumentListCellRenderer());
        int busyAnimationRate = 30;
        this.busyIconTimer = new Timer(30, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DocumentPanel.this.busyIconIndex = (DocumentPanel.this.busyIconIndex + 1) % BUSY_ICONS.length;
                DocumentPanel.this.lblStatus.setIcon(BUSY_ICONS[DocumentPanel.this.busyIconIndex]);
            }
        });
        this.lblStatus.setIcon(IDLE_ICON);
    }

    public static BufferedImage generateShadow(Image in, int shadowPixel) {
        BufferedImage input;
        if (in instanceof BufferedImage) {
            input = (BufferedImage)in;
        } else {
            BufferedImage temp = new BufferedImage(in.getWidth(null), in.getHeight(null), 6);
            Graphics2D tg = temp.createGraphics();
            tg.drawImage(in, 0, 0, null);
            tg.dispose();
            input = temp;
        }
        ShadowRenderer renderer = new ShadowRenderer(shadowPixel, 0.5f, Color.BLACK);
        BufferedImage shadow = renderer.createShadow(input);
        BufferedImage result = new BufferedImage(input.getWidth() + 2 * shadowPixel, input.getHeight() + 2 * shadowPixel, 6);
        Graphics2D rg = result.createGraphics();
        rg.drawImage((Image)shadow, 0, 0, null);
        rg.drawImage((Image)input, 0, 0, null);
        rg.dispose();
        return result;
    }

    public static ImageIcon loadPicture(String bildURL, int maxPixelX, int maxPixelY, int shadowSize) {
        String urlString;
        Image buffImage;
        if (bildURL != null && bildURL.length() > 0 && (buffImage = DocumentPanel.loadPreview(urlString = bildURL.trim(), maxPixelX, maxPixelY, ConnectionContext.createDummy())) != null) {
            if (shadowSize > 0) {
                return new ImageIcon(DocumentPanel.generateShadow(buffImage, shadowSize));
            }
            return new ImageIcon(buffImage);
        }
        return null;
    }

    private static Image loadPreview(String filenameFullsize, int width, int height, ConnectionContext connectionContext) {
        ImageIcon imageIcon;
        block12: {
            imageIcon = null;
            String extension = DocumentPanel.extractExtension(filenameFullsize);
            if (extension != null && extension.matches("jpg|jpeg|gif|png|bmp")) {
                WebDavTunnelHelper webDavClient = new WebDavTunnelHelper("BELIS2", "BelisWebDavTunnelAction");
                try {
                    String filenameThumbnail = DocumentPanel.extendFilenameWithThumbnail(filenameFullsize);
                    if (webDavClient.checkFileOnWebDAV(filenameThumbnail, connectionContext)) {
                        imageIcon = new ImageIcon(ImageIO.read(webDavClient.getFileFromWebDAV(filenameThumbnail, connectionContext)));
                        break block12;
                    }
                    if (webDavClient.checkFileOnWebDAV(filenameFullsize, connectionContext)) {
                        imageIcon = new ImageIcon(ImageIO.read(webDavClient.getFileFromWebDAV(filenameFullsize, connectionContext)));
                        break block12;
                    }
                    return null;
                }
                catch (Exception ex) {
                    LOG.warn((Object)ex, (Throwable)ex);
                    try {
                        imageIcon = new ImageIcon(filenameFullsize);
                    }
                    catch (Exception ex2) {
                        LOG.error((Object)ex2, (Throwable)ex2);
                        return null;
                    }
                }
            }
        }
        if (imageIcon != null && imageIcon.getImage() != null && imageIcon.getImage().getWidth(null) > 0) {
            BufferedImage in;
            try {
                in = Static2DTools.toCompatibleImage((Image)imageIcon.getImage());
            }
            catch (Exception ex) {
                LOG.error((Object)ex, (Throwable)ex);
                return null;
            }
            int newHeight = 0;
            int newWidth = 0;
            double widthToHeightRatio = (double)imageIcon.getIconWidth() / (double)imageIcon.getIconHeight();
            if (widthToHeightRatio / ((double)width / (double)height) < 1.0) {
                newHeight = height;
                newWidth = (int)((double)height * widthToHeightRatio);
            } else {
                newWidth = width;
                newHeight = (int)((double)width / widthToHeightRatio);
            }
            return Static2DTools.getFasterScaledInstance((BufferedImage)in, (int)newWidth, (int)newHeight, (Object)RenderingHints.VALUE_INTERPOLATION_BICUBIC, (boolean)true);
        }
        return null;
    }

    public static MouseListener decorateComponentWithMouseOverCursorChange(final JComponent toDecorate, final int mouseEntered, final int mouseExited) {
        MouseAdapter toAdd = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                toDecorate.setCursor(new Cursor(mouseEntered));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                toDecorate.setCursor(new Cursor(mouseExited));
            }
        };
        toDecorate.addMouseListener(toAdd);
        return toAdd;
    }

    public Collection<DmsUrlCustomBean> getDokumente() {
        return this.dokumente;
    }

    public void setDokumente(Collection<DmsUrlCustomBean> dokumente) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"setDokumente");
        }
        this.dokumente = dokumente;
        this.firePropertyChange("DocumentPanel.Dokumente", null, dokumente);
        this.bindingGroup.unbind();
        this.bindingGroup.bind();
    }

    private WebDavTunnelHelper getWebdavHelper() {
        WebDavTunnelHelper webdavHelper = new WebDavTunnelHelper("BELIS2", "BelisWebDavTunnelAction");
        return webdavHelper;
    }

    private void downloadSelection() {
        Object sel = this.lstDocList.getSelectedValue();
        if (sel instanceof DmsUrlCustomBean) {
            DmsUrlCustomBean bean = (DmsUrlCustomBean)((Object)sel);
            if (DownloadManagerDialog.getInstance().showAskingForUserTitleDialog((Component)this)) {
                String filenameFullsize;
                String jobname = DownloadManagerDialog.getInstance().getJobName();
                String description = bean.getDescription();
                String string = filenameFullsize = bean.getUrl() != null ? bean.getUrl().getObject_name() : null;
                if (description != null && filenameFullsize != null) {
                    String extension = DocumentPanel.extractExtension(filenameFullsize);
                    final WebDavTunnelHelper webdavHelper = this.getWebdavHelper();
                    BackgroundTaskDownload.DownloadTask swingWorkerBackgroundTask = new BackgroundTaskDownload.DownloadTask(){

                        public void download(File fileToSaveTo) throws Exception {
                            block16: {
                                try (FileOutputStream out = new FileOutputStream(fileToSaveTo);){
                                    String filenameThumbnail = DocumentPanel.extendFilenameWithThumbnail(filenameFullsize, DocumentPanel.EXTENTION_JPG);
                                    if (webdavHelper.checkFileOnWebDAV(filenameFullsize, ConnectionContext.createDummy())) {
                                        IOUtils.copyLarge((InputStream)webdavHelper.getFileFromWebDAV(filenameFullsize, ConnectionContext.createDummy()), (OutputStream)out);
                                        break block16;
                                    }
                                    if (webdavHelper.checkFileOnWebDAV(filenameThumbnail, ConnectionContext.createDummy())) {
                                        InputStream isTemplate = webdavHelper.getFileFromWebDAV(filenameThumbnail, ConnectionContext.createDummy());
                                        IOUtils.copyLarge((InputStream)isTemplate, (OutputStream)out);
                                        break block16;
                                    }
                                    throw new Exception("file not found on webdav");
                                }
                                catch (Exception ex) {
                                    LOG.error((Object)ex, (Throwable)ex);
                                    throw ex;
                                }
                            }
                        }
                    };
                    DownloadManager.instance().add((Download)new BackgroundTaskDownload(swingWorkerBackgroundTask, description, jobname, description, extension != null ? String.format(".%s", extension) : null));
                }
            }
        }
    }

    private String addURLtoList(String urlString) {
        String docName;
        String description;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("addURLToList set: " + this.getDokumente()));
        }
        if ((description = JOptionPane.showInputDialog(this, "Welche Beschriftung soll der Link haben?", docName = urlString.substring(urlString.lastIndexOf("/") + 1))) != null && description.length() > 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("addURLToList: " + this.getDokumente()));
            }
            return description;
        }
        return null;
    }

    public void addFiles(List<DocumentStruct> fileList) {
        if (fileList != null && fileList.size() > 0) {
            WaitDialog wd = new WaitDialog(StaticSwingTools.getParentFrame((Component)this), true, "Speichere Dokument", null);
            CismetThreadPool.execute((Runnable)new DocumentUploadWorker(fileList, wd));
            StaticSwingTools.showDialog((JDialog)wd);
        }
    }

    private void deleteSelectedListItems() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("deleteSelectedListItems: " + this.getDokumente()));
        }
        for (Object sel : this.lstDocList.getSelectedValuesList()) {
            this.dokumente.remove(sel);
        }
        SwingWorker<ImageIcon, Void> sw = this.previewWorker;
        if (sw != null) {
            sw.cancel(true);
        }
        this.lblPreview.setIcon(null);
        this.lblPreview.setText("");
        this.lstDocList.setSelectedIndex(this.lstDocList.getFirstVisibleIndex());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("deleteSelectedListItems: " + this.getDokumente()));
        }
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.popMenu = new JPopupMenu();
        this.miDelete = new JMenuItem();
        this.panStatus = new JPanel();
        this.lblAbsolutePath = new JLabel();
        this.lblStatus = new JLabel();
        this.panList = new JPanel();
        this.scpDocList = new JScrollPane();
        this.lstDocList = new JList();
        this.panPreviewScp = new JPanel();
        this.scpPreview = new JScrollPane();
        this.panPreviewIntern = new JPanel();
        this.lblPreview = new JLabel();
        this.miDelete.setText("L\u00f6schen");
        this.miDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DocumentPanel.this.miDeleteActionPerformed(evt);
            }
        });
        this.popMenu.add(this.miDelete);
        this.setLayout(new GridBagLayout());
        this.panStatus.setMaximumSize(new Dimension(15, 25));
        this.panStatus.setMinimumSize(new Dimension(15, 25));
        this.panStatus.setPreferredSize(new Dimension(15, 25));
        this.panStatus.setLayout(new FlowLayout(2));
        this.panStatus.add(this.lblAbsolutePath);
        this.panStatus.add(this.lblStatus);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.panStatus, gridBagConstraints);
        this.panList.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Dokumente"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.panList.setLayout(new BorderLayout());
        this.scpDocList.setMaximumSize(new Dimension(200, 250));
        this.scpDocList.setMinimumSize(new Dimension(200, 250));
        this.scpDocList.setPreferredSize(new Dimension(200, 250));
        ELProperty eLProperty = ELProperty.create((String)"${dokumente}");
        JListBinding jListBinding = SwingBindings.createJListBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)eLProperty, (JList)this.lstDocList);
        this.bindingGroup.addBinding((Binding)jListBinding);
        this.lstDocList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DocumentPanel.this.lstDocListMouseClicked(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                DocumentPanel.this.lstDocListMousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                DocumentPanel.this.lstDocListMouseReleased(evt);
            }
        });
        this.lstDocList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                DocumentPanel.this.lstDocListValueChanged(evt);
            }
        });
        this.scpDocList.setViewportView(this.lstDocList);
        this.panList.add((Component)this.scpDocList, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 5, 5);
        this.add((Component)this.panList, gridBagConstraints);
        this.panPreviewScp.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Vorschau"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.panPreviewScp.setLayout(new BorderLayout());
        this.scpPreview.setMaximumSize(new Dimension(225, 250));
        this.scpPreview.setMinimumSize(new Dimension(225, 250));
        this.scpPreview.setPreferredSize(new Dimension(225, 250));
        this.panPreviewIntern.setLayout(new GridBagLayout());
        this.lblPreview.setHorizontalAlignment(0);
        this.lblPreview.setHorizontalTextPosition(0);
        this.lblPreview.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DocumentPanel.this.lblPreviewMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.panPreviewIntern.add((Component)this.lblPreview, gridBagConstraints);
        this.scpPreview.setViewportView(this.panPreviewIntern);
        this.panPreviewScp.add((Component)this.scpPreview, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 10);
        this.add((Component)this.panPreviewScp, gridBagConstraints);
        this.bindingGroup.bind();
    }

    private void lstDocListValueChanged(ListSelectionEvent evt) {
        this.lblPreview.setIcon(null);
        this.lblPreview.setText("");
        Object toCast = this.lstDocList.getSelectedValue();
        if (toCast != null && toCast instanceof DmsUrlCustomBean) {
            String file;
            DmsUrlCustomBean url = (DmsUrlCustomBean)((Object)toCast);
            String string = file = url.getUrl() != null ? url.getUrl().getObject_name() : null;
            if (file != null) {
                this.busyIconTimer.start();
                SwingWorker<ImageIcon, Void> oldWorker = this.previewWorker;
                if (oldWorker != null) {
                    oldWorker.cancel(true);
                }
                this.previewWorker = new PreviewWorker(file);
                THREAD_EXECUTOR.execute(this.previewWorker);
            }
        }
    }

    private void lblPreviewMouseClicked(MouseEvent evt) {
        if (!evt.isPopupTrigger()) {
            this.downloadSelection();
        }
    }

    private void lstDocListMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1 && !evt.isPopupTrigger()) {
            this.downloadSelection();
        }
    }

    private void miDeleteActionPerformed(ActionEvent evt) {
        this.deleteSelectedListItems();
    }

    private void lstDocListMousePressed(MouseEvent evt) {
        if (evt.isPopupTrigger() && !this.dokumente.isEmpty() && this.inEditMode) {
            this.popMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private void lstDocListMouseReleased(MouseEvent evt) {
        if (evt.isPopupTrigger() && !this.dokumente.isEmpty() && this.inEditMode) {
            this.popMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    public JList getLstDocList() {
        return this.lstDocList;
    }

    public void setLstDocList(JList lstDocList) {
        this.lstDocList = lstDocList;
    }

    public void setEditable(boolean editable) {
        this.inEditMode = editable;
    }

    @Override
    public void setOpaque(boolean isOpaque) {
        super.setOpaque(isOpaque);
        if (this.panList != null) {
            this.panList.setOpaque(isOpaque);
        }
        if (this.panStatus != null) {
            this.panStatus.setOpaque(isOpaque);
        }
        if (this.panPreviewIntern != null) {
            this.panPreviewIntern.setOpaque(isOpaque);
        }
        if (this.panPreviewScp != null) {
            this.panPreviewScp.setOpaque(isOpaque);
        }
    }

    public static String extendFilenameWithThumbnail(String filename) {
        return DocumentPanel.extendFilenameWithThumbnail(filename, DocumentPanel.extractExtension(filename));
    }

    public static String extendFilenameWithThumbnail(String filename, String extension) {
        return filename != null ? String.format("%s%s%s", filename, THUMBNAIL_SUFFIX_WITHOUT_EXTENSION, extension != null ? String.format(".%s", extension) : "") : null;
    }

    public static String extractExtension(String filename) {
        return filename != null ? filename.substring(filename.lastIndexOf(".") + 1).toLowerCase() : null;
    }

    static {
        BUSY_ICONS = new Icon[15];
        for (int i = 0; i < BUSY_ICONS.length; ++i) {
            DocumentPanel.BUSY_ICONS[i] = new ImageIcon(DocumentPanel.class.getResource("/de/cismet/belis/resource/icon/16/busy-icon" + i + ".png"));
        }
        IDLE_ICON = new ImageIcon(DocumentPanel.class.getResource("/de/cismet/belis/resource/icon/16/idle-icon.png"));
        UNKNOWN_FORMAT = new ImageIcon(DocumentPanel.class.getResource("/de/cismet/belis/resource/icon/16/unknown.png"));
        Class<DocumentPanel> c = DocumentPanel.class;
        FILE_TYPE_ICONS = new HashMap<String, ImageIcon>();
        FILE_TYPE_ICONS.put(EXTENTION_PDF, new ImageIcon(c.getResource("/de/cismet/belis/resource/icon/16/pdf.png")));
        FILE_TYPE_ICONS.put(EXTENTION_JPG, new ImageIcon(c.getResource("/de/cismet/belis/resource/icon/16/image.png")));
        FILE_TYPE_ICONS.put(EXTENTION_JPEG, new ImageIcon(c.getResource("/de/cismet/belis/resource/icon/16/image.png")));
        FILE_TYPE_ICONS.put(EXTENTION_GIF, new ImageIcon(c.getResource("/de/cismet/belis/resource/icon/16/image.png")));
        FILE_TYPE_ICONS.put(EXTENTION_BMP, new ImageIcon(c.getResource("/de/cismet/belis/resource/icon/16/image.png")));
        FILE_TYPE_ICONS.put(EXTENTION_PNG, new ImageIcon(c.getResource("/de/cismet/belis/resource/icon/16/image.png")));
        FILE_TYPE_ICONS.put(EXTENTION_HTML, new ImageIcon(c.getResource("/de/cismet/belis/resource/icon/16/html.png")));
        FILE_TYPE_ICONS.put(EXTENTION_DOC, new ImageIcon(c.getResource("/de/cismet/belis/resource/icon/16/doc.png")));
        FILE_TYPE_ICONS.put(EXTENTION_XLS, new ImageIcon(c.getResource("/de/cismet/belis/resource/icon/16/xls.png")));
    }

    class DocumentListCellRenderer
    extends DefaultListCellRenderer {
        private final Color colorOdd;
        private final Color colorEven;

        public DocumentListCellRenderer() {
            this.colorOdd = new Color(235, 235, 235);
            this.colorEven = new Color(215, 215, 215);
        }

        public DocumentListCellRenderer(Color colorOdd, Color colorEven) {
            this.colorOdd = colorOdd;
            this.colorEven = colorEven;
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            ImageIcon imageIcon = null;
            if (value instanceof DmsUrlCustomBean) {
                String extension;
                DmsUrlCustomBean url = (DmsUrlCustomBean)((Object)value);
                String filename = url.getUrl() != null ? url.getUrl().getObject_name() : null;
                value = url.getBeschreibung();
                if (filename != null && (extension = DocumentPanel.extractExtension(filename)) != null) {
                    imageIcon = (ImageIcon)FILE_TYPE_ICONS.get(extension);
                }
            }
            Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (!isSelected) {
                c.setBackground(index % 2 == 1 ? this.colorOdd : this.colorEven);
            }
            this.setIcon(imageIcon != null ? imageIcon : UNKNOWN_FORMAT);
            return c;
        }
    }

    final class DocumentUploadWorker
    extends SwingWorker<Collection<DmsUrlCustomBean>, Void> {
        private static final String FILE_PREFIX = "DOC-";
        private final Collection<DocumentStruct> docs;
        private final WaitDialog wd;

        public DocumentUploadWorker(Collection<DocumentStruct> docs, WaitDialog wd) {
            this.docs = docs;
            this.wd = wd;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Collection<DmsUrlCustomBean> doInBackground() throws Exception {
            try {
                WebDavTunnelHelper webdavHelper = new WebDavTunnelHelper("BELIS2", "BelisWebDavTunnelAction");
                ArrayList<DmsUrlCustomBean> newBeans = new ArrayList<DmsUrlCustomBean>();
                for (DocumentStruct doc : this.docs) {
                    File fileFullsize = doc.getFile();
                    String filenameFullsize = WebDavTunnelHelper.generateWebDAVFileName((String)FILE_PREFIX, (File)fileFullsize);
                    webdavHelper.uploadFileToWebDAV(filenameFullsize, fileFullsize, (Component)DocumentPanel.this, ConnectionContext.createDummy());
                    newBeans.add(DmsUrlCustomBean.createDmsURLFromLink(filenameFullsize, doc.getName()));
                    try {
                        BufferedImage img = ImageIO.read(new BufferedInputStream(new FileInputStream(fileFullsize)));
                        double ratio = (double)img.getWidth() / (double)img.getHeight();
                        int newHeight = (int)(300.0 / ratio);
                        Image scaledImg = img.getScaledInstance(300, newHeight, 4);
                        BufferedImage thumbnail = new BufferedImage(300, newHeight, 1);
                        thumbnail.createGraphics().drawImage(scaledImg, 0, 0, null);
                        String[] fileNameSplit = filenameFullsize.split("\\.");
                        String endung = fileNameSplit[fileNameSplit.length - 1];
                        File fileThumbnail = File.createTempFile(filenameFullsize, endung);
                        ImageIO.write((RenderedImage)thumbnail, endung, new FileOutputStream(fileThumbnail));
                        String filenameThumbnail = DocumentPanel.extendFilenameWithThumbnail(filenameFullsize);
                        webdavHelper.uploadFileToWebDAV(filenameThumbnail, fileThumbnail, (Component)DocumentPanel.this, ConnectionContext.createDummy());
                    }
                    catch (Exception ex) {
                        LOG.error((Object)ex, (Throwable)ex);
                    }
                }
                ArrayList<DmsUrlCustomBean> arrayList = newBeans;
                return arrayList;
            }
            finally {
                while (!this.wd.isVisible()) {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.wd.setVisible(false);
                this.wd.dispose();
            }
        }

        @Override
        protected void done() {
            try {
                Collection newBeans = (Collection)this.get();
                if (!newBeans.isEmpty()) {
                    DocumentPanel.this.dokumente.addAll(newBeans);
                }
            }
            catch (InterruptedException ex) {
                LOG.warn((Object)ex, (Throwable)ex);
            }
            catch (Exception ex) {
                LOG.error((Object)ex, (Throwable)ex);
                ErrorInfo ei = new ErrorInfo("Fehler", "Beim Hochladen des Dokumentes ist ein Fehler aufgetreten.", null, null, (Throwable)ex, Level.SEVERE, null);
                JXErrorPane.showDialog((Component)DocumentPanel.this, (ErrorInfo)ei);
            }
        }
    }

    private class DocumentStruct {
        private String name;
        private File file;

        public DocumentStruct(String name, File file) {
            this.name = name;
            this.file = file;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public File getFile() {
            return this.file;
        }

        public void setFile(File file) {
            this.file = file;
        }
    }

    final class PreviewWorker
    extends SwingWorker<ImageIcon, Void> {
        private final String document;

        public PreviewWorker(String document) {
            this.document = document;
        }

        @Override
        protected ImageIcon doInBackground() throws Exception {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.document != null && !this.isCancelled()) {
                DocumentPanel.this.lblPreview.setText("loading...");
                return DocumentPanel.loadPicture(this.document, DocumentPanel.this.panPreviewScp.getWidth() - 55 - 4, DocumentPanel.this.panPreviewScp.getHeight() - 55 - 4, 4);
            }
            return null;
        }

        @Override
        protected void done() {
            if (!this.isCancelled()) {
                DocumentPanel.this.lblAbsolutePath.setText("");
                DocumentPanel.this.lblAbsolutePath.setToolTipText("");
                ImageIcon icon = null;
                try {
                    icon = (ImageIcon)this.get();
                }
                catch (InterruptedException interruptedException) {
                }
                catch (ExecutionException executionException) {
                    // empty catch block
                }
                if (icon != null) {
                    DocumentPanel.this.lblPreview.setSize(icon.getIconHeight() + 1, icon.getIconWidth() + 1);
                    DocumentPanel.this.lblPreview.setIcon(icon);
                    DocumentPanel.this.lblPreview.setText("");
                } else if (this.document != null) {
                    DocumentPanel.this.lblPreview.setIcon(NO_PREVIEW);
                    DocumentPanel.this.lblPreview.setSize(NO_PREVIEW.getIconWidth(), NO_PREVIEW.getIconHeight());
                    DocumentPanel.this.lblPreview.setText("<html>Could not create preview.<br>Click to open File!</html>");
                } else {
                    DocumentPanel.this.lblPreview.setIcon(null);
                    DocumentPanel.this.lblPreview.setText("");
                    DocumentPanel.this.lblPreview.setSize(0, 0);
                }
                DocumentPanel.this.busyIconTimer.stop();
                DocumentPanel.this.lblStatus.setIcon(IDLE_ICON);
            }
            DocumentPanel.this.previewWorker = null;
        }
    }

    final class DocListTransferHandler
    extends TransferHandler {
        DocListTransferHandler() {
        }

        @Override
        public int getSourceActions(JComponent c) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"getSourceAction");
            }
            return 0;
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"createTransferable");
            }
            if (c == DocumentPanel.this.lstDocList) {
                return new Transferable(){

                    @Override
                    public DataFlavor[] getTransferDataFlavors() {
                        return new DataFlavor[]{DataFlavor.javaFileListFlavor};
                    }

                    @Override
                    public boolean isDataFlavorSupported(DataFlavor flavor) {
                        return DataFlavor.javaFileListFlavor.equals(flavor);
                    }

                    @Override
                    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
                        Object[] vals = DocumentPanel.this.lstDocList.getSelectedValues();
                        ArrayList<DmsUrlCustomBean> urlList = new ArrayList<DmsUrlCustomBean>();
                        for (Object o : vals) {
                            if (!(o instanceof DmsUrlCustomBean)) continue;
                            urlList.add((DmsUrlCustomBean)((Object)o));
                        }
                        return urlList;
                    }
                };
            }
            return super.createTransferable(c);
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            DataFlavor[] flavs;
            if (!DocumentPanel.this.inEditMode) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Application is not in edit mode, no drag & drop possible");
                }
                return false;
            }
            for (DataFlavor df : flavs = support.getDataFlavors()) {
                if (!df.equals(DataFlavor.javaFileListFlavor) && !df.equals(DataFlavor.stringFlavor)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport e) {
            try {
                int i;
                Transferable tr = e.getTransferable();
                DataFlavor[] flavors = tr.getTransferDataFlavors();
                for (i = 0; i < flavors.length; ++i) {
                    Object possibleFileList;
                    if (!flavors[i].equals(DataFlavor.javaFileListFlavor) || !((possibleFileList = tr.getTransferData(flavors[i])) instanceof List)) continue;
                    List mp = (List)possibleFileList;
                    ArrayList<DocumentStruct> docList = new ArrayList<DocumentStruct>();
                    for (Object o : mp) {
                        File f;
                        String desc;
                        if (!(o instanceof File) || (desc = DocumentPanel.this.addURLtoList((f = (File)o).toURI().toString())) == null) continue;
                        docList.add(new DocumentStruct(desc, f));
                    }
                    DocumentPanel.this.addFiles(docList);
                    return true;
                }
                for (i = 0; i < flavors.length; ++i) {
                    if (!flavors[i].equals(DataFlavor.stringFlavor)) continue;
                    ArrayList<DocumentStruct> docList = new ArrayList<DocumentStruct>();
                    String urls = (String)tr.getTransferData(DataFlavor.stringFlavor);
                    StringTokenizer tokens = new StringTokenizer(urls);
                    while (tokens.hasMoreTokens()) {
                        String urlString = tokens.nextToken();
                        try {
                            String desc;
                            File f = new File(new URL(urlString).toURI());
                            if (!f.exists() || (desc = DocumentPanel.this.addURLtoList(urlString)) == null) continue;
                            docList.add(new DocumentStruct(desc, f));
                        }
                        catch (MalformedURLException ex) {
                            LOG.error((Object)"malformed url", (Throwable)ex);
                        }
                    }
                    DocumentPanel.this.addFiles(docList);
                    return true;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return false;
        }
    }
}

