/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.belis.gui.utils;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;

public class StyleTable
extends JTable {
    public static final Color COLOR_TXT_BACK = new Color(230, 230, 230);
    public static final Color COLOR_TBL_SECOND = new Color(210, 210, 210);

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        this.paintEmptyRows(g);
    }

    protected void paintEmptyRows(Graphics g) {
        int rowCount = this.getRowCount();
        Rectangle bounds = g.getClipBounds();
        if (rowCount * this.rowHeight < bounds.height) {
            for (int i = rowCount; i <= bounds.height / this.rowHeight; ++i) {
                g.setColor(this.colorForRow(i));
                g.fillRect(bounds.x, i * this.rowHeight, bounds.width, this.rowHeight);
            }
        }
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        Container parent = this.getParent();
        if (parent instanceof JViewport) {
            JViewport view = (JViewport)parent;
            return view.getHeight() > this.getPreferredSize().height;
        }
        return false;
    }

    protected Color colorForRow(int row) {
        return row % 2 == 0 ? COLOR_TXT_BACK : COLOR_TBL_SECOND;
    }

    @Override
    public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
        Component c = super.prepareRenderer(renderer, row, column);
        if (!this.isCellSelected(row, column)) {
            c.setBackground(this.colorForRow(row));
            c.setForeground(UIManager.getColor("Table.foreground"));
        } else {
            c.setBackground(UIManager.getColor("Table.selectionBackground"));
            c.setForeground(UIManager.getColor("Table.selectionForeground"));
        }
        return c;
    }
}

