/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.belis.gui.widget;

import de.cismet.belis.broker.BelisBroker;
import de.cismet.commons.architecture.interfaces.ObjectChangeListener;
import de.cismet.commons.architecture.interfaces.Widget;
import de.cismet.commons.architecture.validation.ValidationStateChangedListener;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import org.apache.log4j.Logger;

public abstract class AbstractWidget
extends JPanel
implements Widget {
    public static final String PROP_WIDGET_NAME = "widgetName";
    protected static final Icon DEFAULT_ICON = new ImageIcon(AbstractWidget.class.getResource("/de/cismet/commons/architecture/resource/icon/cismetlogo16.png"));
    public static final String PROP_WIDGET_ICON = "widgetIcon";
    private BelisBroker broker;
    private String widgetName = "Fenstername";
    private Icon widgetIcon;
    private final Logger log = Logger.getLogger(this.getClass());
    private final ArrayList<ValidationStateChangedListener> validationListeners = new ArrayList();
    private UpdateWorker currentWorker;
    private boolean isCoreWidget = false;
    private boolean isReadOnlyWidget = true;

    public BelisBroker getBroker() {
        return this.broker;
    }

    public void setBroker(BelisBroker broker) {
        this.broker = broker;
    }

    public String getWidgetName() {
        return this.widgetName;
    }

    public void setWidgetName(String widgetName) {
        String oldWidgetName = this.getWidgetName();
        this.widgetName = widgetName;
        this.firePropertyChange(PROP_WIDGET_NAME, oldWidgetName, widgetName);
    }

    public Icon getWidgetIcon() {
        if (this.widgetIcon != null) {
            return this.widgetIcon;
        }
        this.widgetIcon = DEFAULT_ICON;
        return DEFAULT_ICON;
    }

    public void setWidgetIcon(String iconName) {
        try {
            this.setWidgetIcon(new ImageIcon(this.getClass().getResource(iconName)));
        }
        catch (Exception ex) {
            this.log.warn((Object)"Fehler beim setzen des Icons: ", (Throwable)ex);
            this.setWidgetIcon(DEFAULT_ICON);
        }
    }

    public void setWidgetIcon(Icon widgetIcon) {
        Icon oldWidgetIcon = this.getWidgetIcon();
        this.widgetIcon = widgetIcon;
        this.firePropertyChange(PROP_WIDGET_NAME, oldWidgetIcon, widgetIcon);
    }

    public boolean isCoreWidget() {
        return this.isCoreWidget;
    }

    public void setIsCoreWidget(boolean isCoreWidget) {
        this.isCoreWidget = isCoreWidget;
    }

    public boolean isReadOnlyWidget() {
        return this.isReadOnlyWidget;
    }

    public void setReadOnlyWidget(boolean isReadOnlyWidget) {
        this.isReadOnlyWidget = isReadOnlyWidget;
    }

    public void objectChanged(Object changedObject) {
        if (this.currentWorker != null && !this.currentWorker.isDone()) {
            this.currentWorker.cancel(true);
        }
        this.currentWorker = new UpdateWorker(changedObject);
        this.broker.execute(this.currentWorker);
    }

    public void removeValidationStateChangedListener(ValidationStateChangedListener l) {
        this.validationListeners.remove(l);
    }

    public void addValidationStateChangedListener(ValidationStateChangedListener l) {
        this.validationListeners.add(l);
    }

    public void fireValidationStateChanged(Object validatedObject) {
        for (ValidationStateChangedListener listener : this.validationListeners) {
            listener.validationStateChanged(validatedObject);
        }
    }

    public abstract void guiObjectChanged(Object var1);

    public void propertyChange(PropertyChangeEvent evt) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("PropertyChange in Widget: " + this.getWidgetName()));
        }
        this.updateUIPropertyChange();
    }

    class UpdateWorker
    extends SwingWorker<Void, Void> {
        private Object changedObject;

        UpdateWorker(Object changedObject) {
            this.changedObject = changedObject;
        }

        @Override
        protected Void doInBackground() throws Exception {
            AbstractWidget.this.guiObjectChanged(this.changedObject);
            return null;
        }

        @Override
        protected void done() {
            if (this.isCancelled()) {
                AbstractWidget.this.log.warn((Object)"UpdateWorker is canceled --> nothing to do in method done()");
                return;
            }
            try {
                AbstractWidget.this.guiObjectChanged(this.changedObject);
                AbstractWidget.this.broker.fireChangeFinished((ObjectChangeListener)AbstractWidget.this);
            }
            catch (Exception ex) {
                AbstractWidget.this.log.error((Object)"Failure during processing UpdateWorker results", (Throwable)ex);
                return;
            }
        }
    }
}

