/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.belis.gui.widget;

import Sirius.navigator.actiontag.ActionTagProtected;
import de.cismet.belis.broker.BelisBroker;
import de.cismet.belis.gui.widget.BelisWidget;
import de.cismet.belis.gui.widget.windowsearchwidget.BelisWindowSearch;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import javax.swing.JTabbedPane;
import org.apache.log4j.Logger;
import org.openide.util.Lookup;

public class WindowSearchWidget
extends BelisWidget {
    private static final Logger LOG = Logger.getLogger(WindowSearchWidget.class);
    private JTabbedPane jTabbedPane1;

    public WindowSearchWidget() {
        this.setWidgetName("Suchen");
    }

    @Override
    public void setBroker(BelisBroker broker) {
        this.initComponents();
        Collection windowSearches = Lookup.getDefault().lookupAll(BelisWindowSearch.class);
        if (!windowSearches.isEmpty()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Initializing " + windowSearches.size() + " window searches."));
            }
            for (BelisWindowSearch windowSearch : windowSearches) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Initializing window search '" + windowSearch.getName() + "'."));
                }
                if (this.checkActionTag(windowSearch)) {
                    this.jTabbedPane1.addTab(windowSearch.getName(), windowSearch.getSearchWindowComponent());
                    continue;
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Could not initialize window search '" + windowSearch.getName() + "' due to restricted permissions."));
            }
            this.revalidate();
            this.repaint();
        }
    }

    private boolean checkActionTag(Object toCheck) {
        if (toCheck instanceof ActionTagProtected) {
            ActionTagProtected atp = (ActionTagProtected)toCheck;
            return atp.checkActionTag();
        }
        return true;
    }

    private void initComponents() {
        this.jTabbedPane1 = new JTabbedPane();
        this.setLayout(new BorderLayout());
        this.add((Component)this.jTabbedPane1, "Center");
    }
}

