/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.belis.gui.widget;

import de.cismet.belis.broker.BelisBroker;
import de.cismet.belis.broker.CidsBroker;
import de.cismet.belis.todo.CustomMutableTreeTableNode;
import de.cismet.cids.custom.beans.belis2.AbzweigdoseCustomBean;
import de.cismet.cids.custom.beans.belis2.ArbeitsauftragCustomBean;
import de.cismet.cids.custom.beans.belis2.ArbeitsprotokollCustomBean;
import de.cismet.cids.custom.beans.belis2.GeometrieCustomBean;
import de.cismet.cids.custom.beans.belis2.LeitungCustomBean;
import de.cismet.cids.custom.beans.belis2.MauerlascheCustomBean;
import de.cismet.cids.custom.beans.belis2.SchaltstelleCustomBean;
import de.cismet.cids.custom.beans.belis2.TdtaLeuchtenCustomBean;
import de.cismet.cids.custom.beans.belis2.TdtaStandortMastCustomBean;
import de.cismet.cids.custom.beans.belis2.VeranlassungCustomBean;
import de.cismet.commons.server.entity.WorkbenchEntity;
import de.cismet.commons.server.entity.WorkbenchFeatureEntity;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.TransferHandler;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXTreeTable;

class WorkbenchTransferHandler
extends TransferHandler {
    private static final Logger LOG = Logger.getLogger(WorkbenchTransferHandler.class);
    private DataFlavor nodesFlavor;
    private DataFlavor[] flavors = new DataFlavor[1];

    public WorkbenchTransferHandler() {
        try {
            String mimeType = "application/x-java-jvm-local-objectref;class=\"" + TreePath[].class.getName() + "\"";
            this.flavors[0] = this.nodesFlavor = new DataFlavor(mimeType);
        }
        catch (ClassNotFoundException e) {
            System.out.println("ClassNotFound: " + e.getMessage());
        }
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        if (!support.isDrop() || !support.isDataFlavorSupported(this.nodesFlavor)) {
            return false;
        }
        support.setShowDropLocation(true);
        JTable.DropLocation dl = (JTable.DropLocation)support.getDropLocation();
        JXTreeTable tree = (JXTreeTable)support.getComponent();
        int dropRow = dl.getRow();
        TreePath targetPath = tree.getPathForRow(dropRow);
        Object userObject = ((CustomMutableTreeTableNode)((Object)targetPath.getLastPathComponent())).getUserObject();
        if (userObject instanceof VeranlassungCustomBean && CidsBroker.getInstance().checkForEditVeranlassung()) {
            return true;
        }
        return userObject instanceof ArbeitsauftragCustomBean && CidsBroker.getInstance().checkForEditArbeitsauftrag();
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        JXTreeTable tree = (JXTreeTable)c;
        ArrayList<TreePath> paths = new ArrayList<TreePath>();
        for (int i = 0; i < tree.getSelectedRowCount(); ++i) {
            paths.add(tree.getPathForRow(tree.getSelectedRows()[i]));
        }
        if (!paths.isEmpty()) {
            ArrayList<TreePath> toTransfer = new ArrayList<TreePath>();
            for (TreePath path : paths) {
                Object object = ((CustomMutableTreeTableNode)((Object)path.getLastPathComponent())).getUserObject();
                if (!(object instanceof WorkbenchEntity || object instanceof VeranlassungCustomBean || object instanceof GeometrieCustomBean)) {
                    return null;
                }
                toTransfer.add(this.copy(path));
            }
            TreePath[] nodes = toTransfer.toArray(new TreePath[toTransfer.size()]);
            return new NodesTransferable(nodes);
        }
        return null;
    }

    private TreePath copy(TreePath path) {
        return new TreePath(path.getPath());
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 1;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        if (!this.canImport(support)) {
            return false;
        }
        try {
            JTable.DropLocation dl = (JTable.DropLocation)support.getDropLocation();
            JXTreeTable tree = (JXTreeTable)support.getComponent();
            int dropRow = dl.getRow();
            int[] selRows = tree.getSelectedRows();
            ArrayList<WorkbenchEntity> clipboardBeans = new ArrayList<WorkbenchEntity>();
            for (int selRow : selRows) {
                WorkbenchEntity selBean = (WorkbenchEntity)((CustomMutableTreeTableNode)((Object)tree.getPathForRow(selRow).getLastPathComponent())).getUserObject();
                clipboardBeans.add(selBean);
            }
            TreePath path = tree.getPathForRow(dropRow);
            CustomMutableTreeTableNode dropNode = (CustomMutableTreeTableNode)((Object)path.getLastPathComponent());
            Object userObject = ((CustomMutableTreeTableNode)((Object)path.getLastPathComponent())).getUserObject();
            if (userObject instanceof VeranlassungCustomBean) {
                VeranlassungCustomBean veranlassungCustomBean = (VeranlassungCustomBean)userObject;
                for (WorkbenchEntity clipboardBean : clipboardBeans) {
                    Collection<GeometrieCustomBean> geometrien;
                    if (clipboardBean instanceof TdtaStandortMastCustomBean) {
                        Collection<TdtaStandortMastCustomBean> standorte = veranlassungCustomBean.getAr_standorte();
                        if (standorte.contains((TdtaStandortMastCustomBean)clipboardBean)) continue;
                        standorte.add((TdtaStandortMastCustomBean)clipboardBean);
                        BelisBroker.getInstance().addNewBasicToVeranlassungNode(dropNode, clipboardBean);
                        continue;
                    }
                    if (clipboardBean instanceof TdtaLeuchtenCustomBean) {
                        Collection<TdtaLeuchtenCustomBean> leuchten = veranlassungCustomBean.getAr_leuchten();
                        if (leuchten.contains((TdtaLeuchtenCustomBean)clipboardBean)) continue;
                        leuchten.add((TdtaLeuchtenCustomBean)clipboardBean);
                        BelisBroker.getInstance().addNewBasicToVeranlassungNode(dropNode, clipboardBean);
                        continue;
                    }
                    if (clipboardBean instanceof LeitungCustomBean) {
                        Collection<LeitungCustomBean> leitungen = veranlassungCustomBean.getAr_leitungen();
                        if (leitungen.contains((LeitungCustomBean)clipboardBean)) continue;
                        leitungen.add((LeitungCustomBean)clipboardBean);
                        BelisBroker.getInstance().addNewBasicToVeranlassungNode(dropNode, clipboardBean);
                        continue;
                    }
                    if (clipboardBean instanceof MauerlascheCustomBean) {
                        Collection<MauerlascheCustomBean> mauerlaschen = veranlassungCustomBean.getAr_mauerlaschen();
                        if (mauerlaschen.contains((MauerlascheCustomBean)clipboardBean)) continue;
                        mauerlaschen.add((MauerlascheCustomBean)clipboardBean);
                        BelisBroker.getInstance().addNewBasicToVeranlassungNode(dropNode, clipboardBean);
                        continue;
                    }
                    if (clipboardBean instanceof AbzweigdoseCustomBean) {
                        Collection<AbzweigdoseCustomBean> abzweigdosen = veranlassungCustomBean.getAr_abzweigdosen();
                        if (abzweigdosen.contains((AbzweigdoseCustomBean)clipboardBean)) continue;
                        abzweigdosen.add((AbzweigdoseCustomBean)clipboardBean);
                        BelisBroker.getInstance().addNewBasicToVeranlassungNode(dropNode, clipboardBean);
                        continue;
                    }
                    if (clipboardBean instanceof SchaltstelleCustomBean) {
                        Collection<SchaltstelleCustomBean> schaltstellen = veranlassungCustomBean.getAr_schaltstellen();
                        if (schaltstellen.contains((SchaltstelleCustomBean)clipboardBean)) continue;
                        schaltstellen.add((SchaltstelleCustomBean)clipboardBean);
                        BelisBroker.getInstance().addNewBasicToVeranlassungNode(dropNode, clipboardBean);
                        continue;
                    }
                    if (!(clipboardBean instanceof GeometrieCustomBean) || (geometrien = veranlassungCustomBean.getAr_geometrien()).contains((GeometrieCustomBean)clipboardBean)) continue;
                    geometrien.add((GeometrieCustomBean)clipboardBean);
                    BelisBroker.getInstance().addNewBasicToVeranlassungNode(dropNode, clipboardBean);
                }
            } else {
                ArbeitsauftragCustomBean arbeitsauftragCustomBean = (ArbeitsauftragCustomBean)userObject;
                for (WorkbenchEntity clipboardBean : clipboardBeans) {
                    if (clipboardBean instanceof VeranlassungCustomBean) {
                        VeranlassungCustomBean veranlassungCustomBean = (VeranlassungCustomBean)clipboardBean;
                        ArrayList<WorkbenchFeatureEntity> allBasics = new ArrayList<WorkbenchFeatureEntity>();
                        allBasics.addAll(veranlassungCustomBean.getAr_abzweigdosen());
                        allBasics.addAll(veranlassungCustomBean.getAr_leitungen());
                        allBasics.addAll(veranlassungCustomBean.getAr_leuchten());
                        allBasics.addAll(veranlassungCustomBean.getAr_mauerlaschen());
                        allBasics.addAll(veranlassungCustomBean.getAr_schaltstellen());
                        allBasics.addAll(veranlassungCustomBean.getAr_standorte());
                        allBasics.addAll(veranlassungCustomBean.getAr_geometrien());
                        for (WorkbenchEntity workbenchEntity : allBasics) {
                            ArbeitsprotokollCustomBean protokoll = BelisBroker.getInstance().createProtokollFromBasic(workbenchEntity);
                            protokoll.setProtokollnummer(arbeitsauftragCustomBean.getAr_protokolle().size() + 1);
                            protokoll.setVeranlassungsnummer(veranlassungCustomBean.getNummer());
                            BelisBroker.getInstance().addNewProtokollToAuftragNode(dropNode, protokoll, workbenchEntity);
                            arbeitsauftragCustomBean.getAr_protokolle().add(protokoll);
                        }
                        continue;
                    }
                    ArbeitsprotokollCustomBean protokoll = BelisBroker.getInstance().createProtokollFromBasic(clipboardBean);
                    protokoll.setProtokollnummer(arbeitsauftragCustomBean.getAr_protokolle().size() + 1);
                    BelisBroker.getInstance().addNewProtokollToAuftragNode(dropNode, protokoll, clipboardBean);
                    arbeitsauftragCustomBean.getAr_protokolle().add(protokoll);
                }
            }
            tree.expandPath(path.getParentPath());
            return true;
        }
        catch (Exception ex) {
            LOG.error((Object)"error while pasting bean", (Throwable)ex);
            return false;
        }
    }

    public String toString() {
        return this.getClass().getName();
    }

    public class NodesTransferable
    implements Transferable {
        TreePath[] nodes;

        public NodesTransferable(TreePath[] nodes) {
            this.nodes = nodes;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
            if (!this.isDataFlavorSupported(flavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.nodes;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return WorkbenchTransferHandler.this.flavors;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return WorkbenchTransferHandler.this.nodesFlavor.equals(flavor);
        }
    }
}

