/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.belis.gui.widget;

import Sirius.server.middleware.types.MetaObject;
import de.cismet.belis.broker.BelisBroker;
import de.cismet.belis.broker.CidsBroker;
import de.cismet.belis.gui.renderer.WorkbenchTreeTableRenderer;
import de.cismet.belis.gui.widget.BelisWidget;
import de.cismet.belis.gui.widget.WorkbenchTransferHandler;
import de.cismet.belis.todo.CustomMutableTreeTableNode;
import de.cismet.belis.todo.CustomTreeTableModel;
import de.cismet.belis.util.BelisIcons;
import de.cismet.belisEE.util.EntityComparator;
import de.cismet.cids.custom.beans.belis2.AbzweigdoseCustomBean;
import de.cismet.cids.custom.beans.belis2.ArbeitsauftragCustomBean;
import de.cismet.cids.custom.beans.belis2.ArbeitsprotokollCustomBean;
import de.cismet.cids.custom.beans.belis2.GeometrieCustomBean;
import de.cismet.cids.custom.beans.belis2.LeitungCustomBean;
import de.cismet.cids.custom.beans.belis2.MauerlascheCustomBean;
import de.cismet.cids.custom.beans.belis2.SchaltstelleCustomBean;
import de.cismet.cids.custom.beans.belis2.TdtaLeuchtenCustomBean;
import de.cismet.cids.custom.beans.belis2.TdtaStandortMastCustomBean;
import de.cismet.cids.custom.beans.belis2.VeranlassungCustomBean;
import de.cismet.cismap.commons.features.AbstractNewFeature;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.FeatureCollection;
import de.cismet.cismap.commons.features.FeatureCollectionEvent;
import de.cismet.cismap.commons.features.FeatureCollectionListener;
import de.cismet.cismap.commons.features.PureNewFeature;
import de.cismet.cismap.commons.features.StyledFeature;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.CreateGeometryListener;
import de.cismet.commons.architecture.interfaces.FeatureSelectionChangedListener;
import de.cismet.commons.server.entity.BaseEntity;
import de.cismet.commons.server.entity.WorkbenchEntity;
import de.cismet.commons.server.entity.WorkbenchFeatureEntity;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.DropMode;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.apache.commons.collections.comparators.ReverseComparator;
import org.apache.log4j.Logger;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.swingx.JXTreeTable;
import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.treetable.AbstractMutableTreeTableNode;
import org.jdesktop.swingx.treetable.DefaultMutableTreeTableNode;
import org.jdesktop.swingx.treetable.MutableTreeTableNode;
import org.jdesktop.swingx.treetable.TreeTableModel;
import org.jdesktop.swingx.treetable.TreeTableNode;
import org.jdom.Element;

public class WorkbenchWidget
extends BelisWidget
implements TreeSelectionListener,
FeatureSelectionChangedListener,
PropertyChangeListener,
FeatureCollectionListener {
    public static final String PROP_SEARCH_RESULTS = "searchResults";
    private static final Logger LOG = Logger.getLogger(WorkbenchWidget.class);
    public static final String PROP_SELECTEDTREENODES = "selectedTreeNodes";
    public static final String PROP_TREE_TABLE_MODEL = "treeTableModel";
    public static final String BELIS_CREATE_MODE = "BELIS_CREATE_MODE";
    public static final int VIEW_MODE = 0;
    public static final int CREATE_MODE = 1;
    public static final int EDIT_MODE = 2;
    BindingGroup bindingGroup2 = new BindingGroup();
    private boolean ignoreFeatureSelection = false;
    private Collection<TreePath> selectedTreeNodes = null;
    private final CustomMutableTreeTableNode rootNode = new CustomMutableTreeTableNode(null, true);
    private final CustomMutableTreeTableNode searchResultsNode = new CustomMutableTreeTableNode(null, true);
    private final CustomMutableTreeTableNode newObjectsNode = new CustomMutableTreeTableNode(null, true);
    private final CustomMutableTreeTableNode editObjectsNode = new CustomMutableTreeTableNode(null, true);
    private CustomTreeTableModel treeTableModel = null;
    private final HashMap<TdtaLeuchtenCustomBean, TdtaStandortMastCustomBean> leuchteToVirtualStandortMap = new HashMap();
    private final JButton btnAttachMode = new JButton();
    private Collection<WorkbenchEntity> currentSearchResults = new TreeSet<WorkbenchEntity>((Comparator<WorkbenchEntity>)new ReverseComparator((Comparator)new EntityComparator()));
    private Set<WorkbenchEntity> objectsToPersist = new TreeSet<WorkbenchEntity>((Comparator<WorkbenchEntity>)new ReverseComparator((Comparator)new EntityComparator()));
    private final Collection<WorkbenchEntity> objectsToDelete = new ArrayList<WorkbenchEntity>();
    private int currentMode = 0;
    private boolean isSelectedOverMap = false;
    private TreePath selectedElement = null;
    private Set searchResults = null;
    private final boolean basicEditEnabled;
    private final boolean veranlassungEditEnabled;
    private final boolean arbeitsauftragEditEnabled;
    private final boolean basicCreateEnabled;
    private final boolean veranlassungCreateEnabled;
    private final boolean arbeitsauftragCreateEnabled;
    private boolean treeSelectionVeto = false;
    private JScrollPane jScrollPane1;
    private JXTreeTable jttHitTable;
    private JPanel panMain;

    public WorkbenchWidget() {
        this.setWidgetName("Arbeitsbereich");
        this.basicEditEnabled = CidsBroker.getInstance().checkForEditBasic();
        this.veranlassungEditEnabled = CidsBroker.getInstance().checkForEditVeranlassung();
        this.arbeitsauftragEditEnabled = CidsBroker.getInstance().checkForEditArbeitsauftrag();
        this.basicCreateEnabled = CidsBroker.getInstance().checkForCreateBasic();
        this.veranlassungCreateEnabled = CidsBroker.getInstance().checkForCreateVeranlassung();
        this.arbeitsauftragCreateEnabled = CidsBroker.getInstance().checkForCreateArbeitsauftrag();
    }

    public CustomMutableTreeTableNode getSearchResultsNode() {
        return this.searchResultsNode;
    }

    public CustomMutableTreeTableNode getNewObjectsNode() {
        return this.newObjectsNode;
    }

    public CustomMutableTreeTableNode getEditObjectsNode() {
        return this.editObjectsNode;
    }

    @Override
    public void setBroker(BelisBroker broker) {
        super.setBroker(broker);
        this.initComponents();
        this.jttHitTable.setDragEnabled(true);
        broker.getMappingComponent().getInputEventListener().put(BELIS_CREATE_MODE, new CreateNewBelisObjectListener(broker.getMappingComponent(), PureNewFeature.class));
        broker.getMappingComponent().putCursor(BELIS_CREATE_MODE, broker.getMappingComponent().getCursor("ZOOM"));
        FeatureCollection collection = broker.getMappingComponent().getFeatureCollection();
        if (collection != null) {
            collection.addFeatureCollectionListener((FeatureCollectionListener)this);
        } else {
            LOG.warn((Object)"No feature Collection to set Listener on.");
        }
        this.jttHitTable.getTreeSelectionModel().addTreeSelectionListener(this);
        this.jttHitTable.setEditable(false);
        this.jttHitTable.setSelectionMode(2);
        this.jttHitTable.setTreeCellRenderer((TreeCellRenderer)new WorkbenchTreeTableRenderer());
        this.treeTableModel = new CustomTreeTableModel(this.getBroker(), this.rootNode);
        this.searchResultsNode.setUserObject(CustomTreeTableModel.HIT_NODE);
        this.newObjectsNode.setUserObject(CustomTreeTableModel.NEW_OBJECT_NODE);
        this.editObjectsNode.setUserObject(CustomTreeTableModel.EDIT_OBJECT_NODE);
        this.treeTableModel.insertNodeIntoAsLastChild((MutableTreeTableNode)this.searchResultsNode, (MutableTreeTableNode)this.rootNode);
        this.jttHitTable.setTreeTableModel((TreeTableModel)this.treeTableModel);
        broker.decorateWithAlternateHighlighting(this.jttHitTable);
        HighlightPredicate noGeometryPredicate = new HighlightPredicate(){

            public boolean isHighlighted(Component renderer, ComponentAdapter componentAdapter) {
                try {
                    Object userObj = ((AbstractMutableTreeTableNode)WorkbenchWidget.this.jttHitTable.getPathForRow(componentAdapter.row).getLastPathComponent()).getUserObject();
                    if (userObj != null) {
                        if (userObj instanceof TdtaLeuchtenCustomBean) {
                            TdtaStandortMastCustomBean virtualStandort = (TdtaStandortMastCustomBean)WorkbenchWidget.this.leuchteToVirtualStandortMap.get((TdtaLeuchtenCustomBean)userObj);
                            if (virtualStandort != null) {
                                return virtualStandort.getGeometry() == null;
                            }
                        } else {
                            if (userObj instanceof VeranlassungCustomBean) {
                                VeranlassungCustomBean veranlassungCustomBean = (VeranlassungCustomBean)userObj;
                                return veranlassungCustomBean.getAr_abzweigdosen().isEmpty() && veranlassungCustomBean.getAr_leitungen().isEmpty() && veranlassungCustomBean.getAr_leuchten().isEmpty() && veranlassungCustomBean.getAr_mauerlaschen().isEmpty() && veranlassungCustomBean.getAr_schaltstellen().isEmpty() && veranlassungCustomBean.getAr_standorte().isEmpty() && veranlassungCustomBean.getAr_geometrien().isEmpty();
                            }
                            if (userObj instanceof WorkbenchFeatureEntity) {
                                return ((WorkbenchFeatureEntity)userObj).getGeometry() == null;
                            }
                        }
                    }
                }
                catch (Exception ex) {
                    LOG.error((Object)"Exception in Highlighter: ", (Throwable)ex);
                }
                return false;
            }
        };
        ColorHighlighter noGeometryHighlighter = new ColorHighlighter(noGeometryPredicate, BelisBroker.red, null);
        this.jttHitTable.addHighlighter((Highlighter)noGeometryHighlighter);
        this.jttHitTable.setTransferHandler((TransferHandler)new WorkbenchTransferHandler());
        this.jttHitTable.setDropMode(DropMode.ON);
    }

    public CustomTreeTableModel getTreeTableModel() {
        return this.treeTableModel;
    }

    public void setTreeTableModel(CustomTreeTableModel treeTableModel) {
        this.treeTableModel = treeTableModel;
        this.firePropertyChange(PROP_TREE_TABLE_MODEL, null, (Object)treeTableModel);
    }

    public Collection<TreePath> getSelectedTreeNodes() {
        return this.selectedTreeNodes;
    }

    public TreePath getSelectedTreeNode() {
        Collection<TreePath> selectedTreeNodes = this.getSelectedTreeNodes();
        TreePath selectedTreeNode = selectedTreeNodes != null && selectedTreeNodes.size() == 1 ? selectedTreeNodes.iterator().next() : null;
        return selectedTreeNode;
    }

    public void setSelectedTreeNodes(final Collection<TreePath> selectedTreeNodes) {
        final Collection<TreePath> oldSelectedTreeNodes = this.selectedTreeNodes;
        this.selectedTreeNodes = selectedTreeNodes;
        this.firePropertyChange(PROP_SELECTEDTREENODES, oldSelectedTreeNodes, selectedTreeNodes);
        if (this.isTreeSelectionVeto()) {
            this.setTreeSelectionVeto(false);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WorkbenchWidget.this.jttHitTable.getTreeSelectionModel().setSelectionPaths(oldSelectedTreeNodes.toArray(new TreePath[0]));
                }
            });
        }
        if (selectedTreeNodes != null) {
            SwingUtilities.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    block20: {
                        try {
                            WorkbenchWidget.this.configureMapModeAccordingToSelection();
                            if (WorkbenchWidget.this.isSelectedOverMap) {
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug((Object)"feature was selected over map. No need to select it in map.");
                                }
                                break block20;
                            }
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)"feature was selected over table. Going to select feature in map.");
                            }
                            final ArrayList<Object> featuresToSelect = new ArrayList<Object>();
                            for (TreePath path : selectedTreeNodes) {
                                ArbeitsprotokollCustomBean apCustomBean;
                                Object currentUserObject = WorkbenchWidget.getUserObjectForTreePath(path);
                                if (currentUserObject != null && currentUserObject instanceof WorkbenchFeatureEntity && ((WorkbenchFeatureEntity)currentUserObject).getGeometry() != null) {
                                    if (LOG.isDebugEnabled()) {
                                        LOG.debug((Object)"UserObject != null and instance of StyledFeature and geometry available --> select Feature");
                                    }
                                    featuresToSelect.add((StyledFeature)currentUserObject);
                                    continue;
                                }
                                if (WorkbenchWidget.this.isParentNodeMast(path.getLastPathComponent())) {
                                    if (LOG.isDebugEnabled()) {
                                        LOG.debug((Object)"Leuchte from mast is selected in table.");
                                    }
                                    TdtaStandortMastCustomBean parentMast = WorkbenchWidget.this.getParentMast(path.getLastPathComponent());
                                    if (LOG.isDebugEnabled()) {
                                        LOG.debug((Object)"Selecting Mast in map.");
                                    }
                                    featuresToSelect.add(parentMast);
                                    continue;
                                }
                                if (WorkbenchWidget.this.isNodeHaengeLeuchte(path.getLastPathComponent())) {
                                    if (LOG.isDebugEnabled()) {
                                        LOG.debug((Object)"current selected node is haengeleuchte. Selecting corresponding standort in map: ");
                                    }
                                    featuresToSelect.add(WorkbenchWidget.this.leuchteToVirtualStandortMap.get((TdtaLeuchtenCustomBean)currentUserObject));
                                    continue;
                                }
                                if (currentUserObject instanceof VeranlassungCustomBean) {
                                    VeranlassungCustomBean veranlassungCustomBean = (VeranlassungCustomBean)currentUserObject;
                                    featuresToSelect.addAll(veranlassungCustomBean.getAr_abzweigdosen());
                                    featuresToSelect.addAll(veranlassungCustomBean.getAr_leitungen());
                                    featuresToSelect.addAll(veranlassungCustomBean.getAr_leuchten());
                                    featuresToSelect.addAll(veranlassungCustomBean.getAr_mauerlaschen());
                                    featuresToSelect.addAll(veranlassungCustomBean.getAr_schaltstellen());
                                    featuresToSelect.addAll(veranlassungCustomBean.getAr_standorte());
                                    featuresToSelect.addAll(veranlassungCustomBean.getAr_geometrien());
                                    continue;
                                }
                                if (currentUserObject instanceof ArbeitsauftragCustomBean) {
                                    ArbeitsauftragCustomBean arbeitsauftragCustomBean = (ArbeitsauftragCustomBean)currentUserObject;
                                    for (ArbeitsprotokollCustomBean apCustomBean2 : arbeitsauftragCustomBean.getAr_protokolle()) {
                                        if (apCustomBean2.getChildEntity() == null) continue;
                                        featuresToSelect.add(apCustomBean2.getChildEntity());
                                    }
                                    continue;
                                }
                                if (!(currentUserObject instanceof ArbeitsprotokollCustomBean) || (apCustomBean = (ArbeitsprotokollCustomBean)currentUserObject).getChildEntity() == null) continue;
                                featuresToSelect.add(apCustomBean.getChildEntity());
                            }
                            if (featuresToSelect.isEmpty()) {
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug((Object)"no geometry to select --> unselect");
                                }
                                WorkbenchWidget.this.getBroker().addFeatureSelectionChangeIgnore(WorkbenchWidget.this);
                                WorkbenchWidget.this.getBroker().getMappingComponent().getFeatureCollection().unselectAll();
                            } else {
                                WorkbenchWidget.this.getBroker().addFeatureSelectionChangeIgnore(WorkbenchWidget.this);
                                Runnable runnable = new Runnable(){

                                    @Override
                                    public void run() {
                                        WorkbenchWidget.this.ignoreFeatureSelection = true;
                                        WorkbenchWidget.this.getBroker().getMappingComponent().getFeatureCollection().removeFeatures(featuresToSelect);
                                        WorkbenchWidget.this.getBroker().getMappingComponent().getFeatureCollection().addFeatures(featuresToSelect);
                                        WorkbenchWidget.this.getBroker().getMappingComponent().getFeatureCollection().select(featuresToSelect);
                                        WorkbenchWidget.this.ignoreFeatureSelection = false;
                                    }
                                };
                                SwingUtilities.invokeLater(runnable);
                            }
                        }
                        finally {
                            WorkbenchWidget.this.getBroker().removeFeatureSelectionChangeIgnore(WorkbenchWidget.this);
                            WorkbenchWidget.this.isSelectedOverMap = false;
                        }
                    }
                }
            });
        }
    }

    public int getCurrentMode() {
        return this.currentMode;
    }

    public void setCurrentMode(int currentMode) {
        this.currentMode = currentMode;
    }

    public void selectUserObjects(Collection userObjects) {
        this.jttHitTable.getTreeSelectionModel().clearSelection();
        for (Object userObject : userObjects) {
            Collection<TreePath> pathsToEntity = this.getTreeTableModel().getPathsForUserObject(userObject);
            for (TreePath pathToEntity : pathsToEntity) {
                this.jttHitTable.getTreeSelectionModel().addSelectionPath(pathToEntity);
            }
        }
        this.setSelectedTreeNodes(Arrays.asList(this.jttHitTable.getTreeSelectionModel().getSelectionPaths()));
    }

    @Override
    public void setWidgetEditable(boolean isEditable) {
        super.setWidgetEditable(isEditable);
        if (isEditable) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Setting " + this.getWidgetName() + "editable"));
            }
            this.configureMapModeAccordingToSelection();
            if (this.getBroker().isInCreateMode()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Configuring Workbench for CreateMode. ");
                }
                this.setCurrentMode(1);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("removing node:" + (Object)((Object)this.searchResultsNode)));
                }
                try {
                    this.treeTableModel.removeNodeFromParent((MutableTreeTableNode)this.searchResultsNode);
                }
                catch (Exception ex) {
                    LOG.warn((Object)"could not remove node from parent", (Throwable)ex);
                }
                this.treeTableModel.insertNodeIntoAsLastChild((MutableTreeTableNode)this.newObjectsNode, (MutableTreeTableNode)this.rootNode);
                this.treeTableModel.insertNodeIntoAsLastChild((MutableTreeTableNode)this.searchResultsNode, (MutableTreeTableNode)this.rootNode);
                this.jttHitTable.expandPath(new TreePath(this.treeTableModel.getPathToRoot((TreeTableNode)this.newObjectsNode)));
                this.jttHitTable.getTreeSelectionModel().setSelectionPath(new TreePath(this.treeTableModel.getPathToRoot((TreeTableNode)this.newObjectsNode)));
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Configuring Workbench for EditMode");
                }
                this.setCurrentMode(2);
                ArrayList<MutableTreeTableNode> expandedNodes = new ArrayList<MutableTreeTableNode>();
                ArrayList<Object> seletedUserObjects = new ArrayList<Object>();
                if (this.jttHitTable.getTreeSelectionModel().getSelectionPaths() != null) {
                    for (TreePath selPath : this.jttHitTable.getTreeSelectionModel().getSelectionPaths()) {
                        seletedUserObjects.add(((CustomMutableTreeTableNode)((Object)selPath.getLastPathComponent())).getUserObject());
                    }
                }
                ArrayList<MutableTreeTableNode> nodes = new ArrayList<MutableTreeTableNode>();
                for (int i = 0; i < this.searchResultsNode.getChildCount(); ++i) {
                    MutableTreeTableNode node = (MutableTreeTableNode)this.searchResultsNode.getChildAt(i);
                    boolean isBasicNode = node.getUserObject() instanceof TdtaStandortMastCustomBean || node.getUserObject() instanceof TdtaLeuchtenCustomBean || node.getUserObject() instanceof MauerlascheCustomBean || node.getUserObject() instanceof SchaltstelleCustomBean || node.getUserObject() instanceof LeitungCustomBean || node.getUserObject() instanceof AbzweigdoseCustomBean;
                    boolean isVeranlassungNode = node.getUserObject() instanceof VeranlassungCustomBean;
                    boolean isArbeitsauftragNode = node.getUserObject() instanceof ArbeitsauftragCustomBean;
                    if (!(isBasicNode && this.basicEditEnabled || isVeranlassungNode && this.veranlassungEditEnabled) && (!isArbeitsauftragNode || !this.arbeitsauftragEditEnabled)) continue;
                    nodes.add(node);
                    TreePath path = new TreePath(this.treeTableModel.getPathToRoot((TreeTableNode)node));
                    if (!this.jttHitTable.isExpanded(path)) continue;
                    expandedNodes.add(node);
                }
                try {
                    this.treeTableModel.removeNodeFromParent((MutableTreeTableNode)this.searchResultsNode);
                }
                catch (Exception ex) {
                    LOG.warn((Object)"could not remove node from parent", (Throwable)ex);
                }
                this.treeTableModel.insertNodeIntoAsLastChild((MutableTreeTableNode)this.editObjectsNode, (MutableTreeTableNode)this.rootNode);
                this.treeTableModel.insertNodeIntoAsLastChild((MutableTreeTableNode)this.searchResultsNode, (MutableTreeTableNode)this.rootNode);
                for (MutableTreeTableNode node : nodes) {
                    this.treeTableModel.insertNodeIntoAsLastChild(node, (MutableTreeTableNode)this.editObjectsNode);
                    this.objectsToPersist.add((WorkbenchEntity)node.getUserObject());
                }
                for (MutableTreeTableNode expandedNode : expandedNodes) {
                    this.jttHitTable.expandPath(new TreePath(this.treeTableModel.getPathToRoot((TreeTableNode)expandedNode)));
                }
                this.selectUserObjects(seletedUserObjects);
                this.jttHitTable.expandPath(new TreePath(this.treeTableModel.getPathToRoot((TreeTableNode)this.editObjectsNode)));
            }
            this.jttHitTable.expandPath(new TreePath(this.treeTableModel.getPathToRoot((TreeTableNode)this.searchResultsNode)));
        } else {
            ArrayList expandedNodes = new ArrayList();
            ArrayList<MutableTreeTableNode> seletedNodes = new ArrayList<MutableTreeTableNode>();
            if (this.jttHitTable.getTreeSelectionModel().getSelectionPaths() != null) {
                for (TreePath selPath : this.jttHitTable.getTreeSelectionModel().getSelectionPaths()) {
                    seletedNodes.add((MutableTreeTableNode)selPath.getLastPathComponent());
                }
            }
            if (this.getCurrentMode() == 1) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Was in create mode switching to view mode.");
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("removing node:" + (Object)((Object)this.newObjectsNode)));
                }
                try {
                    this.treeTableModel.removeNodeFromParent((MutableTreeTableNode)this.newObjectsNode);
                }
                catch (Exception ex) {
                    LOG.warn((Object)"could not remove node from parent", (Throwable)ex);
                }
                try {
                    this.treeTableModel.removeNodeFromParent((MutableTreeTableNode)this.searchResultsNode);
                }
                catch (Exception ex) {
                    LOG.warn((Object)"could not remove node from parent", (Throwable)ex);
                }
                this.treeTableModel.insertNodeIntoAsLastChild((MutableTreeTableNode)this.searchResultsNode, (MutableTreeTableNode)this.rootNode);
                this.jttHitTable.expandPath(new TreePath(this.treeTableModel.getPathToRoot((TreeTableNode)this.searchResultsNode)));
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Was in edit mode switching to view mode.");
                }
                this.treeTableModel.removeAllChildrenFromNode(this.editObjectsNode, false);
                try {
                    this.treeTableModel.removeNodeFromParent((MutableTreeTableNode)this.editObjectsNode);
                }
                catch (Exception ex) {
                    LOG.warn((Object)"could not remove node from parent", (Throwable)ex);
                }
                this.objectsToPersist.clear();
                if (this.treeTableModel.getPathForUserObject(this.searchResultsNode.getUserObject()) == null) {
                    this.treeTableModel.insertNodeIntoAsLastChild((MutableTreeTableNode)this.searchResultsNode, (MutableTreeTableNode)this.rootNode);
                }
            }
            this.setCurrentMode(0);
            this.refreshSearchObjects();
            for (MutableTreeTableNode expandedNode : expandedNodes) {
                this.jttHitTable.expandPath(new TreePath(this.treeTableModel.getPathToRoot((TreeTableNode)expandedNode)));
            }
            ArrayList<TreePath> paths = new ArrayList<TreePath>();
            for (MutableTreeTableNode selecteNode : seletedNodes) {
                if (selecteNode == null) continue;
                try {
                    paths.add(new TreePath(this.treeTableModel.getPathToRoot((TreeTableNode)selecteNode)));
                }
                catch (NullPointerException nullPointerException) {}
            }
            if (paths.isEmpty()) {
                this.jttHitTable.getTreeSelectionModel().clearSelection();
            } else {
                this.jttHitTable.getTreeSelectionModel().setSelectionPaths(paths.toArray(new TreePath[0]));
            }
        }
    }

    @Override
    public void masterConfigure(Element parent) {
        this.addButtonToMapWidget();
        this.getBroker().getMappingComponent().addPropertyChangeListener((PropertyChangeListener)this);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Configure binding TreeTableModel <--> SearchResults");
        }
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.getBroker(), (Property)ELProperty.create((String)"${currentSearchResults}"), (Object)this, (Property)ELProperty.create((String)"${currentSearchResults}"));
        this.bindingGroup2.addBinding((Binding)binding);
        this.bindingGroup2.bind();
    }

    @Override
    public void updateUIPropertyChange() {
        super.updateUIPropertyChange();
        this.jttHitTable.repaint();
    }

    public boolean checkConstraintForMapModeSwitch() {
        TdtaStandortMastCustomBean virtualStandort = null;
        if (this.getBroker().isInEditMode()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Application is in Editmode");
            }
            if (this.getSelectedTreeNode() != null && this.getSelectedTreeNode().getLastPathComponent() != null) {
                if (this.getSelectedTreeNode().getLastPathComponent() instanceof CustomMutableTreeTableNode) {
                    Object userObject;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Chosen object is CustomMutableTreeTableNode");
                    }
                    if ((userObject = ((CustomMutableTreeTableNode)((Object)this.getSelectedTreeNode().getLastPathComponent())).getUserObject()) != null) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"userObject != null");
                        }
                        if (userObject instanceof TdtaLeuchtenCustomBean && (virtualStandort = this.leuchteToVirtualStandortMap.get((TdtaLeuchtenCustomBean)userObject)) != null && virtualStandort instanceof TdtaStandortMastCustomBean && !virtualStandort.isStandortMast()) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)"UserObject is Leuchte with virtual standort");
                            }
                            if (virtualStandort.getGeometry() == null) {
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug((Object)"Geometry of virtual standort is null, swithcing mode of Mapping Compoenent");
                                }
                                return true;
                            }
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)"Geometry of virtual standort != null nothing to do");
                            }
                        } else if (userObject instanceof WorkbenchFeatureEntity) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)"UserObject is instance of GeoBaseEntity");
                            }
                            if (((WorkbenchFeatureEntity)userObject).getGeometry() == null) {
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug((Object)"Geometry is null swicht mode of Mapping Component");
                                }
                                return true;
                            }
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)"Geometry != null nothing to do");
                            }
                        } else if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"UserObject is not instance of GeoBaseEntity or Leuchte.");
                        }
                    } else if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"userObject == null");
                    }
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"No instance of CustomMutableTreeNode");
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"LastPathComponent == null");
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Application is not in Editmode");
        }
        return false;
    }

    public static Object getUserObjectForTreePath(TreePath path) {
        try {
            return ((DefaultMutableTreeTableNode)path.getLastPathComponent()).getUserObject();
        }
        catch (Exception ex) {
            LOG.warn((Object)"Error while accessing user object. ", (Throwable)ex);
            return null;
        }
    }

    public static Object getUserObjectForTreeNode(Object node) {
        try {
            return ((CustomMutableTreeTableNode)((Object)node)).getUserObject();
        }
        catch (Exception ex) {
            LOG.warn((Object)"Error while accessing user object. ", (Throwable)ex);
            return null;
        }
    }

    private void addButtonToMapWidget() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"adding attachMode button to MapWidget");
        }
        this.btnAttachMode.setIcon(BelisIcons.icoAttachGeometry16);
        this.btnAttachMode.setSelectedIcon(BelisIcons.icoAttachGeometrySelected16);
        this.btnAttachMode.setToolTipText("Georeferenziere Objekt");
        this.btnAttachMode.setBorder(BorderFactory.createEmptyBorder(1, 3, 1, 3));
        this.btnAttachMode.setIconTextGap(8);
        this.btnAttachMode.setMargin(new Insets(10, 14, 10, 14));
        this.btnAttachMode.setEnabled(false);
        this.btnAttachMode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WorkbenchWidget.this.configureMapModeAccordingToSelection();
            }
        });
        this.getBroker().getMapWidget().addCustomButton(this.btnAttachMode);
    }

    public boolean isTreeSelectionVeto() {
        return this.treeSelectionVeto;
    }

    public void setTreeSelectionVeto(boolean treeSelectionVeto) {
        this.treeSelectionVeto = treeSelectionVeto;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void configureMapModeAccordingToSelection() {
        if (this.checkConstraintForMapModeSwitch()) {
            try {
                this.getBroker().addFeatureSelectionChangeIgnore(this);
                this.ignoreFeatureSelection = true;
                this.btnAttachMode.setEnabled(true);
                this.getBroker().getMapWidget().setLastMapMode(this.getBroker().getMapWidget().getCurrentMapMode());
                this.getBroker().getMapWidget().removeMainGroupSelection();
                this.getBroker().getMappingComponent().setInteractionMode(BELIS_CREATE_MODE);
                this.btnAttachMode.setSelected(true);
                Object userObject = ((CustomMutableTreeTableNode)((Object)this.getSelectedTreeNode().getLastPathComponent())).getUserObject();
                if (userObject instanceof TdtaLeuchtenCustomBean) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Instance is Leuchte --> geometry == point");
                    }
                    ((CreateGeometryListener)this.getBroker().getMappingComponent().getInputListener(BELIS_CREATE_MODE)).setMode("POINT");
                    return;
                }
                if (userObject instanceof TdtaStandortMastCustomBean) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Instance is Standort --> geometry == point");
                        LOG.debug(userObject);
                    }
                    ((CreateGeometryListener)this.getBroker().getMappingComponent().getInputListener(BELIS_CREATE_MODE)).setMode("POINT");
                    return;
                }
                if (userObject instanceof MauerlascheCustomBean) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Instance is Mauerlasche --> geometry == point");
                        LOG.debug(userObject);
                    }
                    ((CreateGeometryListener)this.getBroker().getMappingComponent().getInputListener(BELIS_CREATE_MODE)).setMode("POINT");
                    return;
                }
                if (userObject instanceof SchaltstelleCustomBean) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Instance is Schaltstelle --> geometry == point");
                        LOG.debug(userObject);
                    }
                    ((CreateGeometryListener)this.getBroker().getMappingComponent().getInputListener(BELIS_CREATE_MODE)).setMode("POINT");
                    return;
                }
                if (userObject instanceof LeitungCustomBean) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Instance is Leitung --> geometry == line");
                        LOG.debug(userObject);
                    }
                    ((CreateGeometryListener)this.getBroker().getMappingComponent().getInputListener(BELIS_CREATE_MODE)).setMode("LINESTRING");
                    return;
                }
                if (userObject instanceof AbzweigdoseCustomBean) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Instance is Abzweigdose --> geometry == point");
                        LOG.debug(userObject);
                    }
                    ((CreateGeometryListener)this.getBroker().getMappingComponent().getInputListener(BELIS_CREATE_MODE)).setMode("POINT");
                    return;
                }
                if (!(userObject instanceof GeometrieCustomBean)) return;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Instance is Geometrie --> geometry == polygon");
                    LOG.debug(userObject);
                }
                ((CreateGeometryListener)this.getBroker().getMappingComponent().getInputListener(BELIS_CREATE_MODE)).setMode("POLYGON");
                return;
            }
            catch (Exception ex) {
                LOG.error((Object)"Error while configuring map. Setting map back: ", (Throwable)ex);
                return;
            }
            finally {
                this.getBroker().removeFeatureSelectionChangeIgnore(this);
                this.ignoreFeatureSelection = false;
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Constraints for ModeSwitch not fullfied");
            }
            if (!this.getBroker().getMappingComponent().getInteractionMode().equals(BELIS_CREATE_MODE)) return;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Is already in: BELIS_CREATE_MODE mode. Switching back");
            }
            this.btnAttachMode.setEnabled(false);
            if (this.getBroker().getMappingComponent().getInteractionMode() == null || !this.getBroker().getMappingComponent().getInteractionMode().equals(BELIS_CREATE_MODE)) return;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("False map mode setting is at the moment temp feature create. Mode will be set to lastmode: " + (Object)((Object)this.getBroker().getMapWidget().getLastMapMode())));
            }
            this.getBroker().getMapWidget().setToLastInteractionMode();
        }
    }

    private void initComponents() {
        this.panMain = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jttHitTable = new JXTreeTable();
        this.jttHitTable.setDragEnabled(true);
        this.jScrollPane1.setViewportView((Component)this.jttHitTable);
        GroupLayout panMainLayout = new GroupLayout(this.panMain);
        this.panMain.setLayout(panMainLayout);
        panMainLayout.setHorizontalGroup(panMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panMainLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 376, Short.MAX_VALUE).addContainerGap()));
        panMainLayout.setVerticalGroup(panMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panMainLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 210, Short.MAX_VALUE).addContainerGap()));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.panMain, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.panMain, -1, -1, Short.MAX_VALUE));
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"JTreeTable selection changend");
        }
        ArrayList<TreePath> paths = new ArrayList<TreePath>();
        for (int i = 0; i < this.jttHitTable.getSelectedRowCount(); ++i) {
            paths.add(this.jttHitTable.getPathForRow(this.jttHitTable.getSelectedRows()[i]));
        }
        if (!paths.isEmpty()) {
            this.setSelectedTreeNodes(paths);
        } else {
            this.setSelectedTreeNodes(null);
        }
    }

    public boolean isUserObjectLeuchte(Object node) {
        Object userObject;
        return node != null && node instanceof CustomMutableTreeTableNode && (userObject = WorkbenchWidget.getUserObjectForTreeNode(node)) != null && userObject instanceof TdtaLeuchtenCustomBean;
    }

    public boolean isUserObjectMast(Object node) {
        Object userObject;
        return node != null && node instanceof CustomMutableTreeTableNode && (userObject = WorkbenchWidget.getUserObjectForTreeNode(node)) != null && userObject instanceof TdtaStandortMastCustomBean && ((TdtaStandortMastCustomBean)userObject).isStandortMast();
    }

    public boolean isParentNodeMast(Object node) {
        try {
            return this.getParentMast(node).isStandortMast();
        }
        catch (Exception ex) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Exception why checking if node is mast, therefore is no mast", (Throwable)ex);
            }
            return false;
        }
    }

    public boolean isNodeHaengeLeuchte(Object node) {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("instance of Leuchte: " + (((CustomMutableTreeTableNode)((Object)node)).getUserObject() instanceof TdtaLeuchtenCustomBean)));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Parent is searchnode: " + ((Object)((Object)((CustomMutableTreeTableNode)((CustomMutableTreeTableNode)((Object)node)).getParent()))).equals((Object)this.searchResultsNode)));
            }
            return ((CustomMutableTreeTableNode)((Object)node)).getUserObject() instanceof TdtaLeuchtenCustomBean && (((Object)((Object)((CustomMutableTreeTableNode)((CustomMutableTreeTableNode)((Object)node)).getParent()))).equals((Object)this.searchResultsNode) || ((Object)((Object)((CustomMutableTreeTableNode)((CustomMutableTreeTableNode)((Object)node)).getParent()))).equals((Object)this.newObjectsNode));
        }
        catch (Exception ex) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Exception why checking if node is haengeleuchte, therefore is no haengeleuchte", (Throwable)ex);
            }
            return false;
        }
    }

    public TdtaStandortMastCustomBean getParentMast(Object node) {
        try {
            return (TdtaStandortMastCustomBean)((CustomMutableTreeTableNode)((CustomMutableTreeTableNode)((Object)node)).getParent()).getUserObject();
        }
        catch (Exception ex) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Exception while getting parent mast. Does not exist", (Throwable)ex);
            }
            return null;
        }
    }

    @Override
    public void refresh(Object refreshedObject) {
        this.bindingGroup2.unbind();
        this.bindingGroup2.bind();
    }

    public void featureSelectionChanged(Collection<Feature> features) {
        if (!this.ignoreFeatureSelection) {
            if (features.isEmpty()) {
                return;
            }
            ArrayList<TreePath> paths = new ArrayList<TreePath>();
            for (Feature feature : features) {
                TreePath path;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("currentFeature: " + feature));
                }
                if (!(feature instanceof WorkbenchFeatureEntity) || !this.getBroker().getMappingComponent().getFeatureCollection().isSelected(feature)) continue;
                if (feature instanceof TdtaStandortMastCustomBean && !((TdtaStandortMastCustomBean)feature).isStandortMast() && ((TdtaStandortMastCustomBean)feature).getLeuchten() != null && ((TdtaStandortMastCustomBean)feature).getLeuchten().size() > 0) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"virtual Standort selected, selecting depending leuchte");
                    }
                    path = this.treeTableModel.getPathForUserObject(((TdtaStandortMastCustomBean)feature).getLeuchten().iterator().next());
                } else {
                    path = this.treeTableModel.getPathForUserObject(feature);
                }
                if (path == null) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Path is available");
                }
                paths.add(path);
            }
            this.jttHitTable.getSelectionModel().clearSelection();
            TreePath[] patharr = paths.toArray(new TreePath[0]);
            if (paths.isEmpty()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"No Path for feature available");
                }
            } else {
                this.isSelectedOverMap = true;
                try {
                    this.jttHitTable.getTreeSelectionModel().setSelectionPaths(patharr);
                    Rectangle tmp = this.jttHitTable.getCellRect(this.jttHitTable.getSelectedRow(), 0, true);
                    if (tmp != null) {
                        this.jttHitTable.scrollRectToVisible(tmp);
                    }
                }
                catch (Exception ex) {
                    LOG.warn((Object)"couldn't set selection", (Throwable)ex);
                }
            }
        }
    }

    public void refreshSearchObjects() {
        this.refreshNode(this.searchResultsNode, this.currentSearchResults);
    }

    public void refreshPersistObjects() {
        if (BelisBroker.getInstance().isInCreateMode()) {
            this.refreshNode(this.newObjectsNode, this.objectsToPersist);
        } else {
            this.refreshNode(this.editObjectsNode, this.objectsToPersist);
        }
    }

    public void refreshAll() {
        if (BelisBroker.getInstance().isInCreateMode()) {
            this.refreshNode(this.newObjectsNode, this.objectsToPersist);
        } else {
            this.refreshNode(this.editObjectsNode, this.objectsToPersist);
        }
        this.refreshNode(this.searchResultsNode, this.currentSearchResults);
    }

    public void reloadSearchResultEntity(WorkbenchEntity entity) {
        MetaObject mo = CidsBroker.getInstance().getMetaObject(entity.getMetaObject().getClassID(), entity.getMetaObject().getID(), "BELIS2");
        WorkbenchEntity reloadedEntity = (WorkbenchEntity)mo.getBean();
        ArrayList<WorkbenchEntity> newSearchResults = new ArrayList<WorkbenchEntity>();
        for (WorkbenchEntity currentSearchResultEntity : this.currentSearchResults) {
            if (currentSearchResultEntity.equals(entity)) {
                newSearchResults.add(reloadedEntity);
                continue;
            }
            newSearchResults.add(currentSearchResultEntity);
        }
        this.setCurrentSearchResults(newSearchResults);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshNode(CustomMutableTreeTableNode refreshNode, Collection<WorkbenchEntity> objects) {
        if (refreshNode != null) {
            String before = (String)refreshNode.getUserObject();
            try {
                refreshNode.setUserObject("wird geladen...");
                this.treeTableModel.removeAllChildrenFromNode(refreshNode, false);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"adding new SearchResults");
                }
                for (WorkbenchEntity curObject : objects) {
                    if (curObject instanceof TdtaStandortMastCustomBean) {
                        TdtaStandortMastCustomBean standort = (TdtaStandortMastCustomBean)curObject;
                        standort.setEditAllowed(this.basicEditEnabled);
                        CustomMutableTreeTableNode standortNode = new CustomMutableTreeTableNode(curObject, true);
                        if (standort.isStandortMast()) {
                            this.treeTableModel.insertNodeIntoAsLastChild((MutableTreeTableNode)standortNode, (MutableTreeTableNode)refreshNode);
                            standort.addPropertyChangeListener(this);
                        }
                        for (TdtaLeuchtenCustomBean tdtaLeuchtenCustomBean : standort.getLeuchten()) {
                            tdtaLeuchtenCustomBean.setEditAllowed(this.basicEditEnabled);
                            CustomMutableTreeTableNode leuchteNode = new CustomMutableTreeTableNode(tdtaLeuchtenCustomBean, false);
                            tdtaLeuchtenCustomBean.addPropertyChangeListener(this);
                            if (((TdtaStandortMastCustomBean)curObject).isStandortMast()) {
                                this.treeTableModel.insertNodeIntoAsLastChild((MutableTreeTableNode)leuchteNode, (MutableTreeTableNode)standortNode);
                                standort.addPropertyChangeListener((PropertyChangeListener)((Object)tdtaLeuchtenCustomBean));
                                continue;
                            }
                            this.treeTableModel.insertNodeIntoAsLastChild((MutableTreeTableNode)leuchteNode, (MutableTreeTableNode)refreshNode);
                            this.leuchteToVirtualStandortMap.put(tdtaLeuchtenCustomBean, standort);
                        }
                        continue;
                    }
                    if (curObject instanceof VeranlassungCustomBean) {
                        VeranlassungCustomBean veranlassungCustomBean = (VeranlassungCustomBean)curObject;
                        veranlassungCustomBean.setEditAllowed(this.veranlassungEditEnabled);
                        CustomMutableTreeTableNode veranlassungNode = new CustomMutableTreeTableNode(veranlassungCustomBean, true);
                        this.treeTableModel.insertNodeIntoAsLastChild((MutableTreeTableNode)veranlassungNode, (MutableTreeTableNode)refreshNode);
                        TreeSet<WorkbenchEntity> subEntities = new TreeSet<WorkbenchEntity>(new EntityComparator());
                        subEntities.addAll(veranlassungCustomBean.getAr_standorte());
                        subEntities.addAll(veranlassungCustomBean.getAr_leuchten());
                        subEntities.addAll(veranlassungCustomBean.getAr_schaltstellen());
                        subEntities.addAll(veranlassungCustomBean.getAr_mauerlaschen());
                        subEntities.addAll(veranlassungCustomBean.getAr_leitungen());
                        subEntities.addAll(veranlassungCustomBean.getAr_abzweigdosen());
                        subEntities.addAll(veranlassungCustomBean.getAr_geometrien());
                        Iterator iterator = subEntities.iterator();
                        while (iterator.hasNext()) {
                            BaseEntity subEntity;
                            subEntity.setEditAllowed((subEntity = (BaseEntity)((Object)iterator.next())) instanceof GeometrieCustomBean && this.veranlassungEditEnabled);
                            this.treeTableModel.insertNodeIntoAsLastChild((MutableTreeTableNode)new CustomMutableTreeTableNode((Object)subEntity, false), (MutableTreeTableNode)veranlassungNode);
                        }
                        continue;
                    }
                    if (curObject instanceof ArbeitsauftragCustomBean) {
                        ArbeitsauftragCustomBean arbeitsauftragCustomBean = (ArbeitsauftragCustomBean)curObject;
                        arbeitsauftragCustomBean.setEditAllowed(this.arbeitsauftragEditEnabled);
                        CustomMutableTreeTableNode arbeitsauftragNode = new CustomMutableTreeTableNode(arbeitsauftragCustomBean, true);
                        this.treeTableModel.insertNodeIntoAsLastChild((MutableTreeTableNode)arbeitsauftragNode, (MutableTreeTableNode)refreshNode);
                        for (ArbeitsprotokollCustomBean arbeitsprotokollCustomBean : arbeitsauftragCustomBean.getSortedProtokolle()) {
                            arbeitsprotokollCustomBean.setEditAllowed(this.arbeitsauftragEditEnabled);
                            WorkbenchFeatureEntity childEntity = arbeitsprotokollCustomBean.getChildEntity();
                            if (childEntity == null) continue;
                            childEntity.setEditAllowed(this.basicEditEnabled);
                            CustomMutableTreeTableNode childNode = new CustomMutableTreeTableNode(childEntity, false);
                            CustomMutableTreeTableNode protokollNode = new CustomMutableTreeTableNode(arbeitsprotokollCustomBean, true);
                            this.treeTableModel.insertNodeIntoAsLastChild((MutableTreeTableNode)protokollNode, (MutableTreeTableNode)arbeitsauftragNode);
                            this.treeTableModel.insertNodeIntoAsLastChild((MutableTreeTableNode)childNode, (MutableTreeTableNode)protokollNode);
                        }
                        continue;
                    }
                    if (!(curObject instanceof WorkbenchFeatureEntity)) continue;
                    WorkbenchFeatureEntity entity = (WorkbenchFeatureEntity)curObject;
                    entity.setEditAllowed(this.basicEditEnabled);
                    CustomMutableTreeTableNode foundObject = new CustomMutableTreeTableNode(entity, true);
                    this.treeTableModel.insertNodeIntoAsLastChild((MutableTreeTableNode)foundObject, (MutableTreeTableNode)refreshNode);
                }
                try {
                    this.jttHitTable.expandPath(new TreePath(this.treeTableModel.getPathToRoot((TreeTableNode)refreshNode)));
                }
                catch (Exception ex) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)ex, (Throwable)ex);
                    }
                }
            }
            finally {
                refreshNode.setUserObject(before);
            }
        }
    }

    public void clearPersistNode(CustomMutableTreeTableNode node) {
    }

    public void removeSelectedEntity() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"remove Entity");
        }
        TreePath pathToNodeToRemove = BelisBroker.getInstance().getWorkbenchWidget().getSelectedTreeNode();
        Object entity = ((CustomMutableTreeTableNode)((Object)pathToNodeToRemove.getLastPathComponent())).getUserObject();
        if (pathToNodeToRemove.getLastPathComponent() != null && pathToNodeToRemove.getLastPathComponent() instanceof CustomMutableTreeTableNode && entity instanceof WorkbenchEntity) {
            CustomMutableTreeTableNode nodeToRemove = (CustomMutableTreeTableNode)((Object)pathToNodeToRemove.getLastPathComponent());
            CustomMutableTreeTableNode parentNode = nodeToRemove.getParent() != null && nodeToRemove.getParent() instanceof CustomMutableTreeTableNode ? (CustomMutableTreeTableNode)nodeToRemove.getParent() : null;
            Object parentEntity = parentNode != null ? parentNode.getUserObject() : null;
            WorkbenchEntity parentWorkbenchEntity = parentEntity instanceof WorkbenchEntity ? (WorkbenchEntity)parentEntity : null;
            WorkbenchEntity workbenchEntity = (WorkbenchEntity)entity;
            if (parentEntity instanceof VeranlassungCustomBean) {
                VeranlassungCustomBean veranlassung = (VeranlassungCustomBean)workbenchEntity;
                if (workbenchEntity instanceof TdtaLeuchtenCustomBean) {
                    veranlassung.getAr_leuchten().remove((TdtaLeuchtenCustomBean)workbenchEntity);
                } else if (workbenchEntity instanceof TdtaStandortMastCustomBean) {
                    veranlassung.getAr_standorte().remove((TdtaStandortMastCustomBean)workbenchEntity);
                } else if (workbenchEntity instanceof MauerlascheCustomBean) {
                    veranlassung.getAr_mauerlaschen().remove((MauerlascheCustomBean)workbenchEntity);
                } else if (workbenchEntity instanceof LeitungCustomBean) {
                    veranlassung.getAr_leitungen().remove((LeitungCustomBean)workbenchEntity);
                } else if (workbenchEntity instanceof AbzweigdoseCustomBean) {
                    veranlassung.getAr_abzweigdosen().remove((AbzweigdoseCustomBean)workbenchEntity);
                } else if (workbenchEntity instanceof SchaltstelleCustomBean) {
                    veranlassung.getAr_schaltstellen().remove((SchaltstelleCustomBean)workbenchEntity);
                } else if (workbenchEntity instanceof GeometrieCustomBean) {
                    veranlassung.getAr_geometrien().remove((GeometrieCustomBean)workbenchEntity);
                }
            } else if (workbenchEntity instanceof ArbeitsprotokollCustomBean && parentWorkbenchEntity instanceof ArbeitsauftragCustomBean) {
                ArbeitsauftragCustomBean auftrag = (ArbeitsauftragCustomBean)parentWorkbenchEntity;
                ArbeitsprotokollCustomBean arbeitsprotokollCustomBean = (ArbeitsprotokollCustomBean)workbenchEntity;
                auftrag.getAr_protokolle().remove(arbeitsprotokollCustomBean);
                this.objectsToDelete.add(arbeitsprotokollCustomBean);
            } else if (workbenchEntity instanceof TdtaLeuchtenCustomBean && parentWorkbenchEntity instanceof TdtaStandortMastCustomBean) {
                TdtaStandortMastCustomBean mast = (TdtaStandortMastCustomBean)parentWorkbenchEntity;
                TdtaLeuchtenCustomBean tdtaLeuchtenCustomBean = (TdtaLeuchtenCustomBean)workbenchEntity;
                this.objectsToDelete.add(tdtaLeuchtenCustomBean);
                if (mast.getLeuchten().isEmpty()) {
                    this.getBroker().getMappingComponent().getFeatureCollection().reconsiderFeature((Feature)mast);
                }
            } else if (workbenchEntity instanceof TdtaStandortMastCustomBean) {
                for (WorkbenchEntity workbenchEntity2 : ((TdtaStandortMastCustomBean)workbenchEntity).getLeuchten()) {
                    this.objectsToDelete.add(workbenchEntity2);
                }
                this.objectsToDelete.add(workbenchEntity);
            } else if (this.isNodeHaengeLeuchte((Object)nodeToRemove)) {
                TdtaStandortMastCustomBean virtualStandort;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Node which will be removed is a haengeleuchte. Removing also virtual Standort");
                }
                if ((virtualStandort = this.leuchteToVirtualStandortMap.get((TdtaLeuchtenCustomBean)workbenchEntity)) != null) {
                    this.getBroker().getMappingComponent().getFeatureCollection().removeFeature((Feature)virtualStandort);
                    this.objectsToDelete.add(virtualStandort);
                } else {
                    LOG.warn((Object)"No virtual standort found for leuchte");
                }
            } else {
                this.objectsToDelete.add((WorkbenchEntity)entity);
            }
            try {
                this.treeTableModel.removeNodeFromParent((MutableTreeTableNode)nodeToRemove);
            }
            catch (Exception ex) {
                LOG.warn((Object)"could not remove node from parent", (Throwable)ex);
            }
            if (workbenchEntity instanceof WorkbenchFeatureEntity && ((WorkbenchFeatureEntity)entity).getGeometrie() != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Entity has a geometry. Removing geometry from map");
                }
                this.getBroker().getMappingComponent().getFeatureCollection().removeFeature((Feature)((WorkbenchFeatureEntity)entity));
            } else if (workbenchEntity instanceof ArbeitsprotokollCustomBean && ((ArbeitsprotokollCustomBean)entity).getChildEntity().getGeometrie() != null) {
                this.getBroker().getMappingComponent().getFeatureCollection().removeFeature((Feature)((ArbeitsprotokollCustomBean)entity).getChildEntity());
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Can't remove object from Tree, because there is no path to the node.");
        }
    }

    public Collection getCurrentSearchResults() {
        return this.currentSearchResults;
    }

    public void setCurrentSearchResults(Collection currentSearchResults) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"setSearchResults");
        }
        this.currentSearchResults = currentSearchResults;
        this.refreshSearchObjects();
    }

    public Set<WorkbenchEntity> getObjectsToPersist() {
        return this.objectsToPersist;
    }

    public void setObjectsToPersist(Set objectsToPersist) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"setObjectsToPersist");
        }
        this.objectsToPersist = objectsToPersist;
    }

    public Collection<WorkbenchEntity> getObjectsToDelete() {
        return this.objectsToDelete;
    }

    public void clearNewNode() {
        this.treeTableModel.removeAllChildrenFromNode(this.newObjectsNode, true);
        this.objectsToPersist.clear();
        this.leuchteToVirtualStandortMap.clear();
    }

    public void clearEditNode() {
        this.treeTableModel.removeAllChildrenFromNode(this.editObjectsNode, true);
        this.objectsToPersist.clear();
        this.leuchteToVirtualStandortMap.clear();
    }

    public void addNewEntity(WorkbenchEntity entity) {
        boolean allowed;
        boolean isBasic = entity instanceof AbzweigdoseCustomBean || entity instanceof MauerlascheCustomBean || entity instanceof LeitungCustomBean || entity instanceof SchaltstelleCustomBean || entity instanceof TdtaLeuchtenCustomBean || entity instanceof TdtaStandortMastCustomBean;
        boolean isVeranlassung = entity instanceof VeranlassungCustomBean;
        boolean isArbeitsauftrag = entity instanceof ArbeitsauftragCustomBean;
        boolean bl = allowed = isBasic && this.basicCreateEnabled || isVeranlassung && this.veranlassungCreateEnabled || isArbeitsauftrag && this.arbeitsauftragCreateEnabled;
        if (allowed) {
            CustomMutableTreeTableNode entityNode = new CustomMutableTreeTableNode(entity, true);
            this.objectsToPersist.add((WorkbenchEntity)entityNode.getUserObject());
            this.treeTableModel.insertNodeIntoAsLastChild((MutableTreeTableNode)entityNode, (MutableTreeTableNode)this.newObjectsNode);
            this.selectUserObjects(Arrays.asList(entity));
        } else {
            LOG.info((Object)"keine Rechte diese Objekt zu erzeugen");
        }
    }

    public void addNewLeuchte() {
        if (CidsBroker.getInstance().checkForCreateBasic()) {
            TdtaStandortMastCustomBean newStandort = TdtaStandortMastCustomBean.createNew();
            newStandort.addPropertyChangeListener(this);
            newStandort.setVirtuellerStandort(true);
            newStandort.setVerrechnungseinheit(true);
            this.objectsToPersist.add(newStandort);
            this.addNewLeuchte(newStandort);
        } else {
            LOG.info((Object)"keine Rechte diese Objekt zu erzeugen");
        }
    }

    public void addNewLeuchte(Object relatedObject) {
        if (CidsBroker.getInstance().checkForCreateBasic()) {
            CustomMutableTreeTableNode nodeToAddLeuchte = null;
            TdtaStandortMastCustomBean parent = null;
            try {
                TreePath pathToRelatedObejct = this.treeTableModel.getPathForUserObject(relatedObject);
                if (pathToRelatedObejct != null && pathToRelatedObejct.getLastPathComponent() != null && pathToRelatedObejct.getLastPathComponent() instanceof CustomMutableTreeTableNode && ((CustomMutableTreeTableNode)((Object)pathToRelatedObejct.getLastPathComponent())).getUserObject() instanceof TdtaLeuchtenCustomBean && pathToRelatedObejct.getParentPath() != null && pathToRelatedObejct.getParentPath().getLastPathComponent() instanceof CustomMutableTreeTableNode && ((CustomMutableTreeTableNode)((Object)pathToRelatedObejct.getParentPath().getLastPathComponent())).getUserObject() instanceof TdtaStandortMastCustomBean) {
                    parent = (TdtaStandortMastCustomBean)((CustomMutableTreeTableNode)((Object)pathToRelatedObejct.getParentPath().getLastPathComponent())).getUserObject();
                    nodeToAddLeuchte = (CustomMutableTreeTableNode)((Object)pathToRelatedObejct.getParentPath().getLastPathComponent());
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Related object is Leuchte (sibling)");
                    }
                } else if (pathToRelatedObejct != null && pathToRelatedObejct.getLastPathComponent() != null && pathToRelatedObejct.getLastPathComponent() instanceof CustomMutableTreeTableNode && ((CustomMutableTreeTableNode)((Object)pathToRelatedObejct.getLastPathComponent())).getUserObject() instanceof TdtaStandortMastCustomBean) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Related object is Standort (parent)");
                    }
                    parent = (TdtaStandortMastCustomBean)((CustomMutableTreeTableNode)((Object)pathToRelatedObejct.getLastPathComponent())).getUserObject();
                    nodeToAddLeuchte = (CustomMutableTreeTableNode)((Object)pathToRelatedObejct.getLastPathComponent());
                } else if (pathToRelatedObejct == null && relatedObject != null && relatedObject instanceof TdtaStandortMastCustomBean && ((TdtaStandortMastCustomBean)relatedObject).isVirtuellerStandort() != null && ((TdtaStandortMastCustomBean)relatedObject).isVirtuellerStandort().booleanValue() || !((TdtaStandortMastCustomBean)relatedObject).isStandortMast()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Leuchte has virtual standort will be added directly to tree");
                    }
                    nodeToAddLeuchte = this.newObjectsNode;
                    parent = (TdtaStandortMastCustomBean)relatedObject;
                } else {
                    LOG.warn((Object)"Can't add Leuchte relatedObject is neither Leuchte nor Standort.");
                }
            }
            catch (Exception ex) {
                LOG.error((Object)"Error while trying to get node for related object", (Throwable)ex);
            }
            if (nodeToAddLeuchte == null || parent == null) {
                LOG.warn((Object)"Can't add Leuchte no node or standort found. Returning.");
                return;
            }
            TdtaLeuchtenCustomBean newLeuchte = TdtaLeuchtenCustomBean.createNew();
            if (BelisBroker.getDefaultUnterhaltLeuchte() != null) {
                newLeuchte.setUnterhaltspflichtLeuchte(BelisBroker.getDefaultUnterhaltLeuchte());
            }
            if (BelisBroker.getDefaultDoppelkommando1() != null) {
                newLeuchte.setDk1(BelisBroker.getDefaultDoppelkommando1());
            }
            newLeuchte.addPropertyChangeListener(this);
            newLeuchte.addPropertyChangeListener(this.getBroker());
            if (!parent.isStandortMast()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Adding propterychange listener for virtual standort");
                }
                newLeuchte.addPropertyChangeListener((PropertyChangeListener)((Object)parent));
                this.leuchteToVirtualStandortMap.put(newLeuchte, parent);
                newLeuchte.setLeuchtennummer(0);
            } else {
                parent.addPropertyChangeListener((PropertyChangeListener)((Object)newLeuchte));
                newLeuchte.setLeuchtennummer(this.getNextLeuchtennummer(parent));
            }
            parent.getLeuchten().add(newLeuchte);
            newLeuchte.setFk_strassenschluessel(parent.getStrassenschluessel());
            newLeuchte.setKennziffer(parent.getKennziffer());
            newLeuchte.setLaufendeNummer(parent.getLaufendeNummer());
            CustomMutableTreeTableNode newLeuchteNode = new CustomMutableTreeTableNode(newLeuchte, false);
            if (parent.getGeometry() != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"standort has geometry. Reconsidering feature because the icon must be switched from standort without leuchte to standort with leuchte.");
                }
                this.getBroker().getMappingComponent().getFeatureCollection().removeFeature((Feature)parent);
                this.getBroker().getMappingComponent().getFeatureCollection().addFeature((Feature)parent);
            }
            this.treeTableModel.insertNodeIntoAsLastChild((MutableTreeTableNode)newLeuchteNode, (MutableTreeTableNode)nodeToAddLeuchte);
            this.selectUserObjects(Arrays.asList(newLeuchte));
        } else {
            LOG.info((Object)"keine Rechte diese Objekt zu erzeugen");
        }
    }

    public Integer getNextLeuchtennummer(TdtaStandortMastCustomBean standort) {
        if (standort != null && standort.getLeuchten() != null && standort.getLeuchten().size() > 0) {
            Integer max = 0;
            for (TdtaLeuchtenCustomBean curLeuchte : standort.getLeuchten()) {
                if (curLeuchte.getLeuchtennummer() == null || curLeuchte.getLeuchtennummer() <= max) continue;
                max = curLeuchte.getLeuchtennummer();
            }
            return max + 1;
        }
        return 0;
    }

    public void addNewGeometrie() {
        if (CidsBroker.getInstance().checkForEditVeranlassung()) {
            Object tmpObject = ((CustomMutableTreeTableNode)((Object)this.getSelectedTreeNode().getLastPathComponent())).getUserObject();
            if (tmpObject instanceof VeranlassungCustomBean || tmpObject instanceof ArbeitsauftragCustomBean) {
                GeometrieCustomBean newGeometrie = GeometrieCustomBean.createNew();
                newGeometrie.addPropertyChangeListener(this.getBroker());
                newGeometrie.addPropertyChangeListener(this);
                if (tmpObject instanceof VeranlassungCustomBean) {
                    CustomMutableTreeTableNode newGeometrieNode = new CustomMutableTreeTableNode(newGeometrie, true);
                    VeranlassungCustomBean selVeranlassung = (VeranlassungCustomBean)tmpObject;
                    selVeranlassung.getAr_geometrien().add(newGeometrie);
                    this.treeTableModel.insertNodeIntoAsLastChild((MutableTreeTableNode)newGeometrieNode, (MutableTreeTableNode)((CustomMutableTreeTableNode)((Object)this.getSelectedTreeNode().getLastPathComponent())));
                    this.selectUserObjects(Arrays.asList(newGeometrie));
                } else if (tmpObject instanceof ArbeitsauftragCustomBean) {
                    ArbeitsprotokollCustomBean newProtokoll = ArbeitsprotokollCustomBean.createNew();
                    CustomMutableTreeTableNode newProtokollNode = new CustomMutableTreeTableNode(newProtokoll, true);
                    CustomMutableTreeTableNode newGeometrieNode = new CustomMutableTreeTableNode(newGeometrie, true);
                    ArbeitsauftragCustomBean selAuftrag = (ArbeitsauftragCustomBean)tmpObject;
                    newProtokoll.setProtokollnummer(selAuftrag.getAr_protokolle().size() + 1);
                    newProtokoll.setFk_geometrie(newGeometrie);
                    selAuftrag.getAr_protokolle().add(newProtokoll);
                    this.treeTableModel.insertNodeIntoAsLastChild((MutableTreeTableNode)newProtokollNode, (MutableTreeTableNode)((CustomMutableTreeTableNode)((Object)this.getSelectedTreeNode().getLastPathComponent())));
                    this.treeTableModel.insertNodeIntoAsLastChild((MutableTreeTableNode)newGeometrieNode, (MutableTreeTableNode)newProtokollNode);
                    this.selectUserObjects(Arrays.asList(newProtokoll));
                }
            }
        } else {
            LOG.info((Object)"keine Rechte diese Objekt zu erzeugen");
        }
    }

    public void stateChanged(ChangeEvent e) {
    }

    public TdtaStandortMastCustomBean getVirtualStandortForLeuchte(TdtaLeuchtenCustomBean leuchte) {
        return this.leuchteToVirtualStandortMap.get(leuchte);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"property of userobject changed refreshing table");
        }
        this.jttHitTable.repaint();
    }

    public void allFeaturesRemoved(FeatureCollectionEvent fce) {
    }

    public void featureCollectionChanged() {
    }

    public void featureReconsiderationRequested(FeatureCollectionEvent fce) {
    }

    public void featureSelectionChanged(FeatureCollectionEvent fce) {
    }

    public void featuresAdded(FeatureCollectionEvent fce) {
    }

    public void featuresChanged(FeatureCollectionEvent fce) {
    }

    public void featuresRemoved(FeatureCollectionEvent fce) {
    }

    public Set getSearchResults() {
        return this.searchResults;
    }

    public void setSearchResults(Set searchResult) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Search Results set");
        }
        this.searchResults = searchResult;
        this.firePropertyChange(PROP_SEARCH_RESULTS, null, searchResult);
    }

    class CreateNewBelisObjectListener
    extends CreateGeometryListener {
        public CreateNewBelisObjectListener(MappingComponent mc, Class geometryFeatureClass) {
            super(mc, geometryFeatureClass);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finishGeometry(AbstractNewFeature newFeature) {
            if (EventQueue.isDispatchThread()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"is in EDT");
                }
            } else {
                LOG.fatal((Object)"is not in edt");
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Pure new feature created for attachement: " + newFeature));
            }
            super.finishGeometry(newFeature);
            if (newFeature != null && newFeature instanceof PureNewFeature && WorkbenchWidget.this.checkConstraintForMapModeSwitch()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"all prequisites fulfied for adding newly created geometry");
                }
                try {
                    WorkbenchWidget.this.getBroker().addFeatureSelectionChangeIgnore(WorkbenchWidget.this);
                    WorkbenchWidget.this.ignoreFeatureSelection = true;
                    Object tmpObject = ((CustomMutableTreeTableNode)((Object)WorkbenchWidget.this.getSelectedTreeNode().getLastPathComponent())).getUserObject();
                    StyledFeature currentSelectedFeature = null;
                    if (tmpObject instanceof StyledFeature) {
                        currentSelectedFeature = (StyledFeature)tmpObject;
                    } else if (tmpObject instanceof TdtaLeuchtenCustomBean && (currentSelectedFeature = (StyledFeature)WorkbenchWidget.this.leuchteToVirtualStandortMap.get((TdtaLeuchtenCustomBean)tmpObject)) == null) {
                        LOG.warn((Object)"Leuchte has no virtual standort.");
                    }
                    currentSelectedFeature.setGeometry(newFeature.getGeometry());
                    WorkbenchWidget.this.getBroker().getMappingComponent().getFeatureCollection().addFeature((Feature)currentSelectedFeature);
                    currentSelectedFeature.setEditable(true);
                    WorkbenchWidget.this.btnAttachMode.setEnabled(false);
                    WorkbenchWidget.this.getBroker().getMapWidget().setToLastInteractionMode();
                    WorkbenchWidget.this.getBroker().getMappingComponent().getFeatureCollection().select((Feature)currentSelectedFeature);
                }
                finally {
                    WorkbenchWidget.this.getBroker().removeFeatureSelectionChangeIgnore(WorkbenchWidget.this);
                    WorkbenchWidget.this.ignoreFeatureSelection = false;
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Not all prequisites fulfied for adding newly created geometry");
            }
        }
    }
}

