/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.belis.gui.widget.detailWidgetPanels;

import de.cismet.belis.broker.BelisBroker;
import de.cismet.cids.custom.beans.belis2.TdtaStandortMastCustomBean;
import de.cismet.commons.server.entity.BaseEntity;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.log4j.Logger;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.BindingListener;
import org.jdesktop.beansbinding.PropertyStateEvent;

public abstract class AbstractDetailWidgetPanel<T extends BaseEntity>
extends JPanel {
    private static final Logger LOG = Logger.getLogger(AbstractDetailWidgetPanel.class);
    public static final String PROP_CURRENT_ENTITY = "currentEntity";
    protected static final Dimension DIMENSION_KEYSPACER = new Dimension(150, 1);
    protected static final Dimension DIMENSION_CONTENTSPACER = new Dimension(580, 1);
    public final String PANEL_CARD_NAME;
    protected T currentEntity = null;
    boolean isTriggerd = false;
    final HashMap<JComponent, JComponent> componentToLabelMap = new HashMap();
    private String validationMessage;
    private boolean editable = true;

    public AbstractDetailWidgetPanel(String panelCardName) {
        this.PANEL_CARD_NAME = panelCardName;
    }

    public abstract JLabel getTabLabel();

    abstract void initPanel();

    abstract void initComponentToLabelMap();

    public abstract void setElementsNull();

    public abstract void setPanelEditable(boolean var1);

    public T getCurrentEntity() {
        return this.currentEntity;
    }

    protected void setValidationMessage(String validationMessage) {
        this.validationMessage = validationMessage;
    }

    public void setCurrentEntity(T currentEntity) {
        T oldCurrentEntity = this.currentEntity;
        if (oldCurrentEntity != currentEntity) {
            if (this.getBindingGroup() != null) {
                this.getBindingGroup().unbind();
            }
            this.currentEntity = currentEntity;
            if (this.getBindingGroup() != null) {
                this.getBindingGroup().bind();
            }
            try {
                this.firePropertyChange(PROP_CURRENT_ENTITY, oldCurrentEntity, currentEntity);
            }
            catch (Exception ex) {
                LOG.error((Object)ex, (Throwable)ex);
            }
        }
    }

    protected abstract void commitEdits();

    protected abstract BindingGroup getBindingGroup();

    public int getStatus() {
        if (this.getBindingGroup() != null) {
            this.commitEdits();
            for (Binding curBinding : this.getBindingGroup().getBindings()) {
                Binding.ValueResult result;
                if (!this.isAncestorOf((Component)curBinding.getTargetObject())) continue;
                boolean err = false;
                String errMessage = null;
                try {
                    result = curBinding.getTargetValueForSource();
                }
                catch (Exception ex) {
                    LOG.error((Object)ex, (Throwable)ex);
                    err = true;
                    result = null;
                    errMessage = ex.getMessage();
                }
                if (err) {
                    LOG.info((Object)("Validation of property " + curBinding.getSourceProperty() + "has failed: " + result));
                    LOG.info((Object)("Description: " + errMessage));
                    this.setValidationMessage(errMessage);
                    return 2;
                }
                if (result != null && result.failed() && result.getFailure().getType() == Binding.SyncFailureType.VALIDATION_FAILED) {
                    LOG.info((Object)("Validation of property " + curBinding.getSourceProperty() + "has failed: " + result));
                    LOG.info((Object)("Description: " + result.getFailure().getValidationResult().getDescription()));
                    this.setValidationMessage(result.getFailure().getValidationResult().getDescription());
                    return 2;
                }
                LOG.info((Object)("Validation of property " + curBinding.getSourceProperty() + "is valid: " + result));
                try {
                    LOG.info((Object)("Check has failure: " + result.failed()));
                    if (result.failed()) {
                        LOG.info((Object)("failure " + result.getFailure()));
                        LOG.info((Object)("manual check: " + curBinding.getValidator().validate(curBinding.getTargetProperty().getValue(curBinding.getTargetObject()))));
                        continue;
                    }
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)("value: " + result.getValue()));
                }
                catch (Exception ex) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)"manual check failed");
                }
            }
        }
        this.setValidationMessage("");
        return 0;
    }

    public String getValidationMessage() {
        return this.validationMessage;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    class PanelBindingListener
    implements BindingListener {
        private Collection<Binding> validationState = new HashSet<Binding>();

        PanelBindingListener() {
        }

        public void bindingBecameBound(Binding binding) {
        }

        public void bindingBecameUnbound(Binding binding) {
        }

        public void syncWarning(Binding binding, Binding.SyncFailure failure) {
        }

        public void syncFailed(Binding binding, Binding.SyncFailure failure) {
            Object target = binding.getTargetObject();
            if (target instanceof JComponent) {
                JComponent c = (JComponent)target;
                JComponent associatedLabel = AbstractDetailWidgetPanel.this.componentToLabelMap.get(c);
                if (associatedLabel != null) {
                    associatedLabel.setForeground(Color.red);
                } else {
                    c.setForeground(Color.red);
                }
                try {
                    if (associatedLabel != null) {
                        associatedLabel.setToolTipText(failure.getValidationResult().getDescription());
                    }
                    c.setToolTipText(failure.getValidationResult().getDescription());
                }
                catch (Exception ex) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Error while setting tooltip", (Throwable)ex);
                    }
                    c.setToolTipText(null);
                }
            } else {
                LOG.error((Object)"keine JCOmponent");
            }
            if (AbstractDetailWidgetPanel.this.currentEntity instanceof TdtaStandortMastCustomBean && BelisBroker.getInstance().getDetailWidget().getStandortPanel().isAncestorOf((Component)binding.getTargetObject())) {
                this.validationState.add(binding);
            }
        }

        public void synced(Binding binding) {
            Object target = binding.getTargetObject();
            if (target instanceof JComponent) {
                JComponent c = (JComponent)target;
                JComponent associatedLabel = AbstractDetailWidgetPanel.this.componentToLabelMap.get(c);
                if (associatedLabel != null) {
                    associatedLabel.setForeground(Color.black);
                } else {
                    c.setForeground(Color.black);
                }
                c.setToolTipText(null);
            } else {
                LOG.error((Object)"keine JCOmponent");
            }
            if (AbstractDetailWidgetPanel.this.currentEntity instanceof TdtaStandortMastCustomBean && BelisBroker.getInstance().getDetailWidget().getStandortPanel().isAncestorOf((Component)binding.getTargetObject())) {
                this.validationState.remove(binding);
            }
        }

        public void sourceChanged(Binding binding, PropertyStateEvent event) {
        }

        public void targetChanged(Binding binding, PropertyStateEvent event) {
        }
    }
}

