/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.belis.panels;

import de.cismet.belis.broker.BelisBroker;
import de.cismet.belis.broker.EntityClipboard;
import de.cismet.belis.broker.EntityClipboardListener;
import de.cismet.commons.architecture.interfaces.Editable;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class CopyPasteToolbar
extends JPanel
implements Editable,
EntityClipboardListener {
    private static final Logger LOG = Logger.getLogger(CopyPasteToolbar.class);
    private BelisBroker broker;
    private EntityClipboard entityClipboard;
    private final EntityClipboardListener cbListener = new EntityClipboardListener(){

        @Override
        public void clipboardChanged() {
            CopyPasteToolbar.this.btnCopy.setEnabled(CopyPasteToolbar.this.entityClipboard.isCopyable());
            CopyPasteToolbar.this.btnPaste.setEnabled(CopyPasteToolbar.this.entityClipboard.isPastable());
        }
    };
    private JButton btnCopy;
    private JButton btnPaste;

    public CopyPasteToolbar(BelisBroker broker) {
        this.broker = broker;
        this.initComponents();
        broker.getEntityClipboard().addListener(this);
    }

    private void initComponents() {
        this.btnCopy = new JButton();
        this.btnPaste = new JButton();
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        this.btnCopy.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/belis/resource/icon/16/copy.png")));
        this.btnCopy.setEnabled(false);
        this.btnCopy.setFocusable(false);
        this.btnCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CopyPasteToolbar.this.btnCopyActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.add((Component)this.btnCopy, gridBagConstraints);
        this.btnPaste.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/belis/resource/icon/16/paste.png")));
        this.btnPaste.setEnabled(false);
        this.btnPaste.setFocusable(false);
        this.btnPaste.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CopyPasteToolbar.this.btnPasteActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.add((Component)this.btnPaste, gridBagConstraints);
    }

    private void btnCopyActionPerformed(ActionEvent evt) {
        block2: {
            try {
                this.broker.getEntityClipboard().copy();
            }
            catch (Exception ex) {
                if (!LOG.isDebugEnabled()) break block2;
                LOG.debug((Object)"Fehler beim Kopieren in die Zwischenablage", (Throwable)ex);
            }
        }
    }

    private void btnPasteActionPerformed(ActionEvent evt) {
        block2: {
            try {
                this.broker.getEntityClipboard().paste();
            }
            catch (Exception ex) {
                if (!LOG.isDebugEnabled()) break block2;
                LOG.debug((Object)"Fehler beim Einf\u00fcgen aus der Zwischenablage", (Throwable)ex);
            }
        }
    }

    public EntityClipboardListener getClipboardListener() {
        return this.cbListener;
    }

    public void setClipboard(EntityClipboard entityClipboard) {
        this.entityClipboard = entityClipboard;
    }

    public void setWidgetEditable(boolean isEditable) {
        if (!isEditable) {
            this.setAllButtonsEnabled(isEditable);
        }
    }

    private void setAllButtonsEnabled(boolean isEnabled) {
        this.btnCopy.setEnabled(isEnabled);
        this.btnPaste.setEnabled(isEnabled);
    }

    @Override
    public final void clipboardChanged() {
        this.btnCopy.setEnabled(this.broker.getEntityClipboard().isCopyable());
        this.btnPaste.setEnabled(this.broker.getEntityClipboard().isPastable());
    }
}

