/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.belis.panels;

import de.cismet.belis.broker.BelisBroker;
import de.cismet.belis.broker.CidsBroker;
import de.cismet.belis.todo.CustomMutableTreeTableNode;
import de.cismet.cids.custom.beans.belis2.AbzweigdoseCustomBean;
import de.cismet.cids.custom.beans.belis2.ArbeitsauftragCustomBean;
import de.cismet.cids.custom.beans.belis2.ArbeitsprotokollCustomBean;
import de.cismet.cids.custom.beans.belis2.GeometrieCustomBean;
import de.cismet.cids.custom.beans.belis2.LeitungCustomBean;
import de.cismet.cids.custom.beans.belis2.MauerlascheCustomBean;
import de.cismet.cids.custom.beans.belis2.SchaltstelleCustomBean;
import de.cismet.cids.custom.beans.belis2.TdtaLeuchtenCustomBean;
import de.cismet.cids.custom.beans.belis2.TdtaStandortMastCustomBean;
import de.cismet.cids.custom.beans.belis2.VeranlassungCustomBean;
import de.cismet.commons.architecture.interfaces.Editable;
import de.cismet.commons.server.entity.BaseEntity;
import de.cismet.commons.server.entity.WorkbenchEntity;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class CreateToolBar
extends JPanel
implements Editable {
    private static final Logger LOG = Logger.getLogger(CreateToolBar.class);
    protected WorkbenchEntity selectedEntity = null;
    private BelisBroker broker;
    private JButton btnNewAbzweigdose;
    private JButton btnNewArbeitsauftrag;
    private JButton btnNewGeometrie;
    private JButton btnNewLeitung;
    private JButton btnNewLeuchte;
    private JButton btnNewMauerlasche;
    private JButton btnNewSchaltstelle;
    private JButton btnNewStandort;
    private JButton btnNewVeranlassung;
    private JButton btnRemove;

    public CreateToolBar(BelisBroker broker) {
        this.broker = broker;
        this.initComponents();
        this.setWidgetEditable(false);
    }

    public void setWidgetEditable(boolean isEditable) {
        this.updateButtons(isEditable);
    }

    public void setSelectedEntity(WorkbenchEntity selectedEntity) {
        this.selectedEntity = selectedEntity;
        this.updateButtons(this.broker.isInEditMode());
    }

    private void updateButtons(boolean isEnabled) {
        boolean isInCreateMode = this.broker.isInCreateMode();
        boolean isInEditMode = this.broker.isInEditMode();
        boolean basicCreateEnabled = CidsBroker.getInstance().checkForCreateBasic();
        boolean basicEditEnabled = CidsBroker.getInstance().checkForEditBasic();
        boolean veranlassungCreateEnabled = CidsBroker.getInstance().checkForCreateVeranlassung();
        boolean veranlassungEditEnabled = CidsBroker.getInstance().checkForEditVeranlassung();
        boolean arbeitsauftragCreateEnabled = CidsBroker.getInstance().checkForCreateArbeitsauftrag();
        boolean arbeitsauftragEditEnabled = CidsBroker.getInstance().checkForEditArbeitsauftrag();
        boolean deleteEnabled = CidsBroker.getInstance().checkForDelete();
        BaseEntity parent = null;
        try {
            parent = (BaseEntity)((Object)((CustomMutableTreeTableNode)((Object)this.broker.getWorkbenchWidget().getSelectedTreeNode().getLastPathComponent())).getParent().getUserObject());
        }
        catch (Exception ex) {
            parent = null;
        }
        boolean isBasic = this.selectedEntity instanceof TdtaStandortMastCustomBean || this.selectedEntity instanceof TdtaLeuchtenCustomBean || this.selectedEntity instanceof MauerlascheCustomBean || this.selectedEntity instanceof SchaltstelleCustomBean || this.selectedEntity instanceof LeitungCustomBean || this.selectedEntity instanceof AbzweigdoseCustomBean;
        boolean isVeranlassung = this.selectedEntity instanceof VeranlassungCustomBean;
        boolean isGeometrie = this.selectedEntity instanceof GeometrieCustomBean;
        boolean isArbeitsprotokoll = this.selectedEntity instanceof ArbeitsprotokollCustomBean;
        boolean isArbeitsauftrag = this.selectedEntity instanceof ArbeitsauftragCustomBean;
        boolean isLeuchte = this.selectedEntity instanceof TdtaLeuchtenCustomBean;
        boolean isMastOrLeuchteFromMast = this.selectedEntity instanceof TdtaStandortMastCustomBean || this.selectedEntity instanceof TdtaLeuchtenCustomBean && this.broker.getWorkbenchWidget().isParentNodeMast(this.broker.getWorkbenchWidget().getSelectedTreeNode().getLastPathComponent());
        boolean isParentProtokoll = parent instanceof ArbeitsprotokollCustomBean;
        boolean isParentVeranlassung = parent instanceof VeranlassungCustomBean;
        this.btnNewLeitung.setEnabled(isEnabled && isInCreateMode && basicCreateEnabled);
        this.btnNewMauerlasche.setEnabled(isEnabled && isInCreateMode && basicCreateEnabled);
        this.btnNewSchaltstelle.setEnabled(isEnabled && isInCreateMode && basicCreateEnabled);
        this.btnNewStandort.setEnabled(isEnabled && isInCreateMode && basicCreateEnabled);
        this.btnNewAbzweigdose.setEnabled(isEnabled && isInCreateMode && basicCreateEnabled);
        this.btnNewVeranlassung.setEnabled(isEnabled && isInCreateMode && veranlassungCreateEnabled);
        this.btnNewArbeitsauftrag.setEnabled(isEnabled && isInCreateMode && arbeitsauftragCreateEnabled);
        if (isInCreateMode) {
            this.btnNewLeuchte.setEnabled(isEnabled && isMastOrLeuchteFromMast && basicCreateEnabled);
            this.btnNewGeometrie.setEnabled(isEnabled && isVeranlassung && veranlassungCreateEnabled);
            this.btnRemove.setEnabled(isEnabled && this.selectedEntity instanceof BaseEntity && !isParentProtokoll);
        } else {
            this.btnNewLeuchte.setEnabled(isEnabled && parent == null && isMastOrLeuchteFromMast && basicCreateEnabled);
            this.btnNewGeometrie.setEnabled(isEnabled && isVeranlassung && veranlassungEditEnabled);
            this.btnRemove.setEnabled(isEnabled && (isBasic && !isParentProtokoll && (parent == null || parent instanceof TdtaStandortMastCustomBean) && basicEditEnabled || isVeranlassung && veranlassungCreateEnabled || isArbeitsauftrag && arbeitsauftragCreateEnabled || isParentVeranlassung && veranlassungEditEnabled || isArbeitsprotokoll && arbeitsauftragEditEnabled || isGeometrie && veranlassungEditEnabled) && deleteEnabled);
        }
        this.repaint();
    }

    private void initComponents() {
        this.btnNewStandort = new JButton();
        this.btnNewLeuchte = new JButton();
        this.btnNewSchaltstelle = new JButton();
        this.btnNewMauerlasche = new JButton();
        this.btnNewLeitung = new JButton();
        this.btnNewAbzweigdose = new JButton();
        this.btnNewGeometrie = new JButton();
        this.btnNewVeranlassung = new JButton();
        this.btnNewArbeitsauftrag = new JButton();
        this.btnRemove = new JButton();
        this.setFocusable(false);
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        this.btnNewStandort.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/belis/resource/icon/22/standort.png")));
        this.btnNewStandort.setToolTipText("Neuer Mast hinzuf\u00fcgen");
        this.btnNewStandort.setBorder(null);
        this.btnNewStandort.setBorderPainted(false);
        this.btnNewStandort.setFocusPainted(false);
        this.btnNewStandort.setMargin(new Insets(0, 5, 0, 5));
        this.btnNewStandort.setMaximumSize(new Dimension(23, 23));
        this.btnNewStandort.setMinimumSize(new Dimension(23, 23));
        this.btnNewStandort.setPreferredSize(new Dimension(23, 23));
        this.btnNewStandort.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CreateToolBar.this.btnNewStandortActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 2, 0, 1);
        this.add((Component)this.btnNewStandort, gridBagConstraints);
        this.btnNewLeuchte.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/belis/resource/icon/22/leuchte.png")));
        this.btnNewLeuchte.setToolTipText("Neue Leuchte hinzuf\u00fcgen");
        this.btnNewLeuchte.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.btnNewLeuchte.setBorderPainted(false);
        this.btnNewLeuchte.setFocusPainted(false);
        this.btnNewLeuchte.setMaximumSize(new Dimension(23, 23));
        this.btnNewLeuchte.setMinimumSize(new Dimension(23, 23));
        this.btnNewLeuchte.setPreferredSize(new Dimension(23, 23));
        this.btnNewLeuchte.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CreateToolBar.this.btnNewLeuchteActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 1, 0, 1);
        this.add((Component)this.btnNewLeuchte, gridBagConstraints);
        this.btnNewSchaltstelle.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/belis/resource/icon/22/schaltstelle.png")));
        this.btnNewSchaltstelle.setToolTipText("Neue Schaltstelle hinzuf\u00fcgen");
        this.btnNewSchaltstelle.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.btnNewSchaltstelle.setBorderPainted(false);
        this.btnNewSchaltstelle.setFocusPainted(false);
        this.btnNewSchaltstelle.setMaximumSize(new Dimension(23, 23));
        this.btnNewSchaltstelle.setMinimumSize(new Dimension(23, 23));
        this.btnNewSchaltstelle.setPreferredSize(new Dimension(23, 23));
        this.btnNewSchaltstelle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CreateToolBar.this.btnNewSchaltstelleActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 1, 0, 1);
        this.add((Component)this.btnNewSchaltstelle, gridBagConstraints);
        this.btnNewMauerlasche.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/belis/resource/icon/22/mauerlasche.png")));
        this.btnNewMauerlasche.setToolTipText("Neue Mauerlasche hinzuf\u00fcgen");
        this.btnNewMauerlasche.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.btnNewMauerlasche.setBorderPainted(false);
        this.btnNewMauerlasche.setFocusPainted(false);
        this.btnNewMauerlasche.setMaximumSize(new Dimension(23, 23));
        this.btnNewMauerlasche.setMinimumSize(new Dimension(23, 23));
        this.btnNewMauerlasche.setPreferredSize(new Dimension(23, 23));
        this.btnNewMauerlasche.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CreateToolBar.this.btnNewMauerlascheActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 1, 0, 1);
        this.add((Component)this.btnNewMauerlasche, gridBagConstraints);
        this.btnNewLeitung.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/belis/resource/icon/22/leitung.png")));
        this.btnNewLeitung.setToolTipText("Neue Leitung hinzuf\u00fcgen");
        this.btnNewLeitung.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.btnNewLeitung.setBorderPainted(false);
        this.btnNewLeitung.setFocusPainted(false);
        this.btnNewLeitung.setMaximumSize(new Dimension(23, 23));
        this.btnNewLeitung.setMinimumSize(new Dimension(23, 23));
        this.btnNewLeitung.setPreferredSize(new Dimension(23, 23));
        this.btnNewLeitung.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CreateToolBar.this.btnNewLeitungActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 1, 0, 1);
        this.add((Component)this.btnNewLeitung, gridBagConstraints);
        this.btnNewAbzweigdose.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/belis/resource/icon/22/abzweigdose.png")));
        this.btnNewAbzweigdose.setToolTipText("Neue Abzweigdose/Zugkasten hinzuf\u00fcgen");
        this.btnNewAbzweigdose.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.btnNewAbzweigdose.setBorderPainted(false);
        this.btnNewAbzweigdose.setFocusPainted(false);
        this.btnNewAbzweigdose.setMaximumSize(new Dimension(23, 23));
        this.btnNewAbzweigdose.setMinimumSize(new Dimension(23, 23));
        this.btnNewAbzweigdose.setPreferredSize(new Dimension(23, 23));
        this.btnNewAbzweigdose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CreateToolBar.this.btnNewAbzweigdoseActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 1, 0, 1);
        this.add((Component)this.btnNewAbzweigdose, gridBagConstraints);
        this.btnNewGeometrie.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/belis/resource/icon/22/newPolygonMode.png")));
        this.btnNewGeometrie.setToolTipText("Neue Geometrie hinzuf\u00fcgen");
        this.btnNewGeometrie.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.btnNewGeometrie.setBorderPainted(false);
        this.btnNewGeometrie.setFocusPainted(false);
        this.btnNewGeometrie.setMaximumSize(new Dimension(23, 23));
        this.btnNewGeometrie.setMinimumSize(new Dimension(23, 23));
        this.btnNewGeometrie.setPreferredSize(new Dimension(23, 23));
        this.btnNewGeometrie.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CreateToolBar.this.btnNewGeometrieActionPerformed(evt);
            }
        });
        this.add((Component)this.btnNewGeometrie, new GridBagConstraints());
        this.btnNewVeranlassung.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/belis/resource/icon/22/veranlassung.png")));
        this.btnNewVeranlassung.setToolTipText("Neue Veranlassung hinzuf\u00fcgen");
        this.btnNewVeranlassung.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.btnNewVeranlassung.setBorderPainted(false);
        this.btnNewVeranlassung.setFocusPainted(false);
        this.btnNewVeranlassung.setMaximumSize(new Dimension(23, 23));
        this.btnNewVeranlassung.setMinimumSize(new Dimension(23, 23));
        this.btnNewVeranlassung.setPreferredSize(new Dimension(23, 23));
        this.btnNewVeranlassung.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CreateToolBar.this.btnNewVeranlassungActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 1, 0, 1);
        this.add((Component)this.btnNewVeranlassung, gridBagConstraints);
        this.btnNewArbeitsauftrag.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/belis/resource/icon/22/arbeitsauftrag.png")));
        this.btnNewArbeitsauftrag.setToolTipText("Neuen Arbeitsauftrag hinzuf\u00fcgen");
        this.btnNewArbeitsauftrag.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.btnNewArbeitsauftrag.setBorderPainted(false);
        this.btnNewArbeitsauftrag.setFocusPainted(false);
        this.btnNewArbeitsauftrag.setMaximumSize(new Dimension(23, 23));
        this.btnNewArbeitsauftrag.setMinimumSize(new Dimension(23, 23));
        this.btnNewArbeitsauftrag.setPreferredSize(new Dimension(23, 23));
        this.btnNewArbeitsauftrag.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CreateToolBar.this.btnNewArbeitsauftragActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 1, 0, 1);
        this.add((Component)this.btnNewArbeitsauftrag, gridBagConstraints);
        this.btnRemove.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/belis/resource/icon/22/trash.png")));
        this.btnRemove.setToolTipText("Ausgew\u00e4hltes Objekt entfernen");
        this.btnRemove.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.btnRemove.setBorderPainted(false);
        this.btnRemove.setEnabled(false);
        this.btnRemove.setFocusPainted(false);
        this.btnRemove.setMaximumSize(new Dimension(23, 23));
        this.btnRemove.setMinimumSize(new Dimension(23, 23));
        this.btnRemove.setPreferredSize(new Dimension(23, 23));
        this.btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CreateToolBar.this.btnRemoveActionPerformed(evt);
            }
        });
        this.add((Component)this.btnRemove, new GridBagConstraints());
    }

    private void btnNewStandortActionPerformed(ActionEvent evt) {
        if (!this.checkIfCreationPossible()) {
            return;
        }
        this.broker.addNewStandort();
    }

    private void btnNewLeuchteActionPerformed(ActionEvent evt) {
        if (!this.checkIfCreationPossible()) {
            return;
        }
        if (this.selectedEntity == null || this.selectedEntity instanceof TdtaLeuchtenCustomBean && this.broker.getWorkbenchWidget().isNodeHaengeLeuchte(this.broker.getWorkbenchWidget().getSelectedTreeNode().getLastPathComponent()) || !(this.selectedEntity instanceof TdtaStandortMastCustomBean) && !(this.selectedEntity instanceof TdtaLeuchtenCustomBean)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Leuchte will be created without Mast");
            }
            this.broker.addNewLeuchte();
        } else if (this.selectedEntity instanceof TdtaStandortMastCustomBean && ((TdtaStandortMastCustomBean)this.selectedEntity).isStandortMast() || this.selectedEntity instanceof TdtaLeuchtenCustomBean) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Leuchte will be appended to Standort");
            }
            this.broker.addNewLeuchte(this.selectedEntity);
        } else {
            LOG.warn((Object)("Creation of Leuchte not possible selected object must either be of Standort or Leuchte or non entity: " + this.selectedEntity));
        }
    }

    private void btnNewSchaltstelleActionPerformed(ActionEvent evt) {
        if (!this.checkIfCreationPossible()) {
            return;
        }
        this.broker.addNewSchaltstelle();
    }

    private void btnNewMauerlascheActionPerformed(ActionEvent evt) {
        if (!this.checkIfCreationPossible()) {
            return;
        }
        this.broker.addNewMauerlasche();
    }

    private void btnNewLeitungActionPerformed(ActionEvent evt) {
        if (!this.checkIfCreationPossible()) {
            return;
        }
        this.broker.addNewLeitung();
    }

    private void btnRemoveActionPerformed(ActionEvent evt) {
        if (!this.checkIfCreationPossible()) {
            return;
        }
        this.broker.removeSelectedEntity();
    }

    private void btnNewAbzweigdoseActionPerformed(ActionEvent evt) {
        if (!this.checkIfCreationPossible()) {
            return;
        }
        this.broker.addNewAbzweigdose();
    }

    private void btnNewVeranlassungActionPerformed(ActionEvent evt) {
        if (!this.checkIfCreationPossible()) {
            return;
        }
        this.broker.addNewVeranlassung();
        this.broker.setFilterVeranlassung(true);
    }

    private void btnNewArbeitsauftragActionPerformed(ActionEvent evt) {
        if (!this.checkIfCreationPossible()) {
            return;
        }
        this.broker.addNewArbeitsauftrag();
        this.broker.setFilterArbeitsauftrag(true);
    }

    private void btnNewGeometrieActionPerformed(ActionEvent evt) {
        if (!this.checkIfCreationPossible()) {
            return;
        }
        this.broker.addNewGeometrie();
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean checkIfCreationPossible() {
        int anwser;
        if (this.broker.validateWidgets()) {
            if (!LOG.isDebugEnabled()) return true;
            LOG.debug((Object)"creationCheck: No problem all Widgets are valid.");
            return true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"creationCheck: One or more widgets are invalid. Informing user.");
        }
        if ((anwser = this.broker.askUser()) == 0) {
            if (!LOG.isDebugEnabled()) return true;
            LOG.debug((Object)"creationCheck: User wants to cancel changes and create new Objekt.");
            return true;
        }
        if (!LOG.isDebugEnabled()) return false;
        LOG.debug((Object)"creationCheck: User wants to correct validation, not creating new objekt.");
        return false;
    }
}

