/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.belis.panels;

import de.cismet.belis.broker.BelisBroker;
import de.cismet.belis.broker.CidsBroker;
import de.cismet.belis.util.BelisIcons;
import de.cismet.tools.CurrentStackTrace;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.apache.log4j.Logger;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class EditButtonsToolbar
extends JPanel {
    private static final Logger LOG = Logger.getLogger(EditButtonsToolbar.class);
    BelisBroker broker = BelisBroker.getInstance();
    private JButton btnAcceptChanges;
    private JButton btnDiscardChanges;
    private JButton btnSwitchInCreateMode;
    private JButton btnSwitchInEditmode;

    public EditButtonsToolbar() {
        this.initComponents();
        this.btnSwitchInEditmode.setIcon(BelisIcons.icoEdit22);
        this.enableSwitchToModeButtons(true);
    }

    private void initComponents() {
        this.btnSwitchInEditmode = new JButton();
        this.btnSwitchInCreateMode = new JButton();
        this.btnAcceptChanges = new JButton();
        this.btnDiscardChanges = new JButton();
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        this.btnSwitchInEditmode.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/belis/resource/icon/22/editMode.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnSwitchInEditmode, (String)NbBundle.getMessage(EditButtonsToolbar.class, (String)"EditButtonsToolbar.btnSwitchInEditmode.text_2"));
        this.btnSwitchInEditmode.setToolTipText("Editormodus");
        this.btnSwitchInEditmode.setBorderPainted(false);
        this.btnSwitchInEditmode.setFocusable(false);
        this.btnSwitchInEditmode.setMaximumSize(new Dimension(23, 23));
        this.btnSwitchInEditmode.setMinimumSize(new Dimension(23, 23));
        this.btnSwitchInEditmode.setPreferredSize(new Dimension(23, 23));
        this.btnSwitchInEditmode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditButtonsToolbar.this.btnSwitchInEditmodeActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.add((Component)this.btnSwitchInEditmode, gridBagConstraints);
        this.btnSwitchInCreateMode.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/belis/resource/icon/22/createMode.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnSwitchInCreateMode, (String)NbBundle.getMessage(EditButtonsToolbar.class, (String)"EditButtonsToolbar.btnSwitchInCreateMode.text_1"));
        this.btnSwitchInCreateMode.setToolTipText("Anlegenmodus");
        this.btnSwitchInCreateMode.setBorderPainted(false);
        this.btnSwitchInCreateMode.setFocusable(false);
        this.btnSwitchInCreateMode.setLabel(NbBundle.getMessage(EditButtonsToolbar.class, (String)"EditButtonsToolbar.btnSwitchInCreateMode.label"));
        this.btnSwitchInCreateMode.setMaximumSize(new Dimension(23, 23));
        this.btnSwitchInCreateMode.setMinimumSize(new Dimension(23, 23));
        this.btnSwitchInCreateMode.setPreferredSize(new Dimension(23, 23));
        this.btnSwitchInCreateMode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditButtonsToolbar.this.btnSwitchInCreateModeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.add((Component)this.btnSwitchInCreateMode, gridBagConstraints);
        this.broker.setBtnSwitchInCreateMode(this.btnSwitchInCreateMode);
        this.btnAcceptChanges.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/belis/resource/icon/22/accept.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnAcceptChanges, (String)NbBundle.getMessage(EditButtonsToolbar.class, (String)"EditButtonsToolbar.btnAcceptChanges.text_1"));
        this.btnAcceptChanges.setToolTipText("\u00c4nderungen annehmen");
        this.btnAcceptChanges.setBorderPainted(false);
        this.btnAcceptChanges.setEnabled(false);
        this.btnAcceptChanges.setFocusable(false);
        this.btnAcceptChanges.setLabel(NbBundle.getMessage(EditButtonsToolbar.class, (String)"EditButtonsToolbar.btnAcceptChanges.label"));
        this.btnAcceptChanges.setMaximumSize(new Dimension(23, 23));
        this.btnAcceptChanges.setMinimumSize(new Dimension(23, 23));
        this.btnAcceptChanges.setPreferredSize(new Dimension(23, 23));
        this.btnAcceptChanges.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditButtonsToolbar.this.btnAcceptChangesActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.add((Component)this.btnAcceptChanges, gridBagConstraints);
        this.broker.setBtnAcceptChanges(this.btnAcceptChanges);
        this.btnDiscardChanges.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/belis/resource/icon/22/cancel.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnDiscardChanges, (String)NbBundle.getMessage(EditButtonsToolbar.class, (String)"EditButtonsToolbar.btnDiscardChanges.text_1"));
        this.btnDiscardChanges.setToolTipText("\u00c4nderungen Abbrechen");
        this.btnDiscardChanges.setBorderPainted(false);
        this.btnDiscardChanges.setEnabled(false);
        this.btnDiscardChanges.setFocusable(false);
        this.btnDiscardChanges.setLabel(NbBundle.getMessage(EditButtonsToolbar.class, (String)"EditButtonsToolbar.btnDiscardChanges.label"));
        this.btnDiscardChanges.setMaximumSize(new Dimension(23, 23));
        this.btnDiscardChanges.setMinimumSize(new Dimension(23, 23));
        this.btnDiscardChanges.setPreferredSize(new Dimension(23, 23));
        this.btnDiscardChanges.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditButtonsToolbar.this.btnDiscardChangesActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.add((Component)this.btnDiscardChanges, gridBagConstraints);
        this.broker.setBtnDiscardChanges(this.btnDiscardChanges);
    }

    private void btnSwitchInEditmodeActionPerformed(ActionEvent evt) {
        block4: {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Versuche in Editiermodus zu wechseln: ");
            }
            try {
                this.broker.switchEditMode();
            }
            catch (Exception ex) {
                if (!LOG.isDebugEnabled()) break block4;
                LOG.debug((Object)"Fehler beim anlegen der Sperre", (Throwable)ex);
            }
        }
        this.broker.getMappingComponent().setReadOnly(false);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("ist im Editiermodus: " + this.broker.isInEditMode()));
        }
    }

    private void btnSwitchInCreateModeActionPerformed(ActionEvent evt) {
        block5: {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"try to switch in createmode", (Throwable)new CurrentStackTrace());
            }
            try {
                this.broker.isPendingForCreateMode.set(true);
                this.broker.switchEditMode();
            }
            catch (Exception ex) {
                if (!LOG.isDebugEnabled()) break block5;
                LOG.debug((Object)"Fehler beim anlegen der Sperre", (Throwable)ex);
            }
        }
        this.broker.getMappingComponent().setReadOnly(false);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("ist im Editiermodus: " + this.broker.isInEditMode()));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("ist im Createmodus: " + this.broker.isInCreateMode()));
        }
    }

    public void enableSwitchToModeButtons(boolean enable) {
        this.btnSwitchInEditmode.setEnabled(enable && (CidsBroker.getInstance().checkForEditBasic() || CidsBroker.getInstance().checkForEditVeranlassung() || CidsBroker.getInstance().checkForEditArbeitsauftrag()));
        this.btnSwitchInCreateMode.setEnabled(enable && (CidsBroker.getInstance().checkForCreateBasic() || CidsBroker.getInstance().checkForCreateVeranlassung() || CidsBroker.getInstance().checkForCreateArbeitsauftrag()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void btnAcceptChangesActionPerformed(ActionEvent evt) {
        try {
            if (this.broker.isInEditMode()) {
                boolean isValid;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Versuche aus Editiermodus heraus zu wechseln: ");
                }
                if (isValid = this.broker.validateWidgets()) {
                    int answer;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Alle \u00c4nderungen sind valide: " + isValid));
                    }
                    if ((answer = JOptionPane.showConfirmDialog(this.broker.getParentComponent(), "Wollen Sie die gemachten \u00c4nderungen speichern?", "Belis \u00c4nderungen", 0)) != 0) return;
                    this.broker.fireSaveStartedAndExecuteSaveCancelWorker();
                } else {
                    String reason = this.broker.getCurrentValidationErrorMessage();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Es kann nicht gespeichert werden, da nicht alle Komponenten valide sind. Grund:\n" + reason));
                    }
                    JOptionPane.showMessageDialog(this.broker.getParentComponent(), "\u00c4nderungen k\u00f6nnen nur gespeichert werden, wenn alle Inhalte korrekt sind:\n\n" + reason + "\n\nBitte berichtigen Sie die Inhalte oder machen Sie die jeweiligen \u00c4nderungen r\u00fcckg\u00e4ngig.", "Fehler", 2);
                }
            }
            if (!LOG.isDebugEnabled()) return;
            LOG.debug((Object)("ist im Editiermodus: " + this.broker.isInEditMode()));
            return;
        }
        catch (Exception ex) {
            LOG.error((Object)"Fehler beim akzeptieren von \u00c4nderungen: ", (Throwable)ex);
            this.broker.showSaveErrorDialog(ex);
        }
    }

    private void btnDiscardChangesActionPerformed(ActionEvent evt) {
        if (this.broker.isInEditMode()) {
            block6: {
                int answer;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Versuche aus Editiermodus heraus zu wechseln: ");
                }
                if ((answer = JOptionPane.showConfirmDialog(this.broker.getParentComponent(), "Wollen Sie die gemachten \u00c4nderungen verwerfen?", "Belis \u00c4nderungen", 0)) == 1) {
                    return;
                }
                try {
                    this.broker.fireCancelStartedAndExecuteSaveCancelWorker();
                }
                catch (Exception ex) {
                    if (!LOG.isDebugEnabled()) break block6;
                    LOG.debug((Object)"Fehler beim l\u00f6sen der Sperre", (Throwable)ex);
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("ist im Editiermodus: " + this.broker.isInEditMode()));
            }
        }
    }
}

