/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.belis.todo;

import de.cismet.belis.broker.BelisBroker;
import de.cismet.belis.todo.CustomMutableTreeTableNode;
import de.cismet.belisEE.util.EntityComparator;
import de.cismet.cids.custom.beans.belis2.TdtaLeuchtenCustomBean;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.commons.server.entity.WorkbenchEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.tree.TreePath;
import org.apache.commons.collections.comparators.ReverseComparator;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.treetable.DefaultTreeTableModel;
import org.jdesktop.swingx.treetable.MutableTreeTableNode;
import org.jdesktop.swingx.treetable.TreeTableNode;

public class CustomTreeTableModel
extends DefaultTreeTableModel {
    public static String HIT_NODE = "CustomTreeTableModel.Hits";
    public static String NEW_OBJECT_NODE = "CustomTreeTableModel.newObject";
    public static String EDIT_OBJECT_NODE = "CustomTreeTableModel.editObject";
    protected static final Logger LOG = Logger.getLogger(CustomTreeTableModel.class);
    BelisBroker broker = null;
    private CustomMutableTreeTableNode rootNode = null;

    public CustomTreeTableModel(BelisBroker broker, CustomMutableTreeTableNode rootNode) {
        super((TreeTableNode)rootNode);
        this.broker = broker;
        this.rootNode = rootNode;
        this.setRoot((TreeTableNode)rootNode);
    }

    public Set getAllUserObjects() {
        TreeSet<Object> allObjects = new TreeSet<Object>((Comparator<Object>)new ReverseComparator((Comparator)new EntityComparator()));
        for (TreeTableNode curNode : this.getAllNodes((TreeTableNode)this.rootNode)) {
            if (curNode.getUserObject() == null) continue;
            allObjects.add(curNode.getUserObject());
        }
        return allObjects;
    }

    public Set<TreeTableNode> getAllNodes(TreeTableNode node) {
        HashSet<TreeTableNode> allNodes = new HashSet<TreeTableNode>();
        if (node != null) {
            allNodes.add(node);
            Enumeration children = node.children();
            while (children.hasMoreElements()) {
                allNodes.addAll(this.getAllNodes((TreeTableNode)children.nextElement()));
            }
        }
        return allNodes;
    }

    public CustomMutableTreeTableNode cloneNodeWithSameUserObjects(CustomMutableTreeTableNode nodeToClone) {
        if (nodeToClone != null) {
            CustomMutableTreeTableNode cloneNode = new CustomMutableTreeTableNode(nodeToClone.getUserObject(), nodeToClone.getAllowsChildren());
            int childIndexCount = nodeToClone.getChildCount();
            for (int curChildIndex = 0; curChildIndex < childIndexCount; ++curChildIndex) {
                CustomMutableTreeTableNode curChild = (CustomMutableTreeTableNode)nodeToClone.getChildAt(0);
                if (curChild == null) continue;
                CustomMutableTreeTableNode clonedChild = this.cloneNodeWithSameUserObjects(curChild);
                clonedChild.setParent((MutableTreeTableNode)cloneNode);
                cloneNode.add((MutableTreeTableNode)clonedChild);
            }
            return cloneNode;
        }
        return null;
    }

    public int getColumnCount() {
        return 3;
    }

    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "Art";
            }
            case 1: {
                return "Kennzeichnung";
            }
        }
        return "Position";
    }

    public Object getValueAt(Object aObject, int aColumn) {
        switch (aColumn) {
            case 1: {
                if (aObject instanceof TreeTableNode && ((TreeTableNode)aObject).getUserObject() instanceof WorkbenchEntity) {
                    return ((WorkbenchEntity)((TreeTableNode)aObject).getUserObject()).getKeyString();
                }
                return "";
            }
            case 2: {
                if (aObject instanceof TreeTableNode && ((TreeTableNode)aObject).getUserObject() instanceof WorkbenchEntity) {
                    return ((WorkbenchEntity)((TreeTableNode)aObject).getUserObject()).getHumanReadablePosition();
                }
                return "";
            }
        }
        if (aObject instanceof TreeTableNode) {
            return ((TreeTableNode)aObject).getUserObject();
        }
        return "";
    }

    public TreePath getPathForUserObject(Object userObject) {
        Set<TreeTableNode> allNodes;
        if (userObject != null && (allNodes = this.getAllNodes(this.getRoot())) != null) {
            for (TreeTableNode curNode : allNodes) {
                if (curNode.getUserObject() == null || !curNode.getUserObject().equals(userObject)) continue;
                return new TreePath(this.getPathToRoot(curNode));
            }
        }
        return null;
    }

    public Collection<TreePath> getPathsForUserObject(Object userObject) {
        Set<TreeTableNode> allNodes;
        ArrayList<TreePath> coll = new ArrayList<TreePath>();
        if (userObject != null && (allNodes = this.getAllNodes(this.getRoot())) != null) {
            for (TreeTableNode curNode : allNodes) {
                if (curNode.getUserObject() == null || !curNode.getUserObject().equals(userObject)) continue;
                coll.add(new TreePath(this.getPathToRoot(curNode)));
            }
        }
        return coll;
    }

    public void removeAllChildrenFromNode(CustomMutableTreeTableNode node, boolean onlyWihtoutID) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"removeAllChildrenFromNode");
        }
        ArrayList<CustomMutableTreeTableNode> nodesToRemove = new ArrayList<CustomMutableTreeTableNode>();
        int childCount = node.getChildCount();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Childcount of node: " + childCount));
        }
        if (childCount > 0) {
            for (int i = 0; i < childCount; ++i) {
                CustomMutableTreeTableNode curNode = (CustomMutableTreeTableNode)node.getChildAt(i);
                if (onlyWihtoutID && curNode.getUserObject() != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"checking id");
                    }
                    try {
                        if (((CidsBean)curNode.getUserObject()).getProperty("id") != null) continue;
                        try {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)"ID of entity is null. Will be removed.");
                            }
                            nodesToRemove.add(curNode);
                            if (curNode.getUserObject() instanceof Feature && ((Feature)curNode.getUserObject()).getGeometry() != null) {
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug((Object)"Current object is feature and has a geometry, will be removed from map.");
                                }
                                this.broker.getMappingComponent().getFeatureCollection().removeFeature((Feature)curNode.getUserObject());
                                continue;
                            }
                            if (!(curNode.getUserObject() instanceof TdtaLeuchtenCustomBean) || !this.broker.getWorkbenchWidget().isNodeHaengeLeuchte((Object)curNode)) continue;
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)"node is haengeleuchte removing parent from map");
                            }
                            this.broker.getMappingComponent().getFeatureCollection().removeFeature((Feature)this.broker.getWorkbenchWidget().getVirtualStandortForLeuchte((TdtaLeuchtenCustomBean)curNode.getUserObject()));
                        }
                        catch (Exception ex) {
                            LOG.warn((Object)"error while removing geometry from Map", (Throwable)ex);
                            nodesToRemove.add(curNode);
                        }
                    }
                    catch (Exception ex) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"Object has no id field. Will be removed", (Throwable)ex);
                        }
                        nodesToRemove.add(curNode);
                    }
                    continue;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Either no id check or userObject is null");
                }
                nodesToRemove.add(curNode);
            }
            for (CustomMutableTreeTableNode curNode : nodesToRemove) {
                if (curNode != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("removing node:" + (Object)((Object)curNode)));
                    }
                    this.removeNodeFromParent((MutableTreeTableNode)curNode);
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)"node is removed from tree");
            }
        }
    }

    public final void insertNodeIntoAsLastChild(MutableTreeTableNode newChild, MutableTreeTableNode parent) {
        if (parent != null) {
            super.insertNodeInto(newChild, parent, parent.getChildCount());
        } else {
            LOG.warn((Object)"node not inserted, because parent is null");
        }
    }
}

