/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.beans.belis2;

import Sirius.navigator.connection.SessionManager;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.io.WKTWriter;
import de.cismet.belis.broker.CidsBroker;
import de.cismet.belis2.server.search.NextArbeitsauftragNummerSearch;
import de.cismet.belisEE.util.EntityComparator;
import de.cismet.cids.custom.beans.belis2.ArbeitsprotokollCustomBean;
import de.cismet.cids.custom.beans.belis2.DmsUrlCustomBean;
import de.cismet.cids.custom.beans.belis2.TeamCustomBean;
import de.cismet.cids.custom.tostringconverter.belis2.ArbeitsauftragToStringConverter;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.commons.server.entity.WorkbenchEntity;
import de.cismet.commons.server.entity.WorkbenchFeatureEntity;
import java.sql.Date;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdesktop.observablecollections.ObservableList;
import org.jdesktop.observablecollections.ObservableListListener;

public class ArbeitsauftragCustomBean
extends WorkbenchEntity {
    private static final Logger LOG = Logger.getLogger(ArbeitsauftragCustomBean.class);
    public static final String TABLE = "arbeitsauftrag";
    public static final String PROP__ANGELEGT_VON = "angelegt_von";
    public static final String PROP__ANGELEGT_AM = "angelegt_am";
    public static final String PROP__NUMMER = "nummer";
    public static final String PROP__AR_PROTOKOLLE = "ar_protokolle";
    public static final String PROP__ZUGEWIESEN_AN = "zugewiesen_an";
    public static final String PROP__AUSDEHNUNG_WGS84 = "ausdehnung_wgs84";
    private final WKTWriter WKT_WRITER = new WKTWriter();
    private final int SRID_WGS84 = 4326;
    private final int AUSDEHNUNG_BUFFER = 25;
    private String angelegt_von;
    private TeamCustomBean zugewiesen_an;
    private Date angelegt_am;
    private String nummer;
    private Collection<ArbeitsprotokollCustomBean> ar_protokolle;
    private Collection<DmsUrlCustomBean> ar_dokumente = new ArrayList<DmsUrlCustomBean>();

    public ArbeitsauftragCustomBean() {
        this.addPropertyNames(new String[]{PROP__ANGELEGT_VON, PROP__ANGELEGT_AM, PROP__NUMMER, PROP__AR_PROTOKOLLE, PROP__ZUGEWIESEN_AN, PROP__AUSDEHNUNG_WGS84});
    }

    public static ArbeitsauftragCustomBean createNew() {
        ArbeitsauftragCustomBean arbeitsauftragCustomBean = (ArbeitsauftragCustomBean)ArbeitsauftragCustomBean.createNew(TABLE);
        arbeitsauftragCustomBean.setAngelegt_am(new Date(Calendar.getInstance().getTime().getTime()));
        arbeitsauftragCustomBean.setAngelegt_von(SessionManager.getSession().getUser().getName());
        try {
            List nextNumber = (List)CidsBroker.getInstance().executeServerSearch((CidsServerSearch)new NextArbeitsauftragNummerSearch());
            Long number = nextNumber.isEmpty() ? null : (Long)nextNumber.get(0);
            DecimalFormat df = new DecimalFormat("00000000");
            arbeitsauftragCustomBean.setNummer(df.format(number));
        }
        catch (Exception ex) {
            LOG.error((Object)"", (Throwable)ex);
        }
        return arbeitsauftragCustomBean;
    }

    public String getAngelegt_von() {
        return this.angelegt_von;
    }

    public void setAngelegt_von(String angelegt_von) {
        String old = this.angelegt_von;
        this.angelegt_von = angelegt_von;
        this.propertyChangeSupport.firePropertyChange(PROP__ANGELEGT_VON, old, this.angelegt_von);
    }

    public Date getAngelegt_am() {
        return this.angelegt_am;
    }

    public void setAngelegt_am(Date angelegt_am) {
        Date old = this.angelegt_am;
        this.angelegt_am = angelegt_am;
        this.propertyChangeSupport.firePropertyChange(PROP__ANGELEGT_AM, old, this.angelegt_am);
    }

    public TeamCustomBean getZugewiesen_an() {
        return this.zugewiesen_an;
    }

    public void setZugewiesen_an(TeamCustomBean zugewiesen_an) {
        TeamCustomBean old = this.zugewiesen_an;
        this.zugewiesen_an = zugewiesen_an;
        this.propertyChangeSupport.firePropertyChange(PROP__ZUGEWIESEN_AN, (Object)old, (Object)this.zugewiesen_an);
    }

    public String getNummer() {
        return this.nummer;
    }

    public void setNummer(String nummer) {
        String old = this.nummer;
        this.nummer = nummer;
        this.propertyChangeSupport.firePropertyChange(PROP__NUMMER, old, this.nummer);
    }

    public Collection<ArbeitsprotokollCustomBean> getAr_protokolle() {
        return this.ar_protokolle;
    }

    public List<ArbeitsprotokollCustomBean> getSortedProtokolle() {
        ArrayList<ArbeitsprotokollCustomBean> sorted = new ArrayList<ArbeitsprotokollCustomBean>(this.ar_protokolle);
        Collections.sort(sorted, new Comparator<ArbeitsprotokollCustomBean>(){

            @Override
            public int compare(ArbeitsprotokollCustomBean o1, ArbeitsprotokollCustomBean o2) {
                if (o1.getProtokollnummer() != null && o2.getProtokollnummer() != null) {
                    return o1.getProtokollnummer().compareTo(o2.getProtokollnummer());
                }
                if (o1.getProtokollnummer() != null) {
                    return 1;
                }
                if (o2.getProtokollnummer() != null) {
                    return -1;
                }
                return 0;
            }
        });
        return sorted;
    }

    public void setAr_protokolle(Collection<ArbeitsprotokollCustomBean> ar_protokolle) {
        if (ar_protokolle != null && ar_protokolle instanceof ObservableList) {
            ((ObservableList)ar_protokolle).addObservableListListener(new ObservableListListener(){

                public void listElementsAdded(ObservableList list, int index, int length) {
                    for (int i = index; i < index + length; ++i) {
                        Object object = list.get(i);
                        if (object == null || !(object instanceof ArbeitsprotokollCustomBean)) continue;
                        ArbeitsprotokollCustomBean protokoll = (ArbeitsprotokollCustomBean)object;
                        protokoll.setProtokollnummer(i + 1);
                    }
                }

                public void listElementsRemoved(ObservableList list, int index, List removedList) {
                    List<ArbeitsprotokollCustomBean> protokolle = ArbeitsauftragCustomBean.this.getSortedProtokolle();
                    for (int i = 0; i < protokolle.size(); ++i) {
                        protokolle.get(i).setProtokollnummer(i + 1);
                    }
                }

                public void listElementReplaced(ObservableList ol, int i, Object o) {
                }

                public void listElementPropertyChanged(ObservableList ol, int i) {
                }
            });
        }
        Collection<ArbeitsprotokollCustomBean> old = this.ar_protokolle;
        this.ar_protokolle = ar_protokolle;
        List<ArbeitsprotokollCustomBean> sortedProtokolle = this.getSortedProtokolle();
        for (int index = 0; index < sortedProtokolle.size(); ++index) {
            ArbeitsprotokollCustomBean protokoll = sortedProtokolle.get(index);
            if (protokoll.getProtokollnummer() != null) continue;
            protokoll.setProtokollnummer(index + 1);
        }
        this.propertyChangeSupport.firePropertyChange(PROP__AR_PROTOKOLLE, old, this.ar_protokolle);
    }

    public void setAusdehnung_wgs84(String ausdehnung_wgs84) {
    }

    public String getAusdehnung_wgs84() {
        ArrayList<Geometry> geoms = new ArrayList<Geometry>(this.getAr_protokolle().size());
        for (ArbeitsprotokollCustomBean protBean : this.getAr_protokolle()) {
            Geometry childGeometry;
            WorkbenchFeatureEntity child = protBean.getChildEntity();
            if (child == null || (childGeometry = child.getGeometry()) == null) continue;
            geoms.add(childGeometry.buffer(25.0));
        }
        if (!geoms.isEmpty()) {
            GeometryCollection geomColl = new GeometryCollection(GeometryFactory.toGeometryArray(geoms), ((Geometry)geoms.get(0)).getFactory());
            String crs = CrsTransformer.createCrsFromSrid((int)4326);
            Geometry transformedGeom = CrsTransformer.transformToGivenCrs((Geometry)geomColl.convexHull(), (String)crs);
            transformedGeom.setSRID(4326);
            return this.WKT_WRITER.write(transformedGeom);
        }
        return null;
    }

    @Override
    public Collection<DmsUrlCustomBean> getDokumente() {
        return this.ar_dokumente;
    }

    @Override
    public void setDokumente(Collection<DmsUrlCustomBean> ar_dokumente) {
        this.ar_dokumente = ar_dokumente;
    }

    @Override
    public int compareTo(WorkbenchEntity o) {
        if (o instanceof ArbeitsauftragCustomBean) {
            ArbeitsauftragCustomBean a = (ArbeitsauftragCustomBean)o;
            int result = this.getKeyString().compareTo(a.getKeyString()) * -1;
            return result == 0 ? 1 : result;
        }
        return EntityComparator.compareTypes(this, o);
    }

    @Override
    public String getHumanReadablePosition() {
        return new ArbeitsauftragToStringConverter().getHumanReadablePosition((CidsBean)this);
    }

    @Override
    public String getKeyString() {
        return new ArbeitsauftragToStringConverter().getKeyString((CidsBean)this);
    }
}

