/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.beans.belis2;

import de.cismet.cids.custom.beans.belis2.UrlCustomBean;
import de.cismet.commons.server.entity.BaseEntity;
import de.cismet.tools.URLSplitter;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.log4j.Logger;

public class DmsUrlCustomBean
extends BaseEntity {
    private static final Logger LOG = Logger.getLogger(DmsUrlCustomBean.class);
    public static final String TABLE = "dms_url";
    public static final String PROP__TYP = "typ";
    public static final String PROP__URL_ID = "url_id";
    public static final String PROP__DESCRIPTION = "description";
    public static final String PROP__NAME = "name";
    private Integer typ;
    private UrlCustomBean url_id;
    private String description;
    private String name;

    public DmsUrlCustomBean() {
        this.addPropertyNames(new String[]{PROP__TYP, PROP__URL_ID, PROP__DESCRIPTION, PROP__NAME});
    }

    public static DmsUrlCustomBean createNew() {
        return (DmsUrlCustomBean)DmsUrlCustomBean.createNew(TABLE);
    }

    public Integer getTyp() {
        return this.typ;
    }

    public void setTyp(Integer typ) {
        Integer old = this.typ;
        this.typ = typ;
        this.propertyChangeSupport.firePropertyChange(PROP__TYP, old, this.typ);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        String old = this.name;
        this.name = name;
        this.propertyChangeSupport.firePropertyChange(PROP__NAME, old, this.name);
    }

    public UrlCustomBean getUrl_id() {
        return this.url_id;
    }

    public void setUrl_id(UrlCustomBean url_id) {
        UrlCustomBean old = this.url_id;
        this.url_id = url_id;
        this.propertyChangeSupport.firePropertyChange(PROP__URL_ID, (Object)old, (Object)this.url_id);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        String old = this.description;
        this.description = description;
        this.propertyChangeSupport.firePropertyChange(PROP__DESCRIPTION, old, this.description);
    }

    public String getBeschreibung() {
        return this.getDescription();
    }

    public void setBeschreibung(String beschreibung) {
        this.setDescription(beschreibung);
    }

    public UrlCustomBean getUrl() {
        return this.getUrl_id();
    }

    public void setUrl(UrlCustomBean url) {
        this.setUrl_id(url);
    }

    public File toFile() {
        URL u;
        File candidate = null;
        if (this.getUrl() != null && (u = this.getUrl().getURL()) != null) {
            try {
                candidate = new File(u.toURI());
            }
            catch (URISyntaxException ex) {
                candidate = new File(u.getPath());
            }
            if (candidate.isFile()) {
                return candidate;
            }
        }
        return null;
    }

    public URI toUri() {
        URL u;
        if (this.getUrl() != null && (u = this.getUrl().getURL()) != null) {
            try {
                return u.toURI();
            }
            catch (URISyntaxException e) {
                LOG.error((Object)"URL syntax error.", (Throwable)e);
            }
        }
        return null;
    }

    public static DmsUrlCustomBean createDmsURLFromLink(String link, String description) {
        if (link == null || description == null) {
            throw new NullPointerException();
        }
        DmsUrlCustomBean dmsUrlEntity = DmsUrlCustomBean.createNew();
        UrlCustomBean url = UrlCustomBean.createNew();
        URLSplitter splitter = new URLSplitter(link);
        dmsUrlEntity.setBeschreibung(description);
        dmsUrlEntity.setUrl(url);
        url.setObjektname(splitter.getObject_name());
        return dmsUrlEntity;
    }
}

