/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.beans.belis2;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import com.vividsolutions.jts.io.WKTWriter;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.commons.server.entity.BaseEntity;
import org.apache.log4j.Logger;

public class GeomCustomBean
extends BaseEntity {
    private static final Logger LOG = Logger.getLogger(GeomCustomBean.class);
    public static final String TABLE = "geom";
    public static final String PROP__GEO_FIELD = "geo_field";
    public static final String PROP__WGS84_WKT = "wgs84_wkt";
    private final WKTWriter WKT_WRITER = new WKTWriter();
    private final WKTReader WKT_READER = new WKTReader();
    private final int SRID_WGS84 = 4326;
    private Geometry geo_field;
    private String wgs84_wkt;
    private Geometry old;

    public GeomCustomBean() {
        this.addPropertyNames(new String[]{PROP__GEO_FIELD, PROP__WGS84_WKT});
    }

    public static GeomCustomBean createNew() {
        return (GeomCustomBean)GeomCustomBean.createNew(TABLE);
    }

    public Geometry getGeo_field() {
        return this.geo_field;
    }

    public void setGeo_field(Geometry geo_field) {
        this.simpleSetGeo_field(geo_field);
        if (geo_field == null) {
            this.simpleSetWgs84_wkt(null);
        } else {
            String crs = CrsTransformer.createCrsFromSrid((int)4326);
            Geometry transformedGeom = CrsTransformer.transformToGivenCrs((Geometry)geo_field, (String)crs);
            transformedGeom.setSRID(4326);
            this.simpleSetWgs84_wkt(this.WKT_WRITER.write(transformedGeom));
        }
    }

    public void simpleSetGeo_field(Geometry geo_field) {
        this.geo_field = geo_field;
        this.propertyChangeSupport.firePropertyChange(PROP__GEO_FIELD, this.old, this.geo_field);
        this.old = this.geo_field != null ? (Geometry)this.geo_field.clone() : null;
    }

    public Geometry getGeomField() {
        return this.getGeo_field();
    }

    public void setGeomField(Geometry geomField) {
        this.setGeo_field(geomField);
    }

    public String getWgs84_wkt() {
        return this.wgs84_wkt;
    }

    public void setWgs84_wkt(String wgs84_wkt) {
        this.simpleSetWgs84_wkt(wgs84_wkt);
        if (wgs84_wkt == null) {
            this.simpleSetGeo_field(null);
        } else {
            try {
                Geometry fromWkt = this.WKT_READER.read(wgs84_wkt);
                fromWkt.setSRID(4326);
                int currentSrid = CrsTransformer.getCurrentSrid();
                String crs = CrsTransformer.createCrsFromSrid((int)currentSrid);
                Geometry transformedGeom = CrsTransformer.transformToGivenCrs((Geometry)fromWkt, (String)crs);
                transformedGeom.setSRID(currentSrid);
                this.simpleSetGeo_field(transformedGeom);
            }
            catch (ParseException ex) {
                this.simpleSetGeo_field(null);
            }
        }
    }

    private void simpleSetWgs84_wkt(String wgs84_wkt) {
        String old = this.wgs84_wkt;
        this.wgs84_wkt = wgs84_wkt;
        this.propertyChangeSupport.firePropertyChange(PROP__WGS84_WKT, old, this.wgs84_wkt);
    }
}

