/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.beans.belis2;

import Sirius.server.middleware.types.MetaObject;
import Sirius.server.middleware.types.MetaObjectNode;
import de.cismet.belis.broker.CidsBroker;
import de.cismet.belis2.server.search.HighestLfdNummerSearch;
import de.cismet.belis2.server.search.LeuchteSearchStatement;
import de.cismet.belis2.server.utils.ActionNotSuccessfulException;
import de.cismet.belisEE.mapicons.MapIcons;
import de.cismet.belisEE.util.EntityComparator;
import de.cismet.belisEE.util.StandortKey;
import de.cismet.cids.custom.beans.belis2.AnlagengruppeCustomBean;
import de.cismet.cids.custom.beans.belis2.DmsUrlCustomBean;
import de.cismet.cids.custom.beans.belis2.GeomCustomBean;
import de.cismet.cids.custom.beans.belis2.TdtaLeuchtenCustomBean;
import de.cismet.cids.custom.beans.belis2.TkeyBezirkCustomBean;
import de.cismet.cids.custom.beans.belis2.TkeyKennzifferCustomBean;
import de.cismet.cids.custom.beans.belis2.TkeyKlassifizierungCustomBean;
import de.cismet.cids.custom.beans.belis2.TkeyMastartCustomBean;
import de.cismet.cids.custom.beans.belis2.TkeyMasttypCustomBean;
import de.cismet.cids.custom.beans.belis2.TkeyStrassenschluesselCustomBean;
import de.cismet.cids.custom.beans.belis2.TkeyUnterhMastCustomBean;
import de.cismet.cids.custom.tostringconverter.belis2.TdtaStandortMastToStringConverter;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.cismap.commons.gui.piccolo.FeatureAnnotationSymbol;
import de.cismet.cismap.commons.tools.IconUtils;
import de.cismet.commons.server.entity.WorkbenchEntity;
import de.cismet.commons.server.entity.WorkbenchFeatureEntity;
import java.awt.Color;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdesktop.observablecollections.ObservableCollections;
import org.jdesktop.observablecollections.ObservableList;
import org.jdesktop.observablecollections.ObservableListListener;

public class TdtaStandortMastCustomBean
extends WorkbenchFeatureEntity {
    public static TkeyUnterhMastCustomBean DEFAULT_UNTERHALT;
    private static final Logger LOG;
    public static final String TABLE = "tdta_standort_mast";
    public static final String PROP__PLZ = "plz";
    public static final String PROP__FK_STRASSENSCHLUESSEL = "fk_strassenschluessel";
    public static final String PROP__FK_STADTBEZIRK = "fk_stadtbezirk";
    public static final String PROP__FK_MASTART = "fk_mastart";
    public static final String PROP__FK_KLASSIFIZIERUNG = "fk_klassifizierung";
    public static final String PROP__MASTANSTRICH = "mastanstrich";
    public static final String PROP__MASTSCHUTZ = "mastschutz";
    public static final String PROP__FK_UNTERHALTSPFLICHT_MAST = "fk_unterhaltspflicht_mast";
    public static final String PROP__FK_MASTTYP = "fk_masttyp";
    public static final String PROP__INBETRIEBNAHME_MAST = "inbetriebnahme_mast";
    public static final String PROP__VERRECHNUNGSEINHEIT = "verrechnungseinheit";
    public static final String PROP__LETZTE_AENDERUNG = "letzte_aenderung";
    public static final String PROP__FK_GEOM = "fk_geom";
    public static final String PROP__IST_VIRTUELLER_STANDORT = "ist_virtueller_standort";
    public static final String PROP__BEMERKUNGEN = "bemerkungen";
    public static final String PROP__MONTAGEFIRMA = "montagefirma";
    public static final String PROP__STANDORTANGABE = "standortangabe";
    public static final String PROP__FK_KENNZIFFER = "fk_kennziffer";
    public static final String PROP__LFD_NUMMER = "lfd_nummer";
    public static final String PROP__HAUS_NR = "haus_nr";
    public static final String PROP__DOKUMENTE = "dokumente";
    public static final String PROP__GRUENDUNG = "gruendung";
    public static final String PROP__ELEK_PRUEFUNG = "elek_pruefung";
    public static final String PROP__ERDUNG = "erdung";
    public static final String PROP__MONTEUR = "monteur";
    public static final String PROP__STANDSICHERHEITSPRUEFUNG = "standsicherheitspruefung";
    public static final String PROP__VERFAHREN = "verfahren";
    public static final String PROP__FOTO = "foto";
    public static final String PROP__NAECHSTES_PRUEFDATUM = "naechstes_pruefdatum";
    public static final String PROP__ANSTRICHFARBE = "anstrichfarbe";
    public static final String PROP__REVISION = "revision";
    public static final String PROP__ANLAGENGRUPPE = "anlagengruppe";
    public static final String PROP__ANBAUTEN = "anbauten";
    private String plz;
    private TkeyStrassenschluesselCustomBean fk_strassenschluessel;
    private TkeyBezirkCustomBean fk_Stadtbezirk;
    private TkeyMastartCustomBean fk_Mastart;
    private TkeyKlassifizierungCustomBean fk_klassifizierung;
    private Timestamp mastanstrich;
    private Timestamp mastschutz;
    private TkeyUnterhMastCustomBean fk_unterhaltspflicht_mast;
    private TkeyMasttypCustomBean fk_masttyp;
    private Timestamp inbetriebnahme_mast;
    private Boolean verrechnungseinheit;
    private Timestamp letzte_aenderung;
    private GeomCustomBean fk_geom;
    private Boolean ist_virtueller_standort;
    private String bemerkungen;
    private String montagefirma;
    private String standortangabe;
    private TkeyKennzifferCustomBean fk_kennziffer;
    private Integer lfd_nummer;
    private String haus_nr;
    private Collection<DmsUrlCustomBean> dokumente;
    private Collection<TdtaLeuchtenCustomBean> leuchten;
    private String gruendung;
    private Timestamp elek_pruefung;
    private Boolean erdung;
    private String monteur;
    private Timestamp standsicherheitspruefung;
    private String verfahren;
    private DmsUrlCustomBean foto;
    private Timestamp naechstes_pruefdatum;
    private String anstrichfarbe;
    private Timestamp revision;
    private AnlagengruppeCustomBean anlagengruppe;
    private String anbauten;
    private final Collection<TdtaLeuchtenCustomBean> removedLeuchten = new HashSet<TdtaLeuchtenCustomBean>();

    public TdtaStandortMastCustomBean() {
        this.addPropertyNames(new String[]{PROP__PLZ, PROP__FK_STRASSENSCHLUESSEL, PROP__FK_STADTBEZIRK, PROP__FK_MASTART, PROP__FK_KLASSIFIZIERUNG, PROP__MASTANSTRICH, PROP__MASTSCHUTZ, PROP__FK_UNTERHALTSPFLICHT_MAST, PROP__FK_MASTTYP, PROP__INBETRIEBNAHME_MAST, PROP__VERRECHNUNGSEINHEIT, PROP__LETZTE_AENDERUNG, PROP__FK_GEOM, PROP__IST_VIRTUELLER_STANDORT, PROP__BEMERKUNGEN, PROP__MONTAGEFIRMA, PROP__STANDORTANGABE, PROP__FK_KENNZIFFER, PROP__LFD_NUMMER, PROP__HAUS_NR, PROP__DOKUMENTE, PROP__GRUENDUNG, PROP__ELEK_PRUEFUNG, PROP__ERDUNG, PROP__MONTEUR, PROP__STANDSICHERHEITSPRUEFUNG, PROP__VERFAHREN, PROP__FOTO, PROP__NAECHSTES_PRUEFDATUM, PROP__ANSTRICHFARBE, PROP__REVISION, PROP__ANLAGENGRUPPE, PROP__ANBAUTEN});
    }

    @Override
    public void init() {
        this.refreshLeuchten();
    }

    private void refreshLeuchten() {
        ArrayList<TdtaLeuchtenCustomBean> coll = new ArrayList<TdtaLeuchtenCustomBean>();
        if (this.getId() != null) {
            LeuchteSearchStatement search = new LeuchteSearchStatement();
            search.setFk_standort_id(this.getId());
            try {
                Collection mons = CidsBroker.getInstance().executeServerSearch((CidsServerSearch)search);
                for (MetaObjectNode mon : mons) {
                    int classid = mon.getClassId();
                    int objectid = mon.getObjectId();
                    MetaObject mo = CidsBroker.getInstance().getMetaObject(classid, objectid, "BELIS2");
                    TdtaLeuchtenCustomBean leuchte = (TdtaLeuchtenCustomBean)mo.getBean();
                    coll.add(leuchte);
                }
            }
            catch (Exception ex) {
                LOG.error((Object)ex, (Throwable)ex);
            }
        }
        this.setLeuchten((Collection<TdtaLeuchtenCustomBean>)ObservableCollections.observableList(coll));
    }

    public static TdtaStandortMastCustomBean createNew() {
        TdtaStandortMastCustomBean bean = (TdtaStandortMastCustomBean)TdtaStandortMastCustomBean.createNew(TABLE);
        bean.init();
        return bean;
    }

    @Override
    public Collection<DmsUrlCustomBean> getDokumente() {
        return this.dokumente;
    }

    @Override
    public void setDokumente(Collection<DmsUrlCustomBean> dokumente) {
        Collection<DmsUrlCustomBean> old = this.dokumente;
        this.dokumente = dokumente;
        this.propertyChangeSupport.firePropertyChange(PROP__DOKUMENTE, old, this.dokumente);
    }

    public String getPlz() {
        return this.plz;
    }

    public void setPlz(String plz) {
        String old = this.plz;
        this.plz = plz;
        this.propertyChangeSupport.firePropertyChange(PROP__PLZ, old, this.plz);
    }

    public TkeyStrassenschluesselCustomBean getFk_strassenschluessel() {
        return this.fk_strassenschluessel;
    }

    public void setFk_strassenschluessel(TkeyStrassenschluesselCustomBean fk_strassenschluessel) {
        TkeyStrassenschluesselCustomBean old = this.fk_strassenschluessel;
        this.fk_strassenschluessel = fk_strassenschluessel;
        this.propertyChangeSupport.firePropertyChange(PROP__FK_STRASSENSCHLUESSEL, old, this.fk_strassenschluessel);
    }

    public TkeyStrassenschluesselCustomBean getStrassenschluessel() {
        return this.getFk_strassenschluessel();
    }

    public void setStrassenschluessel(TkeyStrassenschluesselCustomBean fk_strassenschluessel) {
        this.setFk_strassenschluessel(fk_strassenschluessel);
    }

    public TkeyKennzifferCustomBean getKennziffer() {
        return this.getFk_kennziffer();
    }

    public void setKennziffer(TkeyKennzifferCustomBean kennziffer) {
        this.setFk_kennziffer(kennziffer);
    }

    public TkeyKennzifferCustomBean getFk_kennziffer() {
        return this.fk_kennziffer;
    }

    public void setFk_kennziffer(TkeyKennzifferCustomBean fk_kennziffer) {
        TkeyKennzifferCustomBean old = this.fk_kennziffer;
        this.fk_kennziffer = fk_kennziffer;
        this.propertyChangeSupport.firePropertyChange(PROP__FK_KENNZIFFER, old, this.fk_kennziffer);
    }

    public String getStandortangabe() {
        return this.standortangabe;
    }

    public void setStandortangabe(String standortangabe) {
        String old = this.standortangabe;
        this.standortangabe = standortangabe;
        this.propertyChangeSupport.firePropertyChange(PROP__STANDORTANGABE, old, this.standortangabe);
    }

    public TkeyBezirkCustomBean getStadtbezirk() {
        return this.getFk_stadtbezirk();
    }

    public void setStadtbezirk(TkeyBezirkCustomBean stadtbezirk) {
        this.setFk_stadtbezirk(stadtbezirk);
    }

    public Timestamp getMastanstrich() {
        return this.mastanstrich;
    }

    public void setMastanstrich(Timestamp mastanstrich) {
        Timestamp old = this.mastanstrich;
        this.mastanstrich = mastanstrich;
        this.propertyChangeSupport.firePropertyChange(PROP__MASTANSTRICH, old, this.mastanstrich);
    }

    public Timestamp getMastschutz() {
        return this.mastschutz;
    }

    public void setMastschutz(Timestamp mastschutz) {
        Timestamp old = this.mastschutz;
        this.mastschutz = mastschutz;
        this.propertyChangeSupport.firePropertyChange(PROP__MASTSCHUTZ, old, this.mastschutz);
    }

    public Boolean isVerrechnungseinheit() {
        return this.getVerrechnungseinheit();
    }

    public void setVerrechnungseinheit(Boolean verrechnungseinheit) {
        Boolean old = this.verrechnungseinheit;
        this.verrechnungseinheit = verrechnungseinheit;
        this.propertyChangeSupport.firePropertyChange(PROP__VERRECHNUNGSEINHEIT, old, this.verrechnungseinheit);
    }

    public String getBemerkungen() {
        return this.bemerkungen;
    }

    public void setBemerkungen(String bemerkungen) {
        String old = this.bemerkungen;
        this.bemerkungen = bemerkungen;
        this.propertyChangeSupport.firePropertyChange(PROP__BEMERKUNGEN, old, this.bemerkungen);
    }

    public TkeyBezirkCustomBean getFk_stadtbezirk() {
        return this.fk_Stadtbezirk;
    }

    public void setFk_stadtbezirk(TkeyBezirkCustomBean fk_Stadtbezirk) {
        TkeyBezirkCustomBean old = this.fk_Stadtbezirk;
        this.fk_Stadtbezirk = fk_Stadtbezirk;
        this.propertyChangeSupport.firePropertyChange(PROP__FK_STADTBEZIRK, (Object)old, (Object)this.fk_Stadtbezirk);
    }

    public TkeyMastartCustomBean getFk_mastart() {
        return this.fk_Mastart;
    }

    public void setFk_mastart(TkeyMastartCustomBean fk_Mastart) {
        TkeyMastartCustomBean old = this.fk_Mastart;
        this.fk_Mastart = fk_Mastart;
        this.propertyChangeSupport.firePropertyChange(PROP__FK_MASTART, (Object)old, (Object)this.fk_Mastart);
    }

    public TkeyKlassifizierungCustomBean getFk_klassifizierung() {
        return this.fk_klassifizierung;
    }

    public void setFk_klassifizierung(TkeyKlassifizierungCustomBean fk_klassifizierung) {
        TkeyKlassifizierungCustomBean old = this.fk_klassifizierung;
        this.fk_klassifizierung = fk_klassifizierung;
        this.propertyChangeSupport.firePropertyChange(PROP__FK_KLASSIFIZIERUNG, (Object)old, (Object)this.fk_klassifizierung);
    }

    public TkeyUnterhMastCustomBean getFk_unterhaltspflicht_mast() {
        return this.fk_unterhaltspflicht_mast;
    }

    public void setFk_unterhaltspflicht_mast(TkeyUnterhMastCustomBean fk_unterhaltspflicht_mast) {
        TkeyUnterhMastCustomBean old = this.fk_unterhaltspflicht_mast;
        this.fk_unterhaltspflicht_mast = fk_unterhaltspflicht_mast;
        this.propertyChangeSupport.firePropertyChange(PROP__FK_UNTERHALTSPFLICHT_MAST, (Object)old, (Object)this.fk_unterhaltspflicht_mast);
    }

    public TkeyMasttypCustomBean getFk_masttyp() {
        return this.fk_masttyp;
    }

    public void setFk_masttyp(TkeyMasttypCustomBean fk_masttyp) {
        TkeyMasttypCustomBean old = this.fk_masttyp;
        this.fk_masttyp = fk_masttyp;
        this.propertyChangeSupport.firePropertyChange(PROP__FK_MASTTYP, old, this.fk_masttyp);
    }

    public Timestamp getInbetriebnahme_mast() {
        return this.inbetriebnahme_mast;
    }

    public void setInbetriebnahme_mast(Timestamp inbetriebnahme_mast) {
        Timestamp old = this.inbetriebnahme_mast;
        this.inbetriebnahme_mast = inbetriebnahme_mast;
        this.propertyChangeSupport.firePropertyChange(PROP__INBETRIEBNAHME_MAST, old, this.inbetriebnahme_mast);
    }

    public Boolean getVerrechnungseinheit() {
        return this.verrechnungseinheit;
    }

    public Timestamp getLetzte_aenderung() {
        return this.letzte_aenderung;
    }

    public void setLetzte_aenderung(Timestamp letzte_aenderung) {
        Timestamp old = this.letzte_aenderung;
        this.letzte_aenderung = letzte_aenderung;
        this.propertyChangeSupport.firePropertyChange(PROP__LETZTE_AENDERUNG, old, this.letzte_aenderung);
    }

    public GeomCustomBean getFk_geom() {
        return this.fk_geom;
    }

    public void setFk_geom(GeomCustomBean fk_geom) {
        GeomCustomBean old = this.fk_geom;
        this.fk_geom = fk_geom;
        this.propertyChangeSupport.firePropertyChange(PROP__FK_GEOM, (Object)old, (Object)this.fk_geom);
    }

    public Boolean getIst_virtueller_standort() {
        return this.ist_virtueller_standort;
    }

    public void setIst_virtueller_standort(Boolean ist_virtueller_standort) {
        Boolean old = this.ist_virtueller_standort;
        this.ist_virtueller_standort = ist_virtueller_standort;
        this.propertyChangeSupport.firePropertyChange(PROP__IST_VIRTUELLER_STANDORT, old, this.ist_virtueller_standort);
    }

    public Integer getLfd_nummer() {
        return this.lfd_nummer;
    }

    public void setLfd_nummer(Integer lfd_nummer) {
        Integer old = this.lfd_nummer;
        this.lfd_nummer = lfd_nummer;
        this.propertyChangeSupport.firePropertyChange(PROP__LFD_NUMMER, old, this.lfd_nummer);
    }

    public String getHaus_nr() {
        return this.haus_nr;
    }

    public void setHaus_nr(String haus_nr) {
        String old = this.haus_nr;
        this.haus_nr = haus_nr;
        this.propertyChangeSupport.firePropertyChange(PROP__HAUS_NR, old, this.haus_nr);
    }

    public Collection<TdtaLeuchtenCustomBean> getLeuchten() {
        if (this.leuchten == null) {
            this.refreshLeuchten();
        }
        return this.leuchten;
    }

    private void setLeuchten(Collection<TdtaLeuchtenCustomBean> leuchten) {
        if (leuchten != null) {
            for (TdtaLeuchtenCustomBean leuchte : leuchten) {
                if (leuchte == null) continue;
                leuchte.setFk_standort(this);
            }
            if (leuchten instanceof ObservableList) {
                final TdtaStandortMastCustomBean standort = this;
                ((ObservableList)leuchten).addObservableListListener(new ObservableListListener(){

                    public void listElementsAdded(ObservableList list, int index, int length) {
                        for (int i = index; i < index + length; ++i) {
                            Object object = list.get(i);
                            if (object == null || !(object instanceof TdtaLeuchtenCustomBean)) continue;
                            TdtaLeuchtenCustomBean leuchte = (TdtaLeuchtenCustomBean)object;
                            leuchte.setFk_standort(standort);
                        }
                    }

                    public void listElementsRemoved(ObservableList list, int index, List removedList) {
                        for (Object object : removedList) {
                            if (object == null || !(object instanceof TdtaLeuchtenCustomBean)) continue;
                            TdtaLeuchtenCustomBean leuchte = (TdtaLeuchtenCustomBean)object;
                            leuchte.setFk_standort(null);
                            TdtaStandortMastCustomBean.this.removedLeuchten.add(leuchte);
                        }
                    }

                    public void listElementReplaced(ObservableList ol, int i, Object o) {
                    }

                    public void listElementPropertyChanged(ObservableList ol, int i) {
                    }
                });
            }
        }
        this.leuchten = leuchten;
    }

    public String getMontagefirma() {
        return this.montagefirma;
    }

    public void setMontagefirma(String montagefirma) {
        String old = this.montagefirma;
        this.montagefirma = montagefirma;
        this.propertyChangeSupport.firePropertyChange(PROP__MONTAGEFIRMA, old, this.montagefirma);
    }

    public String getAnbauten() {
        return this.anbauten;
    }

    public void setAnbauten(String anbauten) {
        String old = this.anbauten;
        this.anbauten = anbauten;
        this.propertyChangeSupport.firePropertyChange(PROP__ANBAUTEN, old, this.anbauten);
    }

    public Boolean isVirtuellerStandort() {
        return this.getIst_virtueller_standort();
    }

    public void setVirtuellerStandort(Boolean virtualStandort) {
        this.setIst_virtueller_standort(virtualStandort);
    }

    public boolean isStandortMast() {
        return this.getMastart() != null || this.getMasttyp() != null || this.getMastanstrich() != null || this.getMastschutz() != null || this.isVirtuellerStandort() == null || this.isVirtuellerStandort() != null && this.isVirtuellerStandort() == false;
    }

    public Integer getLaufendeNummer() {
        return this.getLfd_nummer();
    }

    public void setLaufendeNummer(Integer lfdNummer) {
        this.setLfd_nummer(lfdNummer);
    }

    public String getHausnummer() {
        return this.getHaus_nr();
    }

    public void setHausnummer(String hausnummer) {
        this.setHaus_nr(hausnummer);
    }

    public TkeyMastartCustomBean getMastart() {
        return this.getFk_mastart();
    }

    public void setMastart(TkeyMastartCustomBean mastart) {
        this.setFk_mastart(mastart);
    }

    public TkeyKlassifizierungCustomBean getKlassifizierung() {
        return this.getFk_klassifizierung();
    }

    public void setKlassifizierung(TkeyKlassifizierungCustomBean klassifizierung) {
        this.setFk_klassifizierung(klassifizierung);
    }

    public TkeyUnterhMastCustomBean getUnterhaltspflichtMast() {
        return this.getFk_unterhaltspflicht_mast();
    }

    public void setUnterhaltspflichtMast(TkeyUnterhMastCustomBean unterhaltspflichtMast) {
        this.setFk_unterhaltspflicht_mast(unterhaltspflichtMast);
    }

    public TkeyMasttypCustomBean getMasttyp() {
        return this.getFk_masttyp();
    }

    public void setMasttyp(TkeyMasttypCustomBean masttyp) {
        this.setFk_masttyp(masttyp);
    }

    public Timestamp getInbetriebnahmeMast() {
        return this.getInbetriebnahme_mast();
    }

    public void setInbetriebnahmeMast(Timestamp inbetriebnahmeMast) {
        this.setInbetriebnahme_mast(inbetriebnahmeMast);
    }

    public Timestamp getLetzteAenderung() {
        return this.getLetzte_aenderung();
    }

    public void setLetzteAenderung(Timestamp letzteAenderung) {
        this.setLetzte_aenderung(letzteAenderung);
    }

    public StandortKey getStandortKey() {
        return new StandortKey(this.getStrassenschluessel(), this.getKennziffer(), this.getLaufendeNummer());
    }

    @Override
    public FeatureAnnotationSymbol getPointAnnotationSymbol() {
        ArrayList<Integer> nums = new ArrayList<Integer>(6);
        if (this.isStandortMast()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Standort is Mast");
            }
            if (this.getLaufendeNummer() != null) {
                nums.add(this.getLaufendeNummer());
            }
            Image iconToUse = null;
            if (this.getLeuchten() != null && this.getLeuchten().size() > 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"There are leuchten at this mast.");
                }
                iconToUse = MapIcons.icoMastWithLeuchte;
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"There are no leuchten at this mast.");
                }
                iconToUse = MapIcons.icoMast;
            }
            Image i1 = IconUtils.mergeNumbersToIcon((Image)iconToUse, nums, (Color)Color.RED);
            return FeatureAnnotationSymbol.newCustomSweetSpotFeatureAnnotationSymbol((Image)i1, null, (double)IconUtils.calcNewSweepSpotX((double)0.5, (Image)iconToUse, (Image)i1), (double)IconUtils.calcNewSweepSpotY((double)0.5, (Image)iconToUse, (Image)i1));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Standort is no Mast. There fore must be Leuchte");
        }
        if (this.getLeuchten() != null) {
            if (this.getLeuchten().size() != 1 && LOG.isDebugEnabled()) {
                LOG.debug((Object)("Standort is Leuchte, but getLeuchten().size() is != 1! (It is " + this.getLeuchten().size() + ")"));
            }
            for (TdtaLeuchtenCustomBean l : this.getLeuchten()) {
                if (l.getLaufendeNummer() == null) continue;
                nums.add(l.getLaufendeNummer());
                break;
            }
        }
        Image i1 = IconUtils.mergeNumbersToIcon((Image)MapIcons.icoLeuchte, nums, (Color)Color.RED);
        return FeatureAnnotationSymbol.newCustomSweetSpotFeatureAnnotationSymbol((Image)i1, null, (double)IconUtils.calcNewSweepSpotX((double)0.5, (Image)MapIcons.icoLeuchte, (Image)i1), (double)IconUtils.calcNewSweepSpotY((double)0.5, (Image)MapIcons.icoLeuchte, (Image)i1));
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"PropertyChange Standort");
        }
        if (!this.isStandortMast() && evt.getSource() instanceof TdtaLeuchtenCustomBean) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Property of Leuchte has changed. Changing Standort property");
            }
            if (evt.getPropertyName() != null && evt.getPropertyName().equals(PROP__FK_STRASSENSCHLUESSEL)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Strassenschluessel changed");
                }
                this.setStrassenschluessel((TkeyStrassenschluesselCustomBean)evt.getNewValue());
            } else if (evt.getPropertyName() != null && evt.getPropertyName().equals(PROP__FK_KENNZIFFER)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Kennziffer changed");
                }
                this.setKennziffer((TkeyKennzifferCustomBean)evt.getNewValue());
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Unkown property. Nothing to change");
            }
        } else if (evt.getSource() != null && evt.getSource() instanceof TdtaStandortMastCustomBean) {
            TkeyStrassenschluesselCustomBean strsch;
            super.propertyChange(evt);
            if (!evt.getPropertyName().equals(PROP__LETZTE_AENDERUNG)) {
                this.setLetzteAenderung(new Timestamp(new Date().getTime()));
            }
            if (evt.getPropertyName().equals(PROP__FK_STRASSENSCHLUESSEL) && (strsch = (TkeyStrassenschluesselCustomBean)evt.getNewValue()) != null && strsch.getPk().equals("00429")) {
                this.setBemerkungen("/ TEST-STRASSE \\");
            }
        }
    }

    @Override
    public GeomCustomBean getGeometrie() {
        return this.getFk_geom();
    }

    @Override
    public void setGeometrie(GeomCustomBean geometrie) {
        this.setFk_geom(geometrie);
    }

    public String getGruendung() {
        return this.gruendung;
    }

    public void setGruendung(String gruendung) {
        String old = this.gruendung;
        this.gruendung = gruendung;
        this.propertyChangeSupport.firePropertyChange(PROP__GRUENDUNG, old, this.gruendung);
    }

    public Timestamp getElek_pruefung() {
        return this.elek_pruefung;
    }

    public void setElek_pruefung(Timestamp elek_pruefung) {
        Timestamp old = this.elek_pruefung;
        this.elek_pruefung = elek_pruefung;
        this.propertyChangeSupport.firePropertyChange(PROP__ELEK_PRUEFUNG, old, this.elek_pruefung);
    }

    public Boolean getErdung() {
        return this.erdung;
    }

    public void setErdung(Boolean erdung) {
        Boolean old = this.erdung;
        this.erdung = erdung;
        this.propertyChangeSupport.firePropertyChange(PROP__ERDUNG, old, this.erdung);
    }

    public String getMonteur() {
        return this.monteur;
    }

    public void setMonteur(String monteur) {
        String old = this.monteur;
        this.monteur = monteur;
        this.propertyChangeSupport.firePropertyChange(PROP__MONTEUR, old, this.monteur);
    }

    public Timestamp getStandsicherheitspruefung() {
        return this.standsicherheitspruefung;
    }

    public void setStandsicherheitspruefung(Timestamp standsicherheitspruefung) {
        Timestamp old = this.standsicherheitspruefung;
        this.standsicherheitspruefung = standsicherheitspruefung;
        this.propertyChangeSupport.firePropertyChange(PROP__STANDSICHERHEITSPRUEFUNG, old, this.standsicherheitspruefung);
    }

    public String getVerfahren() {
        return this.verfahren;
    }

    public void setVerfahren(String verfahren) {
        String old = this.verfahren;
        this.verfahren = verfahren;
        this.propertyChangeSupport.firePropertyChange(PROP__VERFAHREN, old, this.verfahren);
    }

    public DmsUrlCustomBean getFoto() {
        return this.foto;
    }

    public void setFoto(DmsUrlCustomBean foto) {
        DmsUrlCustomBean old = this.foto;
        this.foto = foto;
        this.propertyChangeSupport.firePropertyChange(PROP__FOTO, (Object)old, (Object)this.foto);
    }

    public Timestamp getNaechstes_pruefdatum() {
        return this.naechstes_pruefdatum;
    }

    public void setNaechstes_pruefdatum(Timestamp naechstes_pruefdatum) {
        Timestamp old = this.naechstes_pruefdatum;
        this.naechstes_pruefdatum = naechstes_pruefdatum;
        this.propertyChangeSupport.firePropertyChange(PROP__NAECHSTES_PRUEFDATUM, old, this.naechstes_pruefdatum);
    }

    public String getAnstrichfarbe() {
        return this.anstrichfarbe;
    }

    public void setAnstrichfarbe(String anstrichfarbe) {
        String old = this.anstrichfarbe;
        this.anstrichfarbe = anstrichfarbe;
        this.propertyChangeSupport.firePropertyChange(PROP__ANSTRICHFARBE, old, this.anstrichfarbe);
    }

    public Timestamp getRevision() {
        return this.revision;
    }

    public void setRevision(Timestamp revision) {
        Timestamp old = this.revision;
        this.revision = revision;
        this.propertyChangeSupport.firePropertyChange(PROP__REVISION, old, this.revision);
    }

    public AnlagengruppeCustomBean getAnlagengruppe() {
        return this.anlagengruppe;
    }

    public void setAnlagengruppe(AnlagengruppeCustomBean anlagengruppe) {
        AnlagengruppeCustomBean old = this.anlagengruppe;
        this.anlagengruppe = anlagengruppe;
        this.propertyChangeSupport.firePropertyChange(PROP__ANLAGENGRUPPE, (Object)old, (Object)this.anlagengruppe);
    }

    public CidsBean persist() throws Exception {
        if (this.getLaufendeNummer() == null) {
            this.determineNextLaufendenummer(1);
        }
        this.setLeuchtenPropertiesDependingOnStandort();
        TdtaStandortMastCustomBean standort = (TdtaStandortMastCustomBean)super.persist();
        for (TdtaLeuchtenCustomBean leuchte : this.leuchten) {
            leuchte.setFk_standort(standort);
            leuchte.persist();
        }
        for (TdtaLeuchtenCustomBean leuchte : this.removedLeuchten) {
            if (leuchte.getFk_standort() != null) continue;
            leuchte.persist();
        }
        this.removedLeuchten.clear();
        return standort;
    }

    private void determineNextLaufendenummer(Integer minimalNumber) throws ActionNotSuccessfulException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"determine next laufendenummer");
        }
        String strassenschluessel = null;
        if ((this.getStrassenschluessel() == null || (strassenschluessel = this.getStrassenschluessel().getPk()) == null) && LOG.isDebugEnabled()) {
            LOG.debug((Object)"strassenschluessel must be != null");
        }
        Integer kennziffer = null;
        if ((this.getKennziffer() == null || (kennziffer = this.getKennziffer().getKennziffer()) == null) && LOG.isDebugEnabled()) {
            LOG.debug((Object)"kennziffer must be != null");
        }
        if (kennziffer != null && strassenschluessel != null) {
            try {
                Integer highestNumber;
                List highestNumbers = (List)CidsBroker.getInstance().executeServerSearch((CidsServerSearch)new HighestLfdNummerSearch(strassenschluessel, kennziffer));
                Integer n = highestNumber = highestNumbers.isEmpty() ? null : (Integer)highestNumbers.get(0);
                if (highestNumber == null) {
                    if (minimalNumber > -1) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("there is no highest laufende nummer using minimal: " + minimalNumber));
                        }
                        this.setLaufendeNummer(minimalNumber);
                    } else {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"there is no highest laufende nummer and no minimalNumber using 0.");
                        }
                        this.setLaufendeNummer(0);
                    }
                } else {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("the highest laufende nummer is: " + highestNumber));
                    }
                    if (minimalNumber > -1 && minimalNumber > highestNumber) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Minimal " + minimalNumber + " is greater than highest number using minimal number"));
                        }
                        this.setLaufendeNummer(minimalNumber);
                    } else {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Minimal is -1 or smaller than highest number: " + minimalNumber));
                            LOG.debug((Object)"using highestnumber +1 ");
                        }
                        this.setLaufendeNummer(highestNumber + 1);
                    }
                }
                return;
            }
            catch (Exception ex) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Error while querying entity", (Throwable)ex);
                }
                throw new ActionNotSuccessfulException("Error while querying highest laufendenummer", (Throwable)ex);
            }
        }
        throw new ActionNotSuccessfulException("Not possible to determine laufendenummer kennziffer and strassenschl\u00fcssel of standort must be set.");
    }

    private void setLeuchtenPropertiesDependingOnStandort() {
        Collection<TdtaLeuchtenCustomBean> leuchten = this.getLeuchten();
        if (leuchten != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Setting properties of Leuchte.");
            }
            for (TdtaLeuchtenCustomBean curLeuchte : leuchten) {
                if (this.isStandortMast()) {
                    curLeuchte.setStrassenschluessel(this.getStrassenschluessel());
                    curLeuchte.setKennziffer(this.getKennziffer());
                }
                curLeuchte.setLaufendeNummer(this.getLaufendeNummer());
            }
        }
    }

    @Override
    public int compareTo(WorkbenchEntity o) {
        if (o instanceof TdtaStandortMastCustomBean) {
            TdtaStandortMastCustomBean s = (TdtaStandortMastCustomBean)o;
            if (!this.isStandortMast()) {
                return -1;
            }
            if (!s.isStandortMast()) {
                return 1;
            }
            if (this.getStrassenschluessel() != null && s.getStrassenschluessel() != null) {
                int result = this.getStrassenschluessel().compareTo(s.getStrassenschluessel());
                if (result == 0) {
                    if (this.getKennziffer() != null && s.getKennziffer() != null) {
                        result = this.getKennziffer().compareTo(s.getKennziffer());
                        if (result == 0) {
                            if (this.getLaufendeNummer() != null && s.getLaufendeNummer() != null) {
                                int lfdNumComp = this.getLaufendeNummer().compareTo(s.getLaufendeNummer());
                                return lfdNumComp == 0 ? 1 : lfdNumComp;
                            }
                            if (this.getLaufendeNummer() != null) {
                                return 1;
                            }
                            return -1;
                        }
                        return result == 0 ? 1 : result;
                    }
                    if (this.getKennziffer() != null) {
                        return 1;
                    }
                    return -1;
                }
                return result == 0 ? 1 : result;
            }
            if (this.getStrassenschluessel() != null) {
                return 1;
            }
            return -1;
        }
        return EntityComparator.compareTypes(this, o);
    }

    @Override
    public String getKeyString() {
        return new TdtaStandortMastToStringConverter().getKeyString((CidsBean)this);
    }

    @Override
    public String getHumanReadablePosition() {
        return new TdtaStandortMastToStringConverter().getHumanReadablePosition((CidsBean)this);
    }

    static {
        LOG = Logger.getLogger(TdtaStandortMastCustomBean.class);
    }
}

