/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.commons.server.entity;

import Sirius.server.localserver.attribute.ObjectAttribute;
import Sirius.server.middleware.types.MetaObject;
import de.cismet.cids.dynamics.CidsBean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class BaseEntity
extends CidsBean {
    private static final Logger LOG = Logger.getLogger(BaseEntity.class);
    protected static final String PROP__ID = "id";
    private static int NEXT_NEW_ID = -1;
    private final Collection<String> propertyNames = new ArrayList<String>();
    private final Map<String, Object> backupProperties = new HashMap<String, Object>();
    private boolean editAllowed = false;
    private Integer id;

    public BaseEntity() {
        this.addPropertyName(PROP__ID);
    }

    private static int getNextNewId() {
        return NEXT_NEW_ID--;
    }

    protected static BaseEntity createNew(String tableName) {
        try {
            BaseEntity entity = (BaseEntity)CidsBean.createNewCidsBeanFromTableName((String)"BELIS2", (String)tableName);
            int nextId = BaseEntity.getNextNewId();
            entity.setId(nextId);
            entity.getMetaObject().setID(nextId);
            entity.setEditAllowed(true);
            return entity;
        }
        catch (Exception ex) {
            LOG.error((Object)("error creating " + tableName + " bean"), (Throwable)ex);
            return null;
        }
    }

    public boolean isEditAllowed() {
        return this.editAllowed;
    }

    public void init() {
    }

    public void setEditAllowed(boolean editAllowed) {
        this.editAllowed = this.editAllowed || editAllowed;
    }

    public Integer getId() {
        return this.id == null || this.id < 0 ? null : this.id;
    }

    public void setId(Integer id) {
        Integer old = this.id;
        this.id = id;
        this.propertyChangeSupport.firePropertyChange(PROP__ID, old, this.id);
    }

    public int hashCode() {
        if (this.getId() == null) {
            return System.identityHashCode((Object)this);
        }
        return this.getId().hashCode();
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof BaseEntity)) {
            return false;
        }
        if (this == other) {
            return true;
        }
        BaseEntity otherBE = (BaseEntity)((Object)other);
        if (this.getId() == null || otherBE.getId() == null) {
            return false;
        }
        if (otherBE.getMetaObject().getMetaClass().equals((Object)this.getMetaObject().getMetaClass())) {
            return otherBE.getId().equals(this.getId());
        }
        return false;
    }

    public void storeBackup() {
        this.backupProperties.clear();
        for (String property : this.getPropertyNames()) {
            Object object = this.getProperty(property);
            if (object instanceof Collection) {
                ArrayList collectionCopy = new ArrayList((Collection)object);
                for (Object collectionObject : collectionCopy) {
                    if (!(collectionObject instanceof BaseEntity)) continue;
                    ((BaseEntity)((Object)collectionObject)).storeBackup();
                }
                this.backupProperties.put(property, collectionCopy);
                continue;
            }
            if (object instanceof BaseEntity) {
                ((BaseEntity)((Object)object)).storeBackup();
            }
            this.backupProperties.put(property, object);
        }
    }

    public void loadBackup() {
        MetaObject mo = this.getMetaObject();
        for (String property : this.getPropertyNames()) {
            ObjectAttribute oa = mo.getAttributeByFieldName(property);
            if (oa == null || !oa.isChanged()) continue;
            Object object = this.backupProperties.get(property);
            if (object instanceof Collection) {
                Collection collectionCopy = (Collection)object;
                this.getBeanCollectionProperty(property).clear();
                for (Object collectionObject : collectionCopy) {
                    if (!(collectionObject instanceof BaseEntity)) continue;
                    ((BaseEntity)((Object)collectionObject)).loadBackup();
                    try {
                        this.getBeanCollectionProperty(property).add((BaseEntity)((Object)collectionObject));
                    }
                    catch (Exception ex) {
                        LOG.error((Object)"error while setting collection copy", (Throwable)ex);
                    }
                }
                continue;
            }
            if (object instanceof BaseEntity) {
                ((BaseEntity)((Object)object)).loadBackup();
            }
            try {
                this.setProperty(property, object);
            }
            catch (Exception ex) {
                LOG.error((Object)"error while setting object copy", (Throwable)ex);
            }
        }
    }

    public String[] getPropertyNames() {
        return this.propertyNames.toArray(new String[0]);
    }

    protected final void addPropertyName(String propertyName) {
        this.propertyNames.add(propertyName);
    }

    protected final void addPropertyNames(String[] propertyNames) {
        this.propertyNames.addAll(Arrays.asList(propertyNames));
    }
}

