/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package de.cismet.belis.gui.widget;

import Sirius.navigator.actiontag.ActionTagProtected;

import org.apache.log4j.Logger;

import org.openide.util.Lookup;

import java.util.Collection;

import de.cismet.belis.broker.BelisBroker;

import de.cismet.belis.gui.widget.windowsearchwidget.BelisEntityWindowSearch;
import de.cismet.belis.gui.widget.windowsearchwidget.BelisWindowSearch;

/**
 * DOCUMENT ME!
 *
 * @author   jruiz
 * @version  $Revision$, $Date$
 */
@org.openide.util.lookup.ServiceProvider(service = BelisWidget.class)
public class WindowSearchWidget extends BelisWidget {

    //~ Static fields/initializers ---------------------------------------------

    private static final Logger LOG = Logger.getLogger(WindowSearchWidget.class);

    //~ Instance fields --------------------------------------------------------

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTabbedPane jTabbedPane1;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates new form MetaCatalogueTreeWidget.
     */
    public WindowSearchWidget() {
        setWidgetName("Suchen");
    }

    //~ Methods ----------------------------------------------------------------

    @Override
    public void setBroker(final BelisBroker broker) {
        initComponents();

        final Collection<? extends BelisWindowSearch> windowSearches = Lookup.getDefault()
                    .lookupAll(BelisWindowSearch.class);

        if (!windowSearches.isEmpty()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Initializing " + windowSearches.size() + " window searches.");
            }
            for (final BelisWindowSearch windowSearch : windowSearches) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Initializing window search '" + windowSearch.getName() + "'.");
                }
                if (checkActionTag(windowSearch)) {
                    jTabbedPane1.addTab(windowSearch.getName(), windowSearch.getSearchWindowComponent());
                } else {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Could not initialize window search '" + windowSearch.getName()
                                    + "' due to restricted permissions.");
                    }
                }
            }
            revalidate();
            repaint();
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @param   toCheck  DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    private boolean checkActionTag(final Object toCheck) {
        if (toCheck instanceof ActionTagProtected) {
            final ActionTagProtected atp = (ActionTagProtected)toCheck;
            return atp.checkActionTag();
        }
        return true;
    }

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        jTabbedPane1 = new javax.swing.JTabbedPane();

        setLayout(new java.awt.BorderLayout());
        add(jTabbedPane1, java.awt.BorderLayout.CENTER);
    } // </editor-fold>//GEN-END:initComponents
}
