/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package de.cismet.belis.gui.widget.detailWidgetPanels;

import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.swingx.JXTable;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

import de.cismet.belis.broker.BelisBroker;

import de.cismet.belis.gui.DateToStringConverter;

import de.cismet.belis.util.RendererTools;

import de.cismet.cids.custom.beans.belis2.ArbeitsauftragCustomBean;
import de.cismet.cids.custom.beans.belis2.ArbeitsprotokollCustomBean;
import de.cismet.cids.custom.beans.belis2.ArbeitsprotokollstatusCustomBean;
import de.cismet.cids.custom.beans.belis2.TdtaStandortMastCustomBean;
import de.cismet.cids.custom.beans.belis2.TeamCustomBean;

import de.cismet.commons.architecture.validation.Validatable;

import de.cismet.commons.server.entity.WorkbenchEntity;

/**
 * DOCUMENT ME!
 *
 * @author   Gilles Baatz
 * @version  $Revision$, $Date$
 */
public class ArbeitsauftragPanel extends AbstractDetailWidgetPanel<ArbeitsauftragCustomBean>
        implements ListSelectionListener {

    //~ Static fields/initializers ---------------------------------------------

    private static final org.apache.log4j.Logger LOG = org.apache.log4j.Logger.getLogger(ArbeitsauftragPanel.class);

    private static final String[] COLUMN_NAMES = {
            "#",
            "Herkunft",
            "Fachobjekt",
            "Kennzeichnung",
            "Bearbeiter",
            "Position",
            "Status"
        };

    private static final Class[] COLUMN_CLASSES = {
            Integer.class,
            String.class,
            String.class,
            String.class,
            String.class,
            String.class,
            String.class,
        };

    //~ Instance fields --------------------------------------------------------

    private boolean isEditable = false;

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private de.cismet.belis.gui.widget.detailWidgetPanels.ArbeitsprotokollPanel arbeitsprotokollPanel1;
    private javax.swing.JComboBox cbxZugewiesenAn;
    private javax.swing.JButton jButton10;
    private javax.swing.JButton jButton2;
    private javax.swing.JButton jButton3;
    private javax.swing.JButton jButton8;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel14;
    private javax.swing.JPanel jPanel18;
    private javax.swing.JPanel jPanel19;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JSeparator jSeparator1;
    private javax.swing.JSplitPane jSplitPane1;
    private javax.swing.JTable jTable1;
    private javax.swing.JLabel lblArbeitsauftrag;
    private javax.swing.JLabel lblDatum;
    private javax.swing.JLabel lblDatumValue;
    private javax.swing.JLabel lblNummer;
    private javax.swing.JLabel lblNummerValue;
    private javax.swing.JLabel lblUser;
    private javax.swing.JLabel lblUserValue;
    private javax.swing.JLabel lblZugewiesenAn;
    private org.jdesktop.beansbinding.BindingGroup bindingGroup;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates new form LeuchtePanel.
     */
    public ArbeitsauftragPanel() {
        super("ARBEITSAUFTRAG_PANEL");
        initComponents();
        initComponentToLabelMap();
        initPanel();
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    @Override
    public JLabel getTabLabel() {
        return lblArbeitsauftrag;
    }

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;
        bindingGroup = new org.jdesktop.beansbinding.BindingGroup();

        lblArbeitsauftrag = new javax.swing.JLabel();
        jSplitPane1 = new javax.swing.JSplitPane();
        jPanel4 = new javax.swing.JPanel();
        jPanel3 = new javax.swing.JPanel();
        jPanel2 = new javax.swing.JPanel();
        jPanel14 = new javax.swing.JPanel();
        jButton2 = new javax.swing.JButton();
        jButton3 = new javax.swing.JButton();
        jPanel18 = new javax.swing.JPanel();
        jPanel19 = new javax.swing.JPanel();
        jButton8 = new javax.swing.JButton();
        jButton10 = new javax.swing.JButton();
        jScrollPane2 = new javax.swing.JScrollPane();
        jTable1 = new JXTable();
        lblNummer = new javax.swing.JLabel();
        lblUserValue = new javax.swing.JLabel();
        lblDatum = new javax.swing.JLabel();
        lblUser = new javax.swing.JLabel();
        jSeparator1 = new javax.swing.JSeparator();
        lblDatumValue = new javax.swing.JLabel();
        jPanel1 = new javax.swing.JPanel();
        lblNummerValue = new javax.swing.JLabel();
        lblZugewiesenAn = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        cbxZugewiesenAn = BelisBroker.createKeyTableComboBox(
                TeamCustomBean.TABLE,
                "<html><i>Wert auswählen...</i></html>",
                false);
        arbeitsprotokollPanel1 = new de.cismet.belis.gui.widget.detailWidgetPanels.ArbeitsprotokollPanel();

        lblArbeitsauftrag.setFont(new java.awt.Font("DejaVu Sans", 1, 13));                       // NOI18N
        lblArbeitsauftrag.setIcon(new javax.swing.ImageIcon(
                getClass().getResource("/de/cismet/belis/resource/icon/16/arbeitsauftrag.png"))); // NOI18N
        lblArbeitsauftrag.setText("Arbeitsauftrag");                                              // NOI18N

        setLayout(new java.awt.GridBagLayout());

        jSplitPane1.setBorder(null);
        jSplitPane1.setOrientation(javax.swing.JSplitPane.VERTICAL_SPLIT);

        jPanel4.setLayout(new java.awt.GridBagLayout());

        jPanel3.setLayout(new java.awt.GridBagLayout());

        jPanel2.setLayout(new java.awt.GridBagLayout());
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel2.add(jPanel14, gridBagConstraints);

        jButton2.setIcon(new javax.swing.ImageIcon(getClass().getResource("/de/cismet/cids/search/arrow-090.png"))); // NOI18N
        jButton2.setText(org.openide.util.NbBundle.getMessage(
                ArbeitsauftragPanel.class,
                "ArbeitsauftragPanel.jButton2.text"));                                                               // NOI18N
        jButton2.setToolTipText(org.openide.util.NbBundle.getMessage(
                ArbeitsauftragPanel.class,
                "ArbeitsauftragPanel.jButton2.toolTipText"));                                                        // NOI18N
        jButton2.setBorderPainted(false);
        jButton2.setContentAreaFilled(false);
        jButton2.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    jButton2ActionPerformed(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        gridBagConstraints.weightx = 1.0;
        jPanel2.add(jButton2, gridBagConstraints);

        jButton3.setIcon(new javax.swing.ImageIcon(getClass().getResource("/de/cismet/cids/search/arrow-270.png"))); // NOI18N
        jButton3.setText(org.openide.util.NbBundle.getMessage(
                ArbeitsauftragPanel.class,
                "ArbeitsauftragPanel.jButton3.text"));                                                               // NOI18N
        jButton3.setToolTipText(org.openide.util.NbBundle.getMessage(
                ArbeitsauftragPanel.class,
                "ArbeitsauftragPanel.jButton3.toolTipText"));                                                        // NOI18N
        jButton3.setBorderPainted(false);
        jButton3.setContentAreaFilled(false);
        jButton3.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    jButton3ActionPerformed(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        gridBagConstraints.weightx = 1.0;
        jPanel2.add(jButton3, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel2.add(jPanel18, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel2.add(jPanel19, gridBagConstraints);

        jButton8.setIcon(new javax.swing.ImageIcon(
                getClass().getResource("/de/cismet/cids/search/arrow-stop-090.png"))); // NOI18N
        jButton8.setText(org.openide.util.NbBundle.getMessage(
                ArbeitsauftragPanel.class,
                "ArbeitsauftragPanel.jButton8.text"));                                 // NOI18N
        jButton8.setToolTipText(org.openide.util.NbBundle.getMessage(
                ArbeitsauftragPanel.class,
                "ArbeitsauftragPanel.jButton8.toolTipText"));                          // NOI18N
        jButton8.setBorderPainted(false);
        jButton8.setContentAreaFilled(false);
        jButton8.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    jButton8ActionPerformed(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        jPanel2.add(jButton8, gridBagConstraints);
        jButton8.setVisible(false);

        jButton10.setIcon(new javax.swing.ImageIcon(
                getClass().getResource("/de/cismet/cids/search/arrow-stop-270.png"))); // NOI18N
        jButton10.setText(org.openide.util.NbBundle.getMessage(
                ArbeitsauftragPanel.class,
                "ArbeitsauftragPanel.jButton10.text"));                                // NOI18N
        jButton10.setToolTipText(org.openide.util.NbBundle.getMessage(
                ArbeitsauftragPanel.class,
                "ArbeitsauftragPanel.jButton10.toolTipText"));                         // NOI18N
        jButton10.setBorderPainted(false);
        jButton10.setContentAreaFilled(false);
        jButton10.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    jButton10ActionPerformed(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        jPanel2.add(jButton10, gridBagConstraints);
        jButton10.setVisible(false);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.VERTICAL;
        gridBagConstraints.weighty = 1.0;
        jPanel3.add(jPanel2, gridBagConstraints);

        jScrollPane2.setMinimumSize(new java.awt.Dimension(17, 120));
        jScrollPane2.setPreferredSize(new java.awt.Dimension(450, 120));

        jTable1.setModel(new ProtokolleTableModel());
        jTable1.setSelectionMode(javax.swing.ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
        jScrollPane2.setViewportView(jTable1);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel3.add(jScrollPane2, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel4.add(jPanel3, gridBagConstraints);

        lblNummer.setText("Auftragsnummer:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_END;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        jPanel4.add(lblNummer, gridBagConstraints);

        org.jdesktop.beansbinding.Binding binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${currentEntity.angelegt_von}"),
                lblUserValue,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        jPanel4.add(lblUserValue, gridBagConstraints);

        lblDatum.setText("angelegt am:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_END;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        jPanel4.add(lblDatum, gridBagConstraints);

        lblUser.setText("angelegt von:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_END;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        jPanel4.add(lblUser, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 6.0;
        jPanel4.add(jSeparator1, gridBagConstraints);

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${currentEntity.angelegt_am}"),
                lblDatumValue,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        binding.setConverter(new DateToStringConverter());
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        jPanel4.add(lblDatumValue, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        jPanel4.add(jPanel1, gridBagConstraints);

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${currentEntity.nummer}"),
                lblNummerValue,
                org.jdesktop.beansbinding.BeanProperty.create("text"),
                "nummer");
        binding.setSourceNullValue("00000000");
        binding.setSourceUnreadableValue("00000000");
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_END;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        jPanel4.add(lblNummerValue, gridBagConstraints);

        lblZugewiesenAn.setText("Zugewiesen an:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_END;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        jPanel4.add(lblZugewiesenAn, gridBagConstraints);

        jLabel2.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        jLabel2.setText("Protokolle:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 6.0;
        gridBagConstraints.insets = new java.awt.Insets(20, 5, 5, 5);
        jPanel4.add(jLabel2, gridBagConstraints);

        cbxZugewiesenAn.setEnabled(false);

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${currentEntity.zugewiesen_an}"),
                cbxZugewiesenAn,
                org.jdesktop.beansbinding.BeanProperty.create("selectedItem"));
        binding.setSourceNullValue(null);
        binding.setSourceUnreadableValue(null);
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.FIRST_LINE_START;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        jPanel4.add(cbxZugewiesenAn, gridBagConstraints);

        jSplitPane1.setTopComponent(jPanel4);
        jSplitPane1.setBottomComponent(arbeitsprotokollPanel1);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        add(jSplitPane1, gridBagConstraints);

        bindingGroup.bind();
    } // </editor-fold>//GEN-END:initComponents

    /**
     * DOCUMENT ME!
     *
     * @param  newSelectedIndices  DOCUMENT ME!
     */
    private void setProtokollSelection(final int[] newSelectedIndices) {
        int viewIndex = -1;
        jTable1.getSelectionModel().setValueIsAdjusting(true);
        jTable1.getSelectionModel().clearSelection();
        for (final int newSelectedIndex : newSelectedIndices) {
            final int index = newSelectedIndex;
            viewIndex = jTable1.convertRowIndexToView(index);
            jTable1.getSelectionModel().addSelectionInterval(viewIndex, viewIndex);
        }
        jTable1.getSelectionModel().setValueIsAdjusting(false);
        jTable1.scrollRectToVisible(jTable1.getCellRect(viewIndex, 0, true));
    }

    @Override
    public int getStatus() {
        final List<String> veranlassungen = new ArrayList<String>(currentEntity.getAr_protokolle().size());
        boolean error = false;
        for (final ArbeitsprotokollCustomBean protokoll : currentEntity.getSortedProtokolle()) {
            final String nummer = protokoll.getVeranlassungsnummer();
            if (veranlassungen.contains(nummer)
                        && ((nummer == null) ? (veranlassungen.get(veranlassungen.size() - 1) != null)
                                             : (!nummer.equals(veranlassungen.get(veranlassungen.size() - 1))))) {
                error = true;
                break;
            } else {
                veranlassungen.add(nummer);
            }
        }
        if (error) {
            setValidationMessage("Nicht gruppierte Veranlassungen im Arbeitsauftrag " + currentEntity.getNummer()
                        + " (selbe Herkunft mehrfach vorhanden, aber nicht aufeinanderfolgend).");
            return Validatable.ERROR;
        } else {
            return Validatable.VALID;
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void jButton2ActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_jButton2ActionPerformed
        final int[] selectedIndices = jTable1.getSelectedRows();
        if ((selectedIndices.length > 0) && (jTable1.convertRowIndexToModel(selectedIndices[0]) > 0)) {
            final List<ArbeitsprotokollCustomBean> sortedProtokolle = currentEntity.getSortedProtokolle();

            final int[] newSelectedIndices = new int[selectedIndices.length];
            for (int index = 0; index < selectedIndices.length; index++) {
                final int selectedIndex = jTable1.convertRowIndexToModel(selectedIndices[index]);
                final int newIndex = selectedIndex - 1;
                newSelectedIndices[index] = newIndex;

                sortedProtokolle.get(selectedIndex).setProtokollnummer(newIndex + 1);
                sortedProtokolle.get(newIndex).setProtokollnummer(selectedIndex + 1);

                Collections.swap(sortedProtokolle, selectedIndex, newIndex);
            }

            setProtokollSelection(newSelectedIndices);
        }
    } //GEN-LAST:event_jButton2ActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void jButton3ActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_jButton3ActionPerformed
        final int[] selectedIndices = jTable1.getSelectedRows();
        if ((selectedIndices.length > 0)
                    && (jTable1.convertRowIndexToModel(selectedIndices[selectedIndices.length - 1])
                        < (currentEntity.getSortedProtokolle().size() - 1))) {
            final int[] newSelectedIndices = new int[selectedIndices.length];

            final List<ArbeitsprotokollCustomBean> sortedProtokolle = currentEntity.getSortedProtokolle();
            for (int index = selectedIndices.length - 1; index >= 0; index--) {
                final int selectedIndex = jTable1.convertRowIndexToModel(selectedIndices[index]);
                final int newIndex = selectedIndex + 1;
                newSelectedIndices[index] = newIndex;

                sortedProtokolle.get(selectedIndex).setProtokollnummer(newIndex + 1);
                sortedProtokolle.get(newIndex).setProtokollnummer(selectedIndex + 1);

                Collections.swap(sortedProtokolle, selectedIndex, newIndex);
            }

            setProtokollSelection(newSelectedIndices);
        }
    } //GEN-LAST:event_jButton3ActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void jButton8ActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_jButton8ActionPerformed
        final int[] selectedIndices = jTable1.getSelectedRows();
        if ((selectedIndices.length > 0) && (jTable1.convertRowIndexToModel(selectedIndices[0]) > 0)) {
            final int[] newSelectedIndices = new int[selectedIndices.length];

            final List<ArbeitsprotokollCustomBean> sortedProtokolle = currentEntity.getSortedProtokolle();
            for (int index = 0; index < selectedIndices.length; index++) {
                final int selectedIndex = jTable1.convertRowIndexToModel(selectedIndices[index]);
                final int newIndex = index;
                newSelectedIndices[index] = newIndex;

                sortedProtokolle.get(selectedIndex).setProtokollnummer(newIndex + 1);
                sortedProtokolle.get(newIndex).setProtokollnummer(selectedIndex + 1);

                Collections.swap(sortedProtokolle, selectedIndex, newIndex);
            }

            setProtokollSelection(newSelectedIndices);
        }
    } //GEN-LAST:event_jButton8ActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void jButton10ActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_jButton10ActionPerformed
        final int[] selectedIndices = jTable1.getSelectedRows();
        if ((selectedIndices.length > 0)
                    && (jTable1.convertRowIndexToModel(selectedIndices[selectedIndices.length - 1])
                        < (currentEntity.getSortedProtokolle().size() - 1))) {
            final int[] newSelectedIndices = new int[selectedIndices.length];

            final List<ArbeitsprotokollCustomBean> sortedProtokolle = currentEntity.getSortedProtokolle();
            for (int index = selectedIndices.length - 1; index >= 0; index--) {
                final int selectedIndex = jTable1.convertRowIndexToModel(selectedIndices[index]);
                final int newIndex = sortedProtokolle.size() - index - 1;
                newSelectedIndices[index] = newIndex;

                sortedProtokolle.get(selectedIndex).setProtokollnummer(newIndex + 1);
                sortedProtokolle.get(newIndex).setProtokollnummer(selectedIndex + 1);

                Collections.swap(sortedProtokolle, selectedIndex, newIndex);
            }

            setProtokollSelection(newSelectedIndices);
        }
    } //GEN-LAST:event_jButton10ActionPerformed

    /**
     * DOCUMENT ME!
     */
    @Override
    final void initPanel() {
//        AutoCompleteDecorator.decorate(cbxZugewiesenAn);
//        cbxZugewiesenAn.addActionListener(new ActionListener() {
//
//                @Override
//                public void actionPerformed(final ActionEvent e) {
//                    if (cbxZugewiesenAn.getSelectedItem() == null) {
//                        ((ComboBoxEditorTextField)cbxZugewiesenAn.getEditor().getEditorComponent()).setText("");
//                    }
//                }
//            });
    }

    /**
     * DOCUMENT ME!
     *
     * @param  protokolle  DOCUMENT ME!
     */
    public void setSelectedProtokolle(final Collection<ArbeitsprotokollCustomBean> protokolle) {
        int viewIndex = -1;
        jTable1.getSelectionModel().setValueIsAdjusting(true);
        jTable1.getSelectionModel().clearSelection();
        for (final ArbeitsprotokollCustomBean protokoll : protokolle) {
            final int index = ((ProtokolleTableModel)jTable1.getModel()).getIndexByProtokoll(protokoll);
            viewIndex = jTable1.convertRowIndexToView(index);
            jTable1.getSelectionModel().addSelectionInterval(viewIndex, viewIndex);
        }
        jTable1.getSelectionModel().setValueIsAdjusting(false);
        jTable1.scrollRectToVisible(jTable1.getCellRect(viewIndex, 0, true));
    }

    /**
     * DOCUMENT ME!
     */
    @Override
    public void commitEdits() {
    }

    /**
     * DOCUMENT ME!
     */
    @Override
    final void initComponentToLabelMap() {
        componentToLabelMap.put(lblUserValue, lblUser);
        componentToLabelMap.put(lblDatumValue, lblDatum);

        jTable1.getSelectionModel().addListSelectionListener(this);
    }

    /**
     * DOCUMENT ME!
     */
    @Override
    public void setElementsNull() {
    }

    /**
     * DOCUMENT ME!
     *
     * @param  isEditable  DOCUMENT ME!
     */
    @Override
    public void setPanelEditable(final boolean isEditable) {
        RendererTools.setEditable(cbxZugewiesenAn, isEditable);
        jButton10.setEnabled(isEditable);
        jButton2.setEnabled(isEditable);
        jButton3.setEnabled(isEditable);
        jButton8.setEnabled(isEditable);
        arbeitsprotokollPanel1.setPanelEditable(isEditable && !getSelectedProtokolle().isEmpty());
        this.isEditable = isEditable;
    }

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    @Override
    protected BindingGroup getBindingGroup() {
        return bindingGroup;
    }

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    public Collection<ArbeitsprotokollCustomBean> getSelectedProtokolle() {
        final int[] selection = jTable1.getSelectedRows();
        final int[] modelSelection = new int[selection.length];

        final Collection<ArbeitsprotokollCustomBean> protokolle = new ArrayList<ArbeitsprotokollCustomBean>();
        for (int index = 0; index < selection.length; ++index) {
            modelSelection[index] = jTable1.convertRowIndexToModel(selection[index]);
            final ArbeitsprotokollCustomBean protokoll = ((ProtokolleTableModel)jTable1.getModel()).getProtokollByIndex(
                    modelSelection[index]);
            protokolle.add(protokoll);
        }
        return protokolle;
    }

    /**
     * DOCUMENT ME!
     *
     * @param  e  DOCUMENT ME!
     */
    @Override
    public void valueChanged(final ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            jTable1.getSelectionModel().removeListSelectionListener(this);
            try {
                final Collection<ArbeitsprotokollCustomBean> protokolle = getSelectedProtokolle();

                if (!protokolle.isEmpty()) {
                    BelisBroker.getInstance().getWorkbenchWidget().selectUserObjects(protokolle);
                    SwingUtilities.invokeLater(new Runnable() {

                            @Override
                            public void run() {
                                jTable1.requestFocus();
                            }
                        });

                    arbeitsprotokollPanel1.setCurrentEntities(currentEntity, protokolle);
                    arbeitsprotokollPanel1.setPanelEditable(isEditable);
                } else {
                    final Collection col = new ArrayList();
                    col.add(currentEntity);
                    BelisBroker.getInstance().getWorkbenchWidget().selectUserObjects(col);
                    arbeitsprotokollPanel1.setCurrentEntity(null);
                    arbeitsprotokollPanel1.setPanelEditable(false);
                }
            } finally {
                jTable1.getSelectionModel().addListSelectionListener(this);
            }
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @param  currentEntity  DOCUMENT ME!
     */
    @Override
    public void setCurrentEntity(final ArbeitsauftragCustomBean currentEntity) {
        super.setCurrentEntity(currentEntity);
        ((ProtokolleTableModel)jTable1.getModel()).fireTableDataChanged();

        if (currentEntity != null) {
            final Object o = currentEntity.getZugewiesen_an();
            if (o == null) {
                cbxZugewiesenAn.setSelectedItem(null);
                cbxZugewiesenAn.getEditor();
            }
        }
    }

    //~ Inner Classes ----------------------------------------------------------

    /**
     * DOCUMENT ME!
     *
     * @version  $Revision$, $Date$
     */
    class ProtokolleTableModel extends AbstractTableModel {

        //~ Methods ------------------------------------------------------------

        /**
         * DOCUMENT ME!
         *
         * @return  DOCUMENT ME!
         */
        @Override
        public int getRowCount() {
            if (currentEntity == null) {
                return 0;
            }
            return currentEntity.getSortedProtokolle().size();
        }

        /**
         * DOCUMENT ME!
         *
         * @return  DOCUMENT ME!
         */
        @Override
        public int getColumnCount() {
            return COLUMN_NAMES.length;
        }

        /**
         * DOCUMENT ME!
         *
         * @param   rowIndex     DOCUMENT ME!
         * @param   columnIndex  DOCUMENT ME!
         *
         * @return  DOCUMENT ME!
         */
        @Override
        public Object getValueAt(final int rowIndex, final int columnIndex) {
            final ArbeitsprotokollCustomBean protokoll = getProtokollByIndex(rowIndex);
            if (protokoll == null) {
                return null;
            }

            final ArbeitsprotokollstatusCustomBean status = protokoll.getFk_status();
            final WorkbenchEntity entity;
            final String entityName;
            if (protokoll.getFk_abzweigdose() != null) {
                entity = protokoll.getFk_abzweigdose();
                entityName = "Abzweigdose";
            } else if (protokoll.getFk_geometrie() != null) {
                entity = protokoll.getFk_geometrie();
                entityName = "Geometrie";
            } else if (protokoll.getFk_leitung() != null) {
                entity = protokoll.getFk_leitung();
                entityName = "Leitung";
            } else if (protokoll.getFk_leuchte() != null) {
                entity = protokoll.getFk_leuchte();
                entityName = "Leuchte";
            } else if (protokoll.getFk_mauerlasche() != null) {
                entity = protokoll.getFk_mauerlasche();
                entityName = "Mauerlasche";
            } else if (protokoll.getFk_schaltstelle() != null) {
                entity = protokoll.getFk_schaltstelle();
                entityName = "Schaltstelle";
            } else if (protokoll.getFk_standort() != null) {
                entity = protokoll.getFk_standort();
                if (((TdtaStandortMastCustomBean)entity).isStandortMast()) {
                    entityName = "Mast";
                } else {
                    entityName = "Standort";
                }
            } else {
                entity = null;
                entityName = null;
            }

            switch (columnIndex) {
                case 0: {
                    return protokoll.getProtokollnummer();
                }
                case 1: {
                    return protokoll.getVeranlassungsschluessel();
                }
                case 2: {
                    if (entityName != null) {
                        final String prefix = ((entity != null) && entity.isDeleted()) ? "<html><strike>" : "";
                        return prefix + entityName;
                    } else {
                        return null;
                    }
                }
                case 3: {
                    if (entity != null) {
                        return entity.getKeyString();
                    } else {
                        return null;
                    }
                }
                case 4: {
                    return protokoll.getMonteur();
                }
                case 5: {
                    if (entity != null) {
                        return entity.getHumanReadablePosition();
                    } else {
                        return null;
                    }
                }
                case 6: {
                    if (status != null) {
                        return status.getBezeichnung();
                    } else {
                        return null;
                    }
                }
                default: {
                    return null;
                }
            }
        }

        /**
         * DOCUMENT ME!
         *
         * @param   columnIndex  DOCUMENT ME!
         *
         * @return  DOCUMENT ME!
         */
        @Override
        public String getColumnName(final int columnIndex) {
            return COLUMN_NAMES[columnIndex];
        }

        /**
         * DOCUMENT ME!
         *
         * @param   columnIndex  DOCUMENT ME!
         *
         * @return  DOCUMENT ME!
         */
        @Override
        public Class<?> getColumnClass(final int columnIndex) {
            return COLUMN_CLASSES[columnIndex];
        }

        /**
         * DOCUMENT ME!
         *
         * @param   protokoll  DOCUMENT ME!
         *
         * @return  DOCUMENT ME!
         */
        public int getIndexByProtokoll(final ArbeitsprotokollCustomBean protokoll) {
            if (currentEntity == null) {
                return -1;
            }
            try {
                return currentEntity.getSortedProtokolle().indexOf(protokoll);
            } catch (Exception e) {
                LOG.error("error in getIndexByProtokoll(). will return -1", e);
                return -1;
            }
        }

        /**
         * DOCUMENT ME!
         *
         * @param   modelIndex  DOCUMENT ME!
         *
         * @return  DOCUMENT ME!
         */
        public ArbeitsprotokollCustomBean getProtokollByIndex(final int modelIndex) {
            if (currentEntity == null) {
                return null;
            }
            try {
                return currentEntity.getSortedProtokolle().get(modelIndex);
            } catch (Exception e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("ArbeitsprotokollCustomBean at index " + modelIndex + " not found. will return null", e);
                }
                return null;
            }
        }
    }
}
