/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package de.cismet.belis.gui.widget.detailWidgetPanels;

import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.swingx.autocomplete.AutoCompleteDecorator;

import java.text.ParseException;

import javax.swing.JLabel;

import de.cismet.belis.broker.BelisBroker;

import de.cismet.belis.gui.TimestampToDateConverter;

import de.cismet.belis.util.RendererTools;

import de.cismet.cids.custom.beans.belis2.MaterialMauerlascheCustomBean;
import de.cismet.cids.custom.beans.belis2.MauerlascheCustomBean;
import de.cismet.cids.custom.beans.belis2.TkeyStrassenschluesselCustomBean;

/**
 * DOCUMENT ME!
 *
 * @author   Gilles Baatz
 * @version  $Revision$, $Date$
 */
public final class MauerlaschePanel extends AbstractDetailWidgetPanel<MauerlascheCustomBean> {

    //~ Static fields/initializers ---------------------------------------------

    private static final org.apache.log4j.Logger LOG = org.apache.log4j.Logger.getLogger(MauerlaschePanel.class);

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JComboBox cbxMaterial;
    private javax.swing.JComboBox cbxStrassenschluessel;
    private javax.swing.JComboBox cbxStrassenschluesselNr;
    private org.jdesktop.swingx.JXDatePicker dapMontage;
    private org.jdesktop.swingx.JXDatePicker dapPruefdatum;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JLabel lblBemerkung;
    private javax.swing.JLabel lblLaufendenummer;
    private javax.swing.JLabel lblMaterial;
    private javax.swing.JLabel lblMontage;
    private javax.swing.JLabel lblPruefdatum;
    private javax.swing.JLabel lblStrassenschluessel;
    private javax.swing.JPanel panContent;
    private javax.swing.JPanel panSpacer0;
    private javax.swing.JPanel panSpacer1;
    private javax.swing.JPanel panSpacerBottom;
    private javax.swing.JPanel panSpacerBottom1;
    private javax.swing.JPanel panSpacerLeft;
    private javax.swing.JPanel panStrassenschluessel;
    private javax.swing.JScrollPane scpBemerkung;
    private javax.swing.JTextArea txaMauerlascheBemerkung;
    private javax.swing.JTextField txfLaufendenummer;
    private org.jdesktop.beansbinding.BindingGroup bindingGroup;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates new form MauerlaschePanel.
     */
    public MauerlaschePanel() {
        super("MAUERLASCHE_PANEL");
        initComponents();
        initComponentToLabelMap();
        initPanel();
    }

    //~ Methods ----------------------------------------------------------------

    @Override
    public JLabel getTabLabel() {
        return jLabel2;
    }

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;
        bindingGroup = new org.jdesktop.beansbinding.BindingGroup();

        jLabel2 = new javax.swing.JLabel();
        jPanel1 = new javax.swing.JPanel();
        panContent = new javax.swing.JPanel();
        panSpacer0 = new javax.swing.JPanel();
        panSpacer1 = new javax.swing.JPanel();
        lblStrassenschluessel = new javax.swing.JLabel();
        panStrassenschluessel = new javax.swing.JPanel();
        cbxStrassenschluesselNr = BelisBroker.createStrassenschluesselNummerComboBox();
        cbxStrassenschluessel = BelisBroker.createKeyTableComboBox(TkeyStrassenschluesselCustomBean.TABLE);
        lblLaufendenummer = new javax.swing.JLabel();
        txfLaufendenummer = new javax.swing.JTextField();
        lblMontage = new javax.swing.JLabel();
        dapMontage = new org.jdesktop.swingx.JXDatePicker();
        lblMaterial = new javax.swing.JLabel();
        cbxMaterial = BelisBroker.createKeyTableComboBox(MaterialMauerlascheCustomBean.TABLE);
        lblPruefdatum = new javax.swing.JLabel();
        dapPruefdatum = new org.jdesktop.swingx.JXDatePicker();
        lblBemerkung = new javax.swing.JLabel();
        scpBemerkung = new javax.swing.JScrollPane();
        txaMauerlascheBemerkung = new javax.swing.JTextArea();
        panSpacerBottom = new javax.swing.JPanel();
        panSpacerLeft = new javax.swing.JPanel();
        panSpacerBottom1 = new javax.swing.JPanel();

        jLabel2.setFont(new java.awt.Font("DejaVu Sans", 1, 13));                              // NOI18N
        jLabel2.setIcon(new javax.swing.ImageIcon(
                getClass().getResource("/de/cismet/belis/resource/icon/16/mauerlasche.png"))); // NOI18N
        jLabel2.setText("Mauerlasche");                                                        // NOI18N

        setLayout(new java.awt.GridBagLayout());

        jPanel1.setLayout(new java.awt.GridBagLayout());

        panContent.setLayout(new java.awt.GridBagLayout());

        panSpacer0.setMinimumSize(DIMENSION_KEYSPACER);
        panSpacer0.setPreferredSize(DIMENSION_KEYSPACER);

        final javax.swing.GroupLayout panSpacer0Layout = new javax.swing.GroupLayout(panSpacer0);
        panSpacer0.setLayout(panSpacer0Layout);
        panSpacer0Layout.setHorizontalGroup(
            panSpacer0Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING).addGap(
                0,
                0,
                Short.MAX_VALUE));
        panSpacer0Layout.setVerticalGroup(
            panSpacer0Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING).addGap(
                0,
                0,
                Short.MAX_VALUE));

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        panContent.add(panSpacer0, gridBagConstraints);

        panSpacer1.setName(""); // NOI18N
        panSpacer1.setPreferredSize(new java.awt.Dimension(420, 0));

        final javax.swing.GroupLayout panSpacer1Layout = new javax.swing.GroupLayout(panSpacer1);
        panSpacer1.setLayout(panSpacer1Layout);
        panSpacer1Layout.setHorizontalGroup(
            panSpacer1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING).addGap(
                0,
                0,
                Short.MAX_VALUE));
        panSpacer1Layout.setVerticalGroup(
            panSpacer1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING).addGap(
                0,
                0,
                Short.MAX_VALUE));

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        panContent.add(panSpacer1, gridBagConstraints);

        lblStrassenschluessel.setText("Straßenschlüssel:"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panContent.add(lblStrassenschluessel, gridBagConstraints);

        panStrassenschluessel.setLayout(new java.awt.GridBagLayout());

        cbxStrassenschluesselNr.setEnabled(false);
        cbxStrassenschluesselNr.setMinimumSize(new java.awt.Dimension(80, 27));
        cbxStrassenschluesselNr.setPreferredSize(new java.awt.Dimension(80, 27));
        cbxStrassenschluesselNr.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    cbxStrassenschluesselNrActionPerformed(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panStrassenschluessel.add(cbxStrassenschluesselNr, gridBagConstraints);

        cbxStrassenschluessel.setEnabled(false);

        org.jdesktop.beansbinding.Binding binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${currentEntity.strassenschluessel}"),
                cbxStrassenschluessel,
                org.jdesktop.beansbinding.BeanProperty.create("selectedItem"));
        binding.setSourceNullValue(null);
        binding.setSourceUnreadableValue(null);
        binding.setValidator(new NotNullValidator("Straßenschlüssel"));
        bindingGroup.addBinding(binding);

        cbxStrassenschluessel.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    cbxStrassenschluesselActionPerformed(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panStrassenschluessel.add(cbxStrassenschluessel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        panContent.add(panStrassenschluessel, gridBagConstraints);

        lblLaufendenummer.setText("Laufende Nr.:"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panContent.add(lblLaufendenummer, gridBagConstraints);

        txfLaufendenummer.setEnabled(false);

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${currentEntity.laufendeNummer}"),
                txfLaufendenummer,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panContent.add(txfLaufendenummer, gridBagConstraints);

        lblMontage.setText("Montage:"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panContent.add(lblMontage, gridBagConstraints);

        dapMontage.setEnabled(false);

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${currentEntity.erstellungsjahr}"),
                dapMontage,
                org.jdesktop.beansbinding.BeanProperty.create("date"),
                "");
        binding.setConverter(new TimestampToDateConverter());
        binding.setValidator(new DateValidator());
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panContent.add(dapMontage, gridBagConstraints);

        lblMaterial.setText("Material:"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panContent.add(lblMaterial, gridBagConstraints);

        cbxMaterial.setEnabled(false);

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${currentEntity.material}"),
                cbxMaterial,
                org.jdesktop.beansbinding.BeanProperty.create("selectedItem"));
        binding.setSourceNullValue(null);
        binding.setSourceUnreadableValue(null);
        bindingGroup.addBinding(binding);

        cbxMaterial.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    cbxMaterialActionPerformed(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panContent.add(cbxMaterial, gridBagConstraints);

        lblPruefdatum.setText("Prüfung:"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panContent.add(lblPruefdatum, gridBagConstraints);

        dapPruefdatum.setEnabled(false);

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${currentEntity.pruefdatum}"),
                dapPruefdatum,
                org.jdesktop.beansbinding.BeanProperty.create("date"));
        binding.setConverter(new TimestampToDateConverter());
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panContent.add(dapPruefdatum, gridBagConstraints);

        lblBemerkung.setText("Bemerkung:"); // NOI18N
        lblBemerkung.setVerticalAlignment(javax.swing.SwingConstants.TOP);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panContent.add(lblBemerkung, gridBagConstraints);

        txaMauerlascheBemerkung.setColumns(20);
        txaMauerlascheBemerkung.setRows(5);
        txaMauerlascheBemerkung.setEnabled(false);

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${currentEntity.bemerkung}"),
                txaMauerlascheBemerkung,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        bindingGroup.addBinding(binding);

        scpBemerkung.setViewportView(txaMauerlascheBemerkung);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panContent.add(scpBemerkung, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        jPanel1.add(panContent, gridBagConstraints);

        panSpacerBottom.setMinimumSize(DIMENSION_CONTENTSPACER);
        panSpacerBottom.setPreferredSize(DIMENSION_CONTENTSPACER);

        final javax.swing.GroupLayout panSpacerBottomLayout = new javax.swing.GroupLayout(panSpacerBottom);
        panSpacerBottom.setLayout(panSpacerBottomLayout);
        panSpacerBottomLayout.setHorizontalGroup(
            panSpacerBottomLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING).addGap(
                0,
                0,
                Short.MAX_VALUE));
        panSpacerBottomLayout.setVerticalGroup(
            panSpacerBottomLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING).addGap(
                0,
                0,
                Short.MAX_VALUE));

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel1.add(panSpacerBottom, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        add(jPanel1, gridBagConstraints);

        final javax.swing.GroupLayout panSpacerLeftLayout = new javax.swing.GroupLayout(panSpacerLeft);
        panSpacerLeft.setLayout(panSpacerLeftLayout);
        panSpacerLeftLayout.setHorizontalGroup(
            panSpacerLeftLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING).addGap(
                0,
                0,
                Short.MAX_VALUE));
        panSpacerLeftLayout.setVerticalGroup(
            panSpacerLeftLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING).addGap(
                0,
                0,
                Short.MAX_VALUE));

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        add(panSpacerLeft, gridBagConstraints);

        final javax.swing.GroupLayout panSpacerBottom1Layout = new javax.swing.GroupLayout(panSpacerBottom1);
        panSpacerBottom1.setLayout(panSpacerBottom1Layout);
        panSpacerBottom1Layout.setHorizontalGroup(
            panSpacerBottom1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING).addGap(
                0,
                273,
                Short.MAX_VALUE));
        panSpacerBottom1Layout.setVerticalGroup(
            panSpacerBottom1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING).addGap(
                0,
                0,
                Short.MAX_VALUE));

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weighty = 1.0;
        add(panSpacerBottom1, gridBagConstraints);

        bindingGroup.bind();
    } // </editor-fold>//GEN-END:initComponents

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void cbxMaterialActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_cbxMaterialActionPerformed
// TODO add your handling code here:
    } //GEN-LAST:event_cbxMaterialActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void cbxStrassenschluesselNrActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_cbxStrassenschluesselNrActionPerformed
        try {
            if (!isTriggerd) {
                isTriggerd = true;
                cbxStrassenschluessel.setSelectedItem(cbxStrassenschluesselNr.getSelectedItem());
            }
        } catch (Exception ex) {
            LOG.warn("failuire while updating strassenschluessel ", ex);
        } finally {
            isTriggerd = false;
        }
    }                                                                                           //GEN-LAST:event_cbxStrassenschluesselNrActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void cbxStrassenschluesselActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_cbxStrassenschluesselActionPerformed
        try {
            if (!isTriggerd) {
                isTriggerd = true;
                cbxStrassenschluesselNr.setSelectedItem(cbxStrassenschluessel.getSelectedItem());
            }
        } catch (Exception ex) {
            LOG.warn("failuire while updating strassenschluessel ", ex);
        } finally {
            isTriggerd = false;
        }
    }                                                                                         //GEN-LAST:event_cbxStrassenschluesselActionPerformed

    @Override
    void initPanel() {
        bindingGroup.addBindingListener(new PanelBindingListener());

        AutoCompleteDecorator.decorate(cbxStrassenschluessel, new ObjectToKeyStringConverter());
        AutoCompleteDecorator.decorate(cbxStrassenschluesselNr, new ObjectToPkConverter("pk"));
    }

    @Override
    void initComponentToLabelMap() {
        componentToLabelMap.put(cbxMaterial, lblMaterial);
        componentToLabelMap.put(cbxStrassenschluessel, lblStrassenschluessel);
        componentToLabelMap.put(cbxStrassenschluesselNr, lblStrassenschluessel);
        componentToLabelMap.put(dapMontage, lblMontage);
        componentToLabelMap.put(txfLaufendenummer, lblLaufendenummer);
        componentToLabelMap.put(dapPruefdatum, lblPruefdatum);
        componentToLabelMap.put(txaMauerlascheBemerkung, lblBemerkung);
    }

    @Override
    public void setElementsNull() {
        if (((MauerlascheCustomBean)currentEntity).getStrassenschluessel() == null) {
            cbxStrassenschluessel.setSelectedItem(null);
            cbxStrassenschluesselNr.setSelectedItem(null);
        }
    }

    @Override
    public void setPanelEditable(final boolean isEditable) {
        RendererTools.setEditable(cbxStrassenschluessel, isEditable);
        RendererTools.setEditable(cbxStrassenschluesselNr, isEditable);
        RendererTools.setEditable(cbxMaterial, isEditable);
        RendererTools.setEditable(dapMontage, isEditable);
        RendererTools.setEditable(txfLaufendenummer, isEditable);
        RendererTools.setEditable(dapPruefdatum, isEditable);
        RendererTools.setEditable(txaMauerlascheBemerkung, isEditable);
    }

    /**
     * DOCUMENT ME!
     */
    @Override
    public void commitEdits() {
        try {
            dapMontage.getEditor().commitEdit();
        } catch (ParseException ex) {
            LOG.warn("Error while commiting edits: " + ex);
        }
        try {
            dapPruefdatum.getEditor().commitEdit();
        } catch (ParseException ex) {
            LOG.warn("Error while commiting edits: " + ex);
        }
    }

    @Override
    protected BindingGroup getBindingGroup() {
        return bindingGroup;
    }
}
