/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package de.cismet.belis.gui.widget.detailWidgetPanels;

import Sirius.server.middleware.types.MetaObject;
import Sirius.server.middleware.types.MetaObjectNode;

import org.jdesktop.beansbinding.BindingGroup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

import javax.swing.JLabel;
import javax.swing.SwingWorker;
import javax.swing.table.AbstractTableModel;

import de.cismet.belis.broker.BelisBroker;
import de.cismet.belis.broker.CidsBroker;

import de.cismet.belis.gui.DateToStringConverter;

import de.cismet.belis.util.RendererTools;

import de.cismet.cids.custom.beans.belis2.ArbeitsauftragCustomBean;
import de.cismet.cids.custom.beans.belis2.ArbeitsprotokollCustomBean;
import de.cismet.cids.custom.beans.belis2.InfobausteinCustomBean;
import de.cismet.cids.custom.beans.belis2.InfobausteinTemplateCustomBean;
import de.cismet.cids.custom.beans.belis2.VeranlassungCustomBean;
import de.cismet.cids.custom.beans.belis2.VeranlassungsartCustomBean;

/**
 * DOCUMENT ME!
 *
 * @author   Gilles Baatz
 * @version  $Revision$, $Date$
 */
public class VeranlassungPanel extends AbstractDetailWidgetPanel<VeranlassungCustomBean> {

    //~ Static fields/initializers ---------------------------------------------

    private static final org.apache.log4j.Logger LOG = org.apache.log4j.Logger.getLogger(VeranlassungPanel.class);

    private static final Class[] COLUMN_CLASSES = {
            String.class,
            String.class
        };
    private static final String[] COLUMN_NAMES = { "Bezeichnung", "Wert" };

    private static final Class[] AA_COLUMN_CLASSES = {
            String.class,
            String.class,
            String.class
        };
    private static final String[] AA_COLUMN_NAMES = { "Auftragsnummer", "Protokollobjekt", "Status" };

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton btnAddInfo;
    private javax.swing.JButton btnRemInfo;
    private javax.swing.JButton btnTemplate;
    private javax.swing.JComboBox cbxArt;
    private javax.swing.JComboBox cbxInfobausteineTemplate;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JLabel lblArbeitsauftraege;
    private javax.swing.JLabel lblArt;
    private javax.swing.JLabel lblBemerkungen;
    private javax.swing.JLabel lblBeschreibung;
    private javax.swing.JLabel lblBezeichnung;
    private javax.swing.JLabel lblDatum;
    private javax.swing.JLabel lblDatumValue;
    private javax.swing.JLabel lblInformationsbausteine;
    private javax.swing.JLabel lblNummer;
    private javax.swing.JLabel lblNummerValue;
    private javax.swing.JLabel lblUser;
    private javax.swing.JLabel lblUserValue;
    private javax.swing.JLabel lblVeranlassung;
    private javax.swing.JPanel panContent;
    private javax.swing.JPanel panInformationsbausteine;
    private javax.swing.JPanel panSpacer0;
    private javax.swing.JPanel panSpacer1;
    private javax.swing.JPanel panSpacerBottom;
    private javax.swing.JPanel panSpacerBottom1;
    private javax.swing.JPanel panSpacerLeft;
    private javax.swing.JScrollPane scrBemerkungen;
    private javax.swing.JScrollPane scrBeschreibung;
    private javax.swing.JTable tblArbeitsauftraege;
    private javax.swing.JTable tblInfobausteine;
    private javax.swing.JTextArea txaBemerkungen;
    private javax.swing.JTextArea txaBeschreibung;
    private javax.swing.JTextField txtBezeichnung;
    private org.jdesktop.beansbinding.BindingGroup bindingGroup;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates new form LeuchtePanel.
     */
    public VeranlassungPanel() {
        super("VERANLASSUNG_PANEL");
        initComponents();
        initComponentToLabelMap();
        initPanel();
    }

    //~ Methods ----------------------------------------------------------------

    @Override
    public JLabel getTabLabel() {
        return lblVeranlassung;
    }

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;
        bindingGroup = new org.jdesktop.beansbinding.BindingGroup();

        lblVeranlassung = new javax.swing.JLabel();
        jPanel3 = new javax.swing.JPanel();
        panContent = new javax.swing.JPanel();
        panSpacer0 = new javax.swing.JPanel();
        panSpacer1 = new javax.swing.JPanel();
        lblNummer = new javax.swing.JLabel();
        lblNummerValue = new javax.swing.JLabel();
        lblBezeichnung = new javax.swing.JLabel();
        txtBezeichnung = new javax.swing.JTextField();
        lblArt = new javax.swing.JLabel();
        cbxArt = BelisBroker.createKeyTableComboBox(VeranlassungsartCustomBean.TABLE);
        lblBeschreibung = new javax.swing.JLabel();
        scrBeschreibung = new javax.swing.JScrollPane();
        txaBeschreibung = new javax.swing.JTextArea();
        lblUser = new javax.swing.JLabel();
        lblUserValue = new javax.swing.JLabel();
        lblDatum = new javax.swing.JLabel();
        lblDatumValue = new javax.swing.JLabel();
        lblBemerkungen = new javax.swing.JLabel();
        scrBemerkungen = new javax.swing.JScrollPane();
        txaBemerkungen = new javax.swing.JTextArea();
        lblInformationsbausteine = new javax.swing.JLabel();
        panInformationsbausteine = new javax.swing.JPanel();
        cbxInfobausteineTemplate = BelisBroker.createKeyTableComboBox(InfobausteinTemplateCustomBean.TABLE);
        btnTemplate = new javax.swing.JButton();
        jScrollPane1 = new javax.swing.JScrollPane();
        tblInfobausteine = new javax.swing.JTable();
        jPanel1 = new javax.swing.JPanel();
        btnAddInfo = new javax.swing.JButton();
        btnRemInfo = new javax.swing.JButton();
        jScrollPane2 = new javax.swing.JScrollPane();
        tblArbeitsauftraege = new javax.swing.JTable();
        lblArbeitsauftraege = new javax.swing.JLabel();
        panSpacerBottom = new javax.swing.JPanel();
        panSpacerLeft = new javax.swing.JPanel();
        panSpacerBottom1 = new javax.swing.JPanel();

        lblVeranlassung.setFont(new java.awt.Font("DejaVu Sans", 1, 13));                       // NOI18N
        lblVeranlassung.setIcon(new javax.swing.ImageIcon(
                getClass().getResource("/de/cismet/belis/resource/icon/16/veranlassung.png"))); // NOI18N
        lblVeranlassung.setText("Veranlassung");                                                // NOI18N

        setLayout(new java.awt.GridBagLayout());

        jPanel3.setLayout(new java.awt.GridBagLayout());

        panContent.setLayout(new java.awt.GridBagLayout());

        panSpacer0.setMinimumSize(DIMENSION_KEYSPACER);
        panSpacer0.setPreferredSize(DIMENSION_KEYSPACER);

        final javax.swing.GroupLayout panSpacer0Layout = new javax.swing.GroupLayout(panSpacer0);
        panSpacer0.setLayout(panSpacer0Layout);
        panSpacer0Layout.setHorizontalGroup(
            panSpacer0Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING).addGap(
                0,
                0,
                Short.MAX_VALUE));
        panSpacer0Layout.setVerticalGroup(
            panSpacer0Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING).addGap(
                0,
                0,
                Short.MAX_VALUE));

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        panContent.add(panSpacer0, gridBagConstraints);

        panSpacer1.setName(""); // NOI18N
        panSpacer1.setPreferredSize(new java.awt.Dimension(420, 0));

        final javax.swing.GroupLayout panSpacer1Layout = new javax.swing.GroupLayout(panSpacer1);
        panSpacer1.setLayout(panSpacer1Layout);
        panSpacer1Layout.setHorizontalGroup(
            panSpacer1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING).addGap(
                0,
                0,
                Short.MAX_VALUE));
        panSpacer1Layout.setVerticalGroup(
            panSpacer1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING).addGap(
                0,
                0,
                Short.MAX_VALUE));

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        panContent.add(panSpacer1, gridBagConstraints);

        lblNummer.setText("Nummer:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panContent.add(lblNummer, gridBagConstraints);

        org.jdesktop.beansbinding.Binding binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${currentEntity.nummer}"),
                lblNummerValue,
                org.jdesktop.beansbinding.BeanProperty.create("text"),
                "nummer");
        binding.setSourceNullValue("00000000");
        binding.setSourceUnreadableValue("00000000");
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.FIRST_LINE_START;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panContent.add(lblNummerValue, gridBagConstraints);

        lblBezeichnung.setText("Bezeichnung:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panContent.add(lblBezeichnung, gridBagConstraints);

        txtBezeichnung.setEnabled(false);

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${currentEntity.bezeichnung}"),
                txtBezeichnung,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.FIRST_LINE_START;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panContent.add(txtBezeichnung, gridBagConstraints);

        lblArt.setText("Grund (Art):");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panContent.add(lblArt, gridBagConstraints);

        cbxArt.setEnabled(false);

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${currentEntity.fk_art}"),
                cbxArt,
                org.jdesktop.beansbinding.BeanProperty.create("selectedItem"));
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.FIRST_LINE_START;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panContent.add(cbxArt, gridBagConstraints);

        lblBeschreibung.setText("Beschreibung:");
        lblBeschreibung.setVerticalAlignment(javax.swing.SwingConstants.TOP);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.FIRST_LINE_START;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panContent.add(lblBeschreibung, gridBagConstraints);

        scrBeschreibung.setEnabled(false);

        txaBeschreibung.setColumns(20);
        txaBeschreibung.setRows(5);
        txaBeschreibung.setEnabled(false);
        txaBeschreibung.setMinimumSize(new java.awt.Dimension(240, 85));

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${currentEntity.beschreibung}"),
                txaBeschreibung,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        bindingGroup.addBinding(binding);

        scrBeschreibung.setViewportView(txaBeschreibung);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.FIRST_LINE_START;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panContent.add(scrBeschreibung, gridBagConstraints);

        lblUser.setText("User:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panContent.add(lblUser, gridBagConstraints);

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${currentEntity.username}"),
                lblUserValue,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.FIRST_LINE_START;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panContent.add(lblUserValue, gridBagConstraints);

        lblDatum.setText("Datum:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panContent.add(lblDatum, gridBagConstraints);

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${currentEntity.datum}"),
                lblDatumValue,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        binding.setConverter(new DateToStringConverter());
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.FIRST_LINE_START;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panContent.add(lblDatumValue, gridBagConstraints);

        lblBemerkungen.setText("Bemerkungen:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.FIRST_LINE_START;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panContent.add(lblBemerkungen, gridBagConstraints);

        scrBemerkungen.setEnabled(false);

        txaBemerkungen.setColumns(20);
        txaBemerkungen.setRows(5);
        txaBemerkungen.setEnabled(false);
        txaBemerkungen.setMinimumSize(new java.awt.Dimension(240, 85));

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${currentEntity.bemerkungen}"),
                txaBemerkungen,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        bindingGroup.addBinding(binding);

        scrBemerkungen.setViewportView(txaBemerkungen);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.FIRST_LINE_START;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panContent.add(scrBemerkungen, gridBagConstraints);

        lblInformationsbausteine.setText("Informationsbausteine:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panContent.add(lblInformationsbausteine, gridBagConstraints);

        panInformationsbausteine.setLayout(new java.awt.GridBagLayout());

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${currentEntity.fk_infobaustein_template}"),
                cbxInfobausteineTemplate,
                org.jdesktop.beansbinding.BeanProperty.create("selectedItem"),
                "");
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panInformationsbausteine.add(cbxInfobausteineTemplate, gridBagConstraints);

        btnTemplate.setText("Vorlage hinzufügen");
        btnTemplate.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    btnTemplateActionPerformed(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panInformationsbausteine.add(btnTemplate, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        panContent.add(panInformationsbausteine, gridBagConstraints);

        jScrollPane1.setPreferredSize(new java.awt.Dimension(100, 200));

        tblInfobausteine.setModel(new IBTableModel());
        tblInfobausteine.setMinimumSize(new java.awt.Dimension(60, 200));
        tblInfobausteine.setPreferredSize(new java.awt.Dimension(60, 200));
        jScrollPane1.setViewportView(tblInfobausteine);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.FIRST_LINE_START;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panContent.add(jScrollPane1, gridBagConstraints);

        jPanel1.setOpaque(false);
        jPanel1.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.RIGHT));

        btnAddInfo.setText("+");
        btnAddInfo.setMaximumSize(new java.awt.Dimension(29, 29));
        btnAddInfo.setMinimumSize(new java.awt.Dimension(29, 29));
        btnAddInfo.setPreferredSize(new java.awt.Dimension(29, 29));
        btnAddInfo.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    btnAddInfoActionPerformed(evt);
                }
            });
        jPanel1.add(btnAddInfo);

        btnRemInfo.setText("-");
        btnRemInfo.setMaximumSize(new java.awt.Dimension(29, 29));
        btnRemInfo.setMinimumSize(new java.awt.Dimension(29, 29));
        btnRemInfo.setPreferredSize(new java.awt.Dimension(29, 29));
        btnRemInfo.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    btnRemInfoActionPerformed(evt);
                }
            });
        jPanel1.add(btnRemInfo);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.FIRST_LINE_END;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panContent.add(jPanel1, gridBagConstraints);

        jScrollPane2.setPreferredSize(new java.awt.Dimension(100, 200));

        tblArbeitsauftraege.setMinimumSize(new java.awt.Dimension(60, 200));
        tblArbeitsauftraege.setPreferredSize(new java.awt.Dimension(60, 200));
        jScrollPane2.setViewportView(tblArbeitsauftraege);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.FIRST_LINE_START;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panContent.add(jScrollPane2, gridBagConstraints);

        lblArbeitsauftraege.setText("Arbeitsaufträge:");
        lblArbeitsauftraege.setVerticalAlignment(javax.swing.SwingConstants.TOP);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.FIRST_LINE_START;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panContent.add(lblArbeitsauftraege, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        jPanel3.add(panContent, gridBagConstraints);

        panSpacerBottom.setMinimumSize(DIMENSION_CONTENTSPACER);
        panSpacerBottom.setPreferredSize(DIMENSION_CONTENTSPACER);

        final javax.swing.GroupLayout panSpacerBottomLayout = new javax.swing.GroupLayout(panSpacerBottom);
        panSpacerBottom.setLayout(panSpacerBottomLayout);
        panSpacerBottomLayout.setHorizontalGroup(
            panSpacerBottomLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING).addGap(
                0,
                0,
                Short.MAX_VALUE));
        panSpacerBottomLayout.setVerticalGroup(
            panSpacerBottomLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING).addGap(
                0,
                0,
                Short.MAX_VALUE));

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel3.add(panSpacerBottom, gridBagConstraints);

        add(jPanel3, new java.awt.GridBagConstraints());

        final javax.swing.GroupLayout panSpacerLeftLayout = new javax.swing.GroupLayout(panSpacerLeft);
        panSpacerLeft.setLayout(panSpacerLeftLayout);
        panSpacerLeftLayout.setHorizontalGroup(
            panSpacerLeftLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING).addGap(
                0,
                0,
                Short.MAX_VALUE));
        panSpacerLeftLayout.setVerticalGroup(
            panSpacerLeftLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING).addGap(
                0,
                0,
                Short.MAX_VALUE));

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        add(panSpacerLeft, gridBagConstraints);

        final javax.swing.GroupLayout panSpacerBottom1Layout = new javax.swing.GroupLayout(panSpacerBottom1);
        panSpacerBottom1.setLayout(panSpacerBottom1Layout);
        panSpacerBottom1Layout.setHorizontalGroup(
            panSpacerBottom1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING).addGap(
                0,
                379,
                Short.MAX_VALUE));
        panSpacerBottom1Layout.setVerticalGroup(
            panSpacerBottom1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING).addGap(
                0,
                64,
                Short.MAX_VALUE));

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weighty = 1.0;
        add(panSpacerBottom1, gridBagConstraints);

        bindingGroup.bind();
    } // </editor-fold>//GEN-END:initComponents

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void btnAddInfoActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_btnAddInfoActionPerformed
        final VeranlassungCustomBean template = (VeranlassungCustomBean)currentEntity;
        final Collection<InfobausteinCustomBean> ar_bausteine = template.getAr_infobausteine();
        ar_bausteine.add(InfobausteinCustomBean.createNew());
        ((AbstractTableModel)tblInfobausteine.getModel()).fireTableDataChanged();
    }                                                                              //GEN-LAST:event_btnAddInfoActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void btnRemInfoActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_btnRemInfoActionPerformed
        final VeranlassungCustomBean template = (VeranlassungCustomBean)currentEntity;
        final Collection<InfobausteinCustomBean> ar_bausteine = template.getAr_infobausteine();
        final int rowIndex = tblInfobausteine.getSelectedRow();
        final InfobausteinCustomBean baustein = ar_bausteine.toArray(new InfobausteinCustomBean[0])[rowIndex];
        ar_bausteine.remove(baustein);
        ((AbstractTableModel)tblInfobausteine.getModel()).fireTableDataChanged();
    }                                                                              //GEN-LAST:event_btnRemInfoActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void btnTemplateActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_btnTemplateActionPerformed
        final Object selectedItem = cbxInfobausteineTemplate.getSelectedItem();
//        currentEntity.getAr_infobausteine().clear();
        if (selectedItem instanceof InfobausteinTemplateCustomBean) {
            final InfobausteinTemplateCustomBean template = (InfobausteinTemplateCustomBean)selectedItem;
            currentEntity.setFk_infobaustein_template(template);
            final Collection<InfobausteinCustomBean> ar_bausteine = template.getAr_bausteine();
            for (final InfobausteinCustomBean infobausteinFromTemplate : ar_bausteine) {
                final InfobausteinCustomBean infobaustein = InfobausteinCustomBean.createNew();
                infobaustein.setSchluessel(infobausteinFromTemplate.getSchluessel());
                infobaustein.setBezeichnung(infobausteinFromTemplate.getBezeichnung());
                infobaustein.setPflichtfeld(infobausteinFromTemplate.getPflichtfeld());
                infobaustein.setWert(infobausteinFromTemplate.getWert());
                currentEntity.getAr_infobausteine().add(infobaustein);
            }
        }
        ((AbstractTableModel)tblInfobausteine.getModel()).fireTableDataChanged();
    }                                                                               //GEN-LAST:event_btnTemplateActionPerformed

    @Override
    final void initPanel() {
    }

    /**
     * DOCUMENT ME!
     */
    @Override
    public void commitEdits() {
    }

    @Override
    final void initComponentToLabelMap() {
        componentToLabelMap.put(cbxArt, lblArt);
        componentToLabelMap.put(txtBezeichnung, lblBezeichnung);
        componentToLabelMap.put(txaBeschreibung, lblBeschreibung);
        componentToLabelMap.put(txaBemerkungen, lblBemerkungen);
        componentToLabelMap.put(lblUserValue, lblUser);
        componentToLabelMap.put(lblDatumValue, lblDatum);
        componentToLabelMap.put(lblInformationsbausteine, cbxInfobausteineTemplate);
    }

    @Override
    public void setElementsNull() {
    }

    @Override
    public void setPanelEditable(final boolean isEditable) {
        RendererTools.setEditable(cbxArt, isEditable);
        RendererTools.setEditable(txtBezeichnung, isEditable);
        RendererTools.setEditable(txaBeschreibung, isEditable);
        RendererTools.setEditable(txaBemerkungen, isEditable);
        RendererTools.setEditable(btnAddInfo, isEditable);
        RendererTools.setEditable(btnRemInfo, isEditable);
        RendererTools.setEditable(btnTemplate, isEditable);
        RendererTools.setEditable(cbxInfobausteineTemplate, isEditable);
        RendererTools.setEditable(tblInfobausteine, isEditable);
    }

    @Override
    public void setCurrentEntity(final VeranlassungCustomBean currentEntity) {
        if (tblInfobausteine.getCellEditor() != null) {
            tblInfobausteine.getCellEditor().stopCellEditing();
        }

        super.setCurrentEntity(currentEntity);

        new SwingWorker<Collection<ArbeitsauftragCustomBean>, Void>() {

                @Override
                protected Collection<ArbeitsauftragCustomBean> doInBackground() throws Exception {
                    final Collection<MetaObjectNode> mons = BelisBroker.getInstance()
                                .searchForArbeitsprotokolleOfVeralassung(currentEntity.getNummer());
                    final Collection<ArbeitsauftragCustomBean> beans = new ArrayList<ArbeitsauftragCustomBean>();
                    for (final MetaObjectNode mon : mons) {
                        final int classid = mon.getClassId();
                        final int objectid = mon.getObjectId();
                        final MetaObject mo = CidsBroker.getInstance().getMetaObject(classid, objectid, "BELIS2");
                        if ((mo != null) && (mo.getBean() != null)
                                    && (mo.getBean() instanceof ArbeitsauftragCustomBean)) {
                            beans.add((ArbeitsauftragCustomBean)mo.getBean());
                        }
                    }
                    return beans;
                }

                @Override
                protected void done() {
                    final Collection<ArbeitsauftragCustomBean> beans;
                    try {
                        beans = get();
                        if ((getCurrentEntity() != null) && getCurrentEntity().equals(currentEntity)) {
                            tblArbeitsauftraege.setModel(new AATableModel(beans, currentEntity.getNummer()));
                        }
                    } catch (final Exception ex) {
                        LOG.error("error while searching protokolle", ex);
                    }
                }
            }.execute();

        ((AbstractTableModel)tblInfobausteine.getModel()).fireTableDataChanged();
    }

    @Override
    protected BindingGroup getBindingGroup() {
        return bindingGroup;
    }

    //~ Inner Classes ----------------------------------------------------------

    /**
     * DOCUMENT ME!
     *
     * @version  $Revision$, $Date$
     */
    class IBTableModel extends AbstractTableModel {

        //~ Methods ------------------------------------------------------------

        @Override
        public int getRowCount() {
            if (currentEntity != null) {
                return ((VeranlassungCustomBean)currentEntity).getAr_infobausteine().size();
            } else {
                return 0;
            }
        }

        @Override
        public int getColumnCount() {
            return COLUMN_NAMES.length;
        }

        @Override
        public Object getValueAt(final int rowIndex, final int columnIndex) {
            if (currentEntity != null) {
                final InfobausteinCustomBean baustein = getRowObject(rowIndex);
                if (columnIndex == 0) {
                    return baustein.getBezeichnung();
                } else if (columnIndex == 1) {
                    return baustein.getWert();
                } else {
                    return null;
                }
            } else {
                return null;
            }
        }

        @Override
        public void setValueAt(final Object aValue, final int rowIndex, final int columnIndex) {
            if (currentEntity != null) {
                final InfobausteinCustomBean baustein = getRowObject(rowIndex);
                if (columnIndex == 0) {
                    baustein.setBezeichnung((String)aValue);
                } else if (columnIndex == 1) {
                    baustein.setWert((String)aValue);
                }
            }
        }

        /**
         * DOCUMENT ME!
         *
         * @param   rowIndex  DOCUMENT ME!
         *
         * @return  DOCUMENT ME!
         */
        private InfobausteinCustomBean getRowObject(final int rowIndex) {
            final VeranlassungCustomBean template = (VeranlassungCustomBean)currentEntity;
            final Collection<InfobausteinCustomBean> ar_bausteine = template.getAr_infobausteine();
            final InfobausteinCustomBean baustein = ar_bausteine.toArray(new InfobausteinCustomBean[0])[rowIndex];
            return baustein;
        }

        @Override
        public Class<?> getColumnClass(final int columnIndex) {
            return COLUMN_CLASSES[columnIndex];
        }

        @Override
        public String getColumnName(final int columnIndex) {
            return COLUMN_NAMES[columnIndex];
        }

        @Override
        public boolean isCellEditable(final int rowIndex, final int columnIndex) {
            if (columnIndex == 0) {
                return btnAddInfo.isEnabled();
            } else {
                return true;
            }
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @version  $Revision$, $Date$
     */
    class AATableModel extends AbstractTableModel {

        //~ Instance fields ----------------------------------------------------

        final ArrayList<ArbeitsprotokollCustomBean> protokolle = new ArrayList<ArbeitsprotokollCustomBean>();
        final Map<ArbeitsprotokollCustomBean, ArbeitsauftragCustomBean> protomap =
            new HashMap<ArbeitsprotokollCustomBean, ArbeitsauftragCustomBean>();

        //~ Constructors -------------------------------------------------------

        /**
         * Creates a new AATableModel object.
         *
         * @param  beans                DOCUMENT ME!
         * @param  veranlassungsnummer  DOCUMENT ME!
         */
        public AATableModel(final Collection<ArbeitsauftragCustomBean> beans, final String veranlassungsnummer) {
            for (final ArbeitsauftragCustomBean aa : beans) {
                for (final ArbeitsprotokollCustomBean proto : aa.getAr_protokolle()) {
                    if ((proto.getVeranlassungsnummer() != null)
                                && proto.getVeranlassungsnummer().equals(veranlassungsnummer)) {
                        protokolle.add(proto);
                        protomap.put(proto, aa);
                    }
                }
            }
        }

        //~ Methods ------------------------------------------------------------

        @Override
        public int getRowCount() {
            if (currentEntity != null) {
                return protokolle.size();
            } else {
                return 0;
            }
        }

        @Override
        public int getColumnCount() {
            return AA_COLUMN_NAMES.length;
        }

        @Override
        public Object getValueAt(final int rowIndex, final int columnIndex) {
            if (currentEntity != null) {
                final ArbeitsprotokollCustomBean protokoll = getRowObject(rowIndex);
                if (columnIndex == 0) {
                    return protomap.get(protokoll).getKeyString();
                } else if (columnIndex == 1) {
                    if (protokoll.getFk_abzweigdose() != null) {
                        return "Abzweigdose " + protokoll.getFk_abzweigdose().getKeyString();
                    } else if (protokoll.getFk_leitung() != null) {
                        return "Leitung " + protokoll.getFk_leitung().getKeyString();
                    } else if (protokoll.getFk_leuchte() != null) {
                        return "Leuchte " + protokoll.getFk_leuchte().getKeyString();
                    } else if (protokoll.getFk_mauerlasche() != null) {
                        return "Mauerlasche " + protokoll.getFk_mauerlasche().getKeyString();
                    } else if (protokoll.getFk_schaltstelle() != null) {
                        return "Schaltstelle " + protokoll.getFk_schaltstelle().getKeyString();
                    } else if (protokoll.getFk_geometrie() != null) {
                        return "Geometrie " + protokoll.getFk_geometrie().getKeyString();
                    } else if (protokoll.getFk_standort() != null) {
                        if (protokoll.getFk_standort().isStandortMast()) {
                            return "Mast " + protokoll.getFk_standort().getKeyString();
                        } else {
                            return "Standort " + protokoll.getFk_standort().getKeyString();
                        }
                    } else {
                        return "";
                    }
                } else {
                    if (protokoll.getFk_status() != null) {
                        return protokoll.getFk_status().getBezeichnung();
                    } else {
                        return "";
                    }
                }
            } else {
                return null;
            }
        }

        /**
         * DOCUMENT ME!
         *
         * @param   rowIndex  DOCUMENT ME!
         *
         * @return  DOCUMENT ME!
         */
        private ArbeitsprotokollCustomBean getRowObject(final int rowIndex) {
            return protokolle.get(rowIndex);
        }

        @Override
        public Class<?> getColumnClass(final int columnIndex) {
            return AA_COLUMN_CLASSES[columnIndex];
        }

        @Override
        public String getColumnName(final int columnIndex) {
            return AA_COLUMN_NAMES[columnIndex];
        }

        @Override
        public boolean isCellEditable(final int rowIndex, final int columnIndex) {
            return false;
        }
    }
}
