/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package de.cismet.belis.panels;

import de.cismet.belis.broker.BelisBroker;
import de.cismet.belis.broker.EntityClipboard;
import de.cismet.belis.broker.EntityClipboardListener;

import de.cismet.commons.architecture.interfaces.Editable;

/**
 * DOCUMENT ME!
 *
 * @author   Gilles Baatz
 * @version  $Revision$, $Date$
 */
public class CopyPasteToolbar extends javax.swing.JPanel implements Editable, EntityClipboardListener {

    //~ Static fields/initializers ---------------------------------------------

    private static final org.apache.log4j.Logger LOG = org.apache.log4j.Logger.getLogger(CopyPasteToolbar.class);

    //~ Instance fields --------------------------------------------------------

    private BelisBroker broker;
    private EntityClipboard entityClipboard;
    private final EntityClipboardListener cbListener = new EntityClipboardListener() {

            @Override
            public void clipboardChanged() {
                btnCopy.setEnabled(entityClipboard.isCopyable());
                btnPaste.setEnabled(entityClipboard.isPastable());
            }
        };

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton btnCopy;
    private javax.swing.JButton btnPaste;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates new form EditButtonsPanel.
     *
     * @param  broker  DOCUMENT ME!
     */
    public CopyPasteToolbar(final BelisBroker broker) {
        this.broker = broker;
        initComponents();

        broker.getEntityClipboard().addListener(this);
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        btnCopy = new javax.swing.JButton();
        btnPaste = new javax.swing.JButton();

        setOpaque(false);
        setLayout(new java.awt.GridBagLayout());

        btnCopy.setIcon(new javax.swing.ImageIcon(
                getClass().getResource("/de/cismet/belis/resource/icon/16/copy.png"))); // NOI18N
        btnCopy.setEnabled(false);
        btnCopy.setFocusable(false);
        btnCopy.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    btnCopyActionPerformed(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(0, 2, 0, 2);
        add(btnCopy, gridBagConstraints);

        btnPaste.setIcon(new javax.swing.ImageIcon(
                getClass().getResource("/de/cismet/belis/resource/icon/16/paste.png"))); // NOI18N
        btnPaste.setEnabled(false);
        btnPaste.setFocusable(false);
        btnPaste.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    btnPasteActionPerformed(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(0, 2, 0, 2);
        add(btnPaste, gridBagConstraints);
    } // </editor-fold>//GEN-END:initComponents

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void btnCopyActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_btnCopyActionPerformed
        try {
            broker.getEntityClipboard().copy();
        } catch (Exception ex) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Fehler beim Kopieren in die Zwischenablage", ex);
            }
        }
    }                                                                           //GEN-LAST:event_btnCopyActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void btnPasteActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_btnPasteActionPerformed
        try {
            broker.getEntityClipboard().paste();
        } catch (Exception ex) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Fehler beim Einfügen aus der Zwischenablage", ex);
            }
        }
    }                                                                            //GEN-LAST:event_btnPasteActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    public EntityClipboardListener getClipboardListener() {
        return cbListener;
    }

    /**
     * DOCUMENT ME!
     *
     * @param  entityClipboard  DOCUMENT ME!
     */
    public void setClipboard(final EntityClipboard entityClipboard) {
        this.entityClipboard = entityClipboard;
    }

    @Override
    public void setWidgetEditable(final boolean isEditable) {
        if (!isEditable) {
            setAllButtonsEnabled(isEditable);
//        } else {
//            checkSetButtonState();
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @param  isEnabled  DOCUMENT ME!
     */
    private void setAllButtonsEnabled(final boolean isEnabled) {
        btnCopy.setEnabled(isEnabled);
        btnPaste.setEnabled(isEnabled);
    }

    @Override
    public final void clipboardChanged() {
        btnCopy.setEnabled(broker.getEntityClipboard().isCopyable());
        btnPaste.setEnabled(broker.getEntityClipboard().isPastable());
    }
}
