/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package de.cismet.cids.custom.objecteditors.belis2;

import Sirius.navigator.ui.RequestsFullSizeComponent;

import org.apache.log4j.Logger;

import org.jdesktop.beansbinding.Converter;

import java.util.Collection;

import javax.swing.table.AbstractTableModel;

import de.cismet.belis.commons.constants.BelisMetaClassConstants;

import de.cismet.cids.client.tools.DevelopmentTools;

import de.cismet.cids.custom.beans.belis2.InfobausteinCustomBean;
import de.cismet.cids.custom.beans.belis2.InfobausteinTemplateCustomBean;
import de.cismet.cids.custom.beans.belis2.RundsteuerempfaengerCustomBean;

import de.cismet.cids.dynamics.CidsBean;

import de.cismet.cids.editors.DefaultCustomObjectEditor;

import de.cismet.cids.tools.metaobjectrenderer.CidsBeanRenderer;

/**
 * DOCUMENT ME!
 *
 * @author   daniel
 * @version  $Revision$, $Date$
 */
public class InfobausteinTemplateEditor extends javax.swing.JPanel implements RequestsFullSizeComponent,
    CidsBeanRenderer {

    //~ Static fields/initializers ---------------------------------------------

    private static final Logger LOG = Logger.getLogger(InfobausteinTemplateEditor.class);

    private static final Class[] COLUMN_CLASSES = {
            String.class,
            String.class,
            String.class,
            Boolean.class
        };
    private static final String[] COLUMN_NAMES = { "Schlüssel", "Bezeichnung", "Wert", "Pflichtfeld" };

    //~ Instance fields --------------------------------------------------------

    private CidsBean cidsBean;
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButton1;
    private javax.swing.JButton jButton2;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTable jTable1;
    private javax.swing.JLabel lblBezeichnung;
    private javax.swing.JLabel lblSchluessel;
    private javax.swing.JPanel pnlCard2;
    private javax.swing.JTextField txtBezeichnung;
    private javax.swing.JTextField txtSchluessel;
    private org.jdesktop.beansbinding.BindingGroup bindingGroup;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates new form MauerEditor.
     */
    /**
     * Creates a new MauerEditor object.
     */
    public InfobausteinTemplateEditor() {
        initComponents();
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;
        bindingGroup = new org.jdesktop.beansbinding.BindingGroup();

        pnlCard2 = new javax.swing.JPanel();
        lblSchluessel = new javax.swing.JLabel();
        txtSchluessel = new javax.swing.JTextField();
        lblBezeichnung = new javax.swing.JLabel();
        txtBezeichnung = new javax.swing.JTextField();
        jScrollPane1 = new javax.swing.JScrollPane();
        jTable1 = new javax.swing.JTable();
        jPanel1 = new javax.swing.JPanel();
        jButton1 = new javax.swing.JButton();
        jButton2 = new javax.swing.JButton();

        setMaximumSize(new java.awt.Dimension(1190, 1625));
        setMinimumSize(new java.awt.Dimension(807, 485));
        setVerifyInputWhenFocusTarget(false);
        setLayout(new java.awt.CardLayout());

        pnlCard2.setOpaque(false);
        pnlCard2.setLayout(new java.awt.GridBagLayout());

        lblSchluessel.setText(org.openide.util.NbBundle.getMessage(
                InfobausteinTemplateEditor.class,
                "InfobausteinTemplateEditor.lblSchluessel.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_END;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 3, 5);
        pnlCard2.add(lblSchluessel, gridBagConstraints);

        org.jdesktop.beansbinding.Binding binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.schluessel}"),
                txtSchluessel,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 3, 0);
        pnlCard2.add(txtSchluessel, gridBagConstraints);

        lblBezeichnung.setText(org.openide.util.NbBundle.getMessage(
                InfobausteinTemplateEditor.class,
                "InfobausteinTemplateEditor.lblBezeichnung.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_END;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 3, 5);
        pnlCard2.add(lblBezeichnung, gridBagConstraints);

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.bezeichnung}"),
                txtBezeichnung,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 3, 0);
        pnlCard2.add(txtBezeichnung, gridBagConstraints);

        jScrollPane1.setPreferredSize(new java.awt.Dimension(100, 200));

        jTable1.setModel(new IBTableModel());
        jTable1.setMinimumSize(new java.awt.Dimension(60, 200));
        jTable1.setPreferredSize(new java.awt.Dimension(60, 200));
        jScrollPane1.setViewportView(jTable1);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.FIRST_LINE_START;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        pnlCard2.add(jScrollPane1, gridBagConstraints);

        jPanel1.setOpaque(false);

        jButton1.setText(org.openide.util.NbBundle.getMessage(
                InfobausteinTemplateEditor.class,
                "InfobausteinTemplateEditor.jButton1.text")); // NOI18N
        jButton1.setMaximumSize(new java.awt.Dimension(29, 29));
        jButton1.setMinimumSize(new java.awt.Dimension(29, 29));
        jButton1.setPreferredSize(new java.awt.Dimension(29, 29));
        jButton1.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    jButton1ActionPerformed(evt);
                }
            });
        jPanel1.add(jButton1);

        jButton2.setText(org.openide.util.NbBundle.getMessage(
                InfobausteinTemplateEditor.class,
                "InfobausteinTemplateEditor.jButton2.text")); // NOI18N
        jButton2.setMaximumSize(new java.awt.Dimension(29, 29));
        jButton2.setMinimumSize(new java.awt.Dimension(29, 29));
        jButton2.setPreferredSize(new java.awt.Dimension(29, 29));
        jButton2.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    jButton2ActionPerformed(evt);
                }
            });
        jPanel1.add(jButton2);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.FIRST_LINE_END;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 3, 5);
        pnlCard2.add(jPanel1, gridBagConstraints);

        add(pnlCard2, "card2");

        bindingGroup.bind();
    } // </editor-fold>//GEN-END:initComponents

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void jButton1ActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_jButton1ActionPerformed
        final InfobausteinTemplateCustomBean template = ((InfobausteinTemplateCustomBean)cidsBean);
        final Collection<InfobausteinCustomBean> ar_bausteine = template.getAr_bausteine();
        ar_bausteine.add(InfobausteinCustomBean.createNew());
        ((AbstractTableModel)jTable1.getModel()).fireTableDataChanged();
    }                                                                            //GEN-LAST:event_jButton1ActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void jButton2ActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_jButton2ActionPerformed
        final InfobausteinTemplateCustomBean template = ((InfobausteinTemplateCustomBean)cidsBean);
        final Collection<InfobausteinCustomBean> ar_bausteine = template.getAr_bausteine();
        final int rowIndex = jTable1.getSelectedRow();
        final InfobausteinCustomBean baustein = ar_bausteine.toArray(new InfobausteinCustomBean[0])[rowIndex];
        ar_bausteine.remove(baustein);
        ((AbstractTableModel)jTable1.getModel()).fireTableDataChanged();
    }                                                                            //GEN-LAST:event_jButton2ActionPerformed

    @Override
    public CidsBean getCidsBean() {
        return cidsBean;
    }

    @Override
    public void setCidsBean(final CidsBean cidsBean) {
        bindingGroup.unbind();
        if (cidsBean != null) {
            DefaultCustomObjectEditor.setMetaClassInformationToMetaClassStoreComponentsInBindingGroup(
                bindingGroup,
                cidsBean);
            this.cidsBean = cidsBean;
            bindingGroup.bind();
        }
        ((AbstractTableModel)jTable1.getModel()).fireTableDataChanged();
    }

    @Override
    public void dispose() {
        bindingGroup.unbind();
    }

    @Override
    public String getTitle() {
        return "Infobaustein Template";
    }

    @Override
    public void setTitle(final String title) {
    }

    /**
     * DOCUMENT ME!
     *
     * @param   args  DOCUMENT ME!
     *
     * @throws  Exception  DOCUMENT ME!
     */
    public static void main(final String[] args) throws Exception {
        DevelopmentTools.createEditorInFrameFromRMIConnectionOnLocalhost(
            BelisMetaClassConstants.DOMAIN,
            args[0],
            args[1],
            args[2],
            RundsteuerempfaengerCustomBean.TABLE,
            1,
            1280,
            1024);
    }

    //~ Inner Classes ----------------------------------------------------------

    /**
     * DOCUMENT ME!
     *
     * @version  $Revision$, $Date$
     */
    class CharacterToStringConverter extends Converter<Character, String> {

        //~ Methods ------------------------------------------------------------

        @Override
        public String convertForward(final Character value) {
            if (value != null) {
                return value.toString();
            } else {
                return null;
            }
        }

        @Override
        public Character convertReverse(final String value) {
            try {
                return new Character(value.charAt(0));
            } catch (final Exception ex) {
                return null;
            }
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @version  $Revision$, $Date$
     */
    class IBTableModel extends AbstractTableModel {

        //~ Methods ------------------------------------------------------------

        @Override
        public int getRowCount() {
            if (cidsBean != null) {
                return ((InfobausteinTemplateCustomBean)cidsBean).getAr_bausteine().size();
            } else {
                return 0;
            }
        }

        @Override
        public int getColumnCount() {
            return COLUMN_NAMES.length;
        }

        @Override
        public Object getValueAt(final int rowIndex, final int columnIndex) {
            if (cidsBean != null) {
                final InfobausteinCustomBean baustein = getRowObject(rowIndex);
                if (columnIndex == 0) {
                    return baustein.getSchluessel();
                } else if (columnIndex == 1) {
                    return baustein.getBezeichnung();
                } else if (columnIndex == 2) {
                    return baustein.getWert();
                } else if (columnIndex == 3) {
                    return baustein.getPflichtfeld();
                } else {
                    return null;
                }
            } else {
                return null;
            }
        }

        @Override
        public void setValueAt(final Object aValue, final int rowIndex, final int columnIndex) {
            if (cidsBean != null) {
                final InfobausteinCustomBean baustein = getRowObject(rowIndex);
                if (columnIndex == 0) {
                    baustein.setSchluessel((String)aValue);
                } else if (columnIndex == 1) {
                    baustein.setBezeichnung((String)aValue);
                } else if (columnIndex == 2) {
                    baustein.setWert((String)aValue);
                } else if (columnIndex == 3) {
                    baustein.setPflichtfeld((Boolean)aValue);
                }
            }
        }

        /**
         * DOCUMENT ME!
         *
         * @param   rowIndex  DOCUMENT ME!
         *
         * @return  DOCUMENT ME!
         */
        private InfobausteinCustomBean getRowObject(final int rowIndex) {
            final InfobausteinTemplateCustomBean template = ((InfobausteinTemplateCustomBean)cidsBean);
            final Collection<InfobausteinCustomBean> ar_bausteine = template.getAr_bausteine();
            final InfobausteinCustomBean baustein = ar_bausteine.toArray(new InfobausteinCustomBean[0])[rowIndex];
            return baustein;
        }

        @Override
        public Class<?> getColumnClass(final int columnIndex) {
            return COLUMN_CLASSES[columnIndex];
        }

        @Override
        public String getColumnName(final int columnIndex) {
            return COLUMN_NAMES[columnIndex];
        }

        @Override
        public boolean isCellEditable(final int rowIndex, final int columnIndex) {
            return true;
        }
    }
}
