/*
 * Decompiled with CFR 0.152.
 */
import Sirius.navigator.connection.Connection;
import Sirius.navigator.connection.ConnectionFactory;
import Sirius.navigator.connection.ConnectionInfo;
import Sirius.navigator.connection.ConnectionSession;
import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.connection.proxy.ConnectionProxy;
import Sirius.server.middleware.types.MetaObjectNode;
import com.jgoodies.looks.plastic.PlasticXPLookAndFeel;
import de.cismet.belis.broker.BelisBroker;
import de.cismet.belis.broker.CidsBroker;
import de.cismet.belis.gui.reports.BelisReporter;
import de.cismet.belis.gui.reports.ReportingArbeitsauftrag;
import de.cismet.belis2.server.search.ArbeitsauftragSearchStatement;
import de.cismet.cids.custom.beans.belis2.ArbeitsauftragCustomBean;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.cids.utils.jasperreports.ReportSwingWorkerDialog;
import de.cismet.cismap.commons.MappingModel;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.layerwidget.ActiveLayerModel;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.tools.configuration.Configurable;
import de.cismet.tools.configuration.ConfigurationManager;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.log4jquickconfig.Log4JQuickConfig;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Toolkit;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.view.JRViewer;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXLoginPane;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.auth.LoginService;

public class TestReport {
    private static final transient Logger LOG = Logger.getLogger(TestReport.class);

    public void doLogin(String callServerURL, String domain) {
        CidsAuthentification cidsAuth = new CidsAuthentification(callServerURL, domain);
        JXLoginPane login = new JXLoginPane((LoginService)cidsAuth);
        JXLoginPane.JXLoginDialog loginDialog = new JXLoginPane.JXLoginDialog((Frame)null, login);
        login.setPassword("".toCharArray());
        try {
            ((JXPanel)((JXPanel)login.getComponent(1)).getComponent(1)).getComponent(3).requestFocus();
        }
        catch (Exception ex) {
            LOG.info((Object)"could nor request focus", (Throwable)ex);
        }
        StaticSwingTools.showDialog((JDialog)loginDialog);
        if (loginDialog.getStatus() != JXLoginPane.Status.SUCCEEDED) {
            System.exit(0);
        }
    }

    public void generateReport(final Collection<String> nummern) {
        try {
            final ReportSwingWorkerDialog dialog = new ReportSwingWorkerDialog(StaticSwingTools.getParentFrame(null), true);
            UIManager.setLookAndFeel((LookAndFeel)new PlasticXPLookAndFeel());
            ConfigurationManager configManager = new ConfigurationManager();
            configManager.setFolder(".belis2");
            configManager.setFileName("configurationPlugin.xml");
            configManager.setDefaultFileName("defaultCismapProperties.xml");
            MappingComponent mapC = new MappingComponent(true);
            mapC.setMappingModel((MappingModel)new ActiveLayerModel());
            CismapBroker.getInstance().setMappingComponent(mapC);
            configManager.configure((Configurable)mapC);
            CidsBroker.getInstance().setProxy(SessionManager.getProxy());
            new SwingWorker<JasperPrint, Void>(){

                @Override
                protected JasperPrint doInBackground() throws Exception {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            StaticSwingTools.showDialog((JDialog)dialog);
                        }
                    });
                    ArrayList<ReportingArbeitsauftrag> a = new ArrayList<ReportingArbeitsauftrag>();
                    for (String nummer : nummern) {
                        ArbeitsauftragSearchStatement searchStatement = new ArbeitsauftragSearchStatement();
                        searchStatement.setAuftragsNummer(nummer);
                        searchStatement.setActiveObjectsOnly(false);
                        searchStatement.setWorkedoffObjectsOnly(false);
                        try {
                            Collection mons = SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)searchStatement);
                            for (MetaObjectNode mon : mons) {
                                ArbeitsauftragCustomBean bean = (ArbeitsauftragCustomBean)CidsBroker.getInstance().getMetaObject(mon.getClassId(), mon.getObjectId(), "BELIS2").getBean();
                                ReportingArbeitsauftrag ra = new ReportingArbeitsauftrag();
                                ra.init(bean);
                                a.add(ra);
                            }
                        }
                        catch (Exception ex) {
                            LOG.error((Object)ex, (Throwable)ex);
                        }
                    }
                    BelisBroker.getInstance().lookupProtokollWizards();
                    JRBeanCollectionDataSource dataSource = new JRBeanCollectionDataSource(a);
                    HashMap parameters = new HashMap();
                    try {
                        JasperReport jasperReport = (JasperReport)JRLoader.loadObject((InputStream)BelisReporter.class.getResourceAsStream("/de/cismet/belis/reports/arbeitsauftraege.jasper"));
                        return JasperFillManager.fillReport((JasperReport)jasperReport, parameters, (JRDataSource)dataSource);
                    }
                    catch (Exception e) {
                        LOG.error((Object)e, (Throwable)e);
                        return null;
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void done() {
                    try {
                        dialog.setVisible(false);
                        JasperPrint jasperPrint = (JasperPrint)this.get();
                        JRViewer aViewer = new JRViewer(jasperPrint);
                        JFrame aFrame = new JFrame("Druckvorschau");
                        aFrame.setDefaultCloseOperation(3);
                        aFrame.getContentPane().add((Component)aViewer);
                        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                        aFrame.setSize((int)((double)screenSize.width * 0.8), (int)((float)screenSize.height * 0.9f));
                        Insets insets = aFrame.getInsets();
                        aFrame.setSize(aFrame.getWidth() + insets.left + insets.right, aFrame.getHeight() + insets.top + insets.bottom + 20);
                        aFrame.setLocation((screenSize.width - aFrame.getWidth()) / 2, (screenSize.height - aFrame.getHeight()) / 2);
                        aViewer.setFitPageZoomRatio();
                        aFrame.setVisible(true);
                    }
                    catch (Exception ex) {
                        LOG.error((Object)ex, (Throwable)ex);
                    }
                    finally {
                        dialog.dispose();
                    }
                }
            }.execute();
        }
        catch (UnsupportedLookAndFeelException ex) {
            LOG.error((Object)ex, (Throwable)ex);
        }
    }

    public static void main(String[] args) {
        Log4JQuickConfig.configure4LumbermillOnLocalhost();
        String callServerURL = args[0];
        String domain = args[1];
        String idsString = args[2];
        ArrayList<String> ids = new ArrayList<String>();
        for (String idString : idsString.split(";")) {
            ids.add(idString);
        }
        TestReport test = new TestReport();
        test.doLogin(callServerURL, domain);
        test.generateReport(ids);
    }

    class CidsAuthentification
    extends LoginService {
        public static final String CONNECTION_PROXY_CLASS = "Sirius.navigator.connection.proxy.DefaultConnectionProxyHandler";
        public static final String CONNECTION_CLASS = "Sirius.navigator.connection.RMIConnection";
        private final String callServerURL;
        private final String domain;

        public CidsAuthentification(String callServerURL, String domain) {
            this.callServerURL = callServerURL;
            this.domain = domain;
        }

        public boolean authenticate(String name, char[] password, String server) throws Exception {
            System.setProperty("sun.rmi.transport.connectionTimeout", "15");
            String[] split = name.split("@");
            String user = split.length > 1 ? split[0] : name;
            String group = split.length > 1 ? split[1] : null;
            String connectionclass = CONNECTION_CLASS;
            try {
                Connection connection = ConnectionFactory.getFactory().createConnection(CONNECTION_CLASS, this.callServerURL);
                ConnectionInfo connectionInfo = new ConnectionInfo();
                connectionInfo.setCallserverURL(this.callServerURL);
                connectionInfo.setPassword(new String(password));
                connectionInfo.setUserDomain(this.domain);
                connectionInfo.setUsergroup(group);
                connectionInfo.setUsergroupDomain(this.domain);
                connectionInfo.setUsername(user);
                ConnectionSession session = ConnectionFactory.getFactory().createSession(connection, connectionInfo, true);
                ConnectionProxy proxy = ConnectionFactory.getFactory().createProxy(CONNECTION_PROXY_CLASS, session);
                SessionManager.init((ConnectionProxy)proxy);
                ClassCacheMultiple.setInstance((String)this.domain);
                return true;
            }
            catch (Throwable t) {
                LOG.error((Object)"Fehler beim Anmelden", t);
                return false;
            }
        }
    }
}

