/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.belis.arbeitsprotokollwizard;

import de.cismet.belis.arbeitsprotokollwizard.ArbeitsprotokollDialog;
import de.cismet.belis.arbeitsprotokollwizard.LeuchteLeuchtenerneuerungWizard;
import de.cismet.belis2.server.utils.LockAlreadyExistsException;
import de.cismet.cids.custom.beans.belis2.ArbeitsauftragCustomBean;
import de.cismet.cids.custom.beans.belis2.ArbeitsprotokollCustomBean;
import de.cismet.cids.custom.beans.belis2.ArbeitsprotokollaktionCustomBean;
import de.cismet.commons.server.entity.WorkbenchFeatureEntity;
import de.cismet.tools.gui.StaticSwingTools;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import javax.swing.Action;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.SwingWorker;

public abstract class AbstractArbeitsprotokollWizard
extends JPanel {
    private ArbeitsauftragCustomBean arbeitsauftrag;
    private Collection<ArbeitsprotokollCustomBean> protokolle;

    public abstract ArbeitsprotokollCustomBean.ChildType getEntityClass();

    public abstract String getTitle();

    public void setProtokolle(Collection<ArbeitsprotokollCustomBean> protokolle) {
        this.protokolle = protokolle;
    }

    public Collection<ArbeitsprotokollCustomBean> getProtokolle() {
        return this.protokolle;
    }

    public ArbeitsauftragCustomBean getArbeitsauftrag() {
        return this.arbeitsauftrag;
    }

    public void setArbeitsauftrag(ArbeitsauftragCustomBean arbeitsauftrag) {
        this.arbeitsauftrag = arbeitsauftrag;
    }

    public abstract Action getAction();

    protected void executeAktion(final PropertyChangeListener listener) {
        final Collection<ArbeitsprotokollCustomBean> protokolle = this.getProtokolle();
        final int numOf = protokolle.size();
        listener.propertyChange(new PropertyChangeEvent(this, "start", null, numOf));
        new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                int index = 0;
                for (ArbeitsprotokollCustomBean protokoll : protokolle) {
                    Object result = null;
                    try {
                        listener.propertyChange(new PropertyChangeEvent(this, "progress", null, index));
                        result = AbstractArbeitsprotokollWizard.this.executeAktion(protokoll);
                    }
                    catch (Exception ex) {
                        LeuchteLeuchtenerneuerungWizard.LOG.error((Object)ex, (Throwable)ex);
                    }
                    ++index;
                    if (!(result instanceof Collection)) continue;
                    throw new LockAlreadyExistsException("A lock for the desired object is already existing", (Collection)result);
                }
                return null;
            }

            @Override
            protected void done() {
                try {
                    this.get();
                }
                catch (Exception ex) {
                    LeuchteLeuchtenerneuerungWizard.LOG.warn((Object)ex, (Throwable)ex);
                }
                finally {
                    listener.propertyChange(new PropertyChangeEvent(this, "done", null, numOf));
                }
            }
        }.execute();
    }

    protected static ArbeitsprotokollaktionCustomBean createAktion(String desc, WorkbenchFeatureEntity entity, String property, Object newValue) throws Exception {
        Object oldValue = entity.getProperty(property);
        entity.setProperty(property, newValue);
        ArbeitsprotokollaktionCustomBean aktion = ArbeitsprotokollaktionCustomBean.createNew();
        aktion.setAenderung(desc);
        aktion.setAlt(AbstractArbeitsprotokollWizard.valueToString(oldValue));
        aktion.setNeu(AbstractArbeitsprotokollWizard.valueToString(newValue));
        return aktion;
    }

    private static String valueToString(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy");
            return dateFormat.format(value);
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? "Ja" : "Nein";
        }
        return value.toString();
    }

    protected abstract Object executeAktion(ArbeitsprotokollCustomBean var1) throws Exception;

    protected void showDialog() {
        ArbeitsprotokollDialog dialog = new ArbeitsprotokollDialog(this, null, true);
        StaticSwingTools.showDialog((JDialog)dialog);
    }

    protected void clear() {
    }
}

