/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.belis.broker;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.event.CatalogueActivationListener;
import Sirius.navigator.event.CatalogueSelectionListener;
import Sirius.navigator.plugin.ui.PluginMenuItem;
import Sirius.navigator.resource.PropertyManager;
import Sirius.navigator.search.CidsSearchExecutor;
import Sirius.navigator.types.treenode.RootTreeNode;
import Sirius.navigator.ui.ComponentRegistry;
import Sirius.navigator.ui.DescriptionPane;
import Sirius.navigator.ui.DescriptionPaneFS;
import Sirius.navigator.ui.GUIContainer;
import Sirius.navigator.ui.LayoutedContainer;
import Sirius.navigator.ui.MutableMenuBar;
import Sirius.navigator.ui.MutablePopupMenu;
import Sirius.navigator.ui.MutableToolBar;
import Sirius.navigator.ui.attributes.AttributeViewer;
import Sirius.navigator.ui.attributes.editor.AttributeEditor;
import Sirius.navigator.ui.tree.MetaCatalogueTree;
import Sirius.navigator.ui.tree.SearchResultsTree;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import Sirius.server.middleware.types.MetaObjectNode;
import Sirius.server.middleware.types.Node;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.belis.arbeitsprotokollwizard.AbstractArbeitsprotokollWizard;
import de.cismet.belis.broker.CidsBroker;
import de.cismet.belis.broker.CsvExportBackend;
import de.cismet.belis.broker.EntityClipboard;
import de.cismet.belis.broker.ScrollableComboBox;
import de.cismet.belis.gui.reports.ArbeitsauftraegeReportDownload;
import de.cismet.belis.gui.search.LocationSearchControl;
import de.cismet.belis.gui.search.MapSearchControl;
import de.cismet.belis.gui.search.SearchControl;
import de.cismet.belis.gui.search.SearchController;
import de.cismet.belis.gui.widget.BelisWidget;
import de.cismet.belis.gui.widget.DetailWidget;
import de.cismet.belis.gui.widget.ExtendedNavigatorAttributeEditorGui;
import de.cismet.belis.gui.widget.KeyTableListener;
import de.cismet.belis.gui.widget.MapWidget;
import de.cismet.belis.gui.widget.WorkbenchWidget;
import de.cismet.belis.gui.widget.windowsearchwidget.QuerySearchResultsWindowSearch;
import de.cismet.belis.panels.AlreadyLockedObjectsPanel;
import de.cismet.belis.panels.CancelWaitDialog;
import de.cismet.belis.panels.CopyPasteToolbar;
import de.cismet.belis.panels.CreateToolBar;
import de.cismet.belis.panels.EditButtonsToolbar;
import de.cismet.belis.panels.FilterToolBar;
import de.cismet.belis.panels.LockWaitDialog;
import de.cismet.belis.panels.ReleaseWaitDialog;
import de.cismet.belis.panels.SaveWaitDialog;
import de.cismet.belis.panels.SearchWaitDialog;
import de.cismet.belis.todo.CustomMutableTreeTableNode;
import de.cismet.belis.todo.CustomTreeTableModel;
import de.cismet.belis.todo.RetrieveWorker;
import de.cismet.belis.util.BelisIcons;
import de.cismet.belis2.server.search.ArbeitsauftragSearchStatement;
import de.cismet.belis2.server.search.BelisLocationSearchStatement;
import de.cismet.belis2.server.search.BelisSearchStatement;
import de.cismet.belis2.server.search.BelisTopicSearchStatement;
import de.cismet.belis2.server.utils.ActionNotSuccessfulException;
import de.cismet.belis2.server.utils.LockAlreadyExistsException;
import de.cismet.belisEE.util.EntityComparator;
import de.cismet.cids.custom.beans.belis2.AbzweigdoseCustomBean;
import de.cismet.cids.custom.beans.belis2.ArbeitsauftragCustomBean;
import de.cismet.cids.custom.beans.belis2.ArbeitsprotokollCustomBean;
import de.cismet.cids.custom.beans.belis2.GeometrieCustomBean;
import de.cismet.cids.custom.beans.belis2.LeitungCustomBean;
import de.cismet.cids.custom.beans.belis2.LeitungstypCustomBean;
import de.cismet.cids.custom.beans.belis2.MauerlascheCustomBean;
import de.cismet.cids.custom.beans.belis2.SchaltstelleCustomBean;
import de.cismet.cids.custom.beans.belis2.SperreCustomBean;
import de.cismet.cids.custom.beans.belis2.TdtaLeuchtenCustomBean;
import de.cismet.cids.custom.beans.belis2.TdtaStandortMastCustomBean;
import de.cismet.cids.custom.beans.belis2.TkeyDoppelkommandoCustomBean;
import de.cismet.cids.custom.beans.belis2.TkeyStrassenschluesselCustomBean;
import de.cismet.cids.custom.beans.belis2.TkeyUnterhLeuchteCustomBean;
import de.cismet.cids.custom.beans.belis2.TkeyUnterhMastCustomBean;
import de.cismet.cids.custom.beans.belis2.VeranlassungCustomBean;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.editors.DefaultBindableReferenceCombo;
import de.cismet.cids.navigator.utils.SimpleMemoryMonitoringToolbarWidget;
import de.cismet.cids.search.SearchQuerySearchMethod;
import de.cismet.cids.server.actions.AppendToTestFileServerAction;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.cids.server.search.MetaObjectNodeServerSearch;
import de.cismet.cids.server.search.builtin.GeoSearch;
import de.cismet.cismap.commons.BoundingBox;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.FeatureCollection;
import de.cismet.cismap.commons.features.StyledFeature;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.statusbar.StatusBar;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.interaction.StatusListener;
import de.cismet.cismap.commons.interaction.events.StatusEvent;
import de.cismet.cismap.commons.tools.IconUtils;
import de.cismet.cismap.navigatorplugin.MetaSearchHelper;
import de.cismet.commons.architecture.exception.LockingNotSuccessfulException;
import de.cismet.commons.architecture.geometrySlot.GeometrySlot;
import de.cismet.commons.architecture.geometrySlot.GeometrySlotInformation;
import de.cismet.commons.architecture.geometrySlot.GeometrySlotProvider;
import de.cismet.commons.architecture.interfaces.Clearable;
import de.cismet.commons.architecture.interfaces.Editable;
import de.cismet.commons.architecture.interfaces.FeatureSelectionChangedListener;
import de.cismet.commons.architecture.interfaces.ObjectChangeListener;
import de.cismet.commons.architecture.plugin.AbstractPlugin;
import de.cismet.commons.server.entity.BaseEntity;
import de.cismet.commons.server.entity.WorkbenchEntity;
import de.cismet.commons.server.entity.WorkbenchFeatureEntity;
import de.cismet.commons2.architecture.layout.LayoutManager;
import de.cismet.lookupoptions.gui.OptionsClient;
import de.cismet.tools.CurrentStackTrace;
import de.cismet.tools.StaticDebuggingTools;
import de.cismet.tools.configuration.Configurable;
import de.cismet.tools.configuration.ConfigurationManager;
import de.cismet.tools.configuration.NoWriteError;
import de.cismet.tools.gui.DefaultPopupMenuListener;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.downloadmanager.ByteArrayDownload;
import de.cismet.tools.gui.downloadmanager.Download;
import de.cismet.tools.gui.downloadmanager.DownloadManager;
import de.cismet.tools.gui.downloadmanager.DownloadManagerDialog;
import de.cismet.veto.VetoException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentListener;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import net.infonode.docking.RootWindow;
import net.infonode.gui.componentpainter.ComponentPainter;
import net.infonode.gui.componentpainter.GradientComponentPainter;
import org.apache.commons.collections.comparators.ReverseComparator;
import org.apache.log4j.Logger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.xml.XmlConfiguration;
import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.JXTreeTable;
import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.CompoundHighlighter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import org.jdesktop.swingx.error.ErrorInfo;
import org.jdesktop.swingx.treetable.AbstractMutableTreeTableNode;
import org.jdesktop.swingx.treetable.MutableTreeTableNode;
import org.jdom.Element;
import org.openide.util.Lookup;

public class BelisBroker
implements SearchController,
PropertyChangeListener,
Configurable {
    private static BelisBroker INSTANCE;
    protected static final Logger LOG;
    public static final Color yellow;
    public static final Color red;
    public static final Color blue;
    public static final String PROP_IN_EDIT_MODE = "inEditMode";
    public static final String PROP_FILTER_NORMAL = "filterNormal";
    public static final String PROP_FILTER_VERANLASSUNG = "filterVeranlassung";
    public static final String PROP_FILTER_ARBEITSAUFTRAG = "filterArbeitsauftrag";
    public static final Color gray;
    public static final int alphaValue = 255;
    public static final Color ODD_ROW_DEFAULT_COLOR;
    public static final Color ODD_ROW_EDIT_COLOR;
    public static final Color ODD_ROW_LOCK_COLOR;
    public static final Color EVEN_ROW_COLOR;
    public static final Color FOREGROUND_ROW_COLOR;
    public static Highlighter ALTERNATE_ROW_HIGHLIGHTER;
    public static final Color EDIT_MODE_COLOR;
    public static final Color DEFAULT_MODE_COLOR;
    private static GregorianCalendar calender;
    public static final String PROP_CURRENT_SEARCH_RESULTS = "currentSearchResults";
    private static TkeyUnterhMastCustomBean defaultUnterhaltMast;
    private static TkeyUnterhLeuchteCustomBean defaultUnterhaltLeuchte;
    private static TkeyDoppelkommandoCustomBean defaultDoppelkommando1;
    public static final String[] jxDatePickerFormats;
    public AtomicBoolean isPendingForCreateMode = new AtomicBoolean(false);
    protected JButton btnDiscardChanges;
    protected JButton btnAcceptChanges;
    protected JButton btnSwitchInCreateMode;
    protected JButton cmdPrint = new JButton();
    protected JButton cmdAAPrint = new JButton();
    protected JButton cmdCsvExport = new JButton();
    protected JButton btnReload = new JButton();
    protected PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    protected final Collection<Clearable> clearAndDisableListeners = new ArrayList<Clearable>();
    protected MapWidget mapWidget = null;
    protected final Collection<BelisWidget> widgets = new ArrayList<BelisWidget>();
    protected final Collection<Editable> editables = new ArrayList<Editable>();
    protected JComponent parentComponent;
    protected JFrame parentFrame;
    protected StatusBar statusBar;
    protected ExecutorService execService = null;
    protected String currentValidationErrorMessage = null;
    private WorkbenchWidget workbenchWidget = null;
    private final CreateToolBar panCreate;
    private final FilterToolBar panFilter;
    private final CopyPasteToolbar copyPasteToolbar;
    private final ArrayList<SearchControl> searchControls = new ArrayList();
    private final EntityClipboard entityClipboard;
    private LayoutManager layoutManager;
    private ConfigurationManager configManager;
    private JToolBar toolbar;
    private String applicationName;
    private String totd;
    private StatusBar statusbar;
    private boolean statusBarEnabled = true;
    private String account;
    private String loggingProperties;
    private boolean inEditMode = false;
    private ArrayList<FeatureSelectionChangedListener> featureSelectionChangedIgnoredWidgets = new ArrayList();
    private AlreadyLockedObjectsPanel lockPanel = null;
    private Set<WorkbenchEntity> currentSearchResults = new TreeSet<WorkbenchEntity>((Comparator<WorkbenchEntity>)new ReverseComparator((Comparator)new EntityComparator()));
    private boolean inCreateMode;
    private MapSearchControl mscPan = null;
    private SaveWaitDialog saveWaitDialog = null;
    private CancelWaitDialog cancelWaitDialog = null;
    private LockWaitDialog lockWaitDialog = null;
    private ReleaseWaitDialog releaseWaitDialog = null;
    private RetrieveWorker lastSearch = null;
    private DetailWidget detailWidget;
    private LeitungstypCustomBean lastLeitungstyp = null;
    private TkeyStrassenschluesselCustomBean lastMauerlascheStrassenschluessel;
    private final ArrayList<WorkbenchFeatureEntity> currentFeatures = new ArrayList();
    private EditButtonsToolbar editButtonsToolbar;
    private MetaSearchHelper metaSearchComponentFactory;
    private ComponentRegistry componentRegistry;
    private Collection<AbstractArbeitsprotokollWizard> leuchtenWizards = new ArrayList<AbstractArbeitsprotokollWizard>();
    private Collection<AbstractArbeitsprotokollWizard> standorteWizards = new ArrayList<AbstractArbeitsprotokollWizard>();
    private Collection<AbstractArbeitsprotokollWizard> mauerlascheWizards = new ArrayList<AbstractArbeitsprotokollWizard>();
    private Collection<AbstractArbeitsprotokollWizard> leitungWizards = new ArrayList<AbstractArbeitsprotokollWizard>();
    private Collection<AbstractArbeitsprotokollWizard> abzweigdoseWizards = new ArrayList<AbstractArbeitsprotokollWizard>();
    private Collection<AbstractArbeitsprotokollWizard> schaltstelleWizards = new ArrayList<AbstractArbeitsprotokollWizard>();
    private Collection<AbstractArbeitsprotokollWizard> allgemeineWizards = new ArrayList<AbstractArbeitsprotokollWizard>();
    private boolean filterNormal = true;
    private boolean filterVeranlassung = false;
    private boolean filterArbeitsauftrag = false;
    private SperreCustomBean sperre = null;
    private QuerySearchResultsWindowSearch querySearchResultsWindowSearch;

    private BelisBroker() {
        this.execService = Executors.newCachedThreadPool();
        this.entityClipboard = new EntityClipboard(this);
        this.panCreate = new CreateToolBar(this);
        this.panFilter = new FilterToolBar(this);
        this.copyPasteToolbar = new CopyPasteToolbar(this);
    }

    public static BelisBroker getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new BelisBroker();
        }
        return INSTANCE;
    }

    public void setMetaSearchComponentFactory(MetaSearchHelper metaSearchComponentFactory) {
        this.metaSearchComponentFactory = metaSearchComponentFactory;
    }

    public MetaSearchHelper getMetaSearchComponentFactory() {
        return this.metaSearchComponentFactory;
    }

    public void setQuerySearchResultsWindowSearch(QuerySearchResultsWindowSearch querySearchResultsWindowSearch) {
        this.querySearchResultsWindowSearch = querySearchResultsWindowSearch;
    }

    public void addWidget(BelisWidget widget) {
        this.widgets.add(widget);
    }

    public Collection<BelisWidget> getWidgets() {
        return this.widgets;
    }

    public Collection<AbstractArbeitsprotokollWizard> getWizardsActionsForEntity(ArbeitsprotokollCustomBean.ChildType entity) {
        if (entity == null) {
            return this.allgemeineWizards;
        }
        switch (entity) {
            case ABZWEIGDOSE: {
                return this.abzweigdoseWizards;
            }
            case STANDORT: {
                return this.standorteWizards;
            }
            case LEUCHTE: {
                return this.leuchtenWizards;
            }
            case MAUERLASCHE: {
                return this.mauerlascheWizards;
            }
            case SCHALTSTELLE: {
                return this.schaltstelleWizards;
            }
            case LEITUNG: {
                return this.leitungWizards;
            }
        }
        return null;
    }

    public void resetWidgets() {
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Lagis Broker : Reset widgets");
                    }
                    for (BelisWidget tmp : BelisBroker.this.widgets) {
                        tmp.clearComponent();
                        tmp.setWidgetEditable(false);
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Lagis Broker : Reset widgets durch");
                    }
                }
            });
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Lagis Broker : Reset widgets");
        }
        for (BelisWidget tmp : this.widgets) {
            tmp.clearComponent();
            tmp.setWidgetEditable(false);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Lagis Broker : Reset widgets durch");
        }
    }

    public synchronized void setComponentsEditable(final boolean isEditable) {
        try {
            if (EventQueue.isDispatchThread()) {
                this.setWidgetsEditable(isEditable);
                for (Editable curEditable : this.editables) {
                    curEditable.setWidgetEditable(isEditable);
                }
            } else {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        BelisBroker.this.setComponentsEditable(isEditable);
                    }
                });
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"Error while setting Components editable: ", (Throwable)ex);
        }
    }

    public void addEditable(Editable editable) {
        this.editables.add(editable);
    }

    public void removeEditable(Editable editable) {
        this.editables.remove(editable);
    }

    public synchronized void setWidgetsEditable(final boolean isEditable) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Setze Widgets editable: " + isEditable));
        }
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BelisBroker.this.setWidgetsEditable(isEditable);
                }
            });
        } else {
            for (BelisWidget curWidget : this.widgets) {
                if (isEditable) {
                    ((ColorHighlighter)((CompoundHighlighter)ALTERNATE_ROW_HIGHLIGHTER).getHighlighters()[0]).setBackground(ODD_ROW_EDIT_COLOR);
                } else {
                    ((ColorHighlighter)((CompoundHighlighter)ALTERNATE_ROW_HIGHLIGHTER).getHighlighters()[0]).setBackground(ODD_ROW_DEFAULT_COLOR);
                }
                curWidget.setWidgetEditable(isEditable);
            }
        }
    }

    public GeometrySlotInformation assignGeometry(Geometry geom) {
        Object[] openSlots = this.collectGeometrySlots();
        switch (openSlots.length) {
            case 0: {
                JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)this.getMappingComponent()), "Es ist kein Element vorhanden dem eine Fl\u00e4che zugeordnet werden kann\noder die entsprechenden Rechte sind nicht ausreichend", "Geometrie zuordnen", 1);
                return null;
            }
            case 1: {
                int anwser = JOptionPane.showConfirmDialog(StaticSwingTools.getParentFrame((Component)this.getMappingComponent()), "Es ist genau ein Element vorhanden, dem eine Fl\u00e4che zugeordnet werden kann:\n\n    " + openSlots[0] + "\n\nSoll die Geometrie diesem dem Element hinzugef\u00fcgt werden ?", "Geometrie zuordnen", 0);
                if (anwser == 0) {
                    GeometrySlot slotGeom = openSlots[0].getOpenSlot();
                    if (slotGeom != null) {
                        slotGeom.setGeometry(geom);
                    } else {
                        slotGeom.setGeometry(geom);
                    }
                    return openSlots[0];
                }
                return null;
            }
        }
        GeometrySlotInformation selectedSlot = (GeometrySlotInformation)JOptionPane.showInputDialog(StaticSwingTools.getParentFrame((Component)this.getMappingComponent()), "Bitte w\u00e4hlen Sie das Element, dem Sie die Geometrie zuordnen m\u00f6chten:\n", "Geometrie zuordnen", -1, null, openSlots, openSlots[0]);
        if (selectedSlot != null) {
            GeometrySlot slotGeom = selectedSlot.getOpenSlot();
            if (slotGeom != null) {
                slotGeom.setGeometry(geom);
            } else {
                slotGeom.setGeometry(geom);
            }
            return selectedSlot;
        }
        return null;
    }

    protected GeometrySlotInformation[] collectGeometrySlots() {
        ArrayList openSlots = new ArrayList();
        for (BelisWidget curWidget : this.widgets) {
            if (!(curWidget instanceof GeometrySlotProvider)) continue;
            openSlots.addAll(((GeometrySlotProvider)curWidget).getSlotInformation());
        }
        return openSlots.toArray(new GeometrySlotInformation[openSlots.size()]);
    }

    public void fireChangeEvent(Object event) {
        for (BelisWidget curWidget : this.widgets) {
            if (!(curWidget instanceof FeatureSelectionChangedListener) || !(event instanceof Collection)) continue;
            if (!this.featureSelectionChangedIgnoredWidgets.contains((FeatureSelectionChangedListener)curWidget)) {
                ((FeatureSelectionChangedListener)curWidget).featureSelectionChanged((Collection)event);
                continue;
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("Widget: " + curWidget.getWidgetName() + " is in ignoredList no featureSelectionChanged"));
        }
    }

    public void addFeatureSelectionChangeIgnore(FeatureSelectionChangedListener ignore) {
        if (ignore != null) {
            this.featureSelectionChangedIgnoredWidgets.add(ignore);
        }
    }

    public void removeFeatureSelectionChangeIgnore(FeatureSelectionChangedListener ignore) {
        if (ignore != null) {
            this.featureSelectionChangedIgnoredWidgets.remove(ignore);
        }
    }

    public boolean isFeatureSelectionChangeIgnoreRegistered(FeatureSelectionChangedListener ignore) {
        return this.featureSelectionChangedIgnoredWidgets.contains(ignore);
    }

    public MappingComponent getMappingComponent() {
        return CismapBroker.getInstance().getMappingComponent();
    }

    public void setMappingComponent(MappingComponent aMappingComponent) {
        CismapBroker.getInstance().setMappingComponent(aMappingComponent);
    }

    public void switchEditMode() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"switchEditMode");
        }
        if (this.isInEditMode()) {
            this.switchInEditMode(false);
            this.setComponentsEditable(false);
            if (this.isInCreateMode()) {
                this.workbenchWidget.clearNewNode();
            } else {
                this.workbenchWidget.clearEditNode();
            }
            new SwingWorker<Void, Void>(){

                @Override
                protected Void doInBackground() throws Exception {
                    BelisBroker.this.fireReleaseStarted();
                    BelisBroker.this.releaseLock();
                    return null;
                }

                @Override
                protected void done() {
                    try {
                        BelisBroker.this.setInEditMode(false);
                        BelisBroker.this.getMappingComponent().setReadOnly(true);
                    }
                    finally {
                        BelisBroker.this.fireReleaseFinished();
                    }
                }
            }.execute();
        } else {
            this.setTitleBarComponentpainter(EDIT_MODE_COLOR);
            this.editButtonsToolbar.enableSwitchToModeButtons(false);
            this.switchInEditMode(true);
            new SwingWorker<Void, Void>(){

                @Override
                protected Void doInBackground() throws Exception {
                    BelisBroker.this.fireLockStarted();
                    BelisBroker.this.acquireLock();
                    return null;
                }

                @Override
                protected void done() {
                    try {
                        try {
                            this.get();
                        }
                        catch (Exception e) {
                            LOG.error((Object)"Problem while switching to Edit Mode", (Throwable)e);
                            BelisBroker.this.switchInEditMode(false);
                            BelisBroker.this.setTitleBarComponentpainter(DEFAULT_MODE_COLOR);
                            BelisBroker.this.editButtonsToolbar.enableSwitchToModeButtons(true);
                            BelisBroker.this.fireLockFinished();
                            return;
                        }
                        BelisBroker.this.setInEditMode(true);
                        BelisBroker.this.setComponentsEditable(true);
                        BelisBroker.this.getMappingComponent().setReadOnly(false);
                        BelisBroker.this.btnAcceptChanges.setEnabled(true);
                        BelisBroker.this.btnDiscardChanges.setEnabled(true);
                    }
                    finally {
                        BelisBroker.this.fireLockFinished();
                    }
                }
            }.execute();
        }
    }

    protected void switchInEditMode(boolean isSwitchedInEditMode) {
        this.cmdAAPrint.setEnabled(!isSwitchedInEditMode);
        if (isSwitchedInEditMode) {
            this.disableSearch();
            if (this.isInCreateMode()) {
                this.setAllFeaturesSelectable(false);
            }
        } else {
            this.enableSearch();
            this.setAllFeaturesSelectable(true);
        }
    }

    public void setInEditMode(boolean inEditMode) {
        boolean old = this.inEditMode;
        this.inEditMode = inEditMode;
        this.editButtonsToolbar.enableSwitchToModeButtons(!inEditMode);
        this.propertyChangeSupport.firePropertyChange(PROP_IN_EDIT_MODE, old, inEditMode);
    }

    public boolean isInEditMode() {
        return this.inEditMode;
    }

    public boolean validateWidgets() {
        for (BelisWidget currentWidget : this.widgets) {
            if (currentWidget.getStatus() != 2) continue;
            this.currentValidationErrorMessage = currentWidget.getValidationMessage();
            if (this.currentValidationErrorMessage == null) {
                this.currentValidationErrorMessage = "Kein Fehlertext vorhanden";
            }
            return false;
        }
        return true;
    }

    public JComponent getParentComponent() {
        return this.parentComponent;
    }

    public void setParentComponent(JComponent parentComponent) {
        this.parentComponent = parentComponent;
    }

    public void refreshWidgets(Object refreshingObject) {
        for (BelisWidget curRefreshable : this.widgets) {
            curRefreshable.refresh(refreshingObject);
        }
    }

    public Date getDateWithoutTime(Date date) {
        calender.setTime(date);
        calender.set(10, 0);
        calender.set(12, 0);
        calender.set(13, 0);
        calender.set(14, 0);
        calender.set(9, 0);
        return calender.getTime();
    }

    public Element getConfiguration() throws NoWriteError {
        return null;
    }

    public ComponentRegistry getComponentRegistry() {
        return this.componentRegistry;
    }

    public void setComponentRegistry(ComponentRegistry componentRegistry) {
        this.componentRegistry = componentRegistry;
    }

    public void initComponentRegistry(JFrame frame) throws Exception {
        PropertyManager.getManager().setEditable(true);
        final SearchResultsTree searchResultsTree = new SearchResultsTree(){

            public void setResultNodes(Node[] nodes, boolean append, PropertyChangeListener listener, boolean simpleSort, boolean sortActive) {
                super.setResultNodes(nodes, append, listener, simpleSort, false);
            }
        };
        MutableToolBar toolBar = new MutableToolBar();
        MutableMenuBar menuBar = new MutableMenuBar();
        LayoutedContainer container = new LayoutedContainer(toolBar, menuBar, true);
        AttributeViewer attributeViewer = new AttributeViewer();
        ExtendedNavigatorAttributeEditorGui attributeEditor = new ExtendedNavigatorAttributeEditorGui();
        DescriptionPaneFS descriptionPane = new DescriptionPaneFS();
        MutablePopupMenu popupMenu = new MutablePopupMenu();
        ArrayList<Component> toRemoveComponents = new ArrayList<Component>();
        for (Component component : popupMenu.getComponents()) {
            if ((!(component instanceof PluginMenuItem) || !((PluginMenuItem)component).getId().equals("Sirius.navigator.ui.MutablePopupMenu$EditObjectMethod")) && !(component instanceof JSeparator) && (!(component instanceof JMenuItem) || ((JMenuItem)component).getActionCommand() == null || !((JMenuItem)component).getActionCommand().equals("cmdSearch") && !((JMenuItem)component).getActionCommand().equals("treecommand") && (((JMenuItem)component).getAccelerator() == null || !((JMenuItem)component).getAccelerator().equals(KeyStroke.getKeyStroke("F5"))))) continue;
            toRemoveComponents.add(component);
        }
        for (Component toRemoveComponent : toRemoveComponents) {
            popupMenu.remove(toRemoveComponent);
        }
        DefaultPopupMenuListener cataloguePopupMenuListener = new DefaultPopupMenuListener((JPopupMenu)popupMenu);
        Node[] roots = SessionManager.getProxy().getRoots("BELIS2");
        RootTreeNode rootTreeNode = new RootTreeNode(roots);
        while (roots.length != rootTreeNode.getChildCount()) {
            Thread.sleep(100L);
        }
        MetaCatalogueTree metaCatalogueTree = new MetaCatalogueTree(rootTreeNode, PropertyManager.getManager().isEditable(), true, PropertyManager.getManager().getMaxConnections());
        CatalogueSelectionListener catalogueSelectionListener = new CatalogueSelectionListener(attributeViewer, (DescriptionPane)descriptionPane);
        CatalogueActivationListener catalogueActivationListener = new CatalogueActivationListener(metaCatalogueTree, attributeViewer, (DescriptionPane)descriptionPane);
        metaCatalogueTree.addMouseListener((MouseListener)cataloguePopupMenuListener);
        metaCatalogueTree.addTreeSelectionListener((TreeSelectionListener)catalogueSelectionListener);
        metaCatalogueTree.addComponentListener((ComponentListener)catalogueActivationListener);
        ComponentRegistry.registerComponents((JFrame)frame, (GUIContainer)container, (MutableMenuBar)menuBar, (MutableToolBar)toolBar, (MutablePopupMenu)popupMenu, (MetaCatalogueTree)metaCatalogueTree, (SearchResultsTree)searchResultsTree, null, (AttributeViewer)attributeViewer, (AttributeEditor)attributeEditor, (DescriptionPane)descriptionPane);
        searchResultsTree.addPropertyChangeListener("browse", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                List nodes;
                if (!(BelisBroker.this.querySearchResultsWindowSearch != null && BelisBroker.this.querySearchResultsWindowSearch.getQuerySearchResultsActionPanel().getQuerySearch().getSelectedMethod() instanceof SearchQuerySearchMethod && ((SearchQuerySearchMethod)BelisBroker.this.querySearchResultsWindowSearch.getQuerySearchResultsActionPanel().getQuerySearch().getSelectedMethod()).isSearching() || (nodes = searchResultsTree.getResultNodes()) == null)) {
                    final SearchWaitDialog swd = SearchWaitDialog.getInstance();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            swd.init(nodes.size());
                            StaticSwingTools.showDialog((JDialog)swd);
                        }
                    });
                    new SwingWorker<TreeSet<WorkbenchEntity>, Void>(){

                        @Override
                        protected TreeSet<WorkbenchEntity> doInBackground() throws Exception {
                            ArrayList<WorkbenchEntity> entities = new ArrayList<WorkbenchEntity>();
                            int count = 0;
                            for (Node node : nodes) {
                                MetaObjectNode moNode;
                                MetaObject mo;
                                if (swd.isCanceled()) {
                                    entities.clear();
                                    break;
                                }
                                ++count;
                                if (node == null || !(node instanceof MetaObjectNode) || (mo = (moNode = (MetaObjectNode)node).getObject() != null ? moNode.getObject() : CidsBroker.getInstance().getMetaObject(moNode.getClassId(), moNode.getObjectId(), "BELIS2")) == null) continue;
                                swd.setValue(count);
                                CidsBean bean = mo.getBean();
                                if (!(bean instanceof BaseEntity)) continue;
                                ((BaseEntity)bean).init();
                                entities.add((WorkbenchEntity)bean);
                            }
                            TreeSet<WorkbenchEntity> results = new TreeSet<WorkbenchEntity>((Comparator<WorkbenchEntity>)new ReverseComparator((Comparator)new EntityComparator()));
                            results.addAll(entities);
                            return results;
                        }

                        @Override
                        protected void done() {
                            TreeSet results = null;
                            try {
                                results = (TreeSet)this.get();
                                BelisBroker.this.setSearchResult(results);
                            }
                            catch (Exception ex) {
                                try {
                                    LOG.warn((Object)"exeption whil building search result treeset", (Throwable)ex);
                                }
                                catch (Throwable throwable) {
                                    SwingUtilities.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            swd.setVisible(false);
                                        }
                                    });
                                    throw throwable;
                                }
                                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                            }
                            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                            BelisBroker.this.enableSearch();
                            BelisBroker.this.fireSearchFinished();
                        }
                    }.execute();
                }
            }
        });
        this.setComponentRegistry(ComponentRegistry.getRegistry());
    }

    public void lookupWidgets() {
        try {
            for (BelisWidget widget : Lookup.getDefault().lookupAll(BelisWidget.class)) {
                if (!widget.isAllowedToShow()) continue;
                try {
                    widget.setBroker(this);
                    if (widget instanceof MapWidget) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"Mapwidget found");
                        }
                        this.mapWidget = (MapWidget)widget;
                    }
                    this.addWidget(widget);
                }
                catch (Exception ex) {
                    LOG.error((Object)"Error while initializing widget", (Throwable)ex);
                }
            }
        }
        catch (Throwable ex) {
            LOG.error((Object)"Error while lookup of widgets", ex);
        }
    }

    public void addNewProtokollToAuftragNode(CustomMutableTreeTableNode arbeitsauftragNode, ArbeitsprotokollCustomBean protokoll, WorkbenchEntity basic) {
        CustomTreeTableModel treeModel = BelisBroker.getInstance().getWorkbenchWidget().getTreeTableModel();
        CustomMutableTreeTableNode newBasicNode = new CustomMutableTreeTableNode(basic, true);
        CustomMutableTreeTableNode newProtokollNode = new CustomMutableTreeTableNode(protokoll, true);
        treeModel.insertNodeIntoAsLastChild((MutableTreeTableNode)newProtokollNode, (MutableTreeTableNode)arbeitsauftragNode);
        treeModel.insertNodeIntoAsLastChild((MutableTreeTableNode)newBasicNode, (MutableTreeTableNode)newProtokollNode);
    }

    public void addNewBasicToVeranlassungNode(CustomMutableTreeTableNode veranlassungNode, WorkbenchEntity basic) {
        CustomTreeTableModel treeModel = BelisBroker.getInstance().getWorkbenchWidget().getTreeTableModel();
        CustomMutableTreeTableNode newNode = new CustomMutableTreeTableNode(basic, true);
        treeModel.insertNodeIntoAsLastChild((MutableTreeTableNode)newNode, (MutableTreeTableNode)veranlassungNode);
    }

    public ArbeitsprotokollCustomBean createProtokollFromBasic(WorkbenchEntity basic) {
        ArbeitsprotokollCustomBean protokoll = ArbeitsprotokollCustomBean.createNew();
        if (basic instanceof AbzweigdoseCustomBean) {
            protokoll.setFk_abzweigdose((AbzweigdoseCustomBean)basic);
        } else if (basic instanceof MauerlascheCustomBean) {
            protokoll.setFk_mauerlasche((MauerlascheCustomBean)basic);
        } else if (basic instanceof LeitungCustomBean) {
            protokoll.setFk_leitung((LeitungCustomBean)basic);
        } else if (basic instanceof SchaltstelleCustomBean) {
            protokoll.setFk_schaltstelle((SchaltstelleCustomBean)basic);
        } else if (basic instanceof TdtaLeuchtenCustomBean) {
            protokoll.setFk_leuchte((TdtaLeuchtenCustomBean)basic);
        } else if (basic instanceof TdtaStandortMastCustomBean) {
            protokoll.setFk_standort((TdtaStandortMastCustomBean)basic);
        } else if (basic instanceof GeometrieCustomBean) {
            protokoll.setFk_geometrie((GeometrieCustomBean)basic);
        }
        return protokoll;
    }

    public void lookupProtokollWizards() {
        try {
            for (AbstractArbeitsprotokollWizard wizard : Lookup.getDefault().lookupAll(AbstractArbeitsprotokollWizard.class)) {
                try {
                    if (wizard.getEntityClass() == null) {
                        this.allgemeineWizards.add(wizard);
                        continue;
                    }
                    if (wizard.getEntityClass().equals((Object)ArbeitsprotokollCustomBean.ChildType.LEUCHTE)) {
                        this.leuchtenWizards.add(wizard);
                        continue;
                    }
                    if (wizard.getEntityClass().equals((Object)ArbeitsprotokollCustomBean.ChildType.STANDORT)) {
                        this.standorteWizards.add(wizard);
                        continue;
                    }
                    if (wizard.getEntityClass().equals((Object)ArbeitsprotokollCustomBean.ChildType.ABZWEIGDOSE)) {
                        this.abzweigdoseWizards.add(wizard);
                        continue;
                    }
                    if (wizard.getEntityClass().equals((Object)ArbeitsprotokollCustomBean.ChildType.MAUERLASCHE)) {
                        this.mauerlascheWizards.add(wizard);
                        continue;
                    }
                    if (wizard.getEntityClass().equals((Object)ArbeitsprotokollCustomBean.ChildType.SCHALTSTELLE)) {
                        this.schaltstelleWizards.add(wizard);
                        continue;
                    }
                    if (!wizard.getEntityClass().equals((Object)ArbeitsprotokollCustomBean.ChildType.LEITUNG)) continue;
                    this.leitungWizards.add(wizard);
                }
                catch (Exception ex) {
                    LOG.error((Object)"Error while initializing wizard", (Throwable)ex);
                }
            }
        }
        catch (Throwable ex) {
            LOG.error((Object)"Error while lookup of widgets", ex);
        }
    }

    public void initMappingComponent() {
        MappingComponent mappingComponent = new MappingComponent();
        final MetaSearchHelper metaSearchComponentFactory = MetaSearchHelper.createNewInstance((boolean)true, (String)"SEARCH_POLYGON", (MappingComponent)mappingComponent, null);
        this.setMappingComponent(mappingComponent);
        metaSearchComponentFactory.setCustomGeoSearch((GeoSearch)new BelisTopicSearchStatement());
        this.setMetaSearchComponentFactory(metaSearchComponentFactory);
        CismapBroker.getInstance().addStatusListener(new StatusListener(){

            public void statusValueChanged(StatusEvent e) {
                if (e.getName().equals("mode")) {
                    if (e.getValue().equals("SEARCH_POLYGON")) {
                        metaSearchComponentFactory.getCmdPluginSearch().setSelected(true);
                        BelisBroker.this.getMapWidget().setCustomMapMode();
                    } else {
                        metaSearchComponentFactory.getCmdPluginSearch().setSelected(false);
                    }
                }
            }
        });
    }

    public void masterConfigure(Element parent) {
        this.initToolbar();
        try {
            this.saveWaitDialog = new SaveWaitDialog(StaticSwingTools.getParentFrame((Component)this.getParentComponent()), true);
            this.cancelWaitDialog = new CancelWaitDialog(StaticSwingTools.getParentFrame((Component)this.getParentComponent()), true);
            this.lockWaitDialog = new LockWaitDialog(StaticSwingTools.getParentFrame((Component)this.getParentComponent()), true);
            this.releaseWaitDialog = new ReleaseWaitDialog(StaticSwingTools.getParentFrame((Component)this.getParentComponent()), true);
        }
        catch (Exception ex) {
            LOG.warn((Object)"Error while creating search and wait dialog", (Throwable)ex);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("masterConfigure: " + BelisBroker.class.getName()));
        }
        try {
            try {
                Element loggingConf = parent.getChild("Logging");
                this.loggingProperties = loggingConf.getChildText("LoggingProperties");
                this.initLog4J();
            }
            catch (Exception ex) {
                LOG.error((Object)"Error while configuring logging", (Throwable)ex);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("masterConfigure: " + BelisBroker.class.getName()));
            }
            this.configManager.addConfigurable((Configurable)this.metaSearchComponentFactory);
            this.configManager.configure((Configurable)this.metaSearchComponentFactory);
            this.configManager.addConfigurable((Configurable)OptionsClient.getInstance());
            this.configManager.configure((Configurable)OptionsClient.getInstance());
            for (BelisWidget widget : this.getWidgets()) {
                try {
                    this.configManager.addConfigurable((Configurable)widget);
                    this.configManager.configure((Configurable)widget);
                }
                catch (Exception ex) {
                    LOG.error((Object)("Fehler beim konfigurieren des Widgets: " + widget.getName()), (Throwable)ex);
                }
            }
            this.customizeApplication();
        }
        catch (Exception ex) {
            LOG.error((Object)"Fehler beim konfigurieren des Lagis Brokers: ", (Throwable)ex);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("masterConfigure:" + BelisBroker.class.getName()));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Configure Belis specific borker");
        }
        this.doBelisBinding();
        this.customizeMapWidget();
        int defaultFontSize = 16;
        LOG.warn((Object)"Error setting fontsize for map objects. Setting font to default: 16");
        IconUtils.setFont((Font)new Font("Courier", 0, 16));
        this.showMainApplication();
    }

    public MapWidget getMapWidget() {
        return this.mapWidget;
    }

    public void setMapWidget(MapWidget mapWidget) {
        this.mapWidget = mapWidget;
    }

    public void configure(Element parent) {
    }

    public String getCurrentValidationErrorMessage() {
        return this.currentValidationErrorMessage;
    }

    public StatusBar getStatusBar() {
        return this.statusBar;
    }

    public void setStatusBar(StatusBar statusBar) {
        this.statusBar = statusBar;
    }

    public void warnIfThreadIsNotEDT() {
        if (!EventQueue.isDispatchThread()) {
            LOG.fatal((Object)"current Thread is not EDT, but should be --> look", (Throwable)new CurrentStackTrace());
        }
    }

    public void warnIfThreadIsEDT() {
        if (EventQueue.isDispatchThread()) {
            LOG.fatal((Object)"current Thread is EDT, but should not --> look", (Throwable)new CurrentStackTrace());
        }
    }

    public void execute(SwingWorker workerThread) {
        try {
            this.execService.submit(workerThread);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"SwingWorker an Threadpool \u00fcbermittelt");
            }
        }
        catch (Exception ex) {
            LOG.fatal((Object)"Fehler beim starten eines Swingworkers", (Throwable)ex);
        }
    }

    public void fireChangeFinished(ObjectChangeListener changeListener) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private void initLog4J() {
        try {
            try (FileInputStream configStream = new FileInputStream(this.loggingProperties);){
                ConfigurationSource source = new ConfigurationSource((InputStream)configStream);
                LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
                context.start((Configuration)new XmlConfiguration(context, source));
            }
            LOG.info((Object)"Log4J System erfolgreich konfiguriert");
        }
        catch (Exception ex) {
            System.err.println("Fehler bei Log4J Initialisierung");
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void showMainApplication() {
        Thread t = new Thread(){

            @Override
            public void run() {
                Frame frame = StaticSwingTools.getParentFrame((Component)BelisBroker.this.getParentComponent());
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("MainApplication frame: " + frame));
                }
                while (frame == null || frame instanceof AbstractPlugin && !((AbstractPlugin)frame).isReadyToShow()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"frame is null or not ready going to sleep");
                    }
                    try {
                        9.sleep(1000L);
                        frame = StaticSwingTools.getParentFrame((Component)BelisBroker.this.getParentComponent());
                    }
                    catch (InterruptedException ex) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"Sleep was interuppted running again.");
                        }
                        this.run();
                    }
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"frame available and ready to show");
                    LOG.debug((Object)"check read mode");
                }
                BelisBroker.this.mapWidget.setInteractionMode();
                frame.setVisible(true);
            }
        };
        t.start();
    }

    public String getAccountName() {
        if (this.account == null) {
            LOG.fatal((Object)("Benutzername unvollst\u00e4ndig: " + this.account));
        }
        return this.account;
    }

    public void setAccountName(String aAccount) {
        this.account = aAccount;
    }

    public ConfigurationManager getConfigManager() {
        return this.configManager;
    }

    public void setApplicatioName(String applicationName) {
        this.applicationName = applicationName;
    }

    public void setTotd(String totd) {
        this.totd = totd;
    }

    public String getTotd() {
        return this.totd;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setConfigManager(ConfigurationManager configManager) {
        this.configManager = configManager;
    }

    public LayoutManager getLayoutManager() {
        return this.layoutManager;
    }

    public void setLayoutManager(LayoutManager layoutManager) {
        this.layoutManager = layoutManager;
    }

    public void pluginConstructionDone() {
        try {
            Runnable layoutRun = new Runnable(){

                @Override
                public void run() {
                    BelisBroker.this.layoutManager.configureInfoNodeDocking();
                    BelisBroker.this.layoutManager.doLayoutInfoNodeDefaultFile();
                }
            };
            if (EventQueue.isDispatchThread()) {
                layoutRun.run();
            } else {
                EventQueue.invokeLater(layoutRun);
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"Error while setting layout: ", (Throwable)ex);
        }
    }

    public RootWindow getRootWindow() {
        return this.layoutManager.getRootWindow();
    }

    public void setTitleBarComponentpainter(Color color) {
        this.getRootWindow().getRootWindowProperties().getViewProperties().getViewTitleBarProperties().getNormalProperties().getShapedPanelProperties().setComponentPainter((ComponentPainter)new GradientComponentPainter(color, new Color(236, 233, 216), color, new Color(236, 233, 216)));
    }

    public void setTitleBarComponentpainter(Color left, Color right) {
        this.getRootWindow().getRootWindowProperties().getViewProperties().getViewTitleBarProperties().getNormalProperties().getShapedPanelProperties().setComponentPainter((ComponentPainter)new GradientComponentPainter(left, right, left, right));
    }

    public JButton getBtnAcceptChanges() {
        return this.btnAcceptChanges;
    }

    public void setBtnAcceptChanges(JButton btnAcceptChanges) {
        this.btnAcceptChanges = btnAcceptChanges;
    }

    public JButton getBtnDiscardChanges() {
        return this.btnDiscardChanges;
    }

    public void setBtnDiscardChanges(JButton btnDiscardChanges) {
        this.btnDiscardChanges = btnDiscardChanges;
    }

    public JButton getBtnReloadFlurstueck() {
        return this.btnReload;
    }

    public void setBtnReloadFlurstueck(JButton btnReloadFlurstueck) {
        this.btnReload = btnReloadFlurstueck;
    }

    public void setBtnSwitchInCreateMode(JButton btnSwitchInCreateMode) {
        this.btnSwitchInCreateMode = btnSwitchInCreateMode;
    }

    private void initToolbar() {
        try {
            this.toolbar = new JToolBar();
            this.toolbar.setBorderPainted(false);
            this.toolbar.setRollover(true);
            if (StaticDebuggingTools.checkHomeForFile((String)"cismetAppendToTestFileServerActionToolbar")) {
                JButton b = new JButton(new AbstractAction("AppendToTestFileServerAction"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        AppendToTestFileServerAction sa = new AppendToTestFileServerAction();
                        try {
                            CidsBroker.getInstance().executeServerAction(sa.getTaskName(), JOptionPane.showInputDialog(null, (Object)"Line to Append?"), new ServerActionParameter[0]);
                        }
                        catch (Exception ex) {
                            LOG.error((Object)ex, (Throwable)ex);
                        }
                    }
                });
                this.toolbar.add(b);
            }
            this.editButtonsToolbar = new EditButtonsToolbar();
            this.toolbar.add(this.editButtonsToolbar);
            this.addSeparatorToToolbar();
            this.cmdPrint.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/commons/architecture/resource/icon/toolbar/frameprint.png")));
            this.cmdPrint.setToolTipText("Drucken");
            this.cmdPrint.setBorderPainted(false);
            this.cmdPrint.setFocusable(false);
            this.cmdPrint.setHorizontalTextPosition(0);
            Dimension size = new Dimension(30, 23);
            this.cmdPrint.setPreferredSize(size);
            this.cmdPrint.setMinimumSize(size);
            this.cmdPrint.setMaximumSize(size);
            this.cmdPrint.setVerticalTextPosition(3);
            this.cmdPrint.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    BelisBroker.this.getMappingComponent().showPrintingSettingsDialog();
                }
            });
            this.cmdAAPrint.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/belis/resource/icon/22/printAA.png")));
            this.cmdAAPrint.setToolTipText("Arbeitsauftrags-Report");
            this.cmdAAPrint.setBorderPainted(false);
            this.cmdAAPrint.setFocusable(false);
            this.cmdAAPrint.setHorizontalTextPosition(0);
            this.cmdAAPrint.setPreferredSize(size);
            this.cmdAAPrint.setMinimumSize(size);
            this.cmdAAPrint.setMaximumSize(size);
            this.cmdAAPrint.setVerticalTextPosition(3);
            this.cmdAAPrint.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    BelisBroker.this.printReport();
                }
            });
            this.cmdCsvExport.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/belis/resource/icon/16/table-import.png")));
            this.cmdCsvExport.setToolTipText("Nach CSV Exportieren");
            this.cmdCsvExport.setBorderPainted(false);
            this.cmdCsvExport.setFocusable(false);
            this.cmdCsvExport.setHorizontalTextPosition(0);
            this.cmdCsvExport.setPreferredSize(size);
            this.cmdCsvExport.setMinimumSize(size);
            this.cmdCsvExport.setMaximumSize(size);
            this.cmdCsvExport.setVerticalTextPosition(3);
            this.cmdCsvExport.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    BelisBroker.this.exportCsv();
                }
            });
            JPanel printPanel = new JPanel();
            printPanel.setLayout(new GridBagLayout());
            printPanel.setMaximumSize(new Dimension(90, 23));
            printPanel.setMinimumSize(new Dimension(90, 23));
            printPanel.setPreferredSize(new Dimension(90, 23));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 17;
            printPanel.add((Component)this.cmdPrint, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            printPanel.add((Component)this.cmdAAPrint, gridBagConstraints);
            gridBagConstraints.gridx = 2;
            printPanel.add((Component)this.cmdCsvExport, gridBagConstraints);
            this.toolbar.add(printPanel);
            this.addSeparatorToToolbar();
        }
        catch (Exception ex) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Exception while initializing toolbar");
            }
            LOG.error((Object)"Exception while initializing toolbar.", (Throwable)ex);
        }
    }

    private void exportCsv() {
        CsvExportBackend backend = CsvExportBackend.getInstance();
        Collection<TreePath> paths = this.getWorkbenchWidget().getSelectedTreeNodes();
        if (paths == null) {
            JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)this.getParentComponent()), "Es muss mindestens ein Objekt im Arbeitsbereich selektiert sein.", "keine Objekte selektiert", 1);
        } else {
            ArrayList<WorkbenchEntity> mainBeans = new ArrayList<WorkbenchEntity>();
            for (TreePath treePath : paths) {
                CustomMutableTreeTableNode customMutableTreeTableNode = (CustomMutableTreeTableNode)((Object)treePath.getLastPathComponent());
                if (customMutableTreeTableNode == null) continue;
                Object object = customMutableTreeTableNode.getUserObject();
                if (object instanceof ArbeitsauftragCustomBean) {
                    ArbeitsauftragCustomBean auftrag = (ArbeitsauftragCustomBean)object;
                    for (ArbeitsprotokollCustomBean protokoll : auftrag.getAr_protokolle()) {
                        WorkbenchEntity childBean = protokoll.getChildEntity();
                        if (mainBeans.contains(childBean)) continue;
                        mainBeans.add(childBean);
                    }
                    continue;
                }
                if (object instanceof ArbeitsprotokollCustomBean) {
                    ArbeitsprotokollCustomBean protokoll = (ArbeitsprotokollCustomBean)object;
                    WorkbenchFeatureEntity workbenchFeatureEntity = protokoll.getChildEntity();
                    if (mainBeans.contains(workbenchFeatureEntity)) continue;
                    mainBeans.add(workbenchFeatureEntity);
                    continue;
                }
                if (object instanceof VeranlassungCustomBean) {
                    VeranlassungCustomBean veranlassung = (VeranlassungCustomBean)object;
                    ArrayList<WorkbenchFeatureEntity> arrayList = new ArrayList<WorkbenchFeatureEntity>();
                    arrayList.addAll(veranlassung.getAr_abzweigdosen());
                    arrayList.addAll(veranlassung.getAr_leitungen());
                    arrayList.addAll(veranlassung.getAr_leuchten());
                    arrayList.addAll(veranlassung.getAr_mauerlaschen());
                    arrayList.addAll(veranlassung.getAr_schaltstellen());
                    arrayList.addAll(veranlassung.getAr_standorte());
                    for (WorkbenchEntity childBean : arrayList) {
                        if (mainBeans.contains(childBean)) continue;
                        mainBeans.add(childBean);
                    }
                    continue;
                }
                if (!(object instanceof WorkbenchEntity) || mainBeans.contains((WorkbenchEntity)object)) continue;
                mainBeans.add((WorkbenchEntity)object);
            }
            ArrayList<CidsBean> beans = new ArrayList<CidsBean>();
            for (WorkbenchEntity workbenchEntity : mainBeans) {
                if (workbenchEntity instanceof TdtaStandortMastCustomBean) {
                    TdtaStandortMastCustomBean standort = (TdtaStandortMastCustomBean)workbenchEntity;
                    if (!beans.contains(standort)) {
                        beans.add(standort);
                    }
                    if (standort.getLeuchten() == null) continue;
                    for (WorkbenchEntity workbenchEntity2 : standort.getLeuchten()) {
                        if (beans.contains(workbenchEntity2)) continue;
                        beans.add(workbenchEntity2);
                    }
                    continue;
                }
                if (workbenchEntity instanceof TdtaLeuchtenCustomBean) {
                    TdtaStandortMastCustomBean standort;
                    TdtaLeuchtenCustomBean leuchte = (TdtaLeuchtenCustomBean)workbenchEntity;
                    if (!beans.contains(leuchte)) {
                        beans.add(leuchte);
                    }
                    if ((standort = leuchte.getFk_standort()) == null || beans.contains(standort)) continue;
                    beans.add(standort);
                    continue;
                }
                if (beans.contains(workbenchEntity)) continue;
                beans.add(workbenchEntity);
            }
            Map<MetaClass, String> map = backend.toCsvStrings(beans);
            if (!map.isEmpty() && DownloadManagerDialog.showAskingForUserTitle((Component)this.getRootWindow())) {
                for (MetaClass metaClass : map.keySet()) {
                    String title = metaClass.getName();
                    String string = map.get(metaClass);
                    DownloadManager.instance().add((Download)new ByteArrayDownload(string.getBytes(), title, DownloadManagerDialog.getInstance().getJobName(), title, ".csv"));
                }
                DownloadManagerDialog downloadManagerDialog = DownloadManagerDialog.getInstance();
                downloadManagerDialog.pack();
                StaticSwingTools.showDialog((Component)this.getRootWindow(), (JDialog)downloadManagerDialog, (boolean)true);
            }
        }
    }

    public void fireSaveStartedAndExecuteSaveCancelWorker() {
        this.fireSaveStarted();
        this.execute(new SaveCancelWorker(0));
    }

    public void fireCancelStartedAndExecuteSaveCancelWorker() {
        this.fireCancelStarted();
        this.execute(new SaveCancelWorker(1));
    }

    protected void fireSaveFinished() {
        this.saveWaitDialog.setVisible(false);
    }

    protected void fireCancelFinished() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                BelisBroker.this.cancelWaitDialog.setVisible(false);
            }
        });
    }

    protected void fireCancelStarted() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                BelisBroker.this.cancelWaitDialog.setLocationRelativeTo(StaticSwingTools.getParentFrame((Component)BelisBroker.this.getParentComponent()));
                BelisBroker.this.cancelWaitDialog.setVisible(true);
            }
        });
    }

    protected void fireLockFinished() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                BelisBroker.this.lockWaitDialog.setVisible(false);
            }
        });
    }

    protected void fireLockStarted() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                BelisBroker.this.lockWaitDialog.setLocationRelativeTo(StaticSwingTools.getParentFrame((Component)BelisBroker.this.getParentComponent()));
                BelisBroker.this.lockWaitDialog.setVisible(true);
            }
        });
    }

    protected void fireReleaseFinished() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                BelisBroker.this.releaseWaitDialog.setVisible(false);
            }
        });
    }

    protected void fireReleaseStarted() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                BelisBroker.this.releaseWaitDialog.setLocationRelativeTo(StaticSwingTools.getParentFrame((Component)BelisBroker.this.getParentComponent()));
                BelisBroker.this.releaseWaitDialog.setVisible(true);
            }
        });
    }

    protected void fireSaveStarted() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                BelisBroker.this.saveWaitDialog.setLocationRelativeTo(StaticSwingTools.getParentFrame((Component)BelisBroker.this.getParentComponent()));
                BelisBroker.this.saveWaitDialog.setVisible(true);
            }
        });
    }

    public JToolBar getToolbar() {
        return this.toolbar;
    }

    public void addSeparatorToToolbar() {
        this.getToolbar().add(this.createToolBarSeperator());
    }

    public JSeparator createToolBarSeperator() {
        JSeparator tmpSeperator = new JSeparator();
        tmpSeperator.setOrientation(1);
        tmpSeperator.setMaximumSize(new Dimension(2, Short.MAX_VALUE));
        tmpSeperator.setMinimumSize(new Dimension(2, 25));
        tmpSeperator.setPreferredSize(new Dimension(2, 23));
        return tmpSeperator;
    }

    public Runnable saveWorkbench() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"save");
            LOG.debug((Object)(this.workbenchWidget.getObjectsToPersist().size() + " Objects to save"));
            LOG.debug((Object)(this.workbenchWidget.getObjectsToDelete().size() + " Objects to delete"));
        }
        Collection<WorkbenchEntity> persistedObjects = CidsBroker.getInstance().saveObjects(this.workbenchWidget.getObjectsToPersist());
        this.getCurrentSearchResults().addAll(persistedObjects);
        if (!this.isInCreateMode()) {
            Collection<WorkbenchEntity> objectsToDelete = this.workbenchWidget.getObjectsToDelete();
            CidsBroker.getInstance().deleteEntities(objectsToDelete);
            this.getCurrentSearchResults().removeAll(objectsToDelete);
        }
        for (WorkbenchEntity entity : this.getCurrentSearchResults()) {
            entity.storeBackup();
        }
        this.workbenchWidget.getObjectsToDelete().clear();
        if (this.isInCreateMode()) {
            this.workbenchWidget.clearNewNode();
        } else {
            this.workbenchWidget.clearEditNode();
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                BelisBroker.this.workbenchWidget.refreshAll();
                BelisBroker.this.refreshMap();
            }
        };
        return runnable;
    }

    protected Runnable cancelWorkbench() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"cancel");
        }
        if (!this.isInCreateMode()) {
            this.getCurrentSearchResults().addAll(this.workbenchWidget.getObjectsToDelete());
            for (BaseEntity baseEntity : this.workbenchWidget.getObjectsToPersist()) {
                baseEntity.loadBackup();
            }
            this.getCurrentSearchResults().addAll(this.workbenchWidget.getObjectsToPersist());
        }
        this.workbenchWidget.getObjectsToDelete().clear();
        if (this.isInCreateMode()) {
            this.workbenchWidget.clearNewNode();
        } else {
            this.workbenchWidget.clearEditNode();
        }
        Runnable cancelEDTRun = new Runnable(){

            @Override
            public void run() {
                BelisBroker.this.workbenchWidget.refreshAll();
                BelisBroker.this.refreshMap();
            }
        };
        return cancelEDTRun;
    }

    public JXTreeTable decorateWithAlternateHighlighting(JXTreeTable ttable) {
        ttable.addHighlighter(ALTERNATE_ROW_HIGHLIGHTER);
        return ttable;
    }

    public JXTreeTable decorateWithNoGeometryHighlighter(final JXTreeTable ttable) {
        HighlightPredicate noGeometryPredicate = new HighlightPredicate(){

            public boolean isHighlighted(Component renderer, ComponentAdapter componentAdapter) {
                try {
                    Object userObj = ((AbstractMutableTreeTableNode)ttable.getPathForRow(componentAdapter.row).getLastPathComponent()).getUserObject();
                    if (userObj != null && userObj instanceof WorkbenchFeatureEntity) {
                        return ((WorkbenchFeatureEntity)userObj).getGeometry() == null;
                    }
                }
                catch (Exception ex) {
                    LOG.error((Object)"Exception in Highlighter: ", (Throwable)ex);
                }
                return false;
            }
        };
        ColorHighlighter noGeometryHighlighter = new ColorHighlighter(noGeometryPredicate, gray, null);
        ttable.addHighlighter((Highlighter)noGeometryHighlighter);
        return ttable;
    }

    public void showSaveErrorDialog(Exception ex) {
        this.showErrorDialog("Fehler beim speichern...", "<html><table width=\"250\" border=\"0\"><tr><td>Fehler beim speichern der Objekte. Ihre \u00c4nderungen konnten nicht gespeichert werden.</td></tr></table></html>", ex);
    }

    public void showErrorDialog(String title, String text, Exception ex) {
        ErrorInfo ei = new ErrorInfo(title, text, null, null, (Throwable)ex, Level.SEVERE, null);
        JXErrorPane.showDialog((Component)this.getParentComponent(), (ErrorInfo)ei);
    }

    private void customizeApplication() {
        this.customizeApplicationToolbar();
    }

    public void customizeApplicationToolbar() {
        SimpleMemoryMonitoringToolbarWidget memTB = new SimpleMemoryMonitoringToolbarWidget();
        if (memTB.isVisible()) {
            this.getToolbar().add((Action)memTB);
            this.getToolbar().add(this.createToolBarSeperator());
        }
        this.addCreateToolBar();
        this.addCopyPasteToolBar();
        this.addFilterToolbar();
        this.addLocationSearch();
        this.getToolbar().add(this.metaSearchComponentFactory.getCmdPluginSearch());
        this.addSeparatorToToolbar();
        this.addMapSearchControl();
        this.btnAcceptChanges.setIcon(BelisIcons.icoAccept22);
        this.btnDiscardChanges.setIcon(BelisIcons.icoCancel22);
    }

    public StatusBar getStatusbar() {
        return this.statusbar;
    }

    public void setStatusbar(StatusBar statusbar) {
        this.statusbar = statusbar;
    }

    public boolean isStatusBarEnabled() {
        return this.statusBarEnabled;
    }

    public void setStatusBarEnabled(boolean isStatusBarEnabled) {
        this.statusBarEnabled = isStatusBarEnabled;
    }

    public Set<WorkbenchEntity> getCurrentSearchResults() {
        return this.currentSearchResults;
    }

    public void setCurrentSearchResults(Set<WorkbenchEntity> currentSearchResults) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"setSearchResults");
        }
        Set<WorkbenchEntity> old = this.currentSearchResults;
        this.currentSearchResults = currentSearchResults;
        if (this.currentSearchResults != null && currentSearchResults != null && this.currentSearchResults.equals(currentSearchResults)) {
            LOG.warn((Object)"Sets are equals no propertyChange doing manually refresh --> ToDo fix me");
            this.refreshWidgets(currentSearchResults);
        }
        this.propertyChangeSupport.firePropertyChange(PROP_CURRENT_SEARCH_RESULTS, old, currentSearchResults);
    }

    public void setSearchResult(final Set<WorkbenchEntity> set) {
        new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                if (set != null) {
                    for (WorkbenchEntity entity : set) {
                        entity.storeBackup();
                    }
                }
                return null;
            }

            @Override
            protected void done() {
                if (set != null) {
                    BelisBroker.this.setCurrentSearchResults(set);
                    BelisBroker.this.refreshMap();
                    BelisBroker.this.getMappingComponent().zoomToFullFeatureCollectionBounds();
                } else {
                    BelisBroker.this.clearMap();
                }
            }
        }.execute();
    }

    public DetailWidget getDetailWidget() {
        return this.detailWidget;
    }

    public void setDetailWidget(DetailWidget detailWidget) {
        this.detailWidget = detailWidget;
    }

    public Collection searchForArbeitsprotokolleOfVeralassung(String veranlassungsnummer) {
        ArbeitsauftragSearchStatement searchStatement = new ArbeitsauftragSearchStatement();
        searchStatement.setVeranlassungsNummer(veranlassungsnummer);
        searchStatement.setActiveObjectsOnly(false);
        searchStatement.setWorkedoffObjectsOnly(false);
        try {
            Collection res = SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)searchStatement);
            return res;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public void search(BoundingBox bb) {
        try {
            this.disableSearch();
            BelisSearchStatement belisSearchStatement = new BelisSearchStatement(this.isFilterNormal(), false, this.isFilterNormal(), this.isFilterNormal(), this.isFilterNormal(), this.isFilterNormal(), this.isFilterVeranlassung(), this.isFilterArbeitsauftrag());
            int srid = CrsTransformer.extractSridFromCrs((String)CismapBroker.getInstance().getMappingComponent().getMappingModel().getSrs().getCode());
            Geometry searchGeom = CrsTransformer.transformToDefaultCrs((Geometry)bb.getGeometry(srid));
            belisSearchStatement.setGeometry(searchGeom);
            CidsSearchExecutor.searchAndDisplayResultsWithDialog((MetaObjectNodeServerSearch)belisSearchStatement);
        }
        catch (Exception ex) {
            LOG.error((Object)"Exception while searching boundingbox: ", (Throwable)ex);
            this.enableSearch();
            this.fireSearchFinished();
        }
    }

    public void search(String strassenschluessel, Integer kennziffer, Integer laufendeNummer) {
        try {
            this.disableSearch();
            BelisLocationSearchStatement searchStatement = new BelisLocationSearchStatement(strassenschluessel, kennziffer, laufendeNummer);
            CidsSearchExecutor.searchAndDisplayResultsWithDialog((MetaObjectNodeServerSearch)searchStatement);
        }
        catch (Exception ex) {
            LOG.error((Object)"Exception while searching by location: ", (Throwable)ex);
            this.enableSearch();
            this.fireSearchFinished();
        }
    }

    private Collection<Feature> addEntityRecursiveToMap(Collection searchResults) {
        HashSet<Feature> featuresToAdd = new HashSet<Feature>();
        if (searchResults != null) {
            for (Object currentResult : searchResults) {
                if (currentResult instanceof VeranlassungCustomBean) {
                    VeranlassungCustomBean veranlassungCustomBean = (VeranlassungCustomBean)currentResult;
                    featuresToAdd.addAll(this.addEntityRecursiveToMap(veranlassungCustomBean.getAr_geometrien()));
                    featuresToAdd.addAll(this.addEntityRecursiveToMap(veranlassungCustomBean.getAr_abzweigdosen()));
                    featuresToAdd.addAll(this.addEntityRecursiveToMap(veranlassungCustomBean.getAr_leitungen()));
                    featuresToAdd.addAll(this.addEntityRecursiveToMap(veranlassungCustomBean.getAr_leuchten()));
                    featuresToAdd.addAll(this.addEntityRecursiveToMap(veranlassungCustomBean.getAr_mauerlaschen()));
                    featuresToAdd.addAll(this.addEntityRecursiveToMap(veranlassungCustomBean.getAr_schaltstellen()));
                    featuresToAdd.addAll(this.addEntityRecursiveToMap(veranlassungCustomBean.getAr_standorte()));
                    continue;
                }
                if (currentResult instanceof ArbeitsauftragCustomBean) {
                    ArbeitsauftragCustomBean arbeitsauftragCustomBean = (ArbeitsauftragCustomBean)currentResult;
                    for (ArbeitsprotokollCustomBean protokoll : arbeitsauftragCustomBean.getAr_protokolle()) {
                        if (protokoll.getFk_abzweigdose() != null) {
                            featuresToAdd.add((Feature)protokoll.getFk_abzweigdose());
                        }
                        if (protokoll.getFk_leitung() != null) {
                            featuresToAdd.add((Feature)protokoll.getFk_leitung());
                        }
                        if (protokoll.getFk_leuchte() != null) {
                            featuresToAdd.add((Feature)protokoll.getFk_leuchte());
                        }
                        if (protokoll.getFk_mauerlasche() != null) {
                            featuresToAdd.add((Feature)protokoll.getFk_mauerlasche());
                        }
                        if (protokoll.getFk_schaltstelle() != null) {
                            featuresToAdd.add((Feature)protokoll.getFk_schaltstelle());
                        }
                        if (protokoll.getFk_standort() != null) {
                            featuresToAdd.add((Feature)protokoll.getFk_standort());
                        }
                        if (protokoll.getFk_geometrie() == null) continue;
                        featuresToAdd.add((Feature)protokoll.getFk_geometrie());
                    }
                    continue;
                }
                if (!(currentResult instanceof StyledFeature) || ((StyledFeature)currentResult).getGeometry() == null) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"SearchResult is Styled Feature and geometry != null --> adding feature to map.");
                }
                featuresToAdd.add((Feature)((StyledFeature)currentResult));
                if (currentResult instanceof TdtaStandortMastCustomBean && ((TdtaStandortMastCustomBean)currentResult).getLeuchten() != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"SearchResult is instance of Standort and owns Leuchte objects --> also adding to Map");
                    }
                    featuresToAdd.addAll(this.addEntityRecursiveToMap(((TdtaStandortMastCustomBean)currentResult).getLeuchten()));
                }
                if (currentResult instanceof LeitungCustomBean) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"SearchResult is instance of Leitung. Setting PropertyChangeListener");
                    }
                    ((LeitungCustomBean)currentResult).addPropertyChangeListener(this);
                }
                if (!(currentResult instanceof MauerlascheCustomBean)) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"SearchResult is instance of Leitung. Setting PropertyChangeListener");
                }
                ((MauerlascheCustomBean)currentResult).addPropertyChangeListener(this);
            }
        }
        return featuresToAdd;
    }

    private void clearMap() {
        try {
            if (EventQueue.isDispatchThread()) {
                this.getMappingComponent().getFeatureCollection().removeAllFeatures();
            } else {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        BelisBroker.this.clearMap();
                    }
                });
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"Error while clearing map: ", (Throwable)ex);
        }
    }

    private void refreshMap() {
        if (this.getCurrentSearchResults() != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("refreshMap (features): " + this.getCurrentSearchResults().size()));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("refreshMap featureCollection: " + this.getMappingComponent().getFeatureCollection().getFeatureCount()));
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"refreshMap no results");
        }
        try {
            if (EventQueue.isDispatchThread()) {
                this.getMappingComponent().getFeatureCollection().removeAllFeatures();
                this.getMappingComponent().getFeatureCollection().substituteFeatures(this.addEntityRecursiveToMap(this.getCurrentSearchResults()));
            } else {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        BelisBroker.this.refreshMap();
                    }
                });
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"Error while refreshi\u0144g map: ", (Throwable)ex);
        }
    }

    public WorkbenchWidget getWorkbenchWidget() {
        return this.workbenchWidget;
    }

    private void doBelisBinding() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"DoBelisBinding()");
        }
        for (BelisWidget curWidget : this.getWidgets()) {
            if (this.workbenchWidget != null && this.detailWidget != null) break;
            if (curWidget instanceof WorkbenchWidget) {
                this.workbenchWidget = (WorkbenchWidget)curWidget;
                continue;
            }
            if (!(curWidget instanceof DetailWidget)) continue;
            this.detailWidget = (DetailWidget)curWidget;
        }
        if (this.workbenchWidget == null || this.detailWidget == null) {
            LOG.warn((Object)"Workbench Widget could not be bound to Detail Widget because one of them == null");
        }
        PropertyChangeListener listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("selectedTreeNodes")) {
                    Object selectedObject;
                    ArrayList<WorkbenchEntity> currentEntities = new ArrayList<WorkbenchEntity>();
                    WorkbenchEntity parentEntity = null;
                    boolean first = true;
                    boolean allSameParent = true;
                    boolean allSameType = true;
                    CustomMutableTreeTableNode allSameParentNode = null;
                    Object allSameMainNode = null;
                    Class<?> allSameTypeClass = null;
                    if (((WorkbenchWidget)evt.getSource()).getSelectedTreeNodes() != null) {
                        for (TreePath treePath : ((WorkbenchWidget)evt.getSource()).getSelectedTreeNodes()) {
                            Object currentMainNode = treePath.getPathComponent(1);
                            CustomMutableTreeTableNode currentParentNode = (CustomMutableTreeTableNode)((Object)treePath.getParentPath().getLastPathComponent());
                            Object currentUserObject = ((CustomMutableTreeTableNode)((Object)treePath.getLastPathComponent())).getUserObject();
                            Class<?> currentClass = currentUserObject.getClass();
                            if (first) {
                                allSameParentNode = currentParentNode;
                                allSameMainNode = currentMainNode;
                                allSameTypeClass = currentClass;
                                first = false;
                            }
                            if (currentParentNode != allSameParentNode) {
                                allSameParent = false;
                            }
                            if (currentClass != allSameTypeClass) {
                                allSameType = false;
                            }
                            if (!(currentUserObject instanceof WorkbenchEntity)) continue;
                            currentEntities.add((WorkbenchEntity)currentUserObject);
                        }
                    }
                    if (!allSameType || allSameTypeClass == null || currentEntities.size() > 1 && !allSameTypeClass.equals(ArbeitsprotokollCustomBean.class)) {
                        currentEntities.clear();
                    }
                    if (!currentEntities.isEmpty() && allSameParent && allSameParentNode != null && allSameParentNode.getUserObject() instanceof WorkbenchEntity) {
                        parentEntity = (WorkbenchEntity)allSameParentNode.getUserObject();
                    }
                    boolean isFromNewNode = allSameMainNode != null && allSameMainNode.equals((Object)((WorkbenchWidget)evt.getSource()).getNewObjectsNode());
                    boolean isFromEditNode = allSameMainNode != null && allSameMainNode.equals((Object)((WorkbenchWidget)evt.getSource()).getEditObjectsNode());
                    try {
                        BelisBroker.this.detailWidget.setCurrentEntities(currentEntities, parentEntity, isFromNewNode || isFromEditNode);
                    }
                    catch (VetoException ex) {
                        return;
                    }
                    BelisBroker.this.copyPasteToolbar.clipboardChanged();
                    WorkbenchEntity selectedSingleEntity = currentEntities.size() == 1 ? ((selectedObject = currentEntities.iterator().next()) != null && selectedObject instanceof WorkbenchEntity ? (WorkbenchEntity)selectedObject : null) : null;
                    if (BelisBroker.this.isInEditMode()) {
                        if (isFromNewNode || isFromEditNode) {
                            BelisBroker.this.panCreate.setSelectedEntity(selectedSingleEntity);
                        } else {
                            BelisBroker.this.panCreate.setSelectedEntity(null);
                        }
                    } else {
                        BelisBroker.this.panCreate.setSelectedEntity(null);
                    }
                }
            }
        };
        if (this.workbenchWidget != null) {
            this.workbenchWidget.addPropertyChangeListener(listener);
        }
    }

    public void acquireLock() throws Exception {
        if (this.isPendingForCreateMode.get()) {
            this.setInCreateMode(true);
            this.isPendingForCreateMode.set(false);
        }
        if (!this.isInCreateMode()) {
            try {
                this.releaseLock();
                this.sperre = CidsBroker.getInstance().lockEntities(this.currentSearchResults, this.getAccountName());
            }
            catch (ActionNotSuccessfulException ex) {
                LOG.error((Object)"Error while creating lock:", (Throwable)ex);
                this.isPendingForCreateMode.set(false);
                throw new Exception("Sperren konnten nicht angelegt werden, wechseln in Editmodus nicht m\u00f6glich");
            }
            catch (LockAlreadyExistsException ex) {
                LOG.info((Object)"Some of the objects are already locked", (Throwable)ex);
                this.isPendingForCreateMode.set(false);
                ArrayList<SperreCustomBean> alreadyLocked = new ArrayList<SperreCustomBean>();
                for (MetaObjectNode mon : ex.getAlreadyExisingLocks()) {
                    alreadyLocked.add((SperreCustomBean)CidsBroker.getInstance().getMetaObject(mon.getClassId(), mon.getObjectId(), "BELIS2").getBean());
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Count of already locked objects: " + alreadyLocked.size()));
                }
                this.fireLockFinished();
                this.showObjectsLockedDialog(alreadyLocked);
                this.isPendingForCreateMode.set(false);
                throw new LockingNotSuccessfulException("Einige der Objekte konnten nicht gesperrt werden, weil sie schon gesperrt sind");
            }
        } else {
            LOG.info((Object)"Create Modus no locks necessary");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void releaseLock() throws Exception {
        this.setInCreateMode(false);
        if (!this.isInCreateMode()) {
            try {
                if (this.sperre == null) return;
                CidsBroker.getInstance().unlock(this.sperre);
                this.sperre = null;
                return;
            }
            catch (ActionNotSuccessfulException ex) {
                LOG.error((Object)"Error while unlocking locked objects:", (Throwable)ex);
                throw new Exception("Angelegte sperren konnten nicht gel\u00f6st werden.");
            }
        } else {
            LOG.info((Object)"Create Modus no locks necessary");
        }
    }

    private void setAllFeaturesSelectable(boolean selectable) {
        block6: {
            block5: {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"setAllFeaturesNotEditable()");
                }
                if (selectable) break block5;
                this.getMappingComponent().getFeatureCollection().unselectAll();
                this.currentFeatures.clear();
                FeatureCollection featureCollection = this.getMappingComponent().getFeatureCollection();
                if (featureCollection == null) break block6;
                for (Feature curFeature : featureCollection.getAllFeatures()) {
                    if (!(curFeature instanceof WorkbenchFeatureEntity)) continue;
                    ((WorkbenchFeatureEntity)curFeature).setSelectable(selectable);
                    this.getMappingComponent().getFeatureCollection().reconsiderFeature(curFeature);
                    this.currentFeatures.add((WorkbenchFeatureEntity)curFeature);
                }
                break block6;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"restoring features");
            }
            if (this.currentFeatures.size() > 0) {
                for (WorkbenchFeatureEntity curFeature : this.currentFeatures) {
                    curFeature.setSelectable(selectable);
                    this.getMappingComponent().getFeatureCollection().reconsiderFeature((Feature)curFeature);
                }
            }
        }
    }

    private void showObjectsLockedDialog(Collection<SperreCustomBean> locks) {
        JDialog dialog = new JDialog(StaticSwingTools.getParentFrame((Component)this.getParentComponent()), "Gesperrte Objekte...", true);
        if (this.lockPanel == null) {
            this.lockPanel = new AlreadyLockedObjectsPanel(locks);
        } else {
            this.lockPanel.setLocks(locks);
        }
        dialog.setIconImage(((ImageIcon)BelisIcons.icoError16).getImage());
        dialog.add(this.lockPanel);
        dialog.pack();
        dialog.setLocationRelativeTo(this.getParentComponent());
        dialog.setVisible(true);
    }

    public static void runOrEDTDispatch(Runnable runnable) {
        if (runnable != null) {
            if (EventQueue.isDispatchThread()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Thread is EDT. Execute run");
                }
                runnable.run();
            } else {
                LOG.info((Object)"Thread is not EDT. InvokeLater");
                EventQueue.invokeLater(runnable);
            }
        }
    }

    private void customizeMapWidget() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Customizing MapWidget");
        }
        Collection<BelisWidget> widgets = this.getWidgets();
        MapWidget mapWidget = null;
        if (widgets != null) {
            for (BelisWidget curWidget : widgets) {
                if (curWidget == null || !(curWidget instanceof MapWidget)) continue;
                mapWidget = (MapWidget)curWidget;
            }
            if (mapWidget != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"MapWidget found");
                }
                this.mapWidget = mapWidget;
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Can't customize MapWidget not found");
            }
        } else {
            LOG.warn((Object)"There are no widgets");
        }
    }

    public boolean isInCreateMode() {
        return this.inCreateMode;
    }

    public void setInCreateMode(boolean isInCreateMode) {
        this.inCreateMode = isInCreateMode;
    }

    private void addLocationSearch() {
        LocationSearchControl lsPan = new LocationSearchControl(this);
        lsPan.setFocusable(false);
        this.addSearchControl(lsPan);
        this.getToolbar().add(lsPan);
        this.addSeparatorToToolbar();
    }

    private void addMapSearchControl() {
        this.mscPan = new MapSearchControl(this);
        this.addSearchControl(this.mscPan);
        this.mscPan.setFocusable(false);
        this.mscPan.setPreferredSize(new Dimension(150, 23));
        this.getToolbar().add(this.mscPan);
    }

    private void addCreateToolBar() {
        this.addEditable(this.panCreate);
        this.getToolbar().add(this.panCreate);
        this.getToolbar().add(this.createToolBarSeperator());
    }

    private void addFilterToolbar() {
        this.getToolbar().add(this.panFilter);
        this.getToolbar().add(this.createToolBarSeperator());
    }

    private void addCopyPasteToolBar() {
        this.addEditable(this.copyPasteToolbar);
        this.getToolbar().add(this.copyPasteToolbar);
        this.getToolbar().add(this.createToolBarSeperator());
    }

    public void addNewStandort() {
        TdtaStandortMastCustomBean newStandort = TdtaStandortMastCustomBean.createNew();
        newStandort.setVerrechnungseinheit(true);
        if (BelisBroker.getDefaultUnterhaltMast() != null) {
            newStandort.setUnterhaltspflichtMast(BelisBroker.getDefaultUnterhaltMast());
        }
        newStandort.addPropertyChangeListener(this.workbenchWidget);
        this.workbenchWidget.addNewEntity(newStandort);
    }

    public void addNewLeuchte(Object relatedObject) {
        this.workbenchWidget.addNewLeuchte(relatedObject);
    }

    public void addNewLeuchte() {
        this.workbenchWidget.addNewLeuchte();
    }

    public void addNewMauerlasche() {
        MauerlascheCustomBean newMauerlasche = MauerlascheCustomBean.createNew();
        newMauerlasche.setStrassenschluessel(this.getLastMauerlascheStrassenschluessel());
        newMauerlasche.addPropertyChangeListener(this);
        newMauerlasche.addPropertyChangeListener(this.workbenchWidget);
        this.workbenchWidget.addNewEntity(newMauerlasche);
    }

    public void addNewSchaltstelle() {
        SchaltstelleCustomBean newSchaltstelle = SchaltstelleCustomBean.createNew();
        newSchaltstelle.addPropertyChangeListener(this.workbenchWidget);
        this.workbenchWidget.addNewEntity(newSchaltstelle);
    }

    public void addNewLeitung() {
        LeitungCustomBean newLeitung = LeitungCustomBean.createNew();
        newLeitung.setLeitungstyp(this.getLastLeitungstyp());
        newLeitung.addPropertyChangeListener(this);
        newLeitung.addPropertyChangeListener(this.workbenchWidget);
        this.workbenchWidget.addNewEntity(newLeitung);
    }

    public void addNewAbzweigdose() {
        AbzweigdoseCustomBean newAbzweigdose = AbzweigdoseCustomBean.createNew();
        this.workbenchWidget.addNewEntity(newAbzweigdose);
    }

    public void addNewVeranlassung() {
        VeranlassungCustomBean newVeranlassung = VeranlassungCustomBean.createNew();
        this.workbenchWidget.addNewEntity(newVeranlassung);
    }

    public void addNewGeometrie() {
        this.workbenchWidget.addNewGeometrie();
    }

    public void addNewArbeitsauftrag() {
        ArbeitsauftragCustomBean newArbeitsauftrag = ArbeitsauftragCustomBean.createNew();
        this.workbenchWidget.addNewEntity(newArbeitsauftrag);
    }

    public void removeSelectedEntity() {
        this.workbenchWidget.removeSelectedEntity();
    }

    @Override
    public synchronized void addSearchControl(SearchControl searchControl) {
        if (searchControl != null) {
            this.searchControls.add(searchControl);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"searchControl is null can't be add.");
        }
    }

    @Override
    public synchronized void fireSearchFinished() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"fireSearchFinished");
        }
        this.editButtonsToolbar.enableSwitchToModeButtons(!this.isInCreateMode() && !this.isInEditMode());
        this.btnReload.setEnabled(true);
        this.cmdPrint.setEnabled(true);
        for (SearchControl curSearchControl : this.searchControls) {
            curSearchControl.searchFinished();
        }
    }

    @Override
    public synchronized void fireSearchStarted() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"fireSearchStarted");
        }
        this.editButtonsToolbar.enableSwitchToModeButtons(false);
        this.btnReload.setEnabled(false);
        this.cmdPrint.setEnabled(false);
        for (SearchControl curSearchControl : this.searchControls) {
            curSearchControl.searchStarted();
        }
    }

    @Override
    public synchronized void removeSearchControl(SearchControl searchControl) {
        if (searchControl != null) {
            this.searchControls.remove(searchControl);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"searchControl is null can't be removed.");
        }
    }

    @Override
    public synchronized void disableSearch() {
        this.setSearchEnabled(false);
    }

    @Override
    public synchronized void enableSearch() {
        this.setSearchEnabled(true);
    }

    @Override
    public synchronized void setSearchEnabled(boolean isSearchEnabled) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("setSearchEnabled " + isSearchEnabled));
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"PropertyChangeEvent");
        }
        if (evt != null && evt.getPropertyName() != null) {
            if (evt.getPropertyName().equals("fk_leitungstyp") && evt.getSource() != null && evt.getSource() instanceof LeitungCustomBean) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"LeitungsTyp Changed");
                }
                this.lastLeitungstyp = (LeitungstypCustomBean)((Object)evt.getNewValue());
                this.getMappingComponent().getFeatureCollection().reconsiderFeature((Feature)((LeitungCustomBean)evt.getSource()));
            } else if (evt.getPropertyName().equals("leuchtennummer") && evt.getSource() != null && evt.getSource() instanceof TdtaLeuchtenCustomBean) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Leuchtennummer changed");
                }
                TreePath pathToLeuchte = this.workbenchWidget.getTreeTableModel().getPathForUserObject(evt.getSource());
                TdtaStandortMastCustomBean parentMast = null;
                if (pathToLeuchte != null) {
                    parentMast = this.workbenchWidget.getParentMast(pathToLeuchte.getLastPathComponent());
                }
                if (parentMast != null) {
                    this.getMappingComponent().getFeatureCollection().reconsiderFeature((Feature)parentMast);
                } else {
                    TdtaStandortMastCustomBean virtualStandort = this.workbenchWidget.getVirtualStandortForLeuchte((TdtaLeuchtenCustomBean)evt.getSource());
                    if (virtualStandort != null) {
                        this.getMappingComponent().getFeatureCollection().reconsiderFeature((Feature)virtualStandort);
                    } else {
                        LOG.warn((Object)"Leuchte is neither H\u00e4ngeleuchte nor attached to a mast. Can't update label in map");
                    }
                }
            } else if (evt.getPropertyName().equals("fk_strassenschluessel") && evt.getSource() != null && evt.getSource() instanceof MauerlascheCustomBean) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Mauerlasche Stra\u00df\u00dfenschl\u00fcssel Changed");
                }
                this.lastMauerlascheStrassenschluessel = (TkeyStrassenschluesselCustomBean)evt.getNewValue();
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"PropertyChange not recognized from BelisBroker.");
            }
        } else {
            LOG.warn((Object)"PropertyChangeEvent or PropertyName == null");
        }
    }

    public TkeyStrassenschluesselCustomBean getLastMauerlascheStrassenschluessel() {
        return this.lastMauerlascheStrassenschluessel;
    }

    public void setLastMauerlascheStrassenschluessel(TkeyStrassenschluesselCustomBean lastMauerlascheStrassenschluessel) {
        this.lastMauerlascheStrassenschluessel = lastMauerlascheStrassenschluessel;
    }

    public LeitungstypCustomBean getLastLeitungstyp() {
        return this.lastLeitungstyp;
    }

    public void setLastLeitungstyp(LeitungstypCustomBean lastLeitungstyp) {
        this.lastLeitungstyp = lastLeitungstyp;
    }

    public int askUser() {
        String string1 = "Ja";
        String string2 = "Nein";
        Object[] options = new Object[]{"Ja", "Nein"};
        return JOptionPane.showOptionDialog(StaticSwingTools.getParentFrame((Component)this.getParentComponent()), "<html><table width=\"400\" border=\"0\"><tr><td>Nicht alle Inhalte des ausgew\u00e4hlten Objektes sind korrekt.<p><br>Grund:<br><b>" + this.getCurrentValidationErrorMessage() + "</b><p><br>Wenn Sie das Objekt wechseln, werden die ung\u00fcltigen \u00c4nderungen nicht \u00fcbernommen. M\u00f6chten Sie trotzdem wechseln ?</td></tr></table></html>", "Achtung! Es gibt falsche Inhalte", 0, 2, null, options, "Nein");
    }

    public static TkeyUnterhLeuchteCustomBean getDefaultUnterhaltLeuchte() {
        return defaultUnterhaltLeuchte;
    }

    public static void setDefaultUnterhaltLeuchte(TkeyUnterhLeuchteCustomBean defaultUnterhaltLeuchte) {
        BelisBroker.defaultUnterhaltLeuchte = defaultUnterhaltLeuchte;
    }

    public static TkeyUnterhMastCustomBean getDefaultUnterhaltMast() {
        return defaultUnterhaltMast;
    }

    public static void setDefaultUnterhaltMast(TkeyUnterhMastCustomBean defaultUnterhaltMast) {
        BelisBroker.defaultUnterhaltMast = defaultUnterhaltMast;
    }

    public static TkeyDoppelkommandoCustomBean getDefaultDoppelkommando1() {
        return defaultDoppelkommando1;
    }

    public static void setDefaultDoppelkommando1(TkeyDoppelkommandoCustomBean defaultDoppelkommando1) {
        BelisBroker.defaultDoppelkommando1 = defaultDoppelkommando1;
    }

    public EntityClipboard getEntityClipboard() {
        return this.entityClipboard;
    }

    public boolean isFilterNormal() {
        return this.filterNormal;
    }

    public void setFilterNormal(boolean filterNormal) {
        boolean old = this.filterNormal;
        this.filterNormal = filterNormal;
        this.propertyChangeSupport.firePropertyChange(PROP_FILTER_NORMAL, old, filterNormal);
    }

    public boolean isFilterVeranlassung() {
        return this.filterVeranlassung;
    }

    public void setFilterVeranlassung(boolean filterVeranlassung) {
        boolean old = this.filterVeranlassung;
        this.filterVeranlassung = filterVeranlassung;
        this.propertyChangeSupport.firePropertyChange(PROP_FILTER_VERANLASSUNG, old, filterVeranlassung);
    }

    public boolean isFilterArbeitsauftrag() {
        return this.filterArbeitsauftrag;
    }

    public void setFilterArbeitsauftrag(boolean filterArbeitsauftrag) {
        boolean old = this.filterArbeitsauftrag;
        this.filterArbeitsauftrag = filterArbeitsauftrag;
        this.propertyChangeSupport.firePropertyChange(PROP_FILTER_ARBEITSAUFTRAG, old, filterArbeitsauftrag);
    }

    public static DefaultBindableReferenceCombo createKeyTableComboBox(String keyTableClassname) {
        return BelisBroker.createKeyTableComboBox(keyTableClassname, "<html><i>Wert ausw\u00e4hlen...</i></html>", true);
    }

    public static DefaultBindableReferenceCombo createKeyTableComboBox(String keyTableClassname, String nullString, boolean scrollable) {
        ScrollableComboBox comboBox = scrollable ? new ScrollableComboBox(CidsBroker.getInstance().getBelisMetaClass(keyTableClassname)) : new DefaultBindableReferenceCombo(CidsBroker.getInstance().getBelisMetaClass(keyTableClassname));
        comboBox.setNullable(true);
        comboBox.setNullValueRepresentation(nullString);
        BelisBroker.addComboBoxToKeyTableValuesListener(comboBox, keyTableClassname);
        return comboBox;
    }

    public static JComboBox createStrassenschluesselNummerComboBox() {
        final DefaultBindableReferenceCombo comboBox = new DefaultBindableReferenceCombo(CidsBroker.getInstance().getBelisMetaClass("tkey_strassenschluessel"), "pk");
        comboBox.setNullable(true);
        comboBox.setNullValueRepresentation("<html><i>Wert ausw\u00e4hlen...</i></html>");
        BelisBroker.addComboBoxToKeyTableValuesListener(comboBox, "tkey_strassenschluessel");
        comboBox.setRenderer((ListCellRenderer)new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component ret = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value == null && ret instanceof JLabel) {
                    ((JLabel)ret).setText(comboBox.getNullValueRepresentation());
                } else if (value instanceof TkeyStrassenschluesselCustomBean && ret instanceof JLabel) {
                    ((JLabel)ret).setText(((TkeyStrassenschluesselCustomBean)value).getPk());
                }
                return ret;
            }
        });
        return comboBox;
    }

    public void printReport() {
        ArrayList<ArbeitsauftragCustomBean> beans = new ArrayList<ArbeitsauftragCustomBean>();
        Collection<TreePath> paths = this.getWorkbenchWidget().getSelectedTreeNodes();
        if (paths != null) {
            for (TreePath path : paths) {
                Object object;
                CustomMutableTreeTableNode node = (CustomMutableTreeTableNode)((Object)path.getLastPathComponent());
                if (node == null || !((object = node.getUserObject()) instanceof ArbeitsauftragCustomBean)) continue;
                beans.add((ArbeitsauftragCustomBean)object);
            }
        }
        if (beans.isEmpty()) {
            JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)this.getParentComponent()), "Es muss mindestens ein Arbeitsauftrag im Arbeitsbereich selektiert sein.", "kein Arbeitsauftrag selektiert", 1);
        } else {
            ArbeitsauftraegeReportDownload reportDownload = new ArbeitsauftraegeReportDownload(beans);
            DownloadManagerDialog downloadManagerDialog = DownloadManagerDialog.getInstance();
            if (DownloadManagerDialog.getInstance().showAskingForUserTitleDialog((Component)this.getRootWindow())) {
                DownloadManager.instance().add((Download)reportDownload);
                downloadManagerDialog.pack();
                StaticSwingTools.showDialog((Component)this.getRootWindow(), (JDialog)downloadManagerDialog, (boolean)true);
            }
        }
    }

    private static void addComboBoxToKeyTableValuesListener(final DefaultBindableReferenceCombo comboBox, final String keyTableClassname) {
        CidsBroker.getInstance().addListenerForKeyTableChange(keyTableClassname, new KeyTableListener(){

            @Override
            public void keyTableChanged() {
                try {
                    if (comboBox.getMetaClass() == null) {
                        MetaClass mc = CidsBroker.getInstance().getBelisMetaClass(keyTableClassname);
                        comboBox.setMetaClass(mc);
                    }
                    comboBox.reload(true);
                }
                catch (Exception ex) {
                    LOG.warn((Object)"exception while comboBox.reload(true)", (Throwable)ex);
                }
            }
        });
    }

    static {
        LOG = Logger.getLogger(BelisBroker.class);
        yellow = new Color(231, 223, 84);
        red = new Color(219, 96, 96);
        blue = new Color(124, 160, 221);
        gray = Color.LIGHT_GRAY;
        ODD_ROW_DEFAULT_COLOR = new Color(blue.getRed() + 113, blue.getGreen() + 79, blue.getBlue() + 14, 255);
        ODD_ROW_EDIT_COLOR = new Color(red.getRed() + 25, red.getGreen() + 143, red.getBlue() + 143, 255);
        ODD_ROW_LOCK_COLOR = new Color(yellow.getRed() + 23, yellow.getGreen() + 31, yellow.getBlue() + 134, 255);
        EVEN_ROW_COLOR = Color.WHITE;
        FOREGROUND_ROW_COLOR = Color.BLACK;
        ALTERNATE_ROW_HIGHLIGHTER = HighlighterFactory.createAlternateStriping((Color)ODD_ROW_DEFAULT_COLOR, (Color)EVEN_ROW_COLOR);
        EDIT_MODE_COLOR = red;
        DEFAULT_MODE_COLOR = blue;
        calender = new GregorianCalendar();
        defaultUnterhaltMast = null;
        defaultUnterhaltLeuchte = null;
        defaultDoppelkommando1 = null;
        jxDatePickerFormats = new String[]{"dd.MM.yyyy", "ddMMyy", "ddMMyyyy"};
    }

    class SaveCancelWorker
    extends SwingWorker<Runnable, Void> {
        public static final int SAVE_MODE = 0;
        public static final int CANCEL_MODE = 1;
        private int mode;

        SaveCancelWorker(int mode) {
            this.mode = mode;
        }

        @Override
        protected Runnable doInBackground() throws Exception {
            if (this.mode == 0) {
                return BelisBroker.this.saveWorkbench();
            }
            if (this.mode == 1) {
                return BelisBroker.this.cancelWorkbench();
            }
            LOG.warn((Object)"Mode is unkown.");
            return null;
        }

        @Override
        protected void done() {
            if (this.isCancelled()) {
                LOG.warn((Object)"SaveUpdateWorker is canceled --> nothing to do in method done()");
                return;
            }
            try {
                Runnable resultRun;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"done");
                }
                if ((resultRun = (Runnable)this.get()) != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"result runnable != null will be executed");
                    }
                    resultRun.run();
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"result runnable == null. Can't execute");
                }
                BelisBroker.this.getMappingComponent().setReadOnly(true);
                BelisBroker.this.switchEditMode();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"enable buttons");
                }
                BelisBroker.this.editButtonsToolbar.enableSwitchToModeButtons(true);
                BelisBroker.this.btnAcceptChanges.setEnabled(false);
                BelisBroker.this.btnDiscardChanges.setEnabled(false);
                BelisBroker.this.setTitleBarComponentpainter(DEFAULT_MODE_COLOR);
                if (this.mode == 0) {
                    BelisBroker.this.fireSaveFinished();
                } else if (this.mode == 1) {
                    BelisBroker.this.fireCancelFinished();
                }
            }
            catch (Exception ex) {
                LOG.error((Object)"Failure during saving/refresh results", (Throwable)ex);
                if (this.mode == 0) {
                    BelisBroker.this.showSaveErrorDialog(ex);
                } else if (this.mode == 1) {
                    // empty if block
                }
            }
            finally {
                if (this.mode == 0) {
                    BelisBroker.this.fireSaveFinished();
                } else if (this.mode == 1) {
                    BelisBroker.this.fireCancelFinished();
                }
            }
        }
    }
}

