/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.belis.broker;

import Sirius.navigator.connection.Connection;
import Sirius.navigator.connection.ConnectionFactory;
import Sirius.navigator.connection.ConnectionInfo;
import Sirius.navigator.connection.ConnectionSession;
import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.connection.proxy.ConnectionProxy;
import Sirius.server.localserver.attribute.Attribute;
import Sirius.server.middleware.types.MetaClass;
import de.cismet.belis.broker.CidsBroker;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.tools.gui.log4jquickconfig.Log4JQuickConfig;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class CsvExportBackend {
    public static final transient Logger LOG = Logger.getLogger(CsvExportBackend.class);
    public static final String CSV_EXPORT = "CsvExport";
    public static final String CSV_EXPORT_KEYVALUE_SEPARATOR = ":";
    public static final String CSV_EXPORT_SEPARATOR = ",";
    public static final String CSV_SEPARATOR = ";";
    public static CsvExportBackend INSTANCE;
    public static final String CONNECTION_CLASS = "Sirius.navigator.connection.RESTfulConnection";
    public static final String CONNECTION_PROXY_CLASS = "Sirius.navigator.connection.proxy.DefaultConnectionProxyHandler";
    public static final String CALLSERVER_URL = "http://localhost:9917/callserver/binary";
    public static final String CALLSERVER_DOMAIN = "BELIS2";
    public static final String CALLSERVER_USER = "WendlingM";
    public static final String CALLSERVER_PASSWORD = "kif";
    public static final String CALLSERVER_GROUP = "Bearbeiter";
    public static final SimpleDateFormat DATE_FORMAT;
    private final Map<MetaClass, List<String>> mcPropkeyMap = new HashMap<MetaClass, List<String>>();

    private CsvExportBackend() {
    }

    public static CsvExportBackend getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CsvExportBackend();
        }
        return INSTANCE;
    }

    public void init() {
        try {
            MetaClass[] metaClasses;
            for (MetaClass metaClass : metaClasses = CidsBroker.getInstance().getProxy().getClasses(SessionManager.getSession().getUser().getDomain())) {
                Collection csvExport = metaClass.getAttributeByName(CSV_EXPORT);
                if (csvExport.isEmpty()) continue;
                for (Attribute attr : csvExport) {
                    String[] props;
                    for (String prop : props = ((String)attr.getValue()).split(CSV_EXPORT_SEPARATOR)) {
                        List<String> propKeyList = this.mcPropkeyMap.get(metaClass);
                        if (propKeyList == null) {
                            propKeyList = new ArrayList<String>();
                            this.mcPropkeyMap.put(metaClass, propKeyList);
                        }
                        propKeyList.add(prop.trim());
                    }
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while retrieving classes", (Throwable)e);
        }
    }

    public Map<MetaClass, List<String>> getMcPropkeyMap() {
        return this.mcPropkeyMap;
    }

    public Object[] getFields(CidsBean bean) {
        MetaClass metaClass = bean.getMetaObject().getMetaClass();
        List<String> propkeys = this.mcPropkeyMap.get(metaClass);
        if (propkeys == null) {
            propkeys = new ArrayList<String>();
        }
        Object[] fields = new Object[propkeys.size()];
        for (int i = 0; i < propkeys.size(); ++i) {
            Object o;
            String propkey = propkeys.get(i);
            String[] propkeyArr = propkey.split(CSV_EXPORT_KEYVALUE_SEPARATOR);
            fields[i] = o = bean.getProperty(propkeyArr[1]);
        }
        return fields;
    }

    public List<Object[]> getFields(Collection<CidsBean> beans) {
        ArrayList<Object[]> ret = new ArrayList<Object[]>(beans.size());
        for (CidsBean bean : beans) {
            ret.add(this.getFields(bean));
        }
        return ret;
    }

    public String[] getFieldNames(MetaClass metaClass) {
        List<String> propkeys = this.mcPropkeyMap.get(metaClass);
        if (propkeys == null) {
            propkeys = new ArrayList<String>();
        }
        String[] fieldNames = new String[propkeys.size()];
        for (int i = 0; i < propkeys.size(); ++i) {
            String propkey = propkeys.get(i);
            String[] propkeyArr = propkey.split(CSV_EXPORT_KEYVALUE_SEPARATOR);
            fieldNames[i] = propkeyArr[0];
        }
        return fieldNames;
    }

    public HashMap<MetaClass, HashSet<CidsBean>> getGroupedBeans(Collection<CidsBean> beans) {
        HashMap<MetaClass, HashSet<CidsBean>> mcBeansMap = new HashMap<MetaClass, HashSet<CidsBean>>();
        for (CidsBean bean : beans) {
            MetaClass mc = bean.getMetaObject().getMetaClass();
            HashSet<Object> propKeyList = mcBeansMap.get(mc);
            if (propKeyList == null) {
                propKeyList = new HashSet();
                mcBeansMap.put(mc, propKeyList);
            }
            propKeyList.add(bean);
        }
        return mcBeansMap;
    }

    public Map<MetaClass, String> toCsvStrings(Collection<CidsBean> beans) {
        HashMap<MetaClass, HashSet<CidsBean>> groupedBeansMap = this.getGroupedBeans(beans);
        HashMap<MetaClass, String> csvMap = new HashMap<MetaClass, String>();
        for (MetaClass metaClass : groupedBeansMap.keySet()) {
            ArrayList groupedBeans = (ArrayList)((Object)groupedBeansMap.get(metaClass));
            if (groupedBeans == null) {
                groupedBeans = new ArrayList();
            }
            List<Object[]> fields = this.getFields(groupedBeans);
            String[] fieldNames = this.getFieldNames(metaClass);
            if (fieldNames.length <= 0) continue;
            String header = CidsBroker.implode(fieldNames, CSV_SEPARATOR);
            StringBuffer csv = new StringBuffer(header);
            for (Object[] field : fields) {
                String[] stringField = new String[field.length];
                for (int i = 0; i < field.length; ++i) {
                    Object prop = field[i];
                    String string = prop == null ? null : (prop instanceof Boolean ? ((Boolean)prop != false ? "ja" : "nein") : (prop instanceof Date ? DATE_FORMAT.format((Date)prop) : prop.toString()));
                    stringField[i] = string != null ? "\"" + string + "\"" : null;
                }
                String row = CidsBroker.implode(stringField, CSV_SEPARATOR);
                csv.append("\n").append(row);
            }
            csvMap.put(metaClass, csv.toString());
        }
        return csvMap;
    }

    private static ConnectionProxy initProxy() throws Exception {
        Connection connection = ConnectionFactory.getFactory().createConnection(CONNECTION_CLASS, CALLSERVER_URL);
        ConnectionInfo connectionInfo = new ConnectionInfo();
        connectionInfo.setCallserverURL(CALLSERVER_URL);
        connectionInfo.setPassword(CALLSERVER_PASSWORD);
        connectionInfo.setUserDomain(CALLSERVER_DOMAIN);
        connectionInfo.setUsergroup(CALLSERVER_GROUP);
        connectionInfo.setUsergroupDomain(CALLSERVER_DOMAIN);
        connectionInfo.setUsername(CALLSERVER_USER);
        ConnectionSession session = ConnectionFactory.getFactory().createSession(connection, connectionInfo, true);
        return ConnectionFactory.getFactory().createProxy(CONNECTION_PROXY_CLASS, session);
    }

    public static void main(String[] args) {
        try {
            Log4JQuickConfig.configure4LumbermillOnLocalhost();
            CidsBroker.getInstance().setProxy(CsvExportBackend.initProxy());
            SessionManager.init((ConnectionProxy)CidsBroker.getInstance().getProxy());
            MetaClass metaclass = CidsBroker.getInstance().getMetaClass("mauerlasche", CALLSERVER_DOMAIN);
            Collection beans = CidsBroker.getInstance().getBeanCollectionForQuery("SELECT " + metaclass.getID() + ", " + metaclass.getPrimaryKey() + " FROM " + metaclass.getTableName() + " LIMIT 10", CALLSERVER_DOMAIN);
            CsvExportBackend test = new CsvExportBackend();
            test.init();
            Map<MetaClass, String> map = test.toCsvStrings(beans);
            for (MetaClass mc : map.keySet()) {
                LOG.fatal((Object)"=========");
                LOG.fatal((Object)mc.getTableName());
                LOG.fatal((Object)"---------");
                LOG.fatal((Object)map.get(mc));
                LOG.fatal((Object)"=========");
            }
            System.exit(0);
        }
        catch (Exception ex) {
            LOG.fatal((Object)ex, (Throwable)ex);
            System.exit(1);
        }
    }

    static {
        DATE_FORMAT = new SimpleDateFormat("dd.MM.yyyy");
    }
}

