/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.belis.gui.renderer;

import de.cismet.belis.todo.CustomMutableTreeTableNode;
import de.cismet.belis.todo.CustomTreeTableModel;
import de.cismet.belis.util.BelisIcons;
import de.cismet.cids.custom.beans.belis2.AbzweigdoseCustomBean;
import de.cismet.cids.custom.beans.belis2.ArbeitsauftragCustomBean;
import de.cismet.cids.custom.beans.belis2.ArbeitsprotokollCustomBean;
import de.cismet.cids.custom.beans.belis2.GeometrieCustomBean;
import de.cismet.cids.custom.beans.belis2.LeitungCustomBean;
import de.cismet.cids.custom.beans.belis2.MauerlascheCustomBean;
import de.cismet.cids.custom.beans.belis2.SchaltstelleCustomBean;
import de.cismet.cids.custom.beans.belis2.TdtaLeuchtenCustomBean;
import de.cismet.cids.custom.beans.belis2.TdtaStandortMastCustomBean;
import de.cismet.cids.custom.beans.belis2.VeranlassungCustomBean;
import de.cismet.commons.server.entity.WorkbenchEntity;
import java.awt.Component;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.apache.log4j.Logger;

public class WorkbenchTreeTableRenderer
extends DefaultTreeCellRenderer {
    private final Logger log = Logger.getLogger(this.getClass());

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Component test = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        if (value != null) {
            if (value instanceof CustomMutableTreeTableNode) {
                Object userObject = ((CustomMutableTreeTableNode)((Object)value)).getUserObject();
                if (userObject instanceof WorkbenchEntity) {
                    String prefix;
                    WorkbenchEntity entity = (WorkbenchEntity)userObject;
                    String string = prefix = entity.isDeleted() ? "<html><strike>" : "";
                    if (userObject instanceof TdtaStandortMastCustomBean) {
                        Integer laufendeNummer = ((TdtaStandortMastCustomBean)userObject).getLaufendeNummer();
                        this.setText(prefix + (laufendeNummer != null ? Integer.toString(laufendeNummer) : ""));
                        this.setIcon(BelisIcons.icoStandort16);
                    } else if (userObject instanceof TdtaLeuchtenCustomBean) {
                        this.setText(prefix + "Leuchte");
                        this.setIcon(BelisIcons.icoLeuchte16);
                    } else if (userObject instanceof MauerlascheCustomBean) {
                        this.setText(prefix + "Mauerlasche");
                        this.setIcon(BelisIcons.icoMauerlasche16);
                    } else if (userObject instanceof SchaltstelleCustomBean) {
                        this.setText(prefix + "Schaltstelle");
                        this.setIcon(BelisIcons.icoSchaltstelle16);
                    } else if (userObject instanceof LeitungCustomBean) {
                        this.setText(prefix + "Leitung");
                        this.setIcon(BelisIcons.icoLeitung16);
                    } else if (userObject instanceof AbzweigdoseCustomBean) {
                        this.setText(prefix + "Abzweigdose/Zugkasten");
                        this.setIcon(BelisIcons.icoAbzweigdose16);
                    } else if (userObject instanceof VeranlassungCustomBean) {
                        this.setText(prefix + "Veranlassung");
                        this.setIcon(BelisIcons.icoVeranlassung16);
                    } else if (userObject instanceof ArbeitsauftragCustomBean) {
                        this.setText(prefix + "Arbeitsauftrag");
                        this.setIcon(BelisIcons.icoArbeitsauftrag16);
                    } else if (userObject instanceof ArbeitsprotokollCustomBean) {
                        this.setText(prefix + "Arbeitsprotokoll");
                        this.setIcon(BelisIcons.icoArbeitsprotokoll16);
                    } else if (userObject instanceof GeometrieCustomBean) {
                        this.setText(prefix + "Geometrie");
                        this.setIcon(BelisIcons.icoGeometrie16);
                    } else {
                        this.setText("Unbekannter Typ");
                    }
                } else if (userObject instanceof String) {
                    if (userObject.equals(CustomTreeTableModel.HIT_NODE)) {
                        this.setText(((CustomMutableTreeTableNode)((Object)value)).getChildCount() + " Suchergebnisse");
                        this.setIcon(BelisIcons.icoSuchergebnisse16);
                    } else if (userObject.equals(CustomTreeTableModel.NEW_OBJECT_NODE)) {
                        this.setText(((CustomMutableTreeTableNode)((Object)value)).getChildCount() + " Neue Objekte");
                        this.setIcon(BelisIcons.icoNewObjects16);
                    } else if (userObject.equals(CustomTreeTableModel.EDIT_OBJECT_NODE)) {
                        this.setText(((CustomMutableTreeTableNode)((Object)value)).getChildCount() + " Objekte zum Bearbeiten");
                        this.setIcon(BelisIcons.icoEditObjects16);
                    } else {
                        this.setText("Unbekannter Typ");
                        this.setToolTipText("Unbekannter Typ");
                    }
                } else {
                    this.setText("Unbekannter Typ");
                }
            } else {
                this.setText("Unbekannter Typ");
            }
        } else {
            this.setText("");
        }
        return this;
    }
}

