/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.belis.gui.reports;

import de.cismet.belis.gui.reports.BelisReporter;
import de.cismet.belis.gui.reports.ReportingArbeitsauftrag;
import de.cismet.cids.custom.beans.belis2.ArbeitsauftragCustomBean;
import de.cismet.tools.gui.downloadmanager.AbstractCancellableDownload;
import de.cismet.tools.gui.downloadmanager.Download;
import de.cismet.tools.gui.downloadmanager.DownloadManagerDialog;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.util.JRLoader;

public class ArbeitsauftraegeReportDownload
extends AbstractCancellableDownload {
    protected JasperPrint jasperPrint;
    private final List<ArbeitsauftragCustomBean> arbeitsauftraege;

    public ArbeitsauftraegeReportDownload(List<ArbeitsauftragCustomBean> arbeitsauftraege) {
        String jobname;
        this.arbeitsauftraege = arbeitsauftraege;
        this.directory = jobname = DownloadManagerDialog.getInstance().getJobName();
        this.title = "Belis-AA";
        this.status = Download.State.WAITING;
        this.determineDestinationFile("belis.aa", ".pdf");
    }

    public void run() {
        if (this.status != Download.State.WAITING) {
            return;
        }
        this.status = Download.State.RUNNING;
        this.stateChanged();
        try {
            ArrayList<ReportingArbeitsauftrag> repAuftraege = new ArrayList<ReportingArbeitsauftrag>(this.arbeitsauftraege.size());
            for (ArbeitsauftragCustomBean aa : this.arbeitsauftraege) {
                ReportingArbeitsauftrag ra = new ReportingArbeitsauftrag();
                ra.init(aa);
                repAuftraege.add(ra);
            }
            JRBeanCollectionDataSource dataSource = new JRBeanCollectionDataSource(repAuftraege);
            HashMap parameters = new HashMap();
            JasperReport jasperReport = (JasperReport)JRLoader.loadObject((InputStream)BelisReporter.class.getResourceAsStream("/de/cismet/belis/reports/arbeitsauftraege.jasper"));
            this.jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, parameters, (JRDataSource)dataSource);
        }
        catch (JRException ex) {
            this.error((Exception)((Object)ex));
        }
        if (this.jasperPrint != null) {
            try {
                if (Thread.interrupted()) {
                    log.info((Object)"Download was interuppted");
                    this.deleteFile();
                    return;
                }
                this.exportReportFile();
            }
            catch (JRException ex) {
                this.error((Exception)((Object)ex));
            }
        }
        if (this.status == Download.State.RUNNING) {
            this.status = Download.State.COMPLETED;
            this.stateChanged();
        }
    }

    protected void exportReportFile() throws JRException {
        JasperExportManager.exportReportToPdfFile((JasperPrint)this.jasperPrint, (String)this.fileToSaveTo.getPath());
    }

    private void deleteFile() {
        if (this.fileToSaveTo.exists() && this.fileToSaveTo.isFile()) {
            this.fileToSaveTo.delete();
        }
    }
}

