/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.belis.gui.reports;

import com.vividsolutions.jts.geom.Geometry;
import de.cismet.belis.broker.BelisBroker;
import de.cismet.belis.gui.reports.ReportingPosition;
import de.cismet.belis.gui.reports.ReportingVeranlassung;
import de.cismet.cids.custom.beans.belis2.ArbeitsauftragCustomBean;
import de.cismet.cids.custom.beans.belis2.ArbeitsprotokollCustomBean;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.HeadlessMapProvider;
import de.cismet.cismap.commons.RetrievalServiceLayer;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.features.DefaultXStyledFeature;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.gui.piccolo.CustomFixedWidthStroke;
import de.cismet.cismap.commons.gui.piccolo.FeatureAnnotationSymbol;
import de.cismet.cismap.commons.raster.wms.simple.SimpleWMS;
import de.cismet.cismap.commons.raster.wms.simple.SimpleWmsGetMapUrl;
import de.cismet.commons.server.entity.WorkbenchFeatureEntity;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.imageio.ImageIO;
import org.apache.commons.collections.MultiHashMap;
import org.apache.log4j.Logger;
import org.openide.util.Exceptions;

public class ReportingArbeitsauftrag {
    private static final Logger LOG = Logger.getLogger(ReportingArbeitsauftrag.class);
    private static String OVERVIEWMAP_URL;
    private static int OVERVIEWMAP_HEIGHT;
    private static int OVERVIEWMAP_WIDTH;
    private static double OVERVIEWMAP_BUFFER;
    private static String POSITIONMAP_URL;
    private static int POSITIONMAP_HEIGHT;
    private static int POSITIONMAP_WIDTH;
    private static double POSITIONMAP_BUFFER;
    private static int BASE_DPI;
    private static int TARGET_DPI;
    private static Font FONT;
    public static final String OHNE_VERANLASSUNG = "OHNE";
    String nummer;
    String angelegt;
    String zugewiesen_an;
    BufferedImage map;
    String link = "http://www.cismet.de";
    ArrayList<ReportingVeranlassung> veranlassungen = new ArrayList();
    MultiHashMap positionenNachVeranlassung = new MultiHashMap();
    ArbeitsauftragCustomBean orig;
    private HeadlessMapProvider mapProvider = new HeadlessMapProvider();
    private final Map<Integer, DefaultXStyledFeature> positionFeatureMap = new HashMap<Integer, DefaultXStyledFeature>();
    private ArrayList<WorkbenchFeatureEntity> allOriginalFeatures;
    private final SimpleWMS overviewMap = new SimpleWMS(new SimpleWmsGetMapUrl(OVERVIEWMAP_URL));
    private final SimpleWMS positionMap = new SimpleWMS(new SimpleWmsGetMapUrl(POSITIONMAP_URL));

    public void init(ArbeitsauftragCustomBean aaBean) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy");
        this.orig = aaBean;
        this.nummer = "Arbeitsauftrag: A" + aaBean.getNummer();
        this.angelegt = aaBean.getAngelegt_von() + " (" + dateFormat.format(aaBean.getAngelegt_am()) + ")";
        String an = aaBean.getZugewiesen_an() == null ? null : aaBean.getZugewiesen_an().getName();
        this.zugewiesen_an = an != null ? an : "_____________";
        this.initMap();
        ArrayList<String> keys = new ArrayList<String>();
        List<ArbeitsprotokollCustomBean> positionen = aaBean.getSortedProtokolle();
        for (ArbeitsprotokollCustomBean position : positionen) {
            this.mapProvider = new HeadlessMapProvider();
            this.mapProvider.setCenterMapOnResize(true);
            this.mapProvider.addLayer((RetrievalServiceLayer)this.positionMap);
            this.mapProvider.addFeatures(this.allOriginalFeatures);
            String veranlassungsnummer = position.getVeranlassungsnummer();
            if (veranlassungsnummer == null) {
                veranlassungsnummer = OHNE_VERANLASSUNG;
            }
            if (position.getProtokollnummer() == null) continue;
            this.mapProvider.addFeature((Feature)this.positionFeatureMap.get(position.getProtokollnummer()));
            this.positionenNachVeranlassung.put((Object)veranlassungsnummer, (Object)new ReportingPosition(position.getProtokollnummer(), position, this.getPositionImageFrom(position.getChildEntity())));
            this.positionFeatureMap.get(position.getProtokollnummer()).setPrimaryAnnotationVisible(false);
            if (keys.contains(veranlassungsnummer)) continue;
            keys.add(veranlassungsnummer);
        }
        for (String key : keys) {
            Collection value = (Collection)this.positionenNachVeranlassung.get((Object)key);
            this.veranlassungen.add(new ReportingVeranlassung(key, value));
        }
    }

    private void initMap() {
        ArbeitsauftragCustomBean arbeitsauftragCustomBean = this.orig;
        this.allOriginalFeatures = new ArrayList();
        ArrayList<DefaultXStyledFeature> annotatingFeatures = new ArrayList<DefaultXStyledFeature>();
        this.mapProvider.setCenterMapOnResize(true);
        FeatureAnnotationSymbol symb = new FeatureAnnotationSymbol((Image)new BufferedImage(10, 10, 2));
        symb.setSweetSpotX(0.5);
        symb.setSweetSpotY(0.5);
        Geometry union = null;
        for (ArbeitsprotokollCustomBean protokoll : arbeitsauftragCustomBean.getSortedProtokolle()) {
            WorkbenchFeatureEntity entity = protokoll.getChildEntity();
            if (entity == null) continue;
            this.allOriginalFeatures.add(entity);
            Geometry geom = entity.getGeometry();
            if (geom == null) continue;
            union = union == null ? geom.getEnvelope() : union.getEnvelope().union(geom.getEnvelope());
            DefaultXStyledFeature dsf = new DefaultXStyledFeature(null, "", "", null, (Stroke)new CustomFixedWidthStroke(2.0f, BelisBroker.getInstance().getMappingComponent()));
            dsf.setGeometry(geom);
            dsf.setPrimaryAnnotation("  P" + protokoll.getProtokollnummer());
            dsf.setPrimaryAnnotationPaint((Paint)Color.black);
            dsf.setPrimaryAnnotationHalo(Color.WHITE);
            dsf.setAutoScale(true);
            dsf.setLinePaint((Paint)new Color(0, 0, 0, 1));
            dsf.setFillingPaint((Paint)new Color(0, 0, 0, 1));
            dsf.setTransparency(1.0f);
            dsf.setPrimaryAnnotationFont(FONT);
            dsf.setFeatureAnnotationSymbol(symb);
            this.positionFeatureMap.put(protokoll.getProtokollnummer(), dsf);
            annotatingFeatures.add(dsf);
        }
        if (union != null) {
            union = union.getEnvelope().buffer(OVERVIEWMAP_BUFFER);
            union.setSRID(CrsTransformer.getCurrentSrid());
        }
        this.mapProvider.addLayer((RetrievalServiceLayer)this.overviewMap);
        this.mapProvider.addFeatures(this.allOriginalFeatures);
        this.mapProvider.addFeatures(annotatingFeatures);
        XBoundingBox bb = new XBoundingBox(union);
        this.mapProvider.setBoundingBox(bb);
        try {
            this.map = (BufferedImage)this.mapProvider.getImageAndWait(BASE_DPI, TARGET_DPI, (double)OVERVIEWMAP_WIDTH, (double)OVERVIEWMAP_HEIGHT);
        }
        catch (Exception ex) {
            LOG.error((Object)ex, (Throwable)ex);
            this.map = this.getFallbackMap();
        }
    }

    private BufferedImage getPositionImageFrom(WorkbenchFeatureEntity bean) {
        if (bean.getGeometry() != null) {
            Geometry geom = bean.getGeometry().getEnvelope().buffer(POSITIONMAP_BUFFER);
            geom.setSRID(CrsTransformer.getCurrentSrid());
            try {
                this.mapProvider.setBoundingBox(new XBoundingBox(geom));
                return (BufferedImage)this.mapProvider.getImageAndWait(BASE_DPI, TARGET_DPI, (double)POSITIONMAP_WIDTH, (double)POSITIONMAP_HEIGHT);
            }
            catch (Exception ex) {
                LOG.error((Object)ex, (Throwable)ex);
                return this.getFallbackMap();
            }
        }
        return null;
    }

    private BufferedImage getFallbackMap() {
        try {
            return ImageIO.read(new URL("http://lorempixel.com/554/219/abstract/"));
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    public String getNummer() {
        return this.nummer;
    }

    public String getAngelegt() {
        return this.angelegt;
    }

    public BufferedImage getMap() {
        return this.map;
    }

    public String getZugewiesen_an() {
        return this.zugewiesen_an;
    }

    public ArrayList<ReportingVeranlassung> getVeranlassungen() {
        return this.veranlassungen;
    }

    public MultiHashMap getPositionenNachVeranlassung() {
        return this.positionenNachVeranlassung;
    }

    public String getLink() {
        return this.link;
    }

    static {
        FONT = new Font("SansSerif", 0, 16);
        Properties prop = new Properties();
        try {
            prop.load(ReportingArbeitsauftrag.class.getResourceAsStream("/de/cismet/belis/reports/reporting.properties"));
            OVERVIEWMAP_URL = prop.getProperty("map.overview.url");
            OVERVIEWMAP_WIDTH = Integer.parseInt(prop.getProperty("map.overview.width"));
            OVERVIEWMAP_HEIGHT = Integer.parseInt(prop.getProperty("map.overview.height"));
            OVERVIEWMAP_BUFFER = Double.parseDouble(prop.getProperty("map.overview.buffer"));
            POSITIONMAP_URL = prop.getProperty("map.position.url");
            POSITIONMAP_WIDTH = Integer.parseInt(prop.getProperty("map.position.width"));
            POSITIONMAP_HEIGHT = Integer.parseInt(prop.getProperty("map.position.height"));
            POSITIONMAP_BUFFER = Double.parseDouble(prop.getProperty("map.position.buffer"));
            BASE_DPI = Integer.parseInt(prop.getProperty("base.dpi"));
            TARGET_DPI = Integer.parseInt(prop.getProperty("target.dpi"));
        }
        catch (Exception ex) {
            LOG.error((Object)"Error during intializing of BelisReportingParameters. No Report will be available");
        }
    }
}

