/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.belis.gui.reports;

import de.cismet.belis.arbeitsprotokollwizard.AbstractArbeitsprotokollWizard;
import de.cismet.belis.broker.BelisBroker;
import de.cismet.belis.gui.reports.ReportingAction;
import de.cismet.belis.gui.reports.ReportingStatus;
import de.cismet.cids.custom.beans.belis2.ArbeitsprotokollCustomBean;
import de.cismet.commons.server.entity.WorkbenchFeatureEntity;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ReportingPosition {
    String name;
    List<ReportingAction> moeglicheAktionen = new ArrayList<ReportingAction>();
    List<ReportingStatus> moeglicheStati = new ArrayList<ReportingStatus>();
    BufferedImage map;

    public ReportingPosition(int nummer, ArbeitsprotokollCustomBean protokoll, BufferedImage map) {
        WorkbenchFeatureEntity entity = protokoll.getChildEntity();
        this.name = "Position " + String.valueOf(nummer) + ": ";
        if (entity != null) {
            this.name = this.name + entity;
        }
        this.map = map;
        Collection<AbstractArbeitsprotokollWizard> wizardActions = BelisBroker.getInstance().getWizardsActionsForEntity(protokoll.getChildType());
        if (wizardActions != null) {
            for (AbstractArbeitsprotokollWizard action : wizardActions) {
                this.moeglicheAktionen.add(new ReportingAction(String.valueOf(action.getAction().getValue("Name"))));
            }
        }
        Collection<AbstractArbeitsprotokollWizard> defaultActions = BelisBroker.getInstance().getWizardsActionsForEntity(null);
        for (AbstractArbeitsprotokollWizard action : defaultActions) {
            this.moeglicheAktionen.add(new ReportingAction(String.valueOf(action.getAction().getValue("Name"))));
        }
        this.moeglicheStati.add(new ReportingStatus("offen"));
        this.moeglicheStati.add(new ReportingStatus("erledigt"));
        this.moeglicheStati.add(new ReportingStatus("Fehlmeldung"));
    }

    public String getName() {
        return this.name;
    }

    public List<ReportingAction> getMoeglicheAktionen() {
        return this.moeglicheAktionen;
    }

    public List<ReportingStatus> getMoeglicheStati() {
        return this.moeglicheStati;
    }

    public BufferedImage getMap() {
        return this.map;
    }
}

