/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.belis.gui.reports;

import Sirius.navigator.connection.SessionManager;
import Sirius.server.middleware.types.MetaObject;
import Sirius.server.middleware.types.MetaObjectNode;
import de.cismet.belis.broker.CidsBroker;
import de.cismet.belis.gui.reports.ReportingPosition;
import de.cismet.belis2.server.search.VeranlassungSearchStatement;
import de.cismet.cids.custom.beans.belis2.VeranlassungCustomBean;
import de.cismet.cids.server.search.CidsServerSearch;
import java.util.ArrayList;
import java.util.Collection;
import org.openide.util.Exceptions;

public class ReportingVeranlassung {
    String nummer;
    String bezeichnung = null;
    String beschreibung = null;
    String bemerkung = null;
    ArrayList<ReportingPosition> positionen;

    public ReportingVeranlassung(String veranlassungsKey, Collection reportingPositionen) {
        int numberPos;
        int n = numberPos = reportingPositionen != null ? reportingPositionen.size() : 0;
        if (veranlassungsKey.equals("OHNE")) {
            this.nummer = "ohne Veranlassung: ";
            this.bezeichnung = "manuell angelegte Positionen";
        } else {
            try {
                VeranlassungSearchStatement veranlassungSearchStatement = new VeranlassungSearchStatement();
                veranlassungSearchStatement.setNummer(veranlassungsKey);
                veranlassungSearchStatement.setActiveObjectsOnly(false);
                Collection c = CidsBroker.getInstance().executeServerSearch((CidsServerSearch)veranlassungSearchStatement);
                if (c != null && c.size() == 1) {
                    MetaObjectNode mon = (MetaObjectNode)c.toArray()[0];
                    MetaObject metaObject = SessionManager.getProxy().getMetaObject(mon.getObjectId(), mon.getClassId(), mon.getDomain());
                    VeranlassungCustomBean veranlassung = (VeranlassungCustomBean)metaObject.getBean();
                    this.nummer = "Aus Veranlassung " + veranlassung.getKeyString() + ": ";
                    this.bezeichnung = veranlassung.getBezeichnung();
                    this.beschreibung = veranlassung.getBeschreibung();
                    this.bemerkung = veranlassung.getBemerkungen();
                }
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        this.nummer = this.nummer + numberPos + (numberPos == 1 ? " Position" : " Positionen");
        this.positionen = new ArrayList(reportingPositionen);
    }

    public String getNummer() {
        return this.nummer;
    }

    public void setNummer(String nummer) {
        this.nummer = nummer;
    }

    public String getBezeichnung() {
        return this.bezeichnung;
    }

    public void setBezeichnung(String bezeichnung) {
        this.bezeichnung = bezeichnung;
    }

    public String getBeschreibung() {
        return this.beschreibung;
    }

    public void setBeschreibung(String beschreibung) {
        this.beschreibung = beschreibung;
    }

    public String getBemerkung() {
        return this.bemerkung;
    }

    public void setBemerkung(String bemerkung) {
        this.bemerkung = bemerkung;
    }

    public ArrayList<ReportingPosition> getPositionen() {
        return this.positionen;
    }

    public void setPositionen(ArrayList<ReportingPosition> positionen) {
        this.positionen = positionen;
    }
}

