/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.belis.gui.search;

import de.cismet.belis.gui.search.AddressChangedListener;
import de.cismet.belis.gui.search.SearchControl;
import de.cismet.cismap.commons.BoundingBox;
import de.cismet.cismap.commons.wfsforms.WFSFormAdress;
import de.cismet.cismap.commons.wfsforms.WFSFormAdressListener;
import de.cismet.cismap.commons.wfsforms.WFSFormQuery;
import de.cismet.commons.architecture.util.ArchitectureUtils;
import de.cismet.tools.configuration.Configurable;
import de.cismet.tools.configuration.NoWriteError;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.apache.log4j.Logger;
import org.jdom.Element;
import org.openide.util.NbBundle;

public class AddressSearchControl
extends WFSFormAdress
implements Configurable,
SearchControl,
WFSFormAdressListener {
    protected static final Logger log = Logger.getLogger(AddressSearchControl.class);
    final ArrayList<AddressChangedListener> addressListener = new ArrayList();
    protected JComboBox _cboNr;
    protected JComboBox _cboStreets;
    protected JCheckBox _chkLockScale;
    protected JCheckBox _chkVisualize;
    protected JButton _cmdOk;
    private JLabel _jLabel1;
    protected JLabel _jLabel2;
    protected JPanel _panEmpty;
    protected JProgressBar _prbNr;
    protected JProgressBar _prbStreets;

    public AddressSearchControl() {
        this.initComponents();
        this.addWFSFormAddressListner(this);
    }

    public void configure(Element parent) {
    }

    public Element getConfiguration() throws NoWriteError {
        return null;
    }

    public void masterConfigure(Element parent) {
        log.info((Object)"Address Search Panel wird konfiguriert");
        try {
            Element searchConf = parent.getChild("ApplicationSpecificConfiguration").getChild("SearchPanel").getChild("AddressSearch");
            Vector<WFSFormQuery> queryVector = new Vector<WFSFormQuery>();
            List queries = searchConf.getChildren("Query");
            for (Object oq : queries) {
                Element q = (Element)oq;
                WFSFormQuery query = new WFSFormQuery();
                query.setComponentName(q.getAttribute("componentName").getValue());
                query.setDisplayTextProperty(q.getAttribute("displayTextProperty").getValue());
                query.setExtentProperty(q.getAttribute("extentProperty").getValue());
                query.setFilename(q.getAttribute("queryFile").getValue());
                query.setWfsQueryString(this.readFileFromClassPathAsString(query.getFilename()));
                query.setId(q.getAttribute("id").getValue());
                query.setIdProperty(q.getAttribute("idProperty").getValue());
                query.setServerUrl(q.getAttribute("server").getValue());
                query.setTitle(q.getAttribute("title").getValue());
                query.setType(q.getAttribute("type").getValue());
                try {
                    query.setPropertyPrefix(q.getAttribute("propertyPrefix").getValue());
                }
                catch (Exception skip) {
                    query.setPropertyPrefix(null);
                }
                try {
                    query.setPropertyNamespace(q.getAttribute("propertyNamespace").getValue());
                }
                catch (Exception skip) {
                    query.setPropertyNamespace(null);
                }
                try {
                    query.setPositionProperty(q.getAttribute("positionProperty").getValue());
                }
                catch (Exception skip) {
                    query.setPositionProperty(null);
                }
                if (q.getAttribute("queryPlaceholder") != null) {
                    query.setQueryPlaceholder(q.getAttribute("queryPlaceholder").getValue());
                }
                queryVector.add(query);
            }
            this.setQueries(queryVector);
        }
        catch (Exception ex) {
            log.error((Object)"Fehler beim einlesen der Address Abfragen (Stra\u00dfe/Hausnummer)", (Throwable)ex);
        }
    }

    private String readFileFromClassPathAsString(String filePath) throws IOException {
        InputStream is = this.getClass().getResourceAsStream(filePath);
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        StringBuffer fileData = new StringBuffer(1000);
        char[] buf = new char[1024];
        int numRead = 0;
        while ((numRead = reader.read(buf)) != -1) {
            String readData = String.valueOf(buf, 0, numRead);
            fileData.append(readData);
            buf = new char[1024];
        }
        reader.close();
        return fileData.toString();
    }

    @Override
    public void searchFinished() {
    }

    @Override
    public void searchStarted() {
    }

    @Override
    public void setSearchEnabled(boolean isSearchEnabled) {
        ArchitectureUtils.enableContainerRecursivley((Container)this._panEmpty, (boolean)isSearchEnabled);
        this._chkVisualize.setEnabled(isSearchEnabled);
        this._chkLockScale.setEnabled(isSearchEnabled);
        this._cmdOk.setEnabled(isSearchEnabled);
    }

    public void wfsFormAddressPositioned(BoundingBox addressBB) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("AddressSearch started --> searching db for geometries boundingbox: " + addressBB));
        }
        this.getMappingComponent().gotoBoundingBoxWithHistory(addressBB);
    }

    public void wfsFormAdressNrSelected() {
    }

    public void wfsFormAdressStreetSelected() {
    }

    private void initComponents() {
        this._prbStreets = this.prbStreets;
        this._prbNr = this.prbNr;
        this._chkLockScale = this.chkLockScale;
        this._jLabel2 = this.jLabel2;
        this._jLabel1 = this.jLabel1;
        this._panEmpty = this.panEmpty;
        this._cmdOk = this.cmdOk;
        this._chkVisualize = this.chkVisualize;
        this._cboNr = this.cboNr;
        this._cboStreets = this.cboStreets;
        this._prbStreets.setBorderPainted(false);
        this._prbStreets.setMaximumSize(new Dimension(Short.MAX_VALUE, 5));
        this._prbStreets.setMinimumSize(new Dimension(10, 5));
        this._prbStreets.setPreferredSize(new Dimension(150, 5));
        this._prbStreets.setVisible(false);
        this._prbNr.setBorderPainted(false);
        this._prbNr.setMaximumSize(new Dimension(Short.MAX_VALUE, 5));
        this._prbNr.setMinimumSize(new Dimension(10, 5));
        this._prbNr.setPreferredSize(new Dimension(150, 5));
        this._prbNr.setVisible(false);
        this._chkLockScale.setToolTipText(NbBundle.getMessage(AddressSearchControl.class, (String)"AddressSearchControl._chkLockScale.toolTipText"));
        this._chkLockScale.setVisible(false);
        this._jLabel2.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/res/fixMapScale.png")));
        this._jLabel2.setToolTipText(NbBundle.getMessage(AddressSearchControl.class, (String)"AddressSearchControl._jLabel2.toolTipText"));
        this._jLabel2.setVisible(false);
        this._jLabel1.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/res/markPoint.png")));
        this._jLabel1.setToolTipText(NbBundle.getMessage(AddressSearchControl.class, (String)"AddressSearchControl._jLabel1.toolTipText"));
        this.jLabel1.setVisible(false);
        this._panEmpty.setMinimumSize(new Dimension(1, 1));
        this._panEmpty.setOpaque(false);
        GroupLayout _panEmptyLayout = new GroupLayout(this._panEmpty);
        this._panEmpty.setLayout(_panEmptyLayout);
        _panEmptyLayout.setHorizontalGroup(_panEmptyLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 1, Short.MAX_VALUE));
        _panEmptyLayout.setVerticalGroup(_panEmptyLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 1, Short.MAX_VALUE));
        this._panEmpty.setVisible(false);
        this.setBorder(null);
        this.setMaximumSize(new Dimension(290, 28));
        this.setMinimumSize(new Dimension(290, 28));
        this.setOpaque(false);
        this.setPreferredSize(new Dimension(290, 28));
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddressSearchControl.this.formActionPerformed(evt);
            }
        });
        this._cmdOk.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/belis/resource/icon/16/dirrection--arrow.png")));
        this._cmdOk.setToolTipText(NbBundle.getMessage(AddressSearchControl.class, (String)"AddressSearchControl._cmdOk.toolTipText"));
        this._cmdOk.setBorder(null);
        this._cmdOk.setBorderPainted(false);
        this._cmdOk.setFocusable(false);
        this._cmdOk.setMaximumSize(new Dimension(22, 22));
        this._cmdOk.setMinimumSize(new Dimension(22, 22));
        this._cmdOk.setPreferredSize(new Dimension(22, 22));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.add(this._cmdOk, gridBagConstraints);
        this._cmdOk.setText(null);
        this._chkVisualize.setSelected(true);
        this._chkVisualize.setToolTipText(NbBundle.getMessage(AddressSearchControl.class, (String)"AddressSearchControl._chkVisualize.toolTipText"));
        this._chkVisualize.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/belis/resource/icon/16/markPointDisabled.png")));
        this._chkVisualize.setSelectedIcon(new ImageIcon(this.getClass().getResource("/de/cismet/belis/resource/icon/16/markPoint.png")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.add(this._chkVisualize, gridBagConstraints);
        this._cboNr.setEditable(true);
        this._cboNr.setEnabled(false);
        this._cboNr.setMaximumSize(new Dimension(50, 19));
        this._cboNr.setMinimumSize(new Dimension(50, 19));
        this._cboNr.setPreferredSize(new Dimension(50, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.add(this._cboNr, gridBagConstraints);
        this._cboStreets.setEnabled(false);
        this._cboStreets.setMaximumSize(new Dimension(Short.MAX_VALUE, 19));
        this._cboStreets.setMinimumSize(new Dimension(41, 19));
        this._cboStreets.setPreferredSize(new Dimension(41, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.add(this._cboStreets, gridBagConstraints);
    }

    private void formActionPerformed(ActionEvent evt) {
    }
}

