/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.belis.gui.search;

import de.cismet.belis.broker.BelisBroker;
import de.cismet.belis.gui.search.SearchControl;
import de.cismet.cismap.commons.wfsforms.WFSFormFeature;
import de.cismet.commons.architecture.util.ArchitectureUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class LocationSearchControl
extends JPanel
implements SearchControl {
    private static final Logger LOG = Logger.getLogger(LocationSearchControl.class);
    private BelisBroker broker;
    protected JButton cmdOk;
    protected JPanel panEmpty1;
    private JTextField txfKennziffer;
    private JTextField txfLaufendenummer;
    private JTextField txfStrassenschluessel;

    public LocationSearchControl(BelisBroker broker) {
        this.broker = broker;
        this.initComponents();
    }

    private void initComponents() {
        this.panEmpty1 = new JPanel();
        this.txfLaufendenummer = new JTextField();
        this.cmdOk = new JButton();
        this.txfStrassenschluessel = new JTextField();
        this.txfKennziffer = new JTextField();
        this.panEmpty1.setMinimumSize(new Dimension(1, 19));
        this.panEmpty1.setOpaque(false);
        GroupLayout panEmpty1Layout = new GroupLayout(this.panEmpty1);
        this.panEmpty1.setLayout(panEmpty1Layout);
        panEmpty1Layout.setHorizontalGroup(panEmpty1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 116, Short.MAX_VALUE));
        panEmpty1Layout.setVerticalGroup(panEmpty1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 25, Short.MAX_VALUE));
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        this.txfLaufendenummer.setHorizontalAlignment(4);
        this.txfLaufendenummer.setMaximumSize(new Dimension(Integer.MAX_VALUE, 18));
        this.txfLaufendenummer.setMinimumSize(new Dimension(30, 18));
        this.txfLaufendenummer.setPreferredSize(new Dimension(45, 18));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 0, 2);
        this.add((Component)this.txfLaufendenummer, gridBagConstraints);
        this.cmdOk.setFont(new Font("DejaVu Sans", 1, 13));
        this.cmdOk.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/belis/resource/icon/22/search.png")));
        this.cmdOk.setMnemonic('P');
        this.cmdOk.setText("Objektschl\u00fcssel");
        this.cmdOk.setBorder(null);
        this.cmdOk.setBorderPainted(false);
        this.cmdOk.setFocusable(false);
        this.cmdOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationSearchControl.this.cmdOkActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 2, 0, 3);
        this.add((Component)this.cmdOk, gridBagConstraints);
        this.txfStrassenschluessel.setHorizontalAlignment(4);
        this.txfStrassenschluessel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 18));
        this.txfStrassenschluessel.setMinimumSize(new Dimension(50, 18));
        this.txfStrassenschluessel.setPreferredSize(new Dimension(65, 18));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 3, 0, 2);
        this.add((Component)this.txfStrassenschluessel, gridBagConstraints);
        this.txfKennziffer.setHorizontalAlignment(4);
        this.txfKennziffer.setMaximumSize(new Dimension(Integer.MAX_VALUE, 18));
        this.txfKennziffer.setMinimumSize(new Dimension(25, 18));
        this.txfKennziffer.setPreferredSize(new Dimension(30, 18));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 0, 2);
        this.add((Component)this.txfKennziffer, gridBagConstraints);
    }

    private void cmdOkActionPerformed(ActionEvent evt) {
        this.broker.fireSearchStarted();
        String strassenschluessel = this.txfStrassenschluessel.getText().isEmpty() ? null : this.txfStrassenschluessel.getText();
        Integer kennziffer = null;
        try {
            kennziffer = this.txfKennziffer.getText().isEmpty() ? null : Integer.valueOf(Integer.parseInt(this.txfKennziffer.getText()));
        }
        catch (Exception ex) {
            LOG.info((Object)"error while parsing kennziffer", (Throwable)ex);
        }
        Integer laufendeNummer = null;
        try {
            laufendeNummer = this.txfLaufendenummer.getText().isEmpty() ? null : Integer.valueOf(Integer.parseInt(this.txfLaufendenummer.getText()));
        }
        catch (Exception ex) {
            LOG.info((Object)"error while parsing laufende Nummer", (Throwable)ex);
        }
        this.broker.search(strassenschluessel, kennziffer, laufendeNummer);
    }

    public void requestRefresh(String component, WFSFormFeature value) {
    }

    @Override
    public void searchFinished() {
    }

    @Override
    public void searchStarted() {
    }

    @Override
    public void setSearchEnabled(boolean isSearchEnabled) {
        ArchitectureUtils.enableContainerRecursivley((Container)this, (boolean)isSearchEnabled);
    }
}

