/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.belis.gui.search;

import de.cismet.belis.broker.BelisBroker;
import de.cismet.belis.gui.search.SearchControl;
import de.cismet.belis.util.BelisIcons;
import de.cismet.commons.architecture.util.ArchitectureUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class MapSearchControl
extends JPanel
implements SearchControl {
    protected JButton cmdOk;
    private final Logger log = Logger.getLogger(MapSearchControl.class);
    private BelisBroker broker;

    public MapSearchControl(BelisBroker broker) {
        this.broker = broker;
        this.initComponents();
        this.cmdOk.setIcon(BelisIcons.icoSearch22);
    }

    private void initComponents() {
        this.cmdOk = new JButton();
        this.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 0));
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        this.cmdOk.setFont(new Font("DejaVu Sans", 1, 13));
        this.cmdOk.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/belis/resource/icon/22/search.png")));
        this.cmdOk.setMnemonic('P');
        this.cmdOk.setText("Karteninhalt");
        this.cmdOk.setBorder(null);
        this.cmdOk.setBorderPainted(false);
        this.cmdOk.setFocusable(false);
        this.cmdOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MapSearchControl.this.cmdOkActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(2, 3, 2, 3);
        this.add((Component)this.cmdOk, gridBagConstraints);
    }

    public void startMapSearch() {
        this.cmdOk.doClick();
    }

    private void cmdOkActionPerformed(ActionEvent evt) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Search with boundingBox");
        }
        this.broker.fireSearchStarted();
        this.broker.search(this.broker.getMappingComponent().getCurrentBoundingBoxFromCamera());
    }

    @Override
    public void searchFinished() {
    }

    @Override
    public void searchStarted() {
    }

    @Override
    public void setSearchEnabled(boolean isSearchEnabled) {
        ArchitectureUtils.enableContainerRecursivley((Container)this, (boolean)isSearchEnabled);
    }
}

