/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.belis.gui.widget;

import de.cismet.belis.broker.BelisBroker;
import de.cismet.belis.gui.utils.DocumentPanel;
import de.cismet.belis.gui.widget.BelisWidget;
import de.cismet.belis.gui.widget.detailWidgetPanels.AbstractDetailWidgetPanel;
import de.cismet.belis.gui.widget.detailWidgetPanels.AbzweigdosePanel;
import de.cismet.belis.gui.widget.detailWidgetPanels.ArbeitsauftragPanel;
import de.cismet.belis.gui.widget.detailWidgetPanels.ArbeitsprotokollPanel;
import de.cismet.belis.gui.widget.detailWidgetPanels.GeometriePanel;
import de.cismet.belis.gui.widget.detailWidgetPanels.LeitungPanel;
import de.cismet.belis.gui.widget.detailWidgetPanels.LeuchtePanel;
import de.cismet.belis.gui.widget.detailWidgetPanels.MauerlaschePanel;
import de.cismet.belis.gui.widget.detailWidgetPanels.SchaltstellePanel;
import de.cismet.belis.gui.widget.detailWidgetPanels.StandortPanel;
import de.cismet.belis.gui.widget.detailWidgetPanels.VeranlassungPanel;
import de.cismet.cids.custom.beans.belis2.AbzweigdoseCustomBean;
import de.cismet.cids.custom.beans.belis2.ArbeitsauftragCustomBean;
import de.cismet.cids.custom.beans.belis2.ArbeitsprotokollCustomBean;
import de.cismet.cids.custom.beans.belis2.GeometrieCustomBean;
import de.cismet.cids.custom.beans.belis2.LeitungCustomBean;
import de.cismet.cids.custom.beans.belis2.MauerlascheCustomBean;
import de.cismet.cids.custom.beans.belis2.SchaltstelleCustomBean;
import de.cismet.cids.custom.beans.belis2.TdtaLeuchtenCustomBean;
import de.cismet.cids.custom.beans.belis2.TdtaStandortMastCustomBean;
import de.cismet.cids.custom.beans.belis2.VeranlassungCustomBean;
import de.cismet.commons.server.entity.WorkbenchEntity;
import de.cismet.commons.server.interfaces.DocumentContainer;
import de.cismet.veto.VetoException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.beans.PropertyChangeEvent;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import org.apache.log4j.Logger;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;

public class DetailWidget
extends BelisWidget {
    public static final String PROP_CURRENT_ENTITY = "currentEntity";
    public static final Short ANZAHL_DK_NULL_VALUE = 0;
    private static final Logger LOG = Logger.getLogger(DetailWidget.class);
    protected Collection<WorkbenchEntity> currentEntities;
    protected WorkbenchEntity currentEntity = null;
    private final StandortPanel standortPanel;
    private final LeuchtePanel leuchtePanel;
    private final LeitungPanel leitungPanel;
    private final AbzweigdosePanel abzweigdosePanel;
    private final MauerlaschePanel mauerlaschePanel;
    private final SchaltstellePanel schaltstellePanel;
    private final VeranlassungPanel veranlassungPanel;
    private final ArbeitsauftragPanel arbeitsauftragPanel;
    private final ArbeitsprotokollPanel arbeitsprotokollPanel;
    private final GeometriePanel geometriePanel;
    private AbstractDetailWidgetPanel currentDetailWidgetPanel = null;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JLabel labDokumente;
    private DocumentPanel panDokumente;
    private JTabbedPane panMain;
    private JScrollPane scpMain;
    private BindingGroup bindingGroup;

    public DetailWidget() {
        try {
            this.setWidgetName("Details");
            this.initComponents();
            this.standortPanel = new StandortPanel();
            this.leuchtePanel = new LeuchtePanel();
            this.leitungPanel = new LeitungPanel();
            this.abzweigdosePanel = new AbzweigdosePanel();
            this.mauerlaschePanel = new MauerlaschePanel();
            this.schaltstellePanel = new SchaltstellePanel();
            this.geometriePanel = new GeometriePanel();
            this.veranlassungPanel = new VeranlassungPanel();
            this.arbeitsauftragPanel = new ArbeitsauftragPanel();
            this.arbeitsprotokollPanel = new ArbeitsprotokollPanel();
        }
        catch (RuntimeException ex) {
            LOG.fatal((Object)"error while initializing DetailWidget", (Throwable)ex);
            throw ex;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("PropertyChange: " + evt));
            LOG.debug((Object)("PropertyChange: " + evt.getPropertyName()));
            LOG.debug((Object)("PropertyChange: " + evt.getOldValue()));
            LOG.debug((Object)("PropertyChange: " + evt.getNewValue()));
        }
    }

    public WorkbenchEntity getCurrentEntity() {
        return this.currentEntity;
    }

    public void setCurrentEntity(WorkbenchEntity currentEntity) throws VetoException {
        WorkbenchEntity oldCurrentEntity = this.currentEntity;
        try {
            currentEntity.setProperty("ausdehnung_wgs84", null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (oldCurrentEntity != currentEntity) {
            int anwser;
            if (!this.getBroker().validateWidgets() && (anwser = this.getBroker().askUser()) != 0) {
                BelisBroker.getInstance().getWorkbenchWidget().setTreeSelectionVeto(true);
                throw new VetoException();
            }
            this.bindingGroup.unbind();
            this.currentEntity = currentEntity;
            this.bindingGroup.bind();
            this.firePropertyChange(PROP_CURRENT_ENTITY, oldCurrentEntity, currentEntity);
        }
    }

    public Collection<WorkbenchEntity> getCurrentEntities() {
        return this.currentEntities;
    }

    public void setCurrentEntities(Collection<WorkbenchEntity> currentEntities, WorkbenchEntity parentEntity, boolean wantsToEdit) throws VetoException {
        boolean isEnabled;
        boolean isAllowedToEdit;
        this.currentEntities = currentEntities;
        WorkbenchEntity selectedEntity = currentEntities != null && !currentEntities.isEmpty() ? currentEntities.iterator().next() : null;
        if (selectedEntity == null) {
            this.currentDetailWidgetPanel = null;
            isAllowedToEdit = false;
            this.setCurrentEntity(null);
        } else {
            if (selectedEntity instanceof TdtaStandortMastCustomBean) {
                this.setCurrentEntity(selectedEntity);
                this.standortPanel.setCurrentEntity((TdtaStandortMastCustomBean)this.currentEntity);
                this.currentDetailWidgetPanel = this.standortPanel;
                isAllowedToEdit = ((TdtaStandortMastCustomBean)this.currentEntity).isEditAllowed();
            } else if (selectedEntity instanceof TdtaLeuchtenCustomBean) {
                this.setCurrentEntity(selectedEntity);
                if (this.getBroker().getWorkbenchWidget().isParentNodeMast(this.getBroker().getWorkbenchWidget().getSelectedTreeNode().getLastPathComponent())) {
                    this.leuchtePanel.setInheritedMastPropertiesEnabled(false);
                } else if (this.getBroker().isInEditMode()) {
                    this.leuchtePanel.setInheritedMastPropertiesEnabled(true);
                }
                this.leuchtePanel.setCurrentEntity((TdtaLeuchtenCustomBean)this.currentEntity);
                this.currentDetailWidgetPanel = this.leuchtePanel;
                isAllowedToEdit = ((TdtaLeuchtenCustomBean)this.currentEntity).isEditAllowed();
            } else if (selectedEntity instanceof LeitungCustomBean) {
                this.setCurrentEntity(selectedEntity);
                this.leitungPanel.setCurrentEntity((LeitungCustomBean)this.currentEntity);
                this.currentDetailWidgetPanel = this.leitungPanel;
                isAllowedToEdit = ((LeitungCustomBean)this.currentEntity).isEditAllowed();
            } else if (selectedEntity instanceof AbzweigdoseCustomBean) {
                this.setCurrentEntity(selectedEntity);
                this.abzweigdosePanel.setCurrentEntity((AbzweigdoseCustomBean)this.currentEntity);
                this.currentDetailWidgetPanel = this.abzweigdosePanel;
                isAllowedToEdit = ((AbzweigdoseCustomBean)this.currentEntity).isEditAllowed();
            } else if (selectedEntity instanceof MauerlascheCustomBean) {
                this.setCurrentEntity(selectedEntity);
                this.mauerlaschePanel.setCurrentEntity((MauerlascheCustomBean)this.currentEntity);
                this.currentDetailWidgetPanel = this.mauerlaschePanel;
                isAllowedToEdit = ((MauerlascheCustomBean)this.currentEntity).isEditAllowed();
            } else if (selectedEntity instanceof SchaltstelleCustomBean) {
                this.setCurrentEntity(selectedEntity);
                this.schaltstellePanel.setCurrentEntity((SchaltstelleCustomBean)this.currentEntity);
                this.currentDetailWidgetPanel = this.schaltstellePanel;
                isAllowedToEdit = ((SchaltstelleCustomBean)this.currentEntity).isEditAllowed();
            } else if (selectedEntity instanceof VeranlassungCustomBean) {
                this.setCurrentEntity(selectedEntity);
                this.veranlassungPanel.setCurrentEntity((VeranlassungCustomBean)this.currentEntity);
                this.currentDetailWidgetPanel = this.veranlassungPanel;
                isAllowedToEdit = ((VeranlassungCustomBean)this.currentEntity).isEditAllowed();
            } else if (selectedEntity instanceof GeometrieCustomBean) {
                this.setCurrentEntity(selectedEntity);
                this.geometriePanel.setCurrentEntity((GeometrieCustomBean)this.currentEntity);
                this.currentDetailWidgetPanel = this.geometriePanel;
                isAllowedToEdit = ((GeometrieCustomBean)this.currentEntity).isEditAllowed();
            } else if (selectedEntity instanceof ArbeitsauftragCustomBean) {
                this.setCurrentEntity(selectedEntity);
                this.arbeitsauftragPanel.setCurrentEntity((ArbeitsauftragCustomBean)this.currentEntity);
                this.currentDetailWidgetPanel = this.arbeitsauftragPanel;
                isAllowedToEdit = ((ArbeitsauftragCustomBean)this.currentEntity).isEditAllowed();
            } else if (selectedEntity instanceof ArbeitsprotokollCustomBean) {
                if (parentEntity instanceof ArbeitsauftragCustomBean) {
                    this.setCurrentEntity(parentEntity);
                    this.arbeitsauftragPanel.setCurrentEntity((ArbeitsauftragCustomBean)parentEntity);
                    this.arbeitsauftragPanel.setSelectedProtokolle(currentEntities);
                    this.currentDetailWidgetPanel = this.arbeitsauftragPanel;
                    isAllowedToEdit = ((ArbeitsauftragCustomBean)parentEntity).isEditAllowed();
                } else {
                    this.setCurrentEntity(null);
                    this.currentDetailWidgetPanel = null;
                    isAllowedToEdit = false;
                }
            } else {
                this.setCurrentEntity(null);
                this.currentDetailWidgetPanel = null;
                isAllowedToEdit = false;
            }
            if (this.currentEntity instanceof DocumentContainer) {
                this.panDokumente.setDokumente(this.currentEntity.getDokumente());
                this.panMain.setTabComponentAt(1, this.labDokumente);
            }
        }
        boolean bl = isEnabled = wantsToEdit && isAllowedToEdit;
        if (this.currentDetailWidgetPanel == null) {
            this.panDokumente.setDokumente(null);
        } else {
            this.currentDetailWidgetPanel.setElementsNull();
            this.currentDetailWidgetPanel.setPanelEditable(isEnabled);
        }
        this.setWidgetEditable(isEnabled);
        this.showPanel(this.currentDetailWidgetPanel);
        this.repaint();
    }

    private void showPanel(AbstractDetailWidgetPanel panel) {
        super.clearComponent();
        if (panel != null) {
            this.scpMain.setViewportView(panel);
            this.panMain.setTabComponentAt(0, panel.getTabLabel());
            this.panMain.setSelectedComponent(this.scpMain);
            this.panMain.setVisible(true);
        } else {
            this.panMain.setVisible(false);
        }
    }

    @Override
    public void clearComponent() {
        super.clearComponent();
        try {
            this.setCurrentEntities(null, null, false);
        }
        catch (VetoException vetoException) {
            // empty catch block
        }
    }

    @Override
    public void setWidgetEditable(boolean isEditable) {
        super.setWidgetEditable(isEditable);
        if (this.currentDetailWidgetPanel != null) {
            this.currentDetailWidgetPanel.setPanelEditable(isEditable);
        }
        this.panDokumente.setEditable(isEditable);
    }

    private void commitEdits() {
        if (this.currentEntity != null) {
            if (this.currentEntity instanceof TdtaLeuchtenCustomBean) {
                this.leuchtePanel.commitEdits();
            } else if (this.currentEntity instanceof TdtaStandortMastCustomBean) {
                this.standortPanel.commitEdits();
            } else if (this.currentEntity instanceof SchaltstelleCustomBean) {
                this.schaltstellePanel.commitEdits();
            } else if (this.currentEntity instanceof MauerlascheCustomBean) {
                this.mauerlaschePanel.commitEdits();
            }
        }
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.labDokumente = new JLabel();
        this.panMain = new JTabbedPane();
        this.scpMain = new JScrollPane();
        this.jPanel2 = new JPanel();
        this.panDokumente = new DocumentPanel();
        this.jPanel3 = new JPanel();
        this.labDokumente.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/belis/resource/icon/16/copy.png")));
        this.labDokumente.setText("Dokumente");
        this.setLayout(new BorderLayout());
        this.scpMain.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.scpMain.setVerticalScrollBarPolicy(22);
        this.panMain.addTab("", this.scpMain);
        this.jPanel2.setLayout(new GridBagLayout());
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${currentEntity.dokumente}"), (Object)this.panDokumente, (Property)BeanProperty.create((String)"dokumente"));
        this.bindingGroup.addBinding((Binding)binding);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.jPanel2.add((Component)this.panDokumente, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel2.add((Component)this.jPanel3, gridBagConstraints);
        this.panMain.addTab("", this.jPanel2);
        this.add((Component)this.panMain, "Center");
        this.bindingGroup.bind();
    }

    @Override
    public int getStatus() {
        if (this.currentDetailWidgetPanel != null) {
            int status = this.currentDetailWidgetPanel.getStatus();
            this.validationMessage = this.currentDetailWidgetPanel.getValidationMessage();
            return status;
        }
        this.validationMessage = "";
        return 0;
    }

    public StandortPanel getStandortPanel() {
        return this.standortPanel;
    }

    public LeuchtePanel getLeuchtePanel() {
        return this.leuchtePanel;
    }

    public LeitungPanel getLeitungPanel() {
        return this.leitungPanel;
    }

    public AbzweigdosePanel getAbzweigdosePanel() {
        return this.abzweigdosePanel;
    }

    public MauerlaschePanel getMauerlaschePanel() {
        return this.mauerlaschePanel;
    }

    public SchaltstellePanel getSchaltstellePanel() {
        return this.schaltstellePanel;
    }

    public VeranlassungPanel getVeranlassungPanel() {
        return this.veranlassungPanel;
    }

    public ArbeitsauftragPanel getArbeitsauftragPanel() {
        return this.arbeitsauftragPanel;
    }

    public ArbeitsprotokollPanel getArbeitsprotokollPanel() {
        return this.arbeitsprotokollPanel;
    }

    public GeometriePanel getGeometriePanel() {
        return this.geometriePanel;
    }
}

