/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.belis.gui.widget;

import com.vividsolutions.jts.geom.Geometry;
import de.cismet.belis.broker.BelisBroker;
import de.cismet.belis.gui.search.AddressSearchControl;
import de.cismet.belis.gui.widget.BelisWidget;
import de.cismet.cismap.commons.MappingModel;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.FeatureCollectionEvent;
import de.cismet.cismap.commons.features.FeatureCollectionListener;
import de.cismet.cismap.commons.features.PureNewFeature;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.layerwidget.ActiveLayerModel;
import de.cismet.cismap.commons.gui.piccolo.PFeature;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.AttachFeatureListener;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.CreateGeometryListener;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.DeleteFeatureListener;
import de.cismet.commons.architecture.geometrySlot.GeometrySlotInformation;
import de.cismet.commons.architecture.interfaces.NoPermissionsWidget;
import de.cismet.tools.CurrentStackTrace;
import de.cismet.tools.configuration.Configurable;
import de.cismet.tools.configuration.ConfigurationManager;
import de.cismet.tools.gui.historybutton.HistoryModel;
import de.cismet.tools.gui.historybutton.JHistoryButton;
import edu.umd.cs.piccolox.event.PNotification;
import edu.umd.cs.piccolox.event.PNotificationCenter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import org.apache.log4j.Logger;
import org.jdesktop.layout.GroupLayout;
import org.jdom.Element;

public class MapWidget
extends BelisWidget
implements FeatureCollectionListener,
NoPermissionsWidget {
    private static final Logger LOG = Logger.getLogger(MapWidget.class);
    private MappingComponent mappingComponent;
    private final ArrayList<JButton> customButtons = new ArrayList();
    private MapMode currentMapMode = null;
    private MapMode lastMapMode = null;
    private final ActiveLayerModel mappingModel = new ActiveLayerModel();
    private boolean isEditable = true;
    private AddressSearchControl addressSearchControl;
    private JButton cmdAdd;
    private JButton cmdAddHandle;
    private JButton cmdBack;
    private JButton cmdForeground;
    private JButton cmdForward;
    private JButton cmdFullPoly;
    private JButton cmdFullPoly1;
    private JButton cmdMoveHandle;
    private JButton cmdMovePolygon;
    private JToggleButton cmdNewLinestring;
    private JButton cmdPan;
    private JButton cmdRemoveHandle;
    private JButton cmdRemovePolygon;
    private JButton cmdSelect;
    private JButton cmdSnap;
    private JButton cmdWmsBackground;
    private JButton cmdZoom;
    private JPanel jPanel1;
    private JSeparator jSeparator4;
    private JSeparator jSeparator5;
    private JSeparator jSeparator6;
    private JSeparator jSeparator7;
    private JToolBar mapWidgetToolbar;

    public MapWidget() {
        this.setWidgetName("Karte");
    }

    @Override
    public void setBroker(BelisBroker broker) {
        super.setBroker(broker);
        this.mappingComponent = broker.getMappingComponent();
        this.initComponents();
        this.addressSearchControl.setMappingComponent(this.mappingComponent);
        broker.addSearchControl(this.addressSearchControl);
    }

    public void setToLastInteractionMode() {
        if (this.getLastMapMode() != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Setting MapWidget to last interactionmode...");
            }
            switch (this.getLastMapMode()) {
                case SELECT: {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Select");
                    }
                    this.cmdSelectActionPerformed(null);
                    break;
                }
                case PAN: {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Pan");
                    }
                    this.cmdPanActionPerformed(null);
                    break;
                }
                case ZOOM: {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Zoom");
                    }
                    this.cmdZoomActionPerformed(null);
                    break;
                }
                case MOVE_POLYGON: {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Move polygon");
                    }
                    this.cmdMovePolygonActionPerformed(null);
                    break;
                }
                case REMOVE_POLYGON: {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Remove handle");
                    }
                    this.cmdRemovePolygonActionPerformed(null);
                    break;
                }
                case MEASUREMENT: {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"New LineString");
                    }
                    this.cmdNewLinestringActionPerformed(null);
                    break;
                }
                case CUSTOM: {
                    LOG.warn((Object)"Can't set to last interaction mode was custom");
                }
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"No last interaction mode. Setting mode to Select");
            }
            this.cmdSelect.doClick();
        }
    }

    public MapMode getCurrentMapMode() {
        return this.currentMapMode;
    }

    public void setCurrentMapMode(MapMode currentMapMode) {
        this.currentMapMode = currentMapMode;
    }

    public MapMode getLastMapMode() {
        return this.lastMapMode;
    }

    public void setLastMapMode(MapMode lastMapMode) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("setLastMapModeTo: " + (Object)((Object)lastMapMode) + " was: " + (Object)((Object)this.getLastMapMode())));
        }
        this.lastMapMode = lastMapMode;
    }

    public JButton getCmdSelect() {
        return this.cmdSelect;
    }

    public ActiveLayerModel getMappingModel() {
        return this.mappingModel;
    }

    public void addCustomButton(JButton customButton) {
        if (customButton != null) {
            customButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MapWidget.this.removeMainGroupSelection();
                    MapWidget.this.setLastMapMode(MapWidget.this.getCurrentMapMode());
                    MapWidget.this.setCurrentMapMode(MapMode.CUSTOM);
                }
            });
            this.customButtons.add(customButton);
            this.mapWidgetToolbar.add(customButton);
        }
    }

    public void setInteractionMode() {
        String currentInteractionMode = this.mappingComponent.getInteractionMode();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("CurrentInteractionMode: " + currentInteractionMode), (Throwable)new CurrentStackTrace());
        }
        if (currentInteractionMode != null) {
            if (currentInteractionMode.equals("SELECT")) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"InteractionMode set to SELCET");
                }
                this.cmdSelectActionPerformed(null);
            } else if (currentInteractionMode.equals("PAN")) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"InteractionMode set to PAN");
                }
                this.cmdPanActionPerformed(null);
            } else if (currentInteractionMode.equals("NEW_POLYGON")) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"InteractionMode set to NEW_POLYGON");
                }
            } else if (currentInteractionMode.equals("ZOOM")) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"InteractionMode set to ZOOM");
                }
                this.cmdZoomActionPerformed(null);
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Unknown Interactionmode: " + currentInteractionMode));
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"InteractionMode == null");
        }
    }

    private void initComponents() {
        this.mapWidgetToolbar = new JToolBar();
        this.cmdFullPoly = new JButton();
        this.cmdFullPoly1 = new JButton();
        this.cmdBack = new JHistoryButton();
        this.cmdForward = new JHistoryButton();
        this.addressSearchControl = new AddressSearchControl();
        this.jSeparator4 = new JSeparator();
        this.cmdWmsBackground = new JButton();
        this.cmdForeground = new JButton();
        this.cmdSnap = new JButton();
        this.jSeparator5 = new JSeparator();
        this.cmdZoom = new JButton();
        this.cmdPan = new JButton();
        this.cmdSelect = new JButton();
        this.cmdMovePolygon = new JButton();
        this.cmdRemovePolygon = new JButton();
        this.jSeparator6 = new JSeparator();
        this.cmdMoveHandle = new JButton();
        this.cmdAddHandle = new JButton();
        this.cmdRemoveHandle = new JButton();
        this.jSeparator7 = new JSeparator();
        this.cmdNewLinestring = new JToggleButton();
        this.jPanel1 = new JPanel();
        this.cmdAdd = new JButton();
        this.setLayout(new BorderLayout());
        this.mapWidgetToolbar.setMaximumSize(new Dimension(32769, 32769));
        this.mapWidgetToolbar.setMinimumSize(new Dimension(300, 25));
        this.mapWidgetToolbar.setPreferredSize(new Dimension(300, 28));
        this.cmdFullPoly.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/commons/architecture/resource/icon/toolbar/fullPoly.png")));
        this.cmdFullPoly.setToolTipText("Zeige alle Fl\u00e4chen");
        this.cmdFullPoly.setBorder(BorderFactory.createEmptyBorder(1, 3, 1, 3));
        this.cmdFullPoly.setIconTextGap(8);
        this.cmdFullPoly.setMargin(new Insets(10, 14, 10, 14));
        this.cmdFullPoly.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MapWidget.this.cmdFullPolyActionPerformed(evt);
            }
        });
        this.mapWidgetToolbar.add(this.cmdFullPoly);
        this.cmdFullPoly1.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/commons/architecture/resource/icon/toolbar/fullSelPoly.png")));
        this.cmdFullPoly1.setToolTipText("Zoom zur ausgew\u00e4hlten Fl\u00e4che");
        this.cmdFullPoly1.setBorder(BorderFactory.createEmptyBorder(1, 3, 1, 3));
        this.cmdFullPoly1.setIconTextGap(8);
        this.cmdFullPoly1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MapWidget.this.cmdFullPoly1ActionPerformed(evt);
            }
        });
        this.mapWidgetToolbar.add(this.cmdFullPoly1);
        this.cmdBack.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/commons/architecture/resource/icon/toolbar/back2.png")));
        this.cmdBack.setToolTipText("Zur\u00fcck");
        this.cmdBack.setBorder(BorderFactory.createEmptyBorder(1, 3, 1, 3));
        this.cmdBack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MapWidget.this.cmdBackActionPerformed(evt);
            }
        });
        this.mapWidgetToolbar.add(this.cmdBack);
        this.cmdForward.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/commons/architecture/resource/icon/toolbar/fwd.png")));
        this.cmdForward.setToolTipText("Vor");
        this.cmdForward.setBorder(BorderFactory.createEmptyBorder(1, 3, 1, 3));
        this.cmdForward.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MapWidget.this.cmdForwardActionPerformed(evt);
            }
        });
        this.mapWidgetToolbar.add(this.cmdForward);
        this.addressSearchControl.setMaximumSize(new Dimension(290, 28));
        this.addressSearchControl.setMinimumSize(new Dimension(290, 28));
        this.addressSearchControl.setName("");
        this.addressSearchControl.setPreferredSize(new Dimension(290, 28));
        this.mapWidgetToolbar.add((Component)((Object)this.addressSearchControl));
        this.jSeparator4.setOrientation(1);
        this.jSeparator4.setMaximumSize(new Dimension(2, Short.MAX_VALUE));
        this.jSeparator4.setMinimumSize(new Dimension(2, 10));
        this.jSeparator4.setPreferredSize(new Dimension(2, 10));
        this.mapWidgetToolbar.add(this.jSeparator4);
        this.cmdWmsBackground.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/commons/architecture/resource/icon/toolbar/map.png")));
        this.cmdWmsBackground.setToolTipText("Hintergrund an/aus");
        this.cmdWmsBackground.setBorder(BorderFactory.createEmptyBorder(1, 3, 1, 3));
        this.cmdWmsBackground.setSelectedIcon(new ImageIcon(this.getClass().getResource("/de/cismet/commons/architecture/resource/icon/toolbar/map_on.png")));
        this.cmdWmsBackground.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MapWidget.this.cmdWmsBackgroundActionPerformed(evt);
            }
        });
        this.mapWidgetToolbar.add(this.cmdWmsBackground);
        this.cmdForeground.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/commons/architecture/resource/icon/toolbar/foreground.png")));
        this.cmdForeground.setToolTipText("Vordergrund an/aus");
        this.cmdForeground.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.cmdForeground.setFocusable(false);
        this.cmdForeground.setHorizontalTextPosition(0);
        this.cmdForeground.setSelected(true);
        this.cmdForeground.setSelectedIcon(new ImageIcon(this.getClass().getResource("/de/cismet/commons/architecture/resource/icon/toolbar/foreground_on.png")));
        this.cmdForeground.setVerticalTextPosition(3);
        this.cmdForeground.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MapWidget.this.cmdForegroundActionPerformed(evt);
            }
        });
        this.mapWidgetToolbar.add(this.cmdForeground);
        this.cmdSnap.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/commons/architecture/resource/icon/toolbar/snap.png")));
        this.cmdSnap.setToolTipText("Snapping an/aus");
        this.cmdSnap.setBorder(BorderFactory.createEmptyBorder(1, 3, 1, 3));
        this.cmdSnap.setSelected(true);
        this.cmdSnap.setSelectedIcon(new ImageIcon(this.getClass().getResource("/de/cismet/commons/architecture/resource/icon/toolbar/snap_selected.png")));
        this.cmdSnap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MapWidget.this.cmdSnapActionPerformed(evt);
            }
        });
        this.mapWidgetToolbar.add(this.cmdSnap);
        this.jSeparator5.setOrientation(1);
        this.jSeparator5.setMaximumSize(new Dimension(2, Short.MAX_VALUE));
        this.jSeparator5.setMinimumSize(new Dimension(2, 10));
        this.jSeparator5.setPreferredSize(new Dimension(2, 10));
        this.mapWidgetToolbar.add(this.jSeparator5);
        this.cmdZoom.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/commons/architecture/resource/icon/toolbar/zoom.png")));
        this.cmdZoom.setToolTipText("Zoomen");
        this.cmdZoom.setBorder(BorderFactory.createEmptyBorder(1, 3, 1, 3));
        this.cmdZoom.setSelectedIcon(new ImageIcon(this.getClass().getResource("/de/cismet/commons/architecture/resource/icon/toolbar/zoom_selected.png")));
        this.cmdZoom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MapWidget.this.cmdZoomActionPerformed(evt);
            }
        });
        this.mapWidgetToolbar.add(this.cmdZoom);
        this.cmdPan.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/commons/architecture/resource/icon/toolbar/move2.png")));
        this.cmdPan.setToolTipText("Verschieben");
        this.cmdPan.setBorder(BorderFactory.createEmptyBorder(1, 3, 1, 3));
        this.cmdPan.setSelectedIcon(new ImageIcon(this.getClass().getResource("/de/cismet/commons/architecture/resource/icon/toolbar/move2_selected.png")));
        this.cmdPan.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MapWidget.this.cmdPanActionPerformed(evt);
            }
        });
        this.mapWidgetToolbar.add(this.cmdPan);
        this.cmdSelect.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/commons/architecture/resource/icon/toolbar/select.png")));
        this.cmdSelect.setToolTipText("Ausw\u00e4hlen");
        this.cmdSelect.setBorder(BorderFactory.createEmptyBorder(1, 3, 1, 3));
        this.cmdSelect.setSelected(true);
        this.cmdSelect.setSelectedIcon(new ImageIcon(this.getClass().getResource("/de/cismet/commons/architecture/resource/icon/toolbar/select_selected.png")));
        this.cmdSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MapWidget.this.cmdSelectActionPerformed(evt);
            }
        });
        this.mapWidgetToolbar.add(this.cmdSelect);
        this.cmdMovePolygon.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/commons/architecture/resource/icon/toolbar/movePoly.png")));
        this.cmdMovePolygon.setToolTipText("Polygon verschieben");
        this.cmdMovePolygon.setBorder(BorderFactory.createEmptyBorder(1, 3, 1, 3));
        this.cmdMovePolygon.setSelectedIcon(new ImageIcon(this.getClass().getResource("/de/cismet/commons/architecture/resource/icon/toolbar/movePoly_selected.png")));
        this.cmdMovePolygon.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MapWidget.this.cmdMovePolygonActionPerformed(evt);
            }
        });
        this.mapWidgetToolbar.add(this.cmdMovePolygon);
        this.cmdRemovePolygon.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/commons/architecture/resource/icon/toolbar/removePoly.png")));
        this.cmdRemovePolygon.setToolTipText("Polygon entfernen");
        this.cmdRemovePolygon.setBorder(BorderFactory.createEmptyBorder(1, 3, 1, 3));
        this.cmdRemovePolygon.setSelectedIcon(new ImageIcon(this.getClass().getResource("/de/cismet/commons/architecture/resource/icon/toolbar/removePoly_selected.png")));
        this.cmdRemovePolygon.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MapWidget.this.cmdRemovePolygonActionPerformed(evt);
            }
        });
        this.mapWidgetToolbar.add(this.cmdRemovePolygon);
        this.jSeparator6.setOrientation(1);
        this.jSeparator6.setMaximumSize(new Dimension(2, Short.MAX_VALUE));
        this.jSeparator6.setMinimumSize(new Dimension(2, 10));
        this.jSeparator6.setPreferredSize(new Dimension(2, 10));
        this.mapWidgetToolbar.add(this.jSeparator6);
        this.cmdMoveHandle.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/commons/architecture/resource/icon/toolbar/moveHandle.png")));
        this.cmdMoveHandle.setToolTipText("Handle verschieben");
        this.cmdMoveHandle.setBorder(BorderFactory.createEmptyBorder(1, 3, 1, 3));
        this.cmdMoveHandle.setSelectedIcon(new ImageIcon(this.getClass().getResource("/de/cismet/commons/architecture/resource/icon/toolbar/moveHandle_selected.png")));
        this.cmdMoveHandle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MapWidget.this.cmdMoveHandleActionPerformed(evt);
            }
        });
        this.mapWidgetToolbar.add(this.cmdMoveHandle);
        this.cmdAddHandle.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/commons/architecture/resource/icon/toolbar/addHandle.png")));
        this.cmdAddHandle.setToolTipText("Handle hinzuf\u00fcgen");
        this.cmdAddHandle.setBorder(BorderFactory.createEmptyBorder(1, 3, 1, 3));
        this.cmdAddHandle.setSelectedIcon(new ImageIcon(this.getClass().getResource("/de/cismet/commons/architecture/resource/icon/toolbar/addHandle_selected.png")));
        this.cmdAddHandle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MapWidget.this.cmdAddHandleActionPerformed(evt);
            }
        });
        this.mapWidgetToolbar.add(this.cmdAddHandle);
        this.cmdRemoveHandle.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/commons/architecture/resource/icon/toolbar/removeHandle.png")));
        this.cmdRemoveHandle.setToolTipText("Handle entfernen");
        this.cmdRemoveHandle.setBorder(BorderFactory.createEmptyBorder(1, 3, 1, 3));
        this.cmdRemoveHandle.setSelectedIcon(new ImageIcon(this.getClass().getResource("/de/cismet/commons/architecture/resource/icon/toolbar/removeHandle_selected.png")));
        this.cmdRemoveHandle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MapWidget.this.cmdRemoveHandleActionPerformed(evt);
            }
        });
        this.mapWidgetToolbar.add(this.cmdRemoveHandle);
        this.jSeparator7.setOrientation(1);
        this.jSeparator7.setMaximumSize(new Dimension(2, Short.MAX_VALUE));
        this.jSeparator7.setMinimumSize(new Dimension(2, 10));
        this.jSeparator7.setPreferredSize(new Dimension(2, 10));
        this.mapWidgetToolbar.add(this.jSeparator7);
        this.cmdNewLinestring.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/belis/resource/icon/16/newLine.png")));
        this.cmdNewLinestring.setToolTipText("neue Linie");
        this.cmdNewLinestring.setBorderPainted(false);
        this.cmdNewLinestring.setContentAreaFilled(false);
        this.cmdNewLinestring.setFocusPainted(false);
        this.cmdNewLinestring.setFocusable(false);
        this.cmdNewLinestring.setHorizontalTextPosition(0);
        this.cmdNewLinestring.setSelectedIcon(new ImageIcon(this.getClass().getResource("/de/cismet/belis/resource/icon/16/newLine_selected.png")));
        this.cmdNewLinestring.setVerticalTextPosition(3);
        this.cmdNewLinestring.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MapWidget.this.cmdNewLinestringActionPerformed(evt);
            }
        });
        this.mapWidgetToolbar.add(this.cmdNewLinestring);
        this.add((Component)this.mapWidgetToolbar, "North");
        this.jPanel1.setMinimumSize(new Dimension(50, 100));
        this.jPanel1.setPreferredSize(new Dimension(50, 30));
        this.cmdAdd.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/commons/architecture/resource/icon/toolbar/layersman.png")));
        this.cmdAdd.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.cmdAdd.setBorderPainted(false);
        this.cmdAdd.setFocusPainted(false);
        this.cmdAdd.setMinimumSize(new Dimension(25, 25));
        this.cmdAdd.setPreferredSize(new Dimension(25, 25));
        this.cmdAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MapWidget.this.cmdAddActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap(892, Short.MAX_VALUE).add((Component)this.cmdAdd, -2, -1, -2)));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.cmdAdd, -2, -1, -2).addContainerGap(75, Short.MAX_VALUE)));
        this.add((Component)this.jPanel1, "South");
    }

    private void cmdMovePolygonActionPerformed(ActionEvent evt) {
        this.removeHandleGroupSelection();
        this.removeMainGroupSelection();
        this.cmdMovePolygon.setSelected(true);
        this.mappingComponent.setInteractionMode("MOVE_POLYGON");
        this.setLastMapMode(this.getCurrentMapMode());
        this.setCurrentMapMode(MapMode.MOVE_POLYGON);
    }

    private void cmdAddActionPerformed(ActionEvent evt) {
        this.mappingComponent.showInternalLayerWidget(!this.mappingComponent.isInternalLayerWidgetVisible(), 500);
    }

    private void cmdRemoveHandleActionPerformed(ActionEvent evt) {
        this.removeHandleGroupSelection();
        this.cmdRemoveHandle.setSelected(true);
        this.removeMainGroupSelection();
        this.cmdSelect.setSelected(true);
        this.mappingComponent.setInteractionMode("SELECT");
        this.mappingComponent.setHandleInteractionMode("REMOVE_HANDLE");
    }

    private void cmdAddHandleActionPerformed(ActionEvent evt) {
        this.removeHandleGroupSelection();
        this.cmdAddHandle.setSelected(true);
        this.removeMainGroupSelection();
        this.cmdSelect.setSelected(true);
        this.mappingComponent.setInteractionMode("SELECT");
        this.mappingComponent.setHandleInteractionMode("ADD_HANDLE");
    }

    private void cmdMoveHandleActionPerformed(ActionEvent evt) {
        this.removeHandleGroupSelection();
        this.cmdMoveHandle.setSelected(true);
        this.removeMainGroupSelection();
        this.cmdSelect.setSelected(true);
        this.mappingComponent.setInteractionMode("SELECT");
        this.mappingComponent.setHandleInteractionMode("MOVE_HANDLE");
    }

    private void cmdRemovePolygonActionPerformed(ActionEvent evt) {
        this.removeHandleGroupSelection();
        this.removeMainGroupSelection();
        this.cmdRemovePolygon.setSelected(true);
        this.mappingComponent.setInteractionMode("REMOVE_POLYGON");
        this.setLastMapMode(this.getCurrentMapMode());
        this.setCurrentMapMode(MapMode.REMOVE_POLYGON);
    }

    private void cmdSelectActionPerformed(ActionEvent evt) {
        this.removeMainGroupSelection();
        this.cmdSelect.setSelected(true);
        this.setLastMapMode(this.getCurrentMapMode());
        this.mappingComponent.setInteractionMode("SELECT");
        this.cmdMoveHandleActionPerformed(null);
        this.setCurrentMapMode(MapMode.SELECT);
    }

    private void removeHandleGroupSelection() {
        this.cmdRemoveHandle.setSelected(false);
        this.cmdAddHandle.setSelected(false);
        this.cmdMoveHandle.setSelected(false);
    }

    private void cmdPanActionPerformed(ActionEvent evt) {
        this.removeHandleGroupSelection();
        this.removeMainGroupSelection();
        this.cmdPan.setSelected(true);
        this.mappingComponent.setInteractionMode("PAN");
        this.setLastMapMode(this.getCurrentMapMode());
        this.setCurrentMapMode(MapMode.PAN);
    }

    public void setCustomMapMode() {
        this.removeHandleGroupSelection();
        this.removeMainGroupSelection();
        this.setLastMapMode(this.getCurrentMapMode());
        this.setCurrentMapMode(MapMode.CUSTOM);
    }

    public void removeMainGroupSelection() {
        this.cmdZoom.setSelected(false);
        this.cmdPan.setSelected(false);
        this.cmdSelect.setSelected(false);
        this.cmdMovePolygon.setSelected(false);
        this.cmdRemovePolygon.setSelected(false);
        this.cmdNewLinestring.setSelected(false);
        for (JButton curButton : this.customButtons) {
            curButton.setSelected(false);
        }
    }

    public boolean assertMappingComponentMode(String modeToAssert) {
        String currentInteractionMode = this.getBroker().getMappingComponent().getInteractionMode();
        if (currentInteractionMode != null) {
            return currentInteractionMode.equals(modeToAssert);
        }
        return modeToAssert == null;
    }

    public boolean assertMappingComponentIsInAnEditMode() {
        return this.assertMappingComponentMode("MOVE_POLYGON") || this.assertMappingComponentMode("ADD_HANDLE") || this.assertMappingComponentMode("ATTACH_POLYGON_TO_ALPHADATA") || this.assertMappingComponentMode("NEW_POLYGON") || this.assertMappingComponentMode("RAISE_POLYGON") || this.assertMappingComponentMode("REMOVE_POLYGON") || this.assertMappingComponentMode("ROTATE_POLYGON") || this.assertMappingComponentMode("SPLIT_POLYGON");
    }

    @Override
    public synchronized void setWidgetEditable(final boolean isEditable) {
        if (this.isEditable == isEditable) {
            return;
        }
        this.isEditable = isEditable;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"MapPanel --> setComponentEditable");
        }
        if (EventQueue.isDispatchThread()) {
            this.mappingComponent.setReadOnly(!isEditable);
            if (!isEditable && this.assertMappingComponentIsInAnEditMode()) {
                LOG.warn((Object)"Application is not in edit mode, but mapping component is in an edit mode. Setting back to Select.");
                this.removeMainGroupSelection();
                this.cmdSelect.setSelected(true);
                this.mappingComponent.setInteractionMode("SELECT");
                this.cmdMoveHandleActionPerformed(null);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Anzahl Features in FeatureCollection:" + this.mappingComponent.getFeatureCollection().getFeatureCount()));
            }
            this.getBroker().getMappingComponent().setReadOnly(!isEditable);
            this.cmdMovePolygon.setVisible(isEditable);
            this.cmdRemovePolygon.setVisible(isEditable);
            this.jSeparator6.setVisible(isEditable);
            this.cmdMoveHandle.setVisible(isEditable);
            this.cmdAddHandle.setVisible(isEditable);
            this.cmdRemoveHandle.setVisible(isEditable);
            this.jSeparator6.setVisible(isEditable);
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MapWidget.this.mappingComponent.setReadOnly(!isEditable);
                    if (!isEditable && MapWidget.this.assertMappingComponentIsInAnEditMode()) {
                        LOG.warn((Object)"Application is not in edit mode, but mapping component is in an edit mode. Setting back to Select.");
                        MapWidget.this.removeMainGroupSelection();
                        MapWidget.this.cmdSelect.setSelected(true);
                        MapWidget.this.mappingComponent.setInteractionMode("SELECT");
                        MapWidget.this.cmdMoveHandleActionPerformed(null);
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Anzahl Features in FeatureCollection:" + MapWidget.this.mappingComponent.getFeatureCollection().getFeatureCount()));
                    }
                    MapWidget.this.getBroker().getMappingComponent().setReadOnly(!isEditable);
                    MapWidget.this.cmdMovePolygon.setVisible(isEditable);
                    MapWidget.this.cmdRemovePolygon.setVisible(isEditable);
                    MapWidget.this.jSeparator6.setVisible(isEditable);
                    MapWidget.this.cmdMoveHandle.setVisible(isEditable);
                    MapWidget.this.cmdAddHandle.setVisible(isEditable);
                    MapWidget.this.cmdRemoveHandle.setVisible(isEditable);
                    MapWidget.this.jSeparator6.setVisible(isEditable);
                }
            });
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"MapPanel --> setComponentEditable finished");
        }
    }

    @Override
    public synchronized void clearComponent() {
    }

    private void cmdZoomActionPerformed(ActionEvent evt) {
        this.removeHandleGroupSelection();
        this.removeMainGroupSelection();
        this.cmdZoom.setSelected(true);
        this.mappingComponent.setInteractionMode("ZOOM");
        this.setLastMapMode(this.getCurrentMapMode());
        this.setCurrentMapMode(MapMode.ZOOM);
    }

    private void cmdSnapActionPerformed(ActionEvent evt) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Set snapping Enabled: " + this.cmdSnap.isSelected()));
        }
        this.cmdSnap.setSelected(!this.cmdSnap.isSelected());
        this.mappingComponent.setSnappingEnabled(!this.mappingComponent.isReadOnly() && this.cmdSnap.isSelected());
        this.mappingComponent.setVisualizeSnappingEnabled(!this.mappingComponent.isReadOnly() && this.cmdSnap.isSelected());
        this.mappingComponent.setInGlueIdenticalPointsMode(this.cmdSnap.isSelected());
    }

    private void cmdWmsBackgroundActionPerformed(ActionEvent evt) {
        if (this.mappingComponent.isBackgroundEnabled()) {
            this.mappingComponent.setBackgroundEnabled(false);
            this.cmdWmsBackground.setSelected(false);
        } else {
            this.mappingComponent.setBackgroundEnabled(true);
            this.cmdWmsBackground.setSelected(true);
            this.mappingComponent.queryServices();
        }
    }

    private void cmdForwardActionPerformed(ActionEvent evt) {
    }

    private void cmdBackActionPerformed(ActionEvent evt) {
    }

    private void cmdFullPoly1ActionPerformed(ActionEvent evt) {
        this.mappingComponent.zoomToSelectedNode();
    }

    private void cmdFullPolyActionPerformed(ActionEvent evt) {
        this.mappingComponent.zoomToFullFeatureCollectionBounds();
    }

    private void cmdForegroundActionPerformed(ActionEvent evt) {
        if (this.mappingComponent.isFeatureCollectionVisible()) {
            this.mappingComponent.setFeatureCollectionVisibility(false);
            this.cmdForeground.setSelected(false);
        } else {
            this.mappingComponent.setFeatureCollectionVisibility(true);
            this.cmdForeground.setSelected(true);
        }
    }

    private void cmdNewLinestringActionPerformed(ActionEvent evt) {
        this.removeMainGroupSelection();
        this.cmdNewLinestring.setSelected(true);
        this.setLastMapMode(this.getCurrentMapMode());
        this.mappingComponent.setInteractionMode("NEW_POLYGON");
        ((CreateGeometryListener)this.mappingComponent.getInputListener("NEW_POLYGON")).setMode("LINESTRING");
        this.setCurrentMapMode(MapMode.MEASUREMENT);
    }

    public void featureDeleteRequested(PNotification notfication) {
        try {
            Object o = notfication.getObject();
            if (o instanceof DeleteFeatureListener) {
                DeleteFeatureListener dfl = (DeleteFeatureListener)o;
                PFeature pf = dfl.getFeatureRequestedForDeletion();
                pf.getFeature().setGeometry(null);
            }
        }
        catch (Exception ex) {
            LOG.warn((Object)"Fehler beim featuredeleteRequest", (Throwable)ex);
        }
    }

    public void attachFeatureRequested(PNotification notification) {
        Object o = notification.getObject();
        LOG.info((Object)"Try to attach Geometry");
        AttachFeatureListener afl = (AttachFeatureListener)o;
        PFeature pf = afl.getFeatureToAttach();
        if (pf.getFeature() instanceof PureNewFeature) {
            Geometry g = pf.getFeature().getGeometry();
            GeometrySlotInformation slotInfo = this.getBroker().assignGeometry(g);
            if (slotInfo != null) {
                slotInfo.getRefreshable().refresh(null);
                this.mappingComponent.getFeatureCollection().removeFeature(pf.getFeature());
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Geometrie: " + slotInfo.getOpenSlot().getGeometry() + " wird hinzugef\u00fcgt"));
                }
                slotInfo.getOpenSlot().setEditable(true);
                this.mappingComponent.getFeatureCollection().addFeature((Feature)slotInfo.getOpenSlot());
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Geometrie wurde an element: " + slotInfo.getSlotIdentifier() + " attached"));
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Geometrie wurde nicht attached");
            }
        }
    }

    @Override
    public void refresh(Object refreshObject) {
    }

    @Override
    public void masterConfigure(Element parent) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"MapWidget masterConfigure");
        }
        ConfigurationManager configManager = this.getBroker().getConfigManager();
        configManager.addConfigurable((Configurable)this.mappingModel);
        configManager.configure((Configurable)this.mappingModel);
        this.mappingComponent.preparationSetMappingModel((MappingModel)this.mappingModel);
        configManager.addConfigurable((Configurable)this.mappingComponent);
        configManager.configure((Configurable)this.mappingComponent);
        this.mappingComponent.setMappingModel((MappingModel)this.mappingModel);
        this.initComponents();
        this.setWidgetEditable(false);
        this.mappingComponent.getFeatureCollection().addFeatureCollectionListener((FeatureCollectionListener)this);
        this.mappingComponent.setBackgroundEnabled(true);
        PNotificationCenter.defaultCenter().addListener((Object)this, "attachFeatureRequested", "ATTACH_FEATURE_NOTIFICATION", (Object)this.mappingComponent.getInputListener("ATTACH_POLYGON_TO_ALPHADATA"));
        PNotificationCenter.defaultCenter().addListener((Object)this, "featureDeleteRequested", "FEATURE_DELETE_REQUEST_NOTIFICATION", (Object)this.mappingComponent.getInputListener("REMOVE_POLYGON"));
        ((JHistoryButton)this.cmdForward).setDirection(1);
        ((JHistoryButton)this.cmdBack).setDirection(2);
        ((JHistoryButton)this.cmdForward).setHistoryModel((HistoryModel)this.mappingComponent);
        ((JHistoryButton)this.cmdBack).setHistoryModel((HistoryModel)this.mappingComponent);
        this.mappingComponent.setBackground(this.getBackground());
        this.mappingComponent.setBackgroundEnabled(true);
        this.mappingComponent.setInternalLayerWidgetAvailable(true);
        this.add("Center", (Component)this.mappingComponent);
        this.addressSearchControl.masterConfigure(parent);
    }

    @Override
    public void configure(Element parent) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Configure: " + this.getClass()));
        }
        this.cmdSnap.setSelected(true);
        this.mappingComponent.setSnappingEnabled(true);
        this.addressSearchControl.configure(parent);
    }

    public void featuresRemoved(FeatureCollectionEvent fce) {
    }

    public void featuresChanged(FeatureCollectionEvent fce) {
    }

    public void featuresAdded(FeatureCollectionEvent fce) {
    }

    public void featureSelectionChanged(FeatureCollectionEvent fce) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"FeatureSelection Changed");
        }
        Collection features = fce.getEventFeatures();
        this.getBroker().fireChangeEvent(features);
    }

    public void featureReconsiderationRequested(FeatureCollectionEvent fce) {
    }

    public void allFeaturesRemoved(FeatureCollectionEvent fce) {
    }

    public void featureCollectionChanged() {
    }

    @Override
    public void guiObjectChanged(Object changedObject) {
    }

    public JToolBar getMapWidgetToolbar() {
        return this.mapWidgetToolbar;
    }

    public void setMapWidgetToolbar(JToolBar mapWidgetToollbar) {
        this.mapWidgetToolbar = mapWidgetToollbar;
    }

    public static enum MapMode {
        SELECT,
        PAN,
        ZOOM,
        MOVE_POLYGON,
        REMOVE_POLYGON,
        CUSTOM,
        MEASUREMENT;

    }
}

