/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.belis.gui.widget.windowsearchwidget;

import Sirius.navigator.search.dynamic.SearchControlListener;
import Sirius.navigator.search.dynamic.SearchControlPanel;
import Sirius.server.middleware.types.MetaClass;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.belis.broker.BelisBroker;
import de.cismet.belis.gui.widget.windowsearchwidget.BelisCreateSearchGeometryListener;
import de.cismet.belis.gui.widget.windowsearchwidget.BelisWindowSearch;
import de.cismet.belis2.server.search.BelisSearchStatement;
import de.cismet.cids.server.search.MetaObjectNodeServerSearch;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.navigatorplugin.GeoSearchButton;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.apache.log4j.Logger;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class BelisEntityWindowSearch
extends JPanel
implements BelisWindowSearch,
SearchControlListener,
PropertyChangeListener {
    private static final Logger LOG = Logger.getLogger(BelisEntityWindowSearch.class);
    private MetaClass mc = null;
    private ImageIcon icon;
    private MappingComponent mappingComponent;
    private boolean geoSearchEnabled;
    private JComboBox lstStreets;
    private JComboBox lstNumbers;
    private SearchControlPanel pnlSearchCancel;
    private GeoSearchButton btnGeoSearch;
    private Geometry mapsearchgeom;
    private final String name;
    private final Mode mode;
    private String searchListenerName;
    private JCheckBox chkAbzweigdose;
    private JCheckBox chkArbeitsauftrag;
    private JCheckBox chkLeitung;
    private JCheckBox chkMap;
    private JCheckBox chkMauerlasche;
    private JCheckBox chkSchaltstelle;
    private JCheckBox chkStandort;
    private JCheckBox chkStreetAndNumber;
    private JCheckBox chkVeranlassung;
    private JComboBox jComboBox1;
    private JComboBox jComboBox2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JScrollPane jScrollPane1;
    private JPanel panArt;
    private JPanel panCommand;
    private JPanel panPosition;
    private JPanel panSearch;
    private BindingGroup bindingGroup;

    public BelisEntityWindowSearch() {
        this(null, "Allgemeine Suche");
        try {
            this.initWithThisSpecificPanel(null);
        }
        catch (Throwable ex) {
            LOG.error((Object)"error while initialiazing BelisWindowSearch", ex);
            throw new RuntimeException(ex);
        }
    }

    protected BelisEntityWindowSearch(Mode mode, String name) {
        this.name = name;
        this.mode = mode;
        this.mappingComponent = BelisBroker.getInstance().getMappingComponent();
        if (mode != null) {
            switch (mode) {
                case ABZEIGDOSE: {
                    this.searchListenerName = "SEARCH_POLYGON_ABZEIGDOSE";
                    break;
                }
                case LEITUNG: {
                    this.searchListenerName = "SEARCH_POLYGON_LEITUNG";
                    break;
                }
                case MAUERLASCHE: {
                    this.searchListenerName = "SEARCH_POLYGON_MAUERLASCHE";
                    break;
                }
                case SCHALTESTELLE: {
                    this.searchListenerName = "SEARCH_POLYGON_SCHALTESTELLE";
                    break;
                }
                case STANDORT: {
                    this.searchListenerName = "SEARCH_POLYGON_STANDORT";
                    break;
                }
                case LEUCHTE: {
                    this.searchListenerName = "SEARCH_POLYGON_LEUCHTE";
                    break;
                }
                case ARBEITSAUFTRAG: {
                    this.searchListenerName = "SEARCH_POLYGON_ARBEITSAUFTRAG";
                    break;
                }
                case VERANLASSUNG: {
                    this.searchListenerName = "SEARCH_POLYGON_VERANLASSUNG";
                }
            }
            BelisCreateSearchGeometryListener listener = new BelisCreateSearchGeometryListener(this.mappingComponent, this, this.searchListenerName);
            this.mappingComponent.addInputListener(this.searchListenerName, (PBasicInputEventHandler)listener);
            this.mappingComponent.putCursor(this.searchListenerName, new Cursor(1));
        }
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.panArt = new JPanel();
        this.jPanel3 = new JPanel();
        this.chkStandort = new JCheckBox();
        this.chkSchaltstelle = new JCheckBox();
        this.chkMauerlasche = new JCheckBox();
        this.chkAbzweigdose = new JCheckBox();
        this.chkLeitung = new JCheckBox();
        this.chkArbeitsauftrag = new JCheckBox();
        this.chkVeranlassung = new JCheckBox();
        this.jPanel2 = new JPanel();
        this.chkStreetAndNumber = new JCheckBox();
        this.jComboBox1 = new JComboBox();
        this.jComboBox2 = new JComboBox();
        this.jScrollPane1 = new JScrollPane();
        this.jPanel4 = new JPanel();
        this.panSearch = new JPanel();
        this.panPosition = new JPanel();
        this.chkMap = new JCheckBox();
        this.panCommand = new JPanel();
        this.jPanel1 = new JPanel();
        this.panArt.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(BelisEntityWindowSearch.class, (String)"BelisEntityWindowSearch.panArt.border.title")));
        this.panArt.setLayout(new GridBagLayout());
        this.jPanel3.setLayout(new GridLayout(0, 2));
        Mnemonics.setLocalizedText((AbstractButton)this.chkStandort, (String)NbBundle.getMessage(BelisEntityWindowSearch.class, (String)"BelisEntityWindowSearch.chkStandort.text"));
        this.jPanel3.add(this.chkStandort);
        Mnemonics.setLocalizedText((AbstractButton)this.chkSchaltstelle, (String)NbBundle.getMessage(BelisEntityWindowSearch.class, (String)"BelisEntityWindowSearch.chkSchaltstelle.text"));
        this.jPanel3.add(this.chkSchaltstelle);
        Mnemonics.setLocalizedText((AbstractButton)this.chkMauerlasche, (String)NbBundle.getMessage(BelisEntityWindowSearch.class, (String)"BelisEntityWindowSearch.chkMauerlasche.text"));
        this.jPanel3.add(this.chkMauerlasche);
        Mnemonics.setLocalizedText((AbstractButton)this.chkAbzweigdose, (String)NbBundle.getMessage(BelisEntityWindowSearch.class, (String)"BelisEntityWindowSearch.chkAbzweigdose.text"));
        this.jPanel3.add(this.chkAbzweigdose);
        Mnemonics.setLocalizedText((AbstractButton)this.chkLeitung, (String)NbBundle.getMessage(BelisEntityWindowSearch.class, (String)"BelisEntityWindowSearch.chkLeitung.text"));
        this.jPanel3.add(this.chkLeitung);
        Mnemonics.setLocalizedText((AbstractButton)this.chkArbeitsauftrag, (String)NbBundle.getMessage(BelisEntityWindowSearch.class, (String)"BelisEntityWindowSearch.chkArbeitsauftrag.text"));
        this.jPanel3.add(this.chkArbeitsauftrag);
        Mnemonics.setLocalizedText((AbstractButton)this.chkVeranlassung, (String)NbBundle.getMessage(BelisEntityWindowSearch.class, (String)"BelisEntityWindowSearch.chkVeranlassung.text"));
        this.jPanel3.add(this.chkVeranlassung);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panArt.add((Component)this.jPanel3, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.chkStreetAndNumber, (String)NbBundle.getMessage(BelisEntityWindowSearch.class, (String)"BelisEntityWindowSearch.chkStreetAndNumber.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.chkStreetAndNumber, gridBagConstraints);
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.chkStreetAndNumber, (Property)ELProperty.create((String)"${selected}"), (Object)this.jComboBox1, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.jComboBox1, gridBagConstraints);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.chkStreetAndNumber, (Property)ELProperty.create((String)"${selected}"), (Object)this.jComboBox2, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.jComboBox2, gridBagConstraints);
        this.setLayout(new BorderLayout());
        this.jScrollPane1.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jPanel4.setLayout(new BorderLayout());
        this.panSearch.setLayout(new GridBagLayout());
        this.panPosition.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(BelisEntityWindowSearch.class, (String)"BelisEntityWindowSearch.panPosition.border.title")));
        this.panPosition.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.chkMap, (String)NbBundle.getMessage(BelisEntityWindowSearch.class, (String)"BelisEntityWindowSearch.chkMap.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panPosition.add((Component)this.chkMap, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panSearch.add((Component)this.panPosition, gridBagConstraints);
        this.panPosition.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BelisEntityWindowSearch.class, (String)"BelisEntityWindowSearch.panPosition.AccessibleContext.accessibleName"));
        this.panCommand.setLayout(new BoxLayout(this.panCommand, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panSearch.add((Component)this.panCommand, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weighty = 1.0;
        this.panSearch.add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel4.add((Component)this.panSearch, "Center");
        this.jScrollPane1.setViewportView(this.jPanel4);
        this.add((Component)this.jScrollPane1, "Center");
        this.bindingGroup.bind();
    }

    public JComponent getSearchWindowComponent() {
        return this;
    }

    public void searchWithThisGeometry(Geometry geometry) {
        this.mapsearchgeom = geometry;
        this.pnlSearchCancel.startSearch();
        this.mapsearchgeom = null;
    }

    protected BelisSearchStatement createSearchStatement(Geometry searchGeom) {
        BelisSearchStatement belisSearchStatement = new BelisSearchStatement(this.chkStandort.isSelected(), false, this.chkSchaltstelle.isSelected(), this.chkMauerlasche.isSelected(), this.chkLeitung.isSelected(), this.chkAbzweigdose.isSelected(), this.chkVeranlassung.isSelected(), this.chkArbeitsauftrag.isSelected());
        belisSearchStatement.setGeometry(searchGeom);
        return belisSearchStatement;
    }

    public MetaObjectNodeServerSearch getServerSearch() {
        Geometry searchGeom = this.mapsearchgeom == null && this.chkMap.isSelected() ? ((XBoundingBox)CismapBroker.getInstance().getMappingComponent().getCurrentBoundingBox()).getGeometry() : this.mapsearchgeom;
        if (searchGeom != null) {
            Geometry transformed = CrsTransformer.transformToDefaultCrs((Geometry)searchGeom);
            transformed.setSRID(CismapBroker.getInstance().getDefaultCrsAlias());
        }
        return this.createSearchStatement(searchGeom);
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    public MetaObjectNodeServerSearch assembleSearch() {
        return this.getServerSearch();
    }

    public void searchStarted() {
    }

    public void searchDone(int numberOfResults) {
    }

    public void searchCanceled() {
    }

    public boolean suppressEmptyResultMessage() {
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
    }

    protected void initWithThisSpecificPanel(JPanel panel) {
        this.mappingComponent = CismapBroker.getInstance().getMappingComponent();
        this.initComponents();
        if (panel == null) {
            panel = this.panArt;
        }
        this.jPanel4.add((Component)panel, "North");
        this.pnlSearchCancel = new SearchControlPanel((SearchControlListener)this);
        Dimension max = this.pnlSearchCancel.getMaximumSize();
        Dimension min = this.pnlSearchCancel.getMinimumSize();
        Dimension pre = this.pnlSearchCancel.getPreferredSize();
        this.pnlSearchCancel.setMaximumSize(new Dimension(new Double(max.getWidth()).intValue(), new Double(max.getHeight() + 5.0).intValue()));
        this.pnlSearchCancel.setMinimumSize(new Dimension(new Double(min.getWidth()).intValue(), new Double(min.getHeight() + 5.0).intValue()));
        this.pnlSearchCancel.setPreferredSize(new Dimension(new Double(pre.getWidth() + 6.0).intValue(), new Double(pre.getHeight() + 5.0).intValue()));
        this.panCommand.add((Component)this.pnlSearchCancel);
        this.panCommand.add(Box.createHorizontalStrut(5));
        boolean bl = this.geoSearchEnabled = this.mappingComponent != null;
        if (this.geoSearchEnabled) {
            this.btnGeoSearch = new GeoSearchButton(this.searchListenerName, this.mappingComponent, null, "Standorte suchen");
            this.panCommand.add((Component)this.btnGeoSearch);
        }
        if (this.mode != null) {
            switch (this.mode) {
                case ABZEIGDOSE: {
                    this.chkAbzweigdose.setSelected(true);
                    break;
                }
                case LEITUNG: {
                    this.chkLeitung.setSelected(true);
                    break;
                }
                case MAUERLASCHE: {
                    this.chkMauerlasche.setSelected(true);
                    break;
                }
                case SCHALTESTELLE: {
                    this.chkSchaltstelle.setSelected(true);
                    break;
                }
                case STANDORT: {
                    this.chkStandort.setSelected(true);
                    break;
                }
                case LEUCHTE: {
                    this.chkStandort.setSelected(true);
                }
                case ARBEITSAUFTRAG: {
                    this.chkArbeitsauftrag.setSelected(true);
                    break;
                }
                case VERANLASSUNG: {
                    this.chkVeranlassung.setSelected(true);
                }
            }
        } else {
            this.chkAbzweigdose.setSelected(true);
            this.chkLeitung.setSelected(true);
            this.chkMauerlasche.setSelected(true);
            this.chkSchaltstelle.setSelected(true);
            this.chkStandort.setSelected(true);
            this.chkArbeitsauftrag.setSelected(true);
            this.chkVeranlassung.setSelected(true);
        }
    }

    public static enum Mode {
        ABZEIGDOSE,
        LEITUNG,
        MAUERLASCHE,
        SCHALTESTELLE,
        STANDORT,
        LEUCHTE,
        ARBEITSAUFTRAG,
        VERANLASSUNG;

    }
}

