/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.belis.panels;

import de.cismet.belis.broker.BelisBroker;
import de.cismet.belis.broker.CidsBroker;
import de.cismet.belis.panels.LockConverter;
import de.cismet.belis2.server.utils.ActionNotSuccessfulException;
import de.cismet.cids.custom.beans.belis2.SperreCustomBean;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collection;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingWorker;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Converter;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.swingx.JXTable;

public class AlreadyLockedObjectsPanel
extends JPanel {
    public static final String PROP_LOCKS = "locks";
    protected PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private Collection<SperreCustomBean> locks;
    private Box.Filler filler2;
    private Box.Filler filler3;
    private JButton jButton1;
    private JButton jButton2;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JXTable jXTable1;
    private BindingGroup bindingGroup;

    public AlreadyLockedObjectsPanel(Collection<SperreCustomBean> lockedObjects) {
        this.locks = lockedObjects;
        this.initComponents();
        this.setLocks(this.locks);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jXTable1 = new JXTable();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jPanel2 = new JPanel();
        this.filler2 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.jButton2 = new JButton();
        this.filler3 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.jButton1 = new JButton();
        this.setMinimumSize(new Dimension(400, 400));
        this.setPreferredSize(new Dimension(400, 400));
        this.setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${locks}"), (Object)this.jXTable1, (Property)BeanProperty.create((String)"model"));
        binding.setConverter((Converter)new LockConverter());
        this.bindingGroup.addBinding((Binding)binding);
        this.jScrollPane1.setViewportView((Component)this.jXTable1);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        this.jPanel1.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/belis/resource/icon/48/error.png")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 0, 10, 20);
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setText("<html>Es gibt bereis gesperrte Objekte. Bitte veringern Sie Ihre Auswahl oder kontaktieren Sie den entsprechenden Sachbearbeiter.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        this.jPanel1.add((Component)this.jLabel2, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 50, 0, 50);
        this.jPanel2.add((Component)this.filler2, gridBagConstraints);
        this.jButton2.setText("eigene Sperren entfernen");
        this.jButton2.setEnabled(false);
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlreadyLockedObjectsPanel.this.jButton2ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        this.jPanel2.add((Component)this.jButton2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 50, 0, 50);
        this.jPanel2.add((Component)this.filler3, gridBagConstraints);
        this.jButton1.setText("OK");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlreadyLockedObjectsPanel.this.jButton1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.weightx = 1.0;
        this.jPanel2.add((Component)this.jButton1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.jPanel1.add((Component)this.jPanel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.bindingGroup.bind();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        ((JDialog)this.getRootPane().getParent()).dispose();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.jButton2.setEnabled(false);
        final String userString = String.format("%s@BELIS2", BelisBroker.getInstance().getAccountName());
        new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                for (SperreCustomBean lockedObject : AlreadyLockedObjectsPanel.this.getLocks()) {
                    if (!userString.equals(lockedObject.getUserString())) continue;
                    try {
                        CidsBroker.getInstance().unlock(lockedObject);
                    }
                    catch (ActionNotSuccessfulException ex) {
                        BelisBroker.getInstance().showErrorDialog("Fehler beim Entsperren", "<html>Die Sperre konnte nicht entfernt werden.", (Exception)((Object)ex));
                    }
                }
                return null;
            }

            @Override
            protected void done() {
                ((JDialog)AlreadyLockedObjectsPanel.this.getRootPane().getParent()).dispose();
            }
        }.execute();
    }

    public Collection<SperreCustomBean> getLocks() {
        return this.locks;
    }

    public void setLocks(Collection<SperreCustomBean> locks) {
        Collection<SperreCustomBean> old = this.locks;
        this.locks = locks;
        this.jButton2.setEnabled(false);
        String userString = String.format("%s@BELIS2", BelisBroker.getInstance().getAccountName());
        for (SperreCustomBean lockedObject : locks) {
            if (!userString.equals(lockedObject.getUserString())) continue;
            this.jButton2.setEnabled(true);
            break;
        }
        this.propertyChangeSupport.firePropertyChange(PROP_LOCKS, old, locks);
    }
}

