/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.belis.panels;

import de.cismet.belis.broker.BelisBroker;
import de.cismet.tools.gui.StaticSwingTools;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class SearchWaitDialog
extends JDialog {
    private static SearchWaitDialog INSTANCE;
    private static final Logger LOG;
    private boolean canceled = false;
    private int target = 0;
    private int value = 0;
    private JButton jButton1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JProgressBar jProgressBar1;

    private SearchWaitDialog() {
        super(StaticSwingTools.getParentFrame((Component)BelisBroker.getInstance().getParentComponent()), true);
        this.initComponents();
    }

    public void init(int target) {
        this.canceled = false;
        int old = this.target;
        this.target = target;
        if (old != target) {
            this.targetChanged();
        }
        this.setValue(0);
    }

    private void targetChanged() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.jProgressBar1.setIndeterminate(false);
            this.jProgressBar1.setMaximum(this.target);
            this.updateString();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SearchWaitDialog.this.targetChanged();
                }
            });
        }
    }

    private void updateString() {
        String string = this.jProgressBar1.getValue() + " von " + this.jProgressBar1.getMaximum();
        this.jProgressBar1.setString(string);
    }

    public void setValue(int value) {
        int old = this.value;
        this.value = value;
        if (old != value) {
            this.valueChanged();
        }
    }

    private void valueChanged() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.jProgressBar1.setValue(this.value);
            this.updateString();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SearchWaitDialog.this.valueChanged();
                }
            });
        }
    }

    public static SearchWaitDialog getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new SearchWaitDialog();
        }
        return INSTANCE;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jProgressBar1 = new JProgressBar();
        this.jButton1 = new JButton();
        this.setTitle("Bitte warten");
        this.setCursor(new Cursor(0));
        this.setResizable(false);
        this.getContentPane().setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel1.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/belis/resource/icon/64/searching.png")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 2.0;
        gridBagConstraints.insets = new Insets(11, 0, 11, 11);
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setText("Suchergebnisse werden geladen... ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.jPanel1.add((Component)this.jLabel2, gridBagConstraints);
        this.jProgressBar1.setIndeterminate(true);
        this.jProgressBar1.setStringPainted(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.jPanel1.add((Component)this.jProgressBar1, gridBagConstraints);
        this.jButton1.setText("Abbrechen");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchWaitDialog.this.jButton1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 26;
        this.jPanel1.add((Component)this.jButton1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.pack();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.canceled = true;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    static {
        LOG = Logger.getLogger(SearchWaitDialog.class);
    }
}

