/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.beans.belis2;

import de.cismet.belis.broker.CidsBroker;
import de.cismet.belis2.server.search.VeranlassungsschluesselSearch;
import de.cismet.belisEE.util.EntityComparator;
import de.cismet.cids.custom.beans.belis2.AbzweigdoseCustomBean;
import de.cismet.cids.custom.beans.belis2.ArbeitsprotokollaktionCustomBean;
import de.cismet.cids.custom.beans.belis2.ArbeitsprotokollstatusCustomBean;
import de.cismet.cids.custom.beans.belis2.DmsUrlCustomBean;
import de.cismet.cids.custom.beans.belis2.GeometrieCustomBean;
import de.cismet.cids.custom.beans.belis2.LeitungCustomBean;
import de.cismet.cids.custom.beans.belis2.MauerlascheCustomBean;
import de.cismet.cids.custom.beans.belis2.SchaltstelleCustomBean;
import de.cismet.cids.custom.beans.belis2.TdtaLeuchtenCustomBean;
import de.cismet.cids.custom.beans.belis2.TdtaStandortMastCustomBean;
import de.cismet.cids.custom.tostringconverter.belis2.ArbeitsprotokollToStringConverter;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.commons.server.entity.WorkbenchEntity;
import de.cismet.commons.server.entity.WorkbenchFeatureEntity;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Date;
import java.util.Collection;
import org.apache.log4j.Logger;

public class ArbeitsprotokollCustomBean
extends WorkbenchEntity {
    private static final Logger LOG = Logger.getLogger(ArbeitsprotokollCustomBean.class);
    public static final String TABLE = "arbeitsprotokoll";
    public static final String PROP__MATERIAL = "material";
    public static final String PROP__MONTEUR = "monteur";
    public static final String PROP__BEMERKUNG = "bemerkung";
    public static final String PROP__DEFEKT = "defekt";
    public static final String PROP__DATUM = "datum";
    public static final String PROP__FK_STATUS = "fk_status";
    public static final String PROP__FK_MAUERLASCHE = "fk_mauerlasche";
    public static final String PROP__FK_LEUCHTE = "fk_leuchte";
    public static final String PROP__FK_LEITUNG = "fk_leitung";
    public static final String PROP__FK_STANDORT = "fk_standort";
    public static final String PROP__FK_ABZWEIGDOSE = "fk_abzweigdose";
    public static final String PROP__FK_SCHALTSTELLE = "fk_schaltstelle";
    public static final String PROP__FK_GEOMETRIE = "fk_geometrie";
    public static final String PROP__VERANLASSUNGSNUMMER = "veranlassungsnummer";
    public static final String PROP__VERANLASSUNGSSCHLUESSEL = "veranlassungsschluessel";
    public static final String PROP__PROTOKOLLNUMMER = "protokollnummer";
    public static final String PROP__N_AKTIONEN = "n_aktionen";
    private String material;
    private String monteur;
    private String bemerkung;
    private String defekt;
    private Date datum;
    private ArbeitsprotokollstatusCustomBean fk_status;
    private MauerlascheCustomBean fk_mauerlasche;
    private TdtaLeuchtenCustomBean fk_leuchte;
    private LeitungCustomBean fk_leitung;
    private TdtaStandortMastCustomBean fk_standort;
    private AbzweigdoseCustomBean fk_abzweigdose;
    private SchaltstelleCustomBean fk_schaltstelle;
    private GeometrieCustomBean fk_geometrie;
    private String veranlassungsnummer;
    private String veranlassungsschluessel;
    private Integer protokollnummer;
    private Collection<ArbeitsprotokollaktionCustomBean> n_aktionen;
    private boolean veranlassungsschluesselInitialized = false;

    public ArbeitsprotokollCustomBean() {
        this.addPropertyNames(new String[]{PROP__MATERIAL, PROP__MONTEUR, PROP__BEMERKUNG, PROP__DEFEKT, PROP__DATUM, PROP__FK_STATUS, PROP__FK_STANDORT, PROP__FK_MAUERLASCHE, PROP__FK_LEUCHTE, PROP__FK_LEITUNG, PROP__FK_ABZWEIGDOSE, PROP__FK_SCHALTSTELLE, PROP__FK_GEOMETRIE, PROP__VERANLASSUNGSNUMMER, PROP__VERANLASSUNGSSCHLUESSEL, PROP__PROTOKOLLNUMMER, PROP__N_AKTIONEN});
    }

    @Override
    public Collection<DmsUrlCustomBean> getDokumente() {
        return null;
    }

    @Override
    public void setDokumente(Collection<DmsUrlCustomBean> urls) {
    }

    public static ArbeitsprotokollCustomBean createNew() {
        ArbeitsprotokollCustomBean bean = (ArbeitsprotokollCustomBean)ArbeitsprotokollCustomBean.createNew(TABLE);
        bean.init();
        return bean;
    }

    @Override
    public void init() {
        this.refreshVeranlassungsschlussel(this.getVeranlassungsnummer());
        this.addPropertyChangeListener((PropertyChangeListener)((Object)this));
    }

    public MauerlascheCustomBean getFk_mauerlasche() {
        return this.fk_mauerlasche;
    }

    public void setFk_mauerlasche(MauerlascheCustomBean fk_mauerlasche) {
        MauerlascheCustomBean old = this.fk_mauerlasche;
        this.fk_mauerlasche = fk_mauerlasche;
        this.propertyChangeSupport.firePropertyChange(PROP__FK_MAUERLASCHE, old, this.fk_mauerlasche);
    }

    public String getMaterial() {
        return this.material;
    }

    public void setMaterial(String material) {
        String old = this.material;
        this.material = material;
        this.propertyChangeSupport.firePropertyChange(PROP__MATERIAL, old, this.material);
    }

    public TdtaLeuchtenCustomBean getFk_leuchte() {
        return this.fk_leuchte;
    }

    public WorkbenchFeatureEntity getChildEntity() {
        if (this.getFk_leuchte() != null) {
            return this.getFk_leuchte();
        }
        if (this.getFk_geometrie() != null) {
            return this.getFk_geometrie();
        }
        if (this.getFk_standort() != null) {
            return this.getFk_standort();
        }
        if (this.getFk_abzweigdose() != null) {
            return this.getFk_abzweigdose();
        }
        if (this.getFk_leitung() != null) {
            return this.getFk_leitung();
        }
        if (this.getFk_mauerlasche() != null) {
            return this.getFk_mauerlasche();
        }
        if (this.getFk_schaltstelle() != null) {
            return this.getFk_schaltstelle();
        }
        return null;
    }

    public void setFk_leuchte(TdtaLeuchtenCustomBean fk_leuchte) {
        TdtaLeuchtenCustomBean old = this.fk_leuchte;
        this.fk_leuchte = fk_leuchte;
        this.propertyChangeSupport.firePropertyChange(PROP__FK_LEUCHTE, old, this.fk_leuchte);
    }

    public String getMonteur() {
        return this.monteur;
    }

    public void setMonteur(String monteur) {
        String old = this.monteur;
        this.monteur = monteur;
        this.propertyChangeSupport.firePropertyChange(PROP__MONTEUR, old, this.monteur);
    }

    public LeitungCustomBean getFk_leitung() {
        return this.fk_leitung;
    }

    public void setFk_leitung(LeitungCustomBean fk_leitung) {
        LeitungCustomBean old = this.fk_leitung;
        this.fk_leitung = fk_leitung;
        this.propertyChangeSupport.firePropertyChange(PROP__FK_LEITUNG, old, this.fk_leitung);
    }

    public String getBemerkung() {
        return this.bemerkung;
    }

    public void setBemerkung(String bemerkung) {
        String old = this.bemerkung;
        this.bemerkung = bemerkung;
        this.propertyChangeSupport.firePropertyChange(PROP__BEMERKUNG, old, this.bemerkung);
    }

    public String getDefekt() {
        return this.defekt;
    }

    public void setDefekt(String defekt) {
        String old = this.defekt;
        this.defekt = defekt;
        this.propertyChangeSupport.firePropertyChange(PROP__DEFEKT, old, this.defekt);
    }

    public TdtaStandortMastCustomBean getFk_standort() {
        return this.fk_standort;
    }

    public void setFk_standort(TdtaStandortMastCustomBean fk_standort) {
        TdtaStandortMastCustomBean old = this.fk_standort;
        this.fk_standort = fk_standort;
        this.propertyChangeSupport.firePropertyChange(PROP__FK_STANDORT, old, this.fk_standort);
    }

    public AbzweigdoseCustomBean getFk_abzweigdose() {
        return this.fk_abzweigdose;
    }

    public void setFk_abzweigdose(AbzweigdoseCustomBean fk_abzweigdose) {
        AbzweigdoseCustomBean old = this.fk_abzweigdose;
        this.fk_abzweigdose = fk_abzweigdose;
        this.propertyChangeSupport.firePropertyChange(PROP__FK_ABZWEIGDOSE, old, this.fk_abzweigdose);
    }

    public SchaltstelleCustomBean getFk_schaltstelle() {
        return this.fk_schaltstelle;
    }

    public void setFk_schaltstelle(SchaltstelleCustomBean fk_schaltstelle) {
        SchaltstelleCustomBean old = this.fk_schaltstelle;
        this.fk_schaltstelle = fk_schaltstelle;
        this.propertyChangeSupport.firePropertyChange(PROP__FK_SCHALTSTELLE, old, this.fk_schaltstelle);
    }

    public Date getDatum() {
        return this.datum;
    }

    public void setDatum(Date datum) {
        Date old = this.datum;
        this.datum = datum;
        this.propertyChangeSupport.firePropertyChange(PROP__DATUM, old, this.datum);
    }

    public ArbeitsprotokollstatusCustomBean getFk_status() {
        return this.fk_status;
    }

    public void setFk_status(ArbeitsprotokollstatusCustomBean fk_status) {
        ArbeitsprotokollstatusCustomBean old = this.fk_status;
        this.fk_status = fk_status;
        this.propertyChangeSupport.firePropertyChange(PROP__FK_STATUS, (Object)old, (Object)this.fk_status);
    }

    public String getVeranlassungsnummer() {
        return this.veranlassungsnummer;
    }

    public void setVeranlassungsnummer(String veranlassungsnummer) {
        String old = this.veranlassungsnummer;
        this.veranlassungsnummer = veranlassungsnummer;
        this.propertyChangeSupport.firePropertyChange(PROP__VERANLASSUNGSNUMMER, old, this.veranlassungsnummer);
    }

    public String getVeranlassungsschluessel() {
        if (this.veranlassungsschluessel == null && !this.veranlassungsschluesselInitialized) {
            this.refreshVeranlassungsschlussel(this.getVeranlassungsnummer());
        }
        return this.veranlassungsschluessel;
    }

    public void setVeranlassungsschluessel(String veranlassungsschluessel) {
        String old = this.veranlassungsschluessel;
        this.veranlassungsschluessel = veranlassungsschluessel;
        this.propertyChangeSupport.firePropertyChange(PROP__VERANLASSUNGSSCHLUESSEL, old, this.veranlassungsschluessel);
    }

    public GeometrieCustomBean getFk_geometrie() {
        return this.fk_geometrie;
    }

    public void setFk_geometrie(GeometrieCustomBean fk_geometrie) {
        GeometrieCustomBean old = this.fk_geometrie;
        this.fk_geometrie = fk_geometrie;
        this.propertyChangeSupport.firePropertyChange(PROP__FK_GEOMETRIE, old, this.fk_geometrie);
    }

    public Collection<ArbeitsprotokollaktionCustomBean> getN_aktionen() {
        return this.n_aktionen;
    }

    public void setN_aktionen(Collection<ArbeitsprotokollaktionCustomBean> n_aktionen) {
        Collection<ArbeitsprotokollaktionCustomBean> old = this.n_aktionen;
        this.n_aktionen = n_aktionen;
        this.propertyChangeSupport.firePropertyChange(PROP__N_AKTIONEN, old, this.n_aktionen);
    }

    public Integer getProtokollnummer() {
        return this.protokollnummer;
    }

    public void setProtokollnummer(Integer protokollnummer) {
        Integer old = this.protokollnummer;
        this.protokollnummer = protokollnummer;
        this.propertyChangeSupport.firePropertyChange(PROP__PROTOKOLLNUMMER, old, this.protokollnummer);
    }

    public ChildType getChildType() {
        if (this.getFk_abzweigdose() != null) {
            return ChildType.ABZWEIGDOSE;
        }
        if (this.getFk_leitung() != null) {
            return ChildType.LEITUNG;
        }
        if (this.getFk_leuchte() != null) {
            return ChildType.LEUCHTE;
        }
        if (this.getFk_mauerlasche() != null) {
            return ChildType.MAUERLASCHE;
        }
        if (this.getFk_schaltstelle() != null) {
            return ChildType.SCHALTSTELLE;
        }
        if (this.getFk_geometrie() != null) {
            return ChildType.GEOMETRIE;
        }
        if (this.getFk_standort() != null) {
            return ChildType.STANDORT;
        }
        return null;
    }

    @Override
    public int compareTo(WorkbenchEntity o) {
        if (o instanceof ArbeitsprotokollCustomBean) {
            ArbeitsprotokollCustomBean p = (ArbeitsprotokollCustomBean)o;
            return 1;
        }
        return EntityComparator.compareTypes(this, o);
    }

    private void refreshVeranlassungsschlussel(String veranlassungsnummer) {
        String schluessel = null;
        try {
            Object item;
            Collection col = CidsBroker.getInstance().executeServerSearch((CidsServerSearch)new VeranlassungsschluesselSearch(veranlassungsnummer));
            if (col != null && !col.isEmpty() && (item = col.iterator().next()) != null && item instanceof String) {
                schluessel = (String)item;
            }
        }
        catch (Exception ex) {
            LOG.warn((Object)"Problem during the refresh of the Veranlassungsschluessel (no problem if in legacy core", (Throwable)ex);
        }
        this.setVeranlassungsschluessel(schluessel);
        this.veranlassungsschluesselInitialized = true;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (!evt.getPropertyName().equals(PROP__VERANLASSUNGSSCHLUESSEL) && this.metaObject != null) {
            super.propertyChange(evt);
        }
        if (evt.getSource().equals(this) && evt.getPropertyName().equals(PROP__VERANLASSUNGSNUMMER) && (evt.getNewValue() == null || evt.getNewValue() instanceof String)) {
            this.refreshVeranlassungsschlussel((String)evt.getNewValue());
        }
    }

    @Override
    public String getKeyString() {
        return new ArbeitsprotokollToStringConverter().getKeyString((CidsBean)this);
    }

    @Override
    public String getHumanReadablePosition() {
        return new ArbeitsprotokollToStringConverter().getHumanReadablePosition((CidsBean)this);
    }

    public static enum ChildType {
        MAUERLASCHE,
        LEUCHTE,
        LEITUNG,
        STANDORT,
        ABZWEIGDOSE,
        SCHALTSTELLE,
        GEOMETRIE;

    }
}

