/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.commons.server.entity;

import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.custom.beans.belis2.GeomCustomBean;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.features.StyledFeature;
import de.cismet.cismap.commons.gui.piccolo.FeatureAnnotationSymbol;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.commons.server.entity.WorkbenchEntity;
import de.cismet.commons.server.interfaces.GeometrySlot;
import java.awt.Color;
import java.awt.Paint;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public abstract class WorkbenchFeatureEntity
extends WorkbenchEntity
implements GeometrySlot,
StyledFeature {
    private static final Logger LOG = Logger.getLogger(WorkbenchFeatureEntity.class);
    protected transient FeatureAnnotationSymbol mapIcon = null;
    private boolean isEditable = false;
    private boolean isSelectable = true;

    public boolean isSelectable() {
        return this.isSelectable;
    }

    public void setSelectable(boolean isSelectable) {
        this.isSelectable = isSelectable;
    }

    public boolean canBeSelected() {
        return this.isSelectable;
    }

    public Geometry getGeometry() {
        if (this.getGeometrie() != null && this.getGeometrie().getGeomField() != null) {
            return this.getGeometrie().getGeomField();
        }
        return null;
    }

    public void hide(boolean hiding) {
    }

    public boolean isEditable() {
        if (!this.isEditAllowed()) {
            return false;
        }
        return this.isEditable;
    }

    public boolean isHidden() {
        return false;
    }

    public void setEditable(boolean editable) {
        this.isEditable = editable;
    }

    public static void transformToDefaultCrsNeeded(Geometry geom) {
        if (geom == null) {
            return;
        }
        int srid = geom.getSRID();
        int defaultSrid = CrsTransformer.extractSridFromCrs((String)CismapBroker.getInstance().getDefaultCrs());
        if (srid == CismapBroker.getInstance().getDefaultCrsAlias()) {
            srid = defaultSrid;
        }
        if (srid != defaultSrid) {
            int ans = JOptionPane.showConfirmDialog(null, "Die angegebene Geometrie befindet sich nicht im Standard-CRS. Soll die Geometrie konvertiert werden?", "Geometrie konvertieren?", 0, 3);
            if (ans == 0) {
                geom = CrsTransformer.transformToDefaultCrs((Geometry)geom);
                geom.setSRID(CismapBroker.getInstance().getDefaultCrsAlias());
            }
        } else {
            geom.setSRID(CismapBroker.getInstance().getDefaultCrsAlias());
        }
    }

    public void setGeometry(Geometry geom) {
        WorkbenchFeatureEntity.transformToDefaultCrsNeeded(geom);
        if (this.getGeometrie() == null) {
            this.setGeometrie(GeomCustomBean.createNew());
        }
        try {
            this.getGeometrie().setGeomField(geom);
        }
        catch (Exception ex) {
            LOG.warn((Object)"Fehler beim setzend er Geometrie", (Throwable)ex);
        }
    }

    public Paint getFillingPaint() {
        return Color.GRAY;
    }

    public Paint getLinePaint() {
        return Color.BLACK;
    }

    public int getLineWidth() {
        return 1;
    }

    public FeatureAnnotationSymbol getPointAnnotationSymbol() {
        return null;
    }

    public float getTransparency() {
        return 1.0f;
    }

    public boolean isHighlightingEnabled() {
        return true;
    }

    public void setFillingPaint(Paint fillingStyle) {
    }

    public void setHighlightingEnabled(boolean enabled) {
    }

    public void setLinePaint(Paint linePaint) {
    }

    public void setLineWidth(int width) {
    }

    public void setPointAnnotationSymbol(FeatureAnnotationSymbol featureAnnotationSymbol) {
    }

    public void setTransparency(float transparrency) {
    }

    public void setCanBeSelected(boolean selectable) {
    }
}

