/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.commons2.architecture.layout;

import de.cismet.belis.broker.BelisBroker;
import de.cismet.belis.gui.widget.BelisWidget;
import de.cismet.belis.util.JnlpSystemPropertyHelper;
import de.cismet.commons2.architecture.layout.LayoutManagerListener;
import de.cismet.tools.CurrentStackTrace;
import java.awt.Color;
import java.awt.Component;
import java.awt.SystemColor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import net.infonode.docking.DockingWindow;
import net.infonode.docking.RootWindow;
import net.infonode.docking.TabWindow;
import net.infonode.docking.View;
import net.infonode.docking.mouse.DockingWindowActionMouseButtonListener;
import net.infonode.docking.properties.RootWindowProperties;
import net.infonode.docking.theme.ShapedGradientDockingTheme;
import net.infonode.docking.util.AbstractViewMap;
import net.infonode.docking.util.DockingUtil;
import net.infonode.docking.util.PropertiesUtil;
import net.infonode.docking.util.StringViewMap;
import net.infonode.gui.componentpainter.AlphaGradientComponentPainter;
import net.infonode.gui.componentpainter.ComponentPainter;
import net.infonode.util.Direction;
import org.apache.log4j.Logger;

public class LayoutManager {
    private static final Logger LOG = Logger.getLogger(LayoutManager.class);
    private static final String FILE_SEPARATOR = JnlpSystemPropertyHelper.getProperty("file.separator");
    private static final String LAYOUT_FILENAME = "belis.layout";
    private static final String DEFAULT_LAYOUT = "/de/cismet/commons/architecture/configuration/defaultBelis.layout";
    private StringViewMap viewMap = new StringViewMap();
    private final String layoutFolder;
    private String layoutFileName;
    private InputStream defaultLayout;
    private final BelisBroker broker;
    private RootWindow rootWindow;
    private boolean isInit = true;
    private ArrayList<View> views = new ArrayList();
    private List<LayoutManagerListener> layoutManagerListener = new ArrayList<LayoutManagerListener>();

    public LayoutManager(String layoutFolder, BelisBroker broker) {
        this.broker = broker;
        this.layoutFolder = layoutFolder;
        try {
            this.layoutFileName = layoutFolder + FILE_SEPARATOR + LAYOUT_FILENAME;
            LOG.info((Object)("LayoutFileName: " + this.layoutFileName));
        }
        catch (Exception ex) {
            LOG.warn((Object)"Error while loading LayoutFileName", (Throwable)ex);
        }
        try {
            String defaultLayoutFileFromClasspath = DEFAULT_LAYOUT;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"defaultLayoutFileFromClasspath: /de/cismet/commons/architecture/configuration/defaultBelis.layout");
            }
            this.defaultLayout = this.getClass().getResourceAsStream(DEFAULT_LAYOUT);
            LOG.info((Object)("defaultLayoutFile: " + this.defaultLayout));
            LOG.info((Object)("defaultLayoutFile: " + this.defaultLayout.available()));
            int current = 0;
            while ((current = this.defaultLayout.read()) != -1) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Layout raw: " + current));
            }
        }
        catch (Exception ex) {
            LOG.warn((Object)"Error while loading defaultLayoutFile", (Throwable)ex);
            this.defaultLayout = null;
        }
    }

    public void configureInfoNodeDocking() {
        try {
            this.createViewsForWidgets();
            this.rootWindow = DockingUtil.createRootWindow((AbstractViewMap)this.viewMap, (boolean)true);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"RootWindow created");
            }
            this.rootWindow.addTabMouseButtonListener(DockingWindowActionMouseButtonListener.MIDDLE_BUTTON_CLOSE_LISTENER);
            ShapedGradientDockingTheme theme = new ShapedGradientDockingTheme();
            this.rootWindow.getRootWindowProperties().addSuperObject(theme.getRootWindowProperties());
            RootWindowProperties titleBarStyleProperties = PropertiesUtil.createTitleBarStyleRootWindowProperties();
            this.rootWindow.getRootWindowProperties().addSuperObject(titleBarStyleProperties);
            this.rootWindow.getRootWindowProperties().getDockingWindowProperties().setUndockEnabled(true);
            AlphaGradientComponentPainter x = new AlphaGradientComponentPainter((Color)SystemColor.inactiveCaptionText, (Color)SystemColor.activeCaptionText, (Color)SystemColor.activeCaptionText, (Color)SystemColor.inactiveCaptionText);
            this.rootWindow.getRootWindowProperties().getDragRectangleShapedPanelProperties().setComponentPainter((ComponentPainter)x);
            this.broker.setTitleBarComponentpainter(BelisBroker.DEFAULT_MODE_COLOR);
            this.rootWindow.getRootWindowProperties().getTabWindowProperties().getTabbedPanelProperties().setPaintTabAreaShadow(true);
            this.rootWindow.getRootWindowProperties().getTabWindowProperties().getTabbedPanelProperties().setShadowSize(10);
            this.rootWindow.getRootWindowProperties().getTabWindowProperties().getTabbedPanelProperties().setShadowStrength(0.8f);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("broker: " + this.broker));
                LOG.debug((Object)("parent: " + this.broker.getParentComponent()));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("rootWindow: " + this.rootWindow));
            }
            this.broker.getParentComponent().add((Component)this.rootWindow, "Center");
            this.fireInfoNodeDockingConfigured();
        }
        catch (Exception ex) {
            LOG.error((Object)"Error while configuring InfoNodeDocking: ", (Throwable)ex);
        }
    }

    private void fireInfoNodeDockingConfigured() {
        for (LayoutManagerListener l : this.layoutManagerListener) {
            l.infoNodeDockingConfigured();
        }
    }

    public void addLayoutManagerListener(LayoutManagerListener listener) {
        this.layoutManagerListener.add(listener);
    }

    public void removeLayoutManagerListener(LayoutManagerListener listener) {
        this.layoutManagerListener.remove(listener);
    }

    private void createViewsForWidgets() {
        Collection<BelisWidget> widgets;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Create views for widget");
        }
        if ((widgets = this.broker.getWidgets()) != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Widgets count: " + widgets.size()));
            }
            for (BelisWidget curWidget : widgets) {
                try {
                    View tmpView = new View(curWidget.getWidgetName(), curWidget.getWidgetIcon(), (Component)curWidget);
                    tmpView.getCustomTitleBarComponents().addAll(curWidget.getCustomButtons());
                    this.viewMap.addView(curWidget.getWidgetName(), tmpView);
                    this.views.add(tmpView);
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)("Widget: " + curWidget.getWidgetName() + " added to viewMap"));
                }
                catch (Exception ex) {
                    LOG.error((Object)("Error while adding Widget: " + curWidget.getWidgetName()), (Throwable)ex);
                }
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"There are no widgets available");
        }
    }

    public void doLayoutInfoNodeDefaultFile() {
        if (this.defaultLayout != null) {
            this.loadLayout(this.defaultLayout, true);
        } else {
            this.doLayoutInfoNodeDefault();
        }
    }

    public void doLayoutInfoNodeDefault() {
        this.rootWindow.setWindow((DockingWindow)new TabWindow((DockingWindow[])this.views.toArray(this.views.toArray(new View[this.views.size()]))));
    }

    public void saveLayout() {
        JFileChooser fc = new JFileChooser(this.layoutFolder);
        fc.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getName().toLowerCase().endsWith(".layout");
            }

            @Override
            public String getDescription() {
                return "Layout";
            }
        });
        fc.setMultiSelectionEnabled(false);
        int state = fc.showSaveDialog(this.broker.getParentComponent());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("state:" + state));
        }
        if (state == 0) {
            File file = fc.getSelectedFile();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("file:" + file));
            }
            String name = file.getAbsolutePath();
            if ((name = name.toLowerCase()).endsWith(".layout")) {
                this.saveLayout(name);
            } else {
                this.saveLayout(name + ".layout");
            }
        }
    }

    public void saveUserLayout() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Speichere StandaloneLayout nach: " + this.layoutFileName));
        }
        this.saveLayout(this.layoutFileName);
    }

    public void saveLayout(String file) {
        this.broker.setTitleBarComponentpainter(BelisBroker.DEFAULT_MODE_COLOR);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Saving Layout.. to " + file));
        }
        File layoutFile = new File(file);
        try {
            if (!layoutFile.exists()) {
                File belisDir;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Saving Layout.. File does not exit");
                }
                if (!(belisDir = new File(this.layoutFolder)).exists()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Belis Directory angelegt");
                    }
                    belisDir.mkdir();
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Saving Layout.. File does not exit");
                }
                layoutFile.createNewFile();
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Saving Layout.. File does exit");
            }
            FileOutputStream layoutOutput = new FileOutputStream(layoutFile);
            ObjectOutputStream out = new ObjectOutputStream(layoutOutput);
            this.rootWindow.write(out);
            out.flush();
            out.close();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Saving Layout.. to " + file + " successfull"));
            }
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this.broker.getParentComponent(), "W\u00e4hrend dem Speichern des Layouts ist ein Fehler aufgetreten.", "Fehler", 1);
            LOG.error((Object)"A failure occured during writing the layout file", (Throwable)ex);
        }
    }

    public void loadUserLayout() {
        this.loadLayout(this.layoutFileName);
    }

    public void loadLayout() {
        JFileChooser fc = new JFileChooser(this.layoutFolder);
        fc.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getName().toLowerCase().endsWith(".layout");
            }

            @Override
            public String getDescription() {
                return "Layout";
            }
        });
        fc.setMultiSelectionEnabled(false);
        int state = fc.showOpenDialog(this.broker.getParentComponent());
        if (state == 0) {
            File file = fc.getSelectedFile();
            String name = file.getAbsolutePath();
            if ((name = name.toLowerCase()).endsWith(".layout")) {
                this.loadLayout(name);
            } else {
                JOptionPane.showMessageDialog(this.broker.getParentComponent(), "Das gew\u00e4hlte Dateiformat wird nicht unterst\u00fctzt.\\nBitte w\u00e4hlen Sie eine Datei mit der Endung .layout", "Fehler", 1);
            }
        }
    }

    public void loadLayout(ObjectInputStream in, boolean defaultFile) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"load layout: ", (Throwable)new CurrentStackTrace());
        }
        try {
            this.rootWindow.read(in);
            in.close();
            this.rootWindow.getWindowBar(Direction.LEFT).setEnabled(true);
            this.rootWindow.getWindowBar(Direction.RIGHT).setEnabled(true);
            if (this.isInit) {
                int count = this.viewMap.getViewCount();
                for (int i = 0; i < count; ++i) {
                    View current = this.viewMap.getViewAtIndex(i);
                    if (!current.isUndocked()) continue;
                    current.dock();
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Loading Layout successfull");
            }
        }
        catch (IOException ex) {
            LOG.warn((Object)"loading of default layout failed. Loading programmed layout", (Throwable)ex);
            if (defaultFile) {
                if (this.isInit) {
                    LOG.warn((Object)"Loading programmed layout");
                    this.doLayoutInfoNodeDefault();
                } else {
                    JOptionPane.showMessageDialog(this.broker.getParentComponent(), "W\u00e4hrend dem Laden des Layouts ist ein Fehler aufgetreten.", "Fehler", 1);
                }
            }
            LOG.error((Object)"Layout File IO Exception --> loading default Layout", (Throwable)ex);
            if (this.isInit) {
                if (defaultFile) {
                    this.doLayoutInfoNodeDefault();
                } else {
                    this.doLayoutInfoNodeDefaultFile();
                }
            }
            JOptionPane.showMessageDialog(this.broker.getParentComponent(), "W\u00e4hrend dem Laden des Layouts ist ein Fehler aufgetreten.", "Fehler", 1);
        }
    }

    public void loadLayout(InputStream inputStream, boolean defaultFile) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("load layout from classpath: " + inputStream));
        }
        try {
            ObjectInputStream in = new ObjectInputStream(inputStream);
            this.loadLayout(in, defaultFile);
        }
        catch (IOException ex) {
            LOG.warn((Object)"load of default layout file failed", (Throwable)ex);
            if (this.isInit) {
                LOG.warn((Object)"loading programmed layout", (Throwable)ex);
                this.doLayoutInfoNodeDefault();
            }
            JOptionPane.showMessageDialog(this.broker.getParentComponent(), "W\u00e4hrend dem Laden des Layouts ist ein Fehler aufgetreten.", "Fehler", 1);
            this.doLayoutInfoNodeDefault();
        }
    }

    public void loadLayout(File file, final boolean defaultFile) {
        block11: {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("load layout from file: " + file));
            }
            if (file.exists()) {
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Layout File exists");
                    }
                    FileInputStream layoutInput = new FileInputStream(file);
                    ObjectInputStream in = new ObjectInputStream(layoutInput);
                    this.loadLayout(in, defaultFile);
                }
                catch (IOException ex) {
                    LOG.error((Object)"Layout File IO Exception --> loading default Layout", (Throwable)ex);
                    if (this.isInit) {
                        if (defaultFile) {
                            this.doLayoutInfoNodeDefault();
                        } else {
                            this.doLayoutInfoNodeDefaultFile();
                        }
                        break block11;
                    }
                    JOptionPane.showMessageDialog(this.broker.getParentComponent(), "W\u00e4hrend dem Laden des Layouts ist ein Fehler aufgetreten.", "Fehler", 1);
                }
            } else if (this.isInit) {
                LOG.warn((Object)"Datei exitstiert nicht --> default layout (init)");
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (defaultFile) {
                            LayoutManager.this.doLayoutInfoNodeDefault();
                        } else {
                            LayoutManager.this.doLayoutInfoNodeDefaultFile();
                        }
                    }
                });
            } else {
                LOG.warn((Object)"Datei exitstiert nicht)");
                JOptionPane.showMessageDialog(this.broker.getParentComponent(), "Das angegebene Layout konnte nicht gefunden werden.", "Fehler", 1);
            }
        }
    }

    public void loadLayout(String file) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Load Layout.. from " + file));
        }
        File layoutFile = new File(file);
        this.loadLayout(layoutFile, false);
    }

    public void addView(View view) {
        this.viewMap.addView(view);
    }

    public RootWindow getRootWindow() {
        if (this.rootWindow == null) {
            LOG.warn((Object)"rootWindow == null");
        }
        return this.rootWindow;
    }

    public StringViewMap getViewMap() {
        return this.viewMap;
    }

    public void setRootWindow(RootWindow rootWindow) {
        this.rootWindow = rootWindow;
    }
}

