/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.belis2.server.action;

import Sirius.server.middleware.impls.domainserver.DomainServerImpl;
import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.middleware.interfaces.domainserver.MetaServiceStore;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.newuser.User;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.cids.server.actions.UserAwareServerAction;
import de.cismet.connectioncontext.AbstractConnectionContext;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.tools.URLSplitter;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.MultiValueMap;
import org.apache.log4j.Logger;

public abstract class AbstractBelisServerActionV3
implements UserAwareServerAction,
MetaServiceStore {
    private static final Logger LOG = Logger.getLogger(AbstractBelisServerActionV3.class);
    private static final ConnectionContext CC = ConnectionContext.create((AbstractConnectionContext.Category)AbstractConnectionContext.Category.ACTION, (String)"ProtokollServerActionV3");
    public static final String DOMAIN = "BELIS2";
    protected final MultiValueMap paramsHashMap = new MultiValueMap();
    private Object body;
    private User user;
    private MetaService metaService;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void setMetaService(MetaService metaService) {
        this.metaService = metaService;
    }

    public MetaService getMetaService() {
        return this.metaService;
    }

    protected Object getBody() {
        return this.body;
    }

    protected CidsBean getCidsBeanFromParam(String key, String tableName) throws Exception {
        MetaClass metaClass = CidsBean.getMetaClassFromTableName((String)DOMAIN, (String)tableName.toLowerCase(), (ConnectionContext)CC);
        Integer objectId = (Integer)this.getParam(key, Integer.class);
        if (objectId == null) {
            return null;
        }
        return DomainServerImpl.getServerInstance().getMetaObject(this.getUser(), objectId.intValue(), metaClass.getId(), CC).getBean();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Collection getListParam(String key, Class clazz) {
        ArrayList<java.util.Date> objects = new ArrayList<java.util.Date>();
        if (!this.paramsHashMap.containsKey((Object)key.toLowerCase())) return objects;
        for (Object val : (List)this.paramsHashMap.get((Object)key.toLowerCase())) {
            Object object = null;
            if (val instanceof String) {
                long timestamp;
                String value = (String)val;
                if (java.util.Date.class.equals((Object)clazz)) {
                    timestamp = Long.parseLong(value);
                    object = new java.util.Date(timestamp);
                } else if (Date.class.equals((Object)clazz)) {
                    timestamp = Long.parseLong(value);
                    object = new Date(timestamp);
                } else if (Timestamp.class.equals((Object)clazz)) {
                    timestamp = Long.parseLong(value);
                    object = new Timestamp(timestamp);
                } else if (Integer.class.equals((Object)clazz)) {
                    object = Integer.parseInt(value);
                } else if (Float.class.equals((Object)clazz)) {
                    object = Float.valueOf(Float.parseFloat(value));
                } else if (Long.class.equals((Object)clazz)) {
                    object = Long.parseLong(value);
                } else if (Double.class.equals((Object)clazz)) {
                    object = Double.parseDouble(value);
                } else if (Boolean.class.equals((Object)clazz)) {
                    if ("ja".equals(value.toLowerCase())) {
                        object = true;
                    } else {
                        if (!"nein".equals(value.toLowerCase())) throw new UnsupportedOperationException("wrong boolean value");
                        object = false;
                    }
                } else {
                    if (!String.class.equals((Object)clazz)) throw new UnsupportedOperationException("this class is not supported");
                    object = value;
                }
            } else if (val == null) {
                object = null;
            } else if (ArrayList.class.equals((Object)clazz)) {
                object = val;
            }
            objects.add((java.util.Date)object);
        }
        return objects;
    }

    protected Object getParam(String key, Class clazz) {
        Collection values = this.getListParam(key, clazz);
        if (values == null || values.isEmpty()) {
            return null;
        }
        return values.iterator().next();
    }

    protected void addParam(String key, Object value) {
        this.paramsHashMap.put((Object)key, value);
    }

    public Object execute(Object body, ServerActionParameter ... params) {
        this.body = body;
        this.paramsHashMap.clear();
        for (ServerActionParameter param : params) {
            String key = param.getKey().toLowerCase();
            Object value = param.getValue();
            if (value instanceof String || value == null) {
                String singleValue = (String)value;
                this.paramsHashMap.put((Object)key, (Object)singleValue);
                continue;
            }
            if (value instanceof Object[] || value instanceof Collection) {
                Collection<Object> collection = value instanceof Object[] ? Arrays.asList((Object[])value) : (value instanceof Collection ? (Collection)value : null);
                if (collection == null) continue;
                for (Object singleValue : collection) {
                    this.paramsHashMap.put((Object)key, singleValue);
                }
                continue;
            }
            if (value instanceof Map) {
                this.paramsHashMap.put((Object)key, value);
                continue;
            }
            String message = "parameter value was neither a string or collection/array of strings";
            LOG.error((Object)"parameter value was neither a string or collection/array of strings");
            return new Exception("parameter value was neither a string or collection/array of strings");
        }
        try {
            return this.processExecution();
        }
        catch (Exception ex) {
            String message = "error while processExecution()";
            LOG.error((Object)"error while processExecution()", (Throwable)ex);
            return ex;
        }
    }

    protected abstract Object processExecution() throws Exception;

    protected static String valueToString(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof java.util.Date) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy");
            return dateFormat.format(value);
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? "Ja" : "Nein";
        }
        return value.toString();
    }

    public static String implodeArray(String[] inputArray, String glueString) {
        String output = "";
        if (inputArray.length > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append(inputArray[0]);
            for (int i = 1; i < inputArray.length; ++i) {
                sb.append(glueString);
                sb.append(inputArray[i]);
            }
            output = sb.toString();
        }
        return output;
    }

    public static CidsBean createDmsURLFromLink(String link, String description) throws Exception {
        if (link == null || description == null) {
            throw new NullPointerException();
        }
        CidsBean dmsUrlBean = CidsBean.createNewCidsBeanFromTableName((String)DOMAIN, (String)"dms_url", (ConnectionContext)CC);
        CidsBean urlBean = CidsBean.createNewCidsBeanFromTableName((String)DOMAIN, (String)"url", (ConnectionContext)CC);
        CidsBean urlBaseBean = CidsBean.createNewCidsBeanFromTableName((String)DOMAIN, (String)"url_base", (ConnectionContext)CC);
        URLSplitter splitter = new URLSplitter(link);
        dmsUrlBean.setProperty("description", (Object)description);
        urlBean.setProperty("url_base_id", (Object)urlBaseBean);
        dmsUrlBean.setProperty("url_id", (Object)urlBean);
        urlBaseBean.setProperty("path", (Object)splitter.getPath());
        urlBaseBean.setProperty("prot_prefix", (Object)splitter.getProt_prefix());
        urlBaseBean.setProperty("server", (Object)splitter.getServer());
        urlBean.setProperty("object_name", (Object)splitter.getObject_name());
        return dmsUrlBean;
    }
}

