/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.belis2.server.action.ProtokollAktion;

import Sirius.server.middleware.impls.domainserver.DomainServerImpl;
import Sirius.server.middleware.types.MetaObject;
import Sirius.server.middleware.types.MetaObjectNode;
import de.cismet.belis2.server.action.AbstractBelisServerAction;
import de.cismet.belis2.server.action.ProtokollAktion.ProtokollStatusServerAction;
import de.cismet.belis2.server.utils.BelisServerUtils;
import de.cismet.cids.dynamics.CidsBean;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.log4j.Logger;

public abstract class AbstractProtokollServerAction
extends AbstractBelisServerAction {
    private static final Logger LOG = Logger.getLogger(AbstractProtokollServerAction.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object processExecution() {
        Integer protokollId = (Integer)this.getParam(ParameterType.PROTOKOLL_ID.toString(), Integer.class);
        if (protokollId != null) {
            try {
                Collection<MetaObjectNode> locks;
                int classId = CidsBean.getMetaClassFromTableName((String)"BELIS2", (String)"arbeitsprotokoll").getId();
                String entityKey = protokollId + "@" + classId;
                ArrayList<String> toLock = new ArrayList<String>(Arrays.asList(entityKey));
                MetaObject mo = DomainServerImpl.getServerInstance().getMetaObject(this.getUser(), protokollId.intValue(), classId);
                CidsBean protokoll = mo.getBean();
                ArrayList<CidsBean> children = new ArrayList<CidsBean>();
                children.add((CidsBean)protokoll.getProperty("fk_mauerlasche"));
                children.add((CidsBean)protokoll.getProperty("fk_leuchte"));
                children.add((CidsBean)protokoll.getProperty("fk_leitung"));
                children.add((CidsBean)protokoll.getProperty("fk_standort"));
                children.add((CidsBean)protokoll.getProperty("fk_abzweigdose"));
                children.add((CidsBean)protokoll.getProperty("fk_schaltstelle"));
                children.add((CidsBean)protokoll.getProperty("fk_geometrie"));
                for (CidsBean child : children) {
                    if (child == null) continue;
                    toLock.add(child.getMetaObject().getID() + "@" + child.getMetaObject().getClassID());
                    break;
                }
                if (!(locks = BelisServerUtils.checkIfLocked(toLock, this.getUser())).isEmpty()) {
                    return locks;
                }
                MetaObjectNode lockNode = BelisServerUtils.lockEntities(toLock, this.getUser());
                try {
                    this.executeAktion(protokoll);
                    DomainServerImpl.getServerInstance().updateMetaObject(this.getUser(), mo);
                }
                finally {
                    DomainServerImpl.getServerInstance().deleteMetaObject(this.getUser(), lockNode.getObject());
                }
                return null;
            }
            catch (Exception ex) {
                LOG.fatal((Object)ex, (Throwable)ex);
                return ex;
            }
        }
        throw new RuntimeException("missing id as param");
    }

    public static CidsBean createProtokollBean(String aenderung, String newValue, String oldValue) throws Exception {
        CidsBean arbeitsprotokollaktionBean = CidsBean.createNewCidsBeanFromTableName((String)"BELIS2", (String)"arbeitsprotokollaktion");
        arbeitsprotokollaktionBean.setProperty("aenderung", (Object)aenderung);
        arbeitsprotokollaktionBean.setProperty("alt", (Object)oldValue);
        arbeitsprotokollaktionBean.setProperty("neu", (Object)newValue);
        return arbeitsprotokollaktionBean;
    }

    protected static CidsBean createAktion(String desc, CidsBean workbenchEntity, String property, Object newValue) throws Exception {
        Object oldValue = workbenchEntity.getProperty(property);
        workbenchEntity.setProperty(property, newValue);
        return AbstractProtokollServerAction.createProtokollBean(desc, AbstractProtokollServerAction.valueToString(newValue), AbstractProtokollServerAction.valueToString(oldValue));
    }

    protected void setStatus(CidsBean protokoll) throws Exception {
        if (this.paramsHashMap.get((Object)ProtokollStatusServerAction.ParameterType.MONTEUR.toString().toLowerCase()) != null) {
            protokoll.setProperty("monteur", (Object)((String)this.getParam(ProtokollStatusServerAction.ParameterType.MONTEUR.toString(), String.class)));
        }
        if (this.paramsHashMap.get((Object)ProtokollStatusServerAction.ParameterType.DATUM.toString().toLowerCase()) != null) {
            protokoll.setProperty("datum", this.getParam(ProtokollStatusServerAction.ParameterType.DATUM.toString(), Date.class));
        }
        if (this.paramsHashMap.get((Object)ProtokollStatusServerAction.ParameterType.STATUS.toString().toLowerCase()) != null) {
            protokoll.setProperty("fk_status", (Object)this.getCidsBeanFromParam(ProtokollStatusServerAction.ParameterType.STATUS.toString(), "arbeitsprotokollstatus"));
        }
    }

    protected abstract void executeAktion(CidsBean var1) throws Exception;

    public static enum ParameterType {
        PROTOKOLL_ID;

    }
}

